/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.IModelConfiguration;

@OnlyIn(value=Dist.CLIENT)
public class SimpleBakedModel
implements IBakedModel {
    protected final List<BakedQuad> field_177563_a;
    protected final Map<Direction, List<BakedQuad>> field_177561_b;
    protected final boolean field_177562_c;
    protected final boolean field_177559_d;
    protected final TextureAtlasSprite field_177560_e;
    protected final ItemCameraTransforms field_177558_f;
    protected final ItemOverrideList field_188620_g;

    public SimpleBakedModel(List<BakedQuad> generalQuadsIn, Map<Direction, List<BakedQuad>> faceQuadsIn, boolean ambientOcclusionIn, boolean gui3dIn, TextureAtlasSprite textureIn, ItemCameraTransforms cameraTransformsIn, ItemOverrideList itemOverrideListIn) {
        this.field_177563_a = generalQuadsIn;
        this.field_177561_b = faceQuadsIn;
        this.field_177562_c = ambientOcclusionIn;
        this.field_177559_d = gui3dIn;
        this.field_177560_e = textureIn;
        this.field_177558_f = cameraTransformsIn;
        this.field_188620_g = itemOverrideListIn;
    }

    @Override
    public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, Random rand) {
        return side == null ? this.field_177563_a : this.field_177561_b.get((Object)side);
    }

    @Override
    public boolean func_177555_b() {
        return this.field_177562_c;
    }

    @Override
    public boolean func_177556_c() {
        return this.field_177559_d;
    }

    @Override
    public boolean func_188618_c() {
        return false;
    }

    @Override
    public TextureAtlasSprite func_177554_e() {
        return this.field_177560_e;
    }

    @Override
    public ItemCameraTransforms func_177552_f() {
        return this.field_177558_f;
    }

    @Override
    public ItemOverrideList func_188617_f() {
        return this.field_188620_g;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Builder {
        private final List<BakedQuad> field_177656_a = Lists.newArrayList();
        private final Map<Direction, List<BakedQuad>> field_177654_b = Maps.newEnumMap(Direction.class);
        private final ItemOverrideList field_188646_c;
        private final boolean field_177655_c;
        private TextureAtlasSprite field_177652_d;
        private final boolean field_177653_e;
        private final ItemCameraTransforms field_177651_f;

        public Builder(BlockModel model, ItemOverrideList overrides) {
            this(model.func_178309_b(), model.func_178311_c(), model.func_181682_g(), overrides);
        }

        public Builder(IModelConfiguration model, ItemOverrideList overrides) {
            this(model.useSmoothLighting(), model.isShadedInGui(), model.getCameraTransforms(), overrides);
        }

        private Builder(boolean ambientOcclusion, boolean gui3d, ItemCameraTransforms transforms, ItemOverrideList overrides) {
            for (Direction direction : Direction.values()) {
                this.field_177654_b.put(direction, Lists.newArrayList());
            }
            this.field_188646_c = overrides;
            this.field_177655_c = ambientOcclusion;
            this.field_177653_e = gui3d;
            this.field_177651_f = transforms;
        }

        public Builder func_177650_a(Direction facing, BakedQuad quad) {
            this.field_177654_b.get((Object)facing).add(quad);
            return this;
        }

        public Builder func_177648_a(BakedQuad quad) {
            this.field_177656_a.add(quad);
            return this;
        }

        public Builder func_177646_a(TextureAtlasSprite texture) {
            this.field_177652_d = texture;
            return this;
        }

        public IBakedModel func_177645_b() {
            if (this.field_177652_d == null) {
                throw new RuntimeException("Missing particle!");
            }
            return new SimpleBakedModel(this.field_177656_a, this.field_177654_b, this.field_177655_c, this.field_177653_e, this.field_177652_d, this.field_177651_f, this.field_188646_c);
        }
    }
}

