/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.realmsclient.RealmsMainScreen;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.ITickable;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.PreloadedTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.crash.ReportedException;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class TextureManager
implements ITickable,
IFutureReloadListener {
    private static final Logger field_147646_a = LogManager.getLogger();
    public static final ResourceLocation field_194008_a = new ResourceLocation("");
    private final Map<ResourceLocation, Texture> field_110585_a = Maps.newHashMap();
    private final Set<ITickable> field_110583_b = Sets.newHashSet();
    private final Map<String, Integer> field_110584_c = Maps.newHashMap();
    private final IResourceManager field_110582_d;

    public TextureManager(IResourceManager resourceManager) {
        this.field_110582_d = resourceManager;
    }

    public void func_110577_a(ResourceLocation resource) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> this.func_229269_d_(resource));
        } else {
            this.func_229269_d_(resource);
        }
    }

    private void func_229269_d_(ResourceLocation p_229269_1_) {
        Texture texture = this.field_110585_a.get(p_229269_1_);
        if (texture == null) {
            texture = new SimpleTexture(p_229269_1_);
            this.func_229263_a_(p_229269_1_, texture);
        }
        texture.func_229148_d_();
    }

    public boolean func_229263_a_(ResourceLocation p_229263_1_, Texture p_229263_2_) {
        boolean flag = true;
        try {
            p_229263_2_.func_195413_a(this.field_110582_d);
        }
        catch (IOException ioexception) {
            if (p_229263_1_ != field_194008_a) {
                field_147646_a.warn("Failed to load texture: {}", (Object)p_229263_1_, (Object)ioexception);
            }
            p_229263_2_ = MissingTextureSprite.func_195676_d();
            this.field_110585_a.put(p_229263_1_, p_229263_2_);
            flag = false;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a(throwable, "Registering texture");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Resource location being registered");
            Texture texture = p_229263_2_;
            crashreportcategory.func_71507_a("Resource location", p_229263_1_);
            crashreportcategory.func_189529_a("Texture object class", (ICrashReportDetail<String>)((ICrashReportDetail)() -> texture.getClass().getName()));
            throw new ReportedException(crashreport);
        }
        this.field_110585_a.put(p_229263_1_, p_229263_2_);
        if (flag && p_229263_2_ instanceof ITickable) {
            this.field_110583_b.add((ITickable)p_229263_2_);
        }
        return flag;
    }

    @Nullable
    public Texture func_229267_b_(ResourceLocation p_229267_1_) {
        return this.field_110585_a.get(p_229267_1_);
    }

    public ResourceLocation func_110578_a(String name, DynamicTexture texture) {
        Integer integer = this.field_110584_c.get(name);
        integer = integer == null ? Integer.valueOf(1) : Integer.valueOf(integer + 1);
        this.field_110584_c.put(name, integer);
        ResourceLocation resourcelocation = new ResourceLocation(String.format("dynamic/%s_%d", name, integer));
        this.func_229263_a_(resourcelocation, (Texture)texture);
        return resourcelocation;
    }

    public CompletableFuture<Void> func_215268_a(ResourceLocation textureLocation, Executor executor) {
        if (!this.field_110585_a.containsKey(textureLocation)) {
            PreloadedTexture preloadedtexture = new PreloadedTexture(this.field_110582_d, textureLocation, executor);
            this.field_110585_a.put(textureLocation, (Texture)preloadedtexture);
            return preloadedtexture.func_215248_a().thenRunAsync(() -> this.func_229263_a_(textureLocation, (Texture)preloadedtexture), TextureManager::func_229262_a_);
        }
        return CompletableFuture.completedFuture(null);
    }

    private static void func_229262_a_(Runnable p_229262_0_) {
        Minecraft.func_71410_x().execute(() -> RenderSystem.recordRenderCall(p_229262_0_::run));
    }

    public void func_110550_d() {
        for (ITickable itickable : this.field_110583_b) {
            itickable.func_110550_d();
        }
    }

    public void func_147645_c(ResourceLocation textureLocation) {
        Texture texture = this.func_229267_b_(textureLocation);
        if (texture != null) {
            this.field_110585_a.remove(textureLocation);
            TextureUtil.func_225679_a_((int)texture.func_110552_b());
        }
    }

    public CompletableFuture<Void> func_215226_a(IFutureReloadListener.IStage stage, IResourceManager resourceManager, IProfiler preparationsProfiler, IProfiler reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        return ((CompletableFuture)CompletableFuture.allOf(MainMenuScreen.func_213097_a(this, backgroundExecutor), this.func_215268_a(Widget.WIDGETS_LOCATION, backgroundExecutor)).thenCompose(arg_0 -> ((IFutureReloadListener.IStage)stage).func_216872_a(arg_0))).thenAcceptAsync(p_229265_3_ -> {
            MissingTextureSprite.func_195676_d();
            RealmsMainScreen.func_227932_a_((IResourceManager)this.field_110582_d);
            Iterator<Map.Entry<ResourceLocation, Texture>> iterator = this.field_110585_a.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ResourceLocation, Texture> entry = iterator.next();
                ResourceLocation resourcelocation = entry.getKey();
                Texture texture = entry.getValue();
                if (texture == MissingTextureSprite.func_195676_d() && !resourcelocation.equals((Object)MissingTextureSprite.func_195675_b())) {
                    iterator.remove();
                    continue;
                }
                texture.func_215244_a(this, resourceManager, resourcelocation, gameExecutor);
            }
        }, p_229266_0_ -> RenderSystem.recordRenderCall(p_229266_0_::run));
    }
}

