/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.vertex;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class VertexFormat {
    private final ImmutableList<VertexFormatElement> field_177355_b;
    private final IntList field_177356_c = new IntArrayList();
    private final int field_177353_d;

    public VertexFormat(ImmutableList<VertexFormatElement> p_i225911_1_) {
        this.field_177355_b = p_i225911_1_;
        int i = 0;
        for (VertexFormatElement vertexformatelement : p_i225911_1_) {
            this.field_177356_c.add(i);
            i += vertexformatelement.func_177368_f();
        }
        this.field_177353_d = i;
    }

    public String toString() {
        return "format: " + this.field_177355_b.size() + " elements: " + this.field_177355_b.stream().map(Object::toString).collect(Collectors.joining(" "));
    }

    public int func_181719_f() {
        return this.func_177338_f() / 4;
    }

    public int func_177338_f() {
        return this.field_177353_d;
    }

    public ImmutableList<VertexFormatElement> func_227894_c_() {
        return this.field_177355_b;
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (p_equals_1_ != null && this.getClass() == p_equals_1_.getClass()) {
            VertexFormat vertexformat = (VertexFormat)p_equals_1_;
            return this.field_177353_d != vertexformat.field_177353_d ? false : this.field_177355_b.equals(vertexformat.field_177355_b);
        }
        return false;
    }

    public int hashCode() {
        return this.field_177355_b.hashCode();
    }

    public void func_227892_a_(long p_227892_1_) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> this.func_227892_a_(p_227892_1_));
        } else {
            int i = this.func_177338_f();
            ImmutableList<VertexFormatElement> list = this.func_227894_c_();
            for (int j = 0; j < list.size(); ++j) {
                ((VertexFormatElement)list.get(j)).func_227897_a_(p_227892_1_ + (long)this.field_177356_c.getInt(j), i);
            }
        }
    }

    public void func_227895_d_() {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(this::func_227895_d_);
        } else {
            for (VertexFormatElement vertexformatelement : this.func_227894_c_()) {
                vertexformatelement.func_227898_g_();
            }
        }
    }

    public int getOffset(int index) {
        return this.field_177356_c.getInt(index);
    }

    public boolean hasPosition() {
        return this.field_177355_b.stream().anyMatch(e -> e.func_177374_g());
    }

    public boolean hasNormal() {
        return this.field_177355_b.stream().anyMatch(e -> e.func_177375_c() == VertexFormatElement.Usage.NORMAL);
    }

    public boolean hasColor() {
        return this.field_177355_b.stream().anyMatch(e -> e.func_177375_c() == VertexFormatElement.Usage.COLOR);
    }

    public boolean hasUV(int which) {
        return this.field_177355_b.stream().anyMatch(e -> e.func_177375_c() == VertexFormatElement.Usage.UV && e.func_177369_e() == which);
    }
}

