/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.SuggestionProviders;
import net.minecraft.command.impl.AdvancementCommand;
import net.minecraft.command.impl.BanCommand;
import net.minecraft.command.impl.BanIpCommand;
import net.minecraft.command.impl.BanListCommand;
import net.minecraft.command.impl.BossBarCommand;
import net.minecraft.command.impl.ClearCommand;
import net.minecraft.command.impl.CloneCommand;
import net.minecraft.command.impl.DataPackCommand;
import net.minecraft.command.impl.DeOpCommand;
import net.minecraft.command.impl.DebugCommand;
import net.minecraft.command.impl.DefaultGameModeCommand;
import net.minecraft.command.impl.DifficultyCommand;
import net.minecraft.command.impl.EffectCommand;
import net.minecraft.command.impl.EnchantCommand;
import net.minecraft.command.impl.ExecuteCommand;
import net.minecraft.command.impl.ExperienceCommand;
import net.minecraft.command.impl.FillCommand;
import net.minecraft.command.impl.ForceLoadCommand;
import net.minecraft.command.impl.FunctionCommand;
import net.minecraft.command.impl.GameModeCommand;
import net.minecraft.command.impl.GameRuleCommand;
import net.minecraft.command.impl.GiveCommand;
import net.minecraft.command.impl.HelpCommand;
import net.minecraft.command.impl.KickCommand;
import net.minecraft.command.impl.KillCommand;
import net.minecraft.command.impl.ListCommand;
import net.minecraft.command.impl.LocateCommand;
import net.minecraft.command.impl.LootCommand;
import net.minecraft.command.impl.MeCommand;
import net.minecraft.command.impl.MessageCommand;
import net.minecraft.command.impl.OpCommand;
import net.minecraft.command.impl.PardonCommand;
import net.minecraft.command.impl.PardonIpCommand;
import net.minecraft.command.impl.ParticleCommand;
import net.minecraft.command.impl.PlaySoundCommand;
import net.minecraft.command.impl.PublishCommand;
import net.minecraft.command.impl.RecipeCommand;
import net.minecraft.command.impl.ReloadCommand;
import net.minecraft.command.impl.ReplaceItemCommand;
import net.minecraft.command.impl.SaveAllCommand;
import net.minecraft.command.impl.SaveOffCommand;
import net.minecraft.command.impl.SaveOnCommand;
import net.minecraft.command.impl.SayCommand;
import net.minecraft.command.impl.ScheduleCommand;
import net.minecraft.command.impl.ScoreboardCommand;
import net.minecraft.command.impl.SeedCommand;
import net.minecraft.command.impl.SetBlockCommand;
import net.minecraft.command.impl.SetIdleTimeoutCommand;
import net.minecraft.command.impl.SetWorldSpawnCommand;
import net.minecraft.command.impl.SpawnPointCommand;
import net.minecraft.command.impl.SpectateCommand;
import net.minecraft.command.impl.SpreadPlayersCommand;
import net.minecraft.command.impl.StopCommand;
import net.minecraft.command.impl.StopSoundCommand;
import net.minecraft.command.impl.SummonCommand;
import net.minecraft.command.impl.TagCommand;
import net.minecraft.command.impl.TeamCommand;
import net.minecraft.command.impl.TeamMsgCommand;
import net.minecraft.command.impl.TeleportCommand;
import net.minecraft.command.impl.TellRawCommand;
import net.minecraft.command.impl.TimeCommand;
import net.minecraft.command.impl.TitleCommand;
import net.minecraft.command.impl.TriggerCommand;
import net.minecraft.command.impl.WeatherCommand;
import net.minecraft.command.impl.WhitelistCommand;
import net.minecraft.command.impl.WorldBorderCommand;
import net.minecraft.command.impl.data.DataCommand;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.play.server.SCommandListPacket;
import net.minecraft.test.TestCommand;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Commands {
    private static final Logger field_197061_a = LogManager.getLogger();
    private final CommandDispatcher<CommandSource> field_197062_b = new CommandDispatcher();

    public Commands(boolean isDedicatedServer) {
        AdvancementCommand.func_198199_a(this.field_197062_b);
        ExecuteCommand.func_198378_a(this.field_197062_b);
        BossBarCommand.func_201413_a(this.field_197062_b);
        ClearCommand.func_198243_a(this.field_197062_b);
        CloneCommand.func_198265_a(this.field_197062_b);
        DataCommand.func_198937_a(this.field_197062_b);
        DataPackCommand.func_198299_a(this.field_197062_b);
        DebugCommand.func_198330_a(this.field_197062_b);
        DefaultGameModeCommand.func_198340_a(this.field_197062_b);
        DifficultyCommand.func_198344_a(this.field_197062_b);
        EffectCommand.func_198353_a(this.field_197062_b);
        MeCommand.func_198364_a(this.field_197062_b);
        EnchantCommand.func_202649_a(this.field_197062_b);
        ExperienceCommand.func_198437_a(this.field_197062_b);
        FillCommand.func_198465_a(this.field_197062_b);
        ForceLoadCommand.func_212712_a(this.field_197062_b);
        FunctionCommand.func_198476_a(this.field_197062_b);
        GameModeCommand.func_198482_a(this.field_197062_b);
        GameRuleCommand.func_198487_a(this.field_197062_b);
        GiveCommand.func_198494_a(this.field_197062_b);
        HelpCommand.func_198510_a(this.field_197062_b);
        KickCommand.func_198514_a(this.field_197062_b);
        KillCommand.func_198518_a(this.field_197062_b);
        ListCommand.func_198522_a(this.field_197062_b);
        LocateCommand.func_198528_a(this.field_197062_b);
        LootCommand.func_218886_a(this.field_197062_b);
        MessageCommand.func_198537_a(this.field_197062_b);
        ParticleCommand.func_198563_a(this.field_197062_b);
        PlaySoundCommand.func_198572_a(this.field_197062_b);
        PublishCommand.func_198581_a(this.field_197062_b);
        ReloadCommand.func_198597_a(this.field_197062_b);
        RecipeCommand.func_198589_a(this.field_197062_b);
        ReplaceItemCommand.func_198602_a(this.field_197062_b);
        SayCommand.func_198625_a(this.field_197062_b);
        ScheduleCommand.func_218909_a(this.field_197062_b);
        ScoreboardCommand.func_198647_a(this.field_197062_b);
        SeedCommand.func_198671_a(this.field_197062_b);
        SetBlockCommand.func_198684_a(this.field_197062_b);
        SpawnPointCommand.func_198695_a(this.field_197062_b);
        SetWorldSpawnCommand.func_198702_a(this.field_197062_b);
        SpectateCommand.func_229826_a_(this.field_197062_b);
        SpreadPlayersCommand.func_198716_a(this.field_197062_b);
        StopSoundCommand.func_198730_a(this.field_197062_b);
        SummonCommand.func_198736_a(this.field_197062_b);
        TagCommand.func_198743_a(this.field_197062_b);
        TeamCommand.func_198771_a(this.field_197062_b);
        TeamMsgCommand.func_218915_a(this.field_197062_b);
        TeleportCommand.func_198809_a(this.field_197062_b);
        TellRawCommand.func_198818_a(this.field_197062_b);
        TimeCommand.func_198823_a(this.field_197062_b);
        TitleCommand.func_198839_a(this.field_197062_b);
        TriggerCommand.func_198852_a(this.field_197062_b);
        WeatherCommand.func_198862_a(this.field_197062_b);
        WorldBorderCommand.func_198894_a(this.field_197062_b);
        if (SharedConstants.field_206244_b) {
            TestCommand.func_229613_a_(this.field_197062_b);
        }
        if (isDedicatedServer) {
            BanIpCommand.func_198220_a(this.field_197062_b);
            BanListCommand.func_198229_a(this.field_197062_b);
            BanCommand.func_198235_a(this.field_197062_b);
            DeOpCommand.func_198321_a(this.field_197062_b);
            OpCommand.func_198541_a(this.field_197062_b);
            PardonCommand.func_198547_a(this.field_197062_b);
            PardonIpCommand.func_198553_a(this.field_197062_b);
            SaveAllCommand.func_198611_a(this.field_197062_b);
            SaveOffCommand.func_198617_a(this.field_197062_b);
            SaveOnCommand.func_198621_a(this.field_197062_b);
            SetIdleTimeoutCommand.func_198690_a(this.field_197062_b);
            StopCommand.func_198725_a(this.field_197062_b);
            WhitelistCommand.func_198873_a(this.field_197062_b);
        }
        this.field_197062_b.findAmbiguities((p_201302_1_, p_201302_2_, p_201302_3_, p_201302_4_) -> field_197061_a.warn("Ambiguity between arguments {} and {} with inputs: {}", (Object)this.field_197062_b.getPath(p_201302_2_), (Object)this.field_197062_b.getPath(p_201302_3_), (Object)p_201302_4_));
        this.field_197062_b.setConsumer((p_197058_0_, p_197058_1_, p_197058_2_) -> ((CommandSource)p_197058_0_.getSource()).func_197038_a(p_197058_0_, p_197058_1_, p_197058_2_));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int func_197059_a(CommandSource source, String command) {
        int n;
        StringReader stringreader = new StringReader(command);
        if (stringreader.canRead() && stringreader.peek() == '/') {
            stringreader.skip();
        }
        source.func_197028_i().func_213185_aS().func_76320_a(command);
        try {
            int lvt_4_3_;
            ParseResults parse = this.field_197062_b.parse(stringreader, (Object)source);
            CommandEvent event = new CommandEvent(parse);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                if (event.getException() != null) {
                    Throwables.throwIfUnchecked((Throwable)event.getException());
                }
                int n2 = 1;
                return n2;
            }
            int n3 = lvt_4_3_ = this.field_197062_b.execute(event.getParseResults());
            return n3;
        }
        catch (CommandException commandexception) {
            int b1;
            source.func_197021_a(commandexception.func_197003_a());
            int lvt_4_3_ = b1 = 0;
            return lvt_4_3_;
        }
        catch (CommandSyntaxException commandsyntaxexception) {
            source.func_197021_a(TextComponentUtils.func_202465_a((Message)commandsyntaxexception.getRawMessage()));
            if (commandsyntaxexception.getInput() != null && commandsyntaxexception.getCursor() >= 0) {
                int k = Math.min(commandsyntaxexception.getInput().length(), commandsyntaxexception.getCursor());
                ITextComponent itextcomponent1 = new StringTextComponent("").func_211708_a(TextFormatting.GRAY).func_211710_a(p_211705_1_ -> p_211705_1_.func_150241_a(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, command)));
                if (k > 10) {
                    itextcomponent1.func_150258_a("...");
                }
                itextcomponent1.func_150258_a(commandsyntaxexception.getInput().substring(Math.max(0, k - 10), k));
                if (k < commandsyntaxexception.getInput().length()) {
                    ITextComponent itextcomponent2 = new StringTextComponent(commandsyntaxexception.getInput().substring(k)).func_211709_a(new TextFormatting[]{TextFormatting.RED, TextFormatting.UNDERLINE});
                    itextcomponent1.func_150257_a(itextcomponent2);
                }
                itextcomponent1.func_150257_a(new TranslationTextComponent("command.context.here", new Object[0]).func_211709_a(new TextFormatting[]{TextFormatting.RED, TextFormatting.ITALIC}));
                source.func_197021_a(itextcomponent1);
            }
        }
        catch (Exception exception) {
            int b2;
            StringTextComponent itextcomponent = new StringTextComponent(exception.getMessage() == null ? exception.getClass().getName() : exception.getMessage());
            if (field_197061_a.isDebugEnabled()) {
                field_197061_a.error("Command exception: {}", (Object)command, (Object)exception);
                StackTraceElement[] astacktraceelement = exception.getStackTrace();
                for (int j = 0; j < Math.min(astacktraceelement.length, 3); ++j) {
                    itextcomponent.func_150258_a("\n\n").func_150258_a(astacktraceelement[j].getMethodName()).func_150258_a("\n ").func_150258_a(astacktraceelement[j].getFileName()).func_150258_a(":").func_150258_a(String.valueOf(astacktraceelement[j].getLineNumber()));
                }
            }
            source.func_197021_a(new TranslationTextComponent("command.failed", new Object[0]).func_211710_a(arg_0 -> Commands.lambda$handleCommand$3((ITextComponent)itextcomponent, arg_0)));
            if (SharedConstants.field_206244_b) {
                source.func_197021_a((ITextComponent)new StringTextComponent(Util.func_229758_d_((Throwable)exception)));
                field_197061_a.error("'" + command + "' threw an exception", (Throwable)exception);
            }
            int n4 = b2 = 0;
            return n4;
        }
        {
            int b0;
            n = b0 = 0;
        }
        return n;
        finally {
            source.func_197028_i().func_213185_aS().func_76319_b();
        }
    }

    public void func_197051_a(ServerPlayerEntity player) {
        HashMap map = Maps.newHashMap();
        RootCommandNode rootcommandnode = new RootCommandNode();
        map.put(this.field_197062_b.getRoot(), rootcommandnode);
        this.func_197052_a((CommandNode<CommandSource>)this.field_197062_b.getRoot(), (CommandNode<ISuggestionProvider>)rootcommandnode, player.func_195051_bN(), map);
        player.field_71135_a.func_147359_a(new SCommandListPacket((RootCommandNode<ISuggestionProvider>)rootcommandnode));
    }

    private void func_197052_a(CommandNode<CommandSource> rootCommandSource, CommandNode<ISuggestionProvider> rootSuggestion, CommandSource source, Map<CommandNode<CommandSource>, CommandNode<ISuggestionProvider>> commandNodeToSuggestionNode) {
        for (CommandNode commandnode : rootCommandSource.getChildren()) {
            RequiredArgumentBuilder requiredargumentbuilder;
            if (!commandnode.canUse((Object)source)) continue;
            ArgumentBuilder argumentbuilder = commandnode.createBuilder();
            argumentbuilder.requires(p_197060_0_ -> true);
            if (argumentbuilder.getCommand() != null) {
                argumentbuilder.executes(p_197053_0_ -> 0);
            }
            if (argumentbuilder instanceof RequiredArgumentBuilder && (requiredargumentbuilder = (RequiredArgumentBuilder)argumentbuilder).getSuggestionsProvider() != null) {
                requiredargumentbuilder.suggests(SuggestionProviders.func_197496_b((SuggestionProvider)requiredargumentbuilder.getSuggestionsProvider()));
            }
            if (argumentbuilder.getRedirect() != null) {
                argumentbuilder.redirect(commandNodeToSuggestionNode.get(argumentbuilder.getRedirect()));
            }
            CommandNode commandnode1 = argumentbuilder.build();
            commandNodeToSuggestionNode.put((CommandNode<CommandSource>)commandnode, (CommandNode<ISuggestionProvider>)commandnode1);
            rootSuggestion.addChild(commandnode1);
            if (commandnode.getChildren().isEmpty()) continue;
            this.func_197052_a((CommandNode<CommandSource>)commandnode, (CommandNode<ISuggestionProvider>)commandnode1, source, commandNodeToSuggestionNode);
        }
    }

    public static LiteralArgumentBuilder<CommandSource> func_197057_a(String name) {
        return LiteralArgumentBuilder.literal((String)name);
    }

    public static <T> RequiredArgumentBuilder<CommandSource, T> func_197056_a(String name, ArgumentType<T> type) {
        return RequiredArgumentBuilder.argument((String)name, type);
    }

    public static Predicate<String> func_212590_a(IParser p_212590_0_) {
        return p_212591_1_ -> {
            try {
                p_212590_0_.parse(new StringReader(p_212591_1_));
                return true;
            }
            catch (CommandSyntaxException var3) {
                return false;
            }
        };
    }

    public CommandDispatcher<CommandSource> func_197054_a() {
        return this.field_197062_b;
    }

    @Nullable
    public static <S> CommandSyntaxException func_227481_a_(ParseResults<S> p_227481_0_) {
        if (!p_227481_0_.getReader().canRead()) {
            return null;
        }
        if (p_227481_0_.getExceptions().size() == 1) {
            return (CommandSyntaxException)((Object)p_227481_0_.getExceptions().values().iterator().next());
        }
        return p_227481_0_.getContext().getRange().isEmpty() ? CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().createWithContext(p_227481_0_.getReader()) : CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument().createWithContext(p_227481_0_.getReader());
    }

    private static /* synthetic */ void lambda$handleCommand$3(ITextComponent itextcomponent, Style p_211704_1_) {
        p_211704_1_.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, itextcomponent));
    }

    @FunctionalInterface
    public static interface IParser {
        public void parse(StringReader var1) throws CommandSyntaxException;
    }
}

