/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.boss;

import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IChargeableMob;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.WitherSkullEntity;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.Difficulty;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

@OnlyIn(value=Dist.CLIENT, _interface=IChargeableMob.class)
public class WitherEntity
extends MonsterEntity
implements IChargeableMob,
IRangedAttackMob {
    private static final DataParameter<Integer> field_184741_a = EntityDataManager.func_187226_a(WitherEntity.class, DataSerializers.field_187192_b);
    private static final DataParameter<Integer> field_184742_b = EntityDataManager.func_187226_a(WitherEntity.class, DataSerializers.field_187192_b);
    private static final DataParameter<Integer> field_184743_c = EntityDataManager.func_187226_a(WitherEntity.class, DataSerializers.field_187192_b);
    private static final List<DataParameter<Integer>> field_184745_bv = ImmutableList.of(field_184741_a, field_184742_b, field_184743_c);
    private static final DataParameter<Integer> field_184746_bw = EntityDataManager.func_187226_a(WitherEntity.class, DataSerializers.field_187192_b);
    private final float[] field_82220_d = new float[2];
    private final float[] field_82221_e = new float[2];
    private final float[] field_82217_f = new float[2];
    private final float[] field_82218_g = new float[2];
    private final int[] field_82223_h = new int[2];
    private final int[] field_82224_i = new int[2];
    private int field_82222_j;
    private final ServerBossInfo field_184744_bE = (ServerBossInfo)new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.PURPLE, BossInfo.Overlay.PROGRESS).func_186741_a(true);
    private static final Predicate<LivingEntity> field_82219_bJ = p_213797_0_ -> p_213797_0_.func_70668_bt() != CreatureAttribute.field_223223_b_ && p_213797_0_.func_190631_cK();
    private static final EntityPredicate field_213798_bB = new EntityPredicate().func_221013_a(20.0).func_221012_a(field_82219_bJ);

    public WitherEntity(EntityType<? extends WitherEntity> p_i50226_1_, World p_i50226_2_) {
        super(p_i50226_1_, p_i50226_2_);
        this.func_70606_j(this.func_110138_aP());
        this.func_70661_as().func_212239_d(true);
        this.field_70728_aV = 50;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new DoNothingGoal());
        this.field_70714_bg.func_75776_a(2, (Goal)new RangedAttackGoal((IRangedAttackMob)this, 1.0, 40, 20.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)((Object)this), PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)((Object)this)));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)((Object)this), MobEntity.class, 0, false, false, field_82219_bJ));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184741_a, 0);
        this.field_70180_af.func_187214_a(field_184742_b, 0);
        this.field_70180_af.func_187214_a(field_184743_c, 0);
        this.field_70180_af.func_187214_a(field_184746_bw, 0);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Invul", this.func_82212_n());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.func_82215_s(compound.func_74762_e("Invul"));
        if (this.func_145818_k_()) {
            this.field_184744_bE.func_186739_a(this.func_145748_c_());
        }
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        super.func_200203_b(name);
        this.field_184744_bE.func_186739_a(this.func_145748_c_());
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187925_gy;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187851_gB;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187849_gA;
    }

    public void func_70636_d() {
        Entity entity;
        Vec3d vec3d = this.func_213322_ci().func_216372_d(1.0, 0.6, 1.0);
        if (!this.field_70170_p.field_72995_K && this.func_82203_t(0) > 0 && (entity = this.field_70170_p.func_73045_a(this.func_82203_t(0))) != null) {
            double d0 = vec3d.field_72448_b;
            if (this.func_226278_cu_() < entity.func_226278_cu_() || !this.func_225509_J__() && this.func_226278_cu_() < entity.func_226278_cu_() + 5.0) {
                d0 = Math.max(0.0, d0);
                d0 += 0.3 - d0 * (double)0.6f;
            }
            vec3d = new Vec3d(vec3d.field_72450_a, d0, vec3d.field_72449_c);
            Vec3d vec3d1 = new Vec3d(entity.func_226277_ct_() - this.func_226277_ct_(), 0.0, entity.func_226281_cx_() - this.func_226281_cx_());
            if (WitherEntity.func_213296_b((Vec3d)vec3d1) > 9.0) {
                Vec3d vec3d2 = vec3d1.func_72432_b();
                vec3d = vec3d.func_72441_c(vec3d2.field_72450_a * 0.3 - vec3d.field_72450_a * 0.6, 0.0, vec3d2.field_72449_c * 0.3 - vec3d.field_72449_c * 0.6);
            }
        }
        this.func_213317_d(vec3d);
        if (WitherEntity.func_213296_b((Vec3d)vec3d) > 0.05) {
            this.field_70177_z = (float)MathHelper.func_181159_b((double)vec3d.field_72449_c, (double)vec3d.field_72450_a) * 57.295776f - 90.0f;
        }
        super.func_70636_d();
        for (int i = 0; i < 2; ++i) {
            this.field_82218_g[i] = this.field_82221_e[i];
            this.field_82217_f[i] = this.field_82220_d[i];
        }
        for (int j = 0; j < 2; ++j) {
            int k = this.func_82203_t(j + 1);
            Entity entity1 = null;
            if (k > 0) {
                entity1 = this.field_70170_p.func_73045_a(k);
            }
            if (entity1 != null) {
                double d9 = this.func_82214_u(j + 1);
                double d1 = this.func_82208_v(j + 1);
                double d3 = this.func_82213_w(j + 1);
                double d4 = entity1.func_226277_ct_() - d9;
                double d5 = entity1.func_226280_cw_() - d1;
                double d6 = entity1.func_226281_cx_() - d3;
                double d7 = MathHelper.func_76133_a((double)(d4 * d4 + d6 * d6));
                float f = (float)(MathHelper.func_181159_b((double)d6, (double)d4) * 57.2957763671875) - 90.0f;
                float f1 = (float)(-(MathHelper.func_181159_b((double)d5, (double)d7) * 57.2957763671875));
                this.field_82220_d[j] = this.func_82204_b(this.field_82220_d[j], f1, 40.0f);
                this.field_82221_e[j] = this.func_82204_b(this.field_82221_e[j], f, 10.0f);
                continue;
            }
            this.field_82221_e[j] = this.func_82204_b(this.field_82221_e[j], this.field_70761_aq, 10.0f);
        }
        boolean flag = this.func_225509_J__();
        for (int l = 0; l < 3; ++l) {
            double d8 = this.func_82214_u(l);
            double d10 = this.func_82208_v(l);
            double d2 = this.func_82213_w(l);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d8 + this.field_70146_Z.nextGaussian() * (double)0.3f, d10 + this.field_70146_Z.nextGaussian() * (double)0.3f, d2 + this.field_70146_Z.nextGaussian() * (double)0.3f, 0.0, 0.0, 0.0);
            if (!flag || this.field_70170_p.field_73012_v.nextInt(4) != 0) continue;
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197625_r, d8 + this.field_70146_Z.nextGaussian() * (double)0.3f, d10 + this.field_70146_Z.nextGaussian() * (double)0.3f, d2 + this.field_70146_Z.nextGaussian() * (double)0.3f, 0.7f, 0.7f, 0.5);
        }
        if (this.func_82212_n() > 0) {
            for (int i1 = 0; i1 < 3; ++i1) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197625_r, this.func_226277_ct_() + this.field_70146_Z.nextGaussian(), this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * 3.3f), this.func_226281_cx_() + this.field_70146_Z.nextGaussian(), 0.7f, 0.7f, 0.9f);
            }
        }
    }

    protected void func_70619_bc() {
        if (this.func_82212_n() > 0) {
            int j1 = this.func_82212_n() - 1;
            if (j1 <= 0) {
                Explosion.Mode explosion$mode = ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)((Object)this)) ? Explosion.Mode.DESTROY : Explosion.Mode.NONE;
                this.field_70170_p.func_217398_a((Entity)((Object)this), this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_(), 7.0f, false, explosion$mode);
                this.field_70170_p.func_175669_a(1023, new BlockPos((Entity)((Object)this)), 0);
            }
            this.func_82215_s(j1);
            if (this.field_70173_aa % 10 == 0) {
                this.func_70691_i(10.0f);
            }
        } else {
            super.func_70619_bc();
            block0: for (int i = 1; i < 3; ++i) {
                int k1;
                if (this.field_70173_aa < this.field_82223_h[i - 1]) continue;
                this.field_82223_h[i - 1] = this.field_70173_aa + 10 + this.field_70146_Z.nextInt(10);
                if (this.field_70170_p.func_175659_aa() == Difficulty.NORMAL || this.field_70170_p.func_175659_aa() == Difficulty.HARD) {
                    int j3 = i - 1;
                    int k3 = this.field_82224_i[i - 1];
                    this.field_82224_i[j3] = this.field_82224_i[i - 1] + 1;
                    if (k3 > 15) {
                        float f = 10.0f;
                        float f1 = 5.0f;
                        double d0 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.func_226277_ct_() - 10.0), (double)(this.func_226277_ct_() + 10.0));
                        double d1 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.func_226278_cu_() - 5.0), (double)(this.func_226278_cu_() + 5.0));
                        double d2 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.func_226281_cx_() - 10.0), (double)(this.func_226281_cx_() + 10.0));
                        this.func_82209_a(i + 1, d0, d1, d2, true);
                        this.field_82224_i[i - 1] = 0;
                    }
                }
                if ((k1 = this.func_82203_t(i)) > 0) {
                    Entity entity = this.field_70170_p.func_73045_a(k1);
                    if (entity != null && entity.func_70089_S() && !(this.func_70068_e(entity) > 900.0) && this.func_70685_l(entity)) {
                        if (entity instanceof PlayerEntity && ((PlayerEntity)entity).field_71075_bZ.field_75102_a) {
                            this.func_82211_c(i, 0);
                            continue;
                        }
                        this.func_82216_a(i + 1, (LivingEntity)entity);
                        this.field_82223_h[i - 1] = this.field_70173_aa + 40 + this.field_70146_Z.nextInt(20);
                        this.field_82224_i[i - 1] = 0;
                        continue;
                    }
                    this.func_82211_c(i, 0);
                    continue;
                }
                List list = this.field_70170_p.func_217374_a(LivingEntity.class, field_213798_bB, (LivingEntity)((Object)this), this.func_174813_aQ().func_72314_b(20.0, 8.0, 20.0));
                for (int j2 = 0; j2 < 10 && !list.isEmpty(); ++j2) {
                    LivingEntity livingentity = (LivingEntity)((Object)list.get(this.field_70146_Z.nextInt(list.size())));
                    if (livingentity != this && livingentity.func_70089_S() && this.func_70685_l(livingentity)) {
                        if (livingentity instanceof PlayerEntity) {
                            if (((PlayerEntity)livingentity).field_71075_bZ.field_75102_a) continue block0;
                            this.func_82211_c(i, livingentity.func_145782_y());
                            continue block0;
                        }
                        this.func_82211_c(i, livingentity.func_145782_y());
                        continue block0;
                    }
                    list.remove((Object)livingentity);
                }
            }
            if (this.func_70638_az() != null) {
                this.func_82211_c(0, this.func_70638_az().func_145782_y());
            } else {
                this.func_82211_c(0, 0);
            }
            if (this.field_82222_j > 0) {
                --this.field_82222_j;
                if (this.field_82222_j == 0 && ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)((Object)this))) {
                    int i1 = MathHelper.func_76128_c((double)this.func_226278_cu_());
                    int l1 = MathHelper.func_76128_c((double)this.func_226277_ct_());
                    int i2 = MathHelper.func_76128_c((double)this.func_226281_cx_());
                    boolean flag = false;
                    for (int k2 = -1; k2 <= 1; ++k2) {
                        for (int l2 = -1; l2 <= 1; ++l2) {
                            for (int j = 0; j <= 3; ++j) {
                                int i3 = l1 + k2;
                                int k = i1 + j;
                                int l = i2 + l2;
                                BlockPos blockpos = new BlockPos(i3, k, l);
                                BlockState blockstate = this.field_70170_p.func_180495_p(blockpos);
                                if (!blockstate.canEntityDestroy((IBlockReader)((Object)this.field_70170_p), blockpos, (Entity)((Object)this)) || !ForgeEventFactory.onEntityDestroyBlock((LivingEntity)((Object)this), (BlockPos)blockpos, (BlockState)blockstate)) continue;
                                flag = this.field_70170_p.func_225521_a_(blockpos, true, (Entity)((Object)this)) || flag;
                            }
                        }
                    }
                    if (flag) {
                        this.field_70170_p.func_217378_a(null, 1022, new BlockPos((Entity)((Object)this)), 0);
                    }
                }
            }
            if (this.field_70173_aa % 20 == 0) {
                this.func_70691_i(1.0f);
            }
            this.field_184744_bE.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        }
    }

    @Deprecated
    public static boolean func_181033_a(BlockState blockIn) {
        return !blockIn.func_196958_f() && !BlockTags.field_219755_X.func_199685_a_(blockIn.func_177230_c());
    }

    public void func_82206_m() {
        this.func_82215_s(220);
        this.func_70606_j(this.func_110138_aP() / 3.0f);
    }

    public void func_213295_a(BlockState p_213295_1_, Vec3d p_213295_2_) {
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.field_184744_bE.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.field_184744_bE.func_186761_b(player);
    }

    private double func_82214_u(int p_82214_1_) {
        if (p_82214_1_ <= 0) {
            return this.func_226277_ct_();
        }
        float f = (this.field_70761_aq + (float)(180 * (p_82214_1_ - 1))) * ((float)Math.PI / 180);
        float f1 = MathHelper.func_76134_b((float)f);
        return this.func_226277_ct_() + (double)f1 * 1.3;
    }

    private double func_82208_v(int p_82208_1_) {
        return p_82208_1_ <= 0 ? this.func_226278_cu_() + 3.0 : this.func_226278_cu_() + 2.2;
    }

    private double func_82213_w(int p_82213_1_) {
        if (p_82213_1_ <= 0) {
            return this.func_226281_cx_();
        }
        float f = (this.field_70761_aq + (float)(180 * (p_82213_1_ - 1))) * ((float)Math.PI / 180);
        float f1 = MathHelper.func_76126_a((float)f);
        return this.func_226281_cx_() + (double)f1 * 1.3;
    }

    private float func_82204_b(float p_82204_1_, float p_82204_2_, float p_82204_3_) {
        float f = MathHelper.func_76142_g((float)(p_82204_2_ - p_82204_1_));
        if (f > p_82204_3_) {
            f = p_82204_3_;
        }
        if (f < -p_82204_3_) {
            f = -p_82204_3_;
        }
        return p_82204_1_ + f;
    }

    private void func_82216_a(int p_82216_1_, LivingEntity p_82216_2_) {
        this.func_82209_a(p_82216_1_, p_82216_2_.func_226277_ct_(), p_82216_2_.func_226278_cu_() + (double)p_82216_2_.func_70047_e() * 0.5, p_82216_2_.func_226281_cx_(), p_82216_1_ == 0 && this.field_70146_Z.nextFloat() < 0.001f);
    }

    private void func_82209_a(int p_82209_1_, double x, double y, double z, boolean invulnerable) {
        this.field_70170_p.func_217378_a(null, 1024, new BlockPos((Entity)((Object)this)), 0);
        double d0 = this.func_82214_u(p_82209_1_);
        double d1 = this.func_82208_v(p_82209_1_);
        double d2 = this.func_82213_w(p_82209_1_);
        double d3 = x - d0;
        double d4 = y - d1;
        double d5 = z - d2;
        WitherSkullEntity witherskullentity = new WitherSkullEntity(this.field_70170_p, (LivingEntity)((Object)this), d3, d4, d5);
        if (invulnerable) {
            witherskullentity.func_82343_e(true);
        }
        witherskullentity.func_226288_n_(d0, d1, d2);
        this.field_70170_p.func_217376_c(witherskullentity);
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        this.func_82216_a(0, target);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (source != DamageSource.field_76369_e && !(source.func_76346_g() instanceof WitherEntity)) {
            Entity entity;
            if (this.func_82212_n() > 0 && source != DamageSource.field_76380_i) {
                return false;
            }
            if (this.func_225509_J__() && (entity = source.func_76364_f()) instanceof AbstractArrowEntity) {
                return false;
            }
            Entity entity1 = source.func_76346_g();
            if (entity1 != null && !(entity1 instanceof PlayerEntity) && entity1 instanceof LivingEntity && ((LivingEntity)entity1).func_70668_bt() == this.func_70668_bt()) {
                return false;
            }
            if (this.field_82222_j <= 0) {
                this.field_82222_j = 20;
            }
            int i = 0;
            while (i < this.field_82224_i.length) {
                int n = i++;
                this.field_82224_i[n] = this.field_82224_i[n] + 3;
            }
            return super.func_70097_a(source, amount);
        }
        return false;
    }

    protected void func_213333_a(DamageSource source, int looting, boolean recentlyHitIn) {
        super.func_213333_a(source, looting, recentlyHitIn);
        ItemEntity itementity = this.func_199703_a(Items.field_151156_bN);
        if (itementity != null) {
            itementity.func_174873_u();
        }
    }

    public void func_70623_bb() {
        if (this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL && this.func_225511_J_()) {
            this.func_70106_y();
        } else {
            this.field_70708_bq = 0;
        }
    }

    public boolean func_225503_b_(float p_225503_1_, float p_225503_2_) {
        return false;
    }

    public boolean func_195064_c(EffectInstance p_195064_1_) {
        return false;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(300.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.6f);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(4.0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_82207_a(int p_82207_1_) {
        return this.field_82221_e[p_82207_1_];
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_82210_r(int p_82210_1_) {
        return this.field_82220_d[p_82210_1_];
    }

    public int func_82212_n() {
        return this.field_70180_af.func_187225_a(field_184746_bw);
    }

    public void func_82215_s(int time) {
        this.field_70180_af.func_187227_b(field_184746_bw, time);
    }

    public int func_82203_t(int head) {
        return this.field_70180_af.func_187225_a(field_184745_bv.get(head));
    }

    public void func_82211_c(int targetOffset, int newId) {
        this.field_70180_af.func_187227_b(field_184745_bv.get(targetOffset), newId);
    }

    public boolean func_225509_J__() {
        return this.func_110143_aJ() <= this.func_110138_aP() / 2.0f;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    protected boolean func_184228_n(Entity entityIn) {
        return false;
    }

    public boolean func_184222_aU() {
        return false;
    }

    public boolean func_70687_e(EffectInstance potioneffectIn) {
        return potioneffectIn.func_188419_a() == Effects.field_82731_v ? false : super.func_70687_e(potioneffectIn);
    }

    class DoNothingGoal
    extends Goal {
        public DoNothingGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return WitherEntity.this.func_82212_n() > 0;
        }
    }
}

