/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.storage.loot.LootTables;

public class SlimeEntity
extends MobEntity
implements IMob {
    private static final DataParameter<Integer> field_184711_bt = EntityDataManager.func_187226_a(SlimeEntity.class, DataSerializers.field_187192_b);
    public float field_70813_a;
    public float field_70811_b;
    public float field_70812_c;
    private boolean field_175452_bi;

    public SlimeEntity(EntityType<? extends SlimeEntity> type, World worldIn) {
        super((EntityType<? extends MobEntity>)type, worldIn);
        this.field_70765_h = new MoveHelperController(this);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new FloatGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new AttackGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new FaceRandomGoal(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new HopGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, false, p_213811_1_ -> Math.abs(p_213811_1_.func_226278_cu_() - this.func_226278_cu_()) <= 4.0));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184711_bt, 1);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
    }

    protected void func_70799_a(int size, boolean resetHealth) {
        this.field_70180_af.func_187227_b(field_184711_bt, size);
        this.func_226264_Z_();
        this.func_213323_x_();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(size * size));
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)(0.2f + 0.1f * (float)size));
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)size);
        if (resetHealth) {
            this.func_70606_j(this.func_110138_aP());
        }
        this.field_70728_aV = size;
    }

    public int func_70809_q() {
        return this.field_70180_af.func_187225_a(field_184711_bt);
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Size", this.func_70809_q() - 1);
        compound.func_74757_a("wasOnGround", this.field_175452_bi);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        int i = compound.func_74762_e("Size");
        if (i < 0) {
            i = 0;
        }
        this.func_70799_a(i + 1, false);
        super.func_70037_a(compound);
        this.field_175452_bi = compound.func_74767_n("wasOnGround");
    }

    public boolean func_189101_db() {
        return this.func_70809_q() <= 1;
    }

    protected IParticleData func_195404_m() {
        return ParticleTypes.field_197592_C;
    }

    @Override
    protected boolean func_225511_J_() {
        return this.func_70809_q() > 0;
    }

    @Override
    public void func_70071_h_() {
        this.field_70811_b += (this.field_70813_a - this.field_70811_b) * 0.5f;
        this.field_70812_c = this.field_70811_b;
        super.func_70071_h_();
        if (this.field_70122_E && !this.field_175452_bi) {
            int i = this.func_70809_q();
            if (this.spawnCustomParticles()) {
                i = 0;
            }
            for (int j = 0; j < i * 8; ++j) {
                float f = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
                float f1 = this.field_70146_Z.nextFloat() * 0.5f + 0.5f;
                float f2 = MathHelper.func_76126_a((float)f) * (float)i * 0.5f * f1;
                float f3 = MathHelper.func_76134_b((float)f) * (float)i * 0.5f * f1;
                this.field_70170_p.func_195594_a(this.func_195404_m(), this.func_226277_ct_() + (double)f2, this.func_226278_cu_(), this.func_226281_cx_() + (double)f3, 0.0, 0.0, 0.0);
            }
            this.func_184185_a(this.func_184709_cY(), this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) / 0.8f);
            this.field_70813_a = -0.5f;
        } else if (!this.field_70122_E && this.field_175452_bi) {
            this.field_70813_a = 1.0f;
        }
        this.field_175452_bi = this.field_70122_E;
        this.func_70808_l();
    }

    protected void func_70808_l() {
        this.field_70813_a *= 0.6f;
    }

    protected int func_70806_k() {
        return this.field_70146_Z.nextInt(20) + 10;
    }

    @Override
    public void func_213323_x_() {
        double d0 = this.func_226277_ct_();
        double d1 = this.func_226278_cu_();
        double d2 = this.func_226281_cx_();
        super.func_213323_x_();
        this.func_70107_b(d0, d1, d2);
    }

    @Override
    public void func_184206_a(DataParameter<?> key) {
        if (field_184711_bt.equals(key)) {
            this.func_213323_x_();
            this.field_70177_z = this.field_70759_as;
            this.field_70761_aq = this.field_70759_as;
            if (this.func_70090_H() && this.field_70146_Z.nextInt(20) == 0) {
                this.func_71061_d_();
            }
        }
        super.func_184206_a(key);
    }

    public EntityType<? extends SlimeEntity> func_200600_R() {
        return super.func_200600_R();
    }

    @Override
    public void remove(boolean keepData) {
        int i = this.func_70809_q();
        if (!this.field_70170_p.field_72995_K && i > 1 && this.func_110143_aJ() <= 0.0f && !this.field_70128_L) {
            int j = 2 + this.field_70146_Z.nextInt(3);
            for (int k = 0; k < j; ++k) {
                float f = ((float)(k % 2) - 0.5f) * (float)i / 4.0f;
                float f1 = ((float)(k / 2) - 0.5f) * (float)i / 4.0f;
                SlimeEntity slimeentity = this.func_200600_R().func_200721_a(this.field_70170_p);
                if (this.func_145818_k_()) {
                    slimeentity.func_200203_b(this.func_200201_e());
                }
                if (this.func_104002_bU()) {
                    slimeentity.func_110163_bv();
                }
                slimeentity.func_184224_h(this.func_190530_aW());
                slimeentity.func_70799_a(i / 2, true);
                slimeentity.func_70012_b(this.func_226277_ct_() + (double)f, this.func_226278_cu_() + 0.5, this.func_226281_cx_() + (double)f1, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
                this.field_70170_p.func_217376_c(slimeentity);
            }
        }
        super.remove(keepData);
    }

    @Override
    public void func_70108_f(Entity entityIn) {
        super.func_70108_f(entityIn);
        if (entityIn instanceof IronGolemEntity && this.func_70800_m()) {
            this.func_175451_e((LivingEntity)entityIn);
        }
    }

    @Override
    public void func_70100_b_(PlayerEntity entityIn) {
        if (this.func_70800_m()) {
            this.func_175451_e(entityIn);
        }
    }

    protected void func_175451_e(LivingEntity entityIn) {
        if (this.func_70089_S()) {
            int i = this.func_70809_q();
            if (this.func_70068_e(entityIn) < 0.6 * (double)i * 0.6 * (double)i && this.func_70685_l(entityIn) && entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), this.func_225512_er_())) {
                this.func_184185_a(SoundEvents.field_187870_fk, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                this.func_174815_a(this, entityIn);
            }
        }
    }

    @Override
    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 0.625f * sizeIn.field_220316_b;
    }

    protected boolean func_70800_m() {
        return !this.func_189101_db() && this.func_70613_aW();
    }

    protected float func_225512_er_() {
        return (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return this.func_189101_db() ? SoundEvents.field_187898_fy : SoundEvents.field_187880_fp;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return this.func_189101_db() ? SoundEvents.field_187896_fx : SoundEvents.field_187874_fm;
    }

    protected SoundEvent func_184709_cY() {
        return this.func_189101_db() ? SoundEvents.field_187900_fz : SoundEvents.field_187886_fs;
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return this.func_70809_q() == 1 ? this.func_200600_R().func_220348_g() : LootTables.field_186419_a;
    }

    public static boolean func_223366_c(EntityType<SlimeEntity> p_223366_0_, IWorld p_223366_1_, SpawnReason reason, BlockPos p_223366_3_, Random randomIn) {
        if (p_223366_1_.func_72912_H().func_76067_t().handleSlimeSpawnReduction(randomIn, p_223366_1_) && randomIn.nextInt(4) != 1) {
            return false;
        }
        if (p_223366_1_.func_175659_aa() != Difficulty.PEACEFUL) {
            boolean flag;
            Biome biome = p_223366_1_.func_226691_t_(p_223366_3_);
            if (biome == Biomes.field_76780_h && p_223366_3_.func_177956_o() > 50 && p_223366_3_.func_177956_o() < 70 && randomIn.nextFloat() < 0.5f && randomIn.nextFloat() < p_223366_1_.func_130001_d() && p_223366_1_.func_201696_r(p_223366_3_) <= randomIn.nextInt(8)) {
                return SlimeEntity.func_223315_a(p_223366_0_, p_223366_1_, reason, p_223366_3_, randomIn);
            }
            ChunkPos chunkpos = new ChunkPos(p_223366_3_);
            boolean bl = flag = SharedSeedRandom.func_205190_a((int)chunkpos.field_77276_a, (int)chunkpos.field_77275_b, (long)p_223366_1_.func_72905_C(), (long)987234911L).nextInt(10) == 0;
            if (randomIn.nextInt(10) == 0 && flag && p_223366_3_.func_177956_o() < 40) {
                return SlimeEntity.func_223315_a(p_223366_0_, p_223366_1_, reason, p_223366_3_, randomIn);
            }
        }
        return false;
    }

    @Override
    protected float func_70599_aP() {
        return 0.4f * (float)this.func_70809_q();
    }

    @Override
    public int func_70646_bf() {
        return 0;
    }

    protected boolean func_70807_r() {
        return this.func_70809_q() > 0;
    }

    @Override
    protected void func_70664_aZ() {
        Vec3d vec3d = this.func_213322_ci();
        this.func_213293_j(vec3d.field_72450_a, this.func_175134_bD(), vec3d.field_72449_c);
        this.field_70160_al = true;
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        int i = this.field_70146_Z.nextInt(3);
        if (i < 2 && this.field_70146_Z.nextFloat() < 0.5f * difficultyIn.func_180170_c()) {
            ++i;
        }
        int j = 1 << i;
        this.func_70799_a(j, true);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected SoundEvent func_184710_cZ() {
        return this.func_189101_db() ? SoundEvents.field_189110_fE : SoundEvents.field_187882_fq;
    }

    @Override
    public EntitySize func_213305_a(Pose poseIn) {
        return super.func_213305_a(poseIn).func_220313_a(0.255f * (float)this.func_70809_q());
    }

    protected boolean spawnCustomParticles() {
        return false;
    }

    static class MoveHelperController
    extends MovementController {
        private float field_179922_g;
        private int field_179924_h;
        private final SlimeEntity field_179925_i;
        private boolean field_179923_j;

        public MoveHelperController(SlimeEntity slimeIn) {
            super((MobEntity)slimeIn);
            this.field_179925_i = slimeIn;
            this.field_179922_g = 180.0f * slimeIn.field_70177_z / (float)Math.PI;
        }

        public void func_179920_a(float yRotIn, boolean aggressive) {
            this.field_179922_g = yRotIn;
            this.field_179923_j = aggressive;
        }

        public void func_179921_a(double speedIn) {
            this.field_75645_e = speedIn;
            this.field_188491_h = MovementController.Action.MOVE_TO;
        }

        public void func_75641_c() {
            this.field_75648_a.field_70759_as = this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, this.field_179922_g, 90.0f);
            this.field_75648_a.field_70761_aq = this.field_75648_a.field_70177_z;
            if (this.field_188491_h != MovementController.Action.MOVE_TO) {
                this.field_75648_a.func_191989_p(0.0f);
            } else {
                this.field_188491_h = MovementController.Action.WAIT;
                if (this.field_75648_a.field_70122_E) {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                    if (this.field_179924_h-- <= 0) {
                        this.field_179924_h = this.field_179925_i.func_70806_k();
                        if (this.field_179923_j) {
                            this.field_179924_h /= 3;
                        }
                        this.field_179925_i.func_70683_ar().func_75660_a();
                        if (this.field_179925_i.func_70807_r()) {
                            this.field_179925_i.func_184185_a(this.field_179925_i.func_184710_cZ(), this.field_179925_i.func_70599_aP(), ((this.field_179925_i.func_70681_au().nextFloat() - this.field_179925_i.func_70681_au().nextFloat()) * 0.2f + 1.0f) * 0.8f);
                        }
                    } else {
                        this.field_179925_i.field_70702_br = 0.0f;
                        this.field_179925_i.field_191988_bg = 0.0f;
                        this.field_75648_a.func_70659_e(0.0f);
                    }
                } else {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                }
            }
        }
    }

    static class HopGoal
    extends Goal {
        private final SlimeEntity field_179458_a;

        public HopGoal(SlimeEntity slimeIn) {
            this.field_179458_a = slimeIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return !this.field_179458_a.func_184218_aH();
        }

        public void func_75246_d() {
            ((MoveHelperController)this.field_179458_a.func_70605_aq()).func_179921_a(1.0);
        }
    }

    static class FloatGoal
    extends Goal {
        private final SlimeEntity field_179457_a;

        public FloatGoal(SlimeEntity slimeIn) {
            this.field_179457_a = slimeIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
            slimeIn.func_70661_as().func_212239_d(true);
        }

        public boolean func_75250_a() {
            return (this.field_179457_a.func_70090_H() || this.field_179457_a.func_180799_ab()) && this.field_179457_a.func_70605_aq() instanceof MoveHelperController;
        }

        public void func_75246_d() {
            if (this.field_179457_a.func_70681_au().nextFloat() < 0.8f) {
                this.field_179457_a.func_70683_ar().func_75660_a();
            }
            ((MoveHelperController)this.field_179457_a.func_70605_aq()).func_179921_a(1.2);
        }
    }

    static class FaceRandomGoal
    extends Goal {
        private final SlimeEntity field_179461_a;
        private float field_179459_b;
        private int field_179460_c;

        public FaceRandomGoal(SlimeEntity slimeIn) {
            this.field_179461_a = slimeIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return this.field_179461_a.func_70638_az() == null && (this.field_179461_a.field_70122_E || this.field_179461_a.func_70090_H() || this.field_179461_a.func_180799_ab() || this.field_179461_a.func_70644_a(Effects.field_188424_y)) && this.field_179461_a.func_70605_aq() instanceof MoveHelperController;
        }

        public void func_75246_d() {
            if (--this.field_179460_c <= 0) {
                this.field_179460_c = 40 + this.field_179461_a.func_70681_au().nextInt(60);
                this.field_179459_b = this.field_179461_a.func_70681_au().nextInt(360);
            }
            ((MoveHelperController)this.field_179461_a.func_70605_aq()).func_179920_a(this.field_179459_b, false);
        }
    }

    static class AttackGoal
    extends Goal {
        private final SlimeEntity field_179466_a;
        private int field_179465_b;

        public AttackGoal(SlimeEntity slimeIn) {
            this.field_179466_a = slimeIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            LivingEntity livingentity = this.field_179466_a.func_70638_az();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.func_70089_S()) {
                return false;
            }
            return livingentity instanceof PlayerEntity && ((PlayerEntity)livingentity).field_71075_bZ.field_75102_a ? false : this.field_179466_a.func_70605_aq() instanceof MoveHelperController;
        }

        public void func_75249_e() {
            this.field_179465_b = 300;
            super.func_75249_e();
        }

        public boolean func_75253_b() {
            LivingEntity livingentity = this.field_179466_a.func_70638_az();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.func_70089_S()) {
                return false;
            }
            if (livingentity instanceof PlayerEntity && ((PlayerEntity)livingentity).field_71075_bZ.field_75102_a) {
                return false;
            }
            return --this.field_179465_b > 0;
        }

        public void func_75246_d() {
            this.field_179466_a.func_70625_a(this.field_179466_a.func_70638_az(), 10.0f, 10.0f);
            ((MoveHelperController)this.field_179466_a.func_70605_aq()).func_179920_a(this.field_179466_a.field_70177_z, this.field_179466_a.func_70800_m());
        }
    }
}

