/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.player;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.OptionalInt;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.command.CommandSource;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.ChatVisibility;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.CraftingResultSlot;
import net.minecraft.inventory.container.HorseInventoryContainer;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.AbstractMapItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffers;
import net.minecraft.item.WrittenBookItem;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.RecipeBook;
import net.minecraft.item.crafting.ServerRecipeBook;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.network.play.client.CClientSettingsPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.network.play.server.SCameraPacket;
import net.minecraft.network.play.server.SChangeGameStatePacket;
import net.minecraft.network.play.server.SChatPacket;
import net.minecraft.network.play.server.SCloseWindowPacket;
import net.minecraft.network.play.server.SCombatPacket;
import net.minecraft.network.play.server.SDestroyEntitiesPacket;
import net.minecraft.network.play.server.SEntityStatusPacket;
import net.minecraft.network.play.server.SMerchantOffersPacket;
import net.minecraft.network.play.server.SOpenBookWindowPacket;
import net.minecraft.network.play.server.SOpenHorseWindowPacket;
import net.minecraft.network.play.server.SOpenSignMenuPacket;
import net.minecraft.network.play.server.SOpenWindowPacket;
import net.minecraft.network.play.server.SPlayEntityEffectPacket;
import net.minecraft.network.play.server.SPlaySoundEffectPacket;
import net.minecraft.network.play.server.SPlaySoundEventPacket;
import net.minecraft.network.play.server.SPlayerAbilitiesPacket;
import net.minecraft.network.play.server.SPlayerLookPacket;
import net.minecraft.network.play.server.SRemoveEntityEffectPacket;
import net.minecraft.network.play.server.SRespawnPacket;
import net.minecraft.network.play.server.SSendResourcePackPacket;
import net.minecraft.network.play.server.SServerDifficultyPacket;
import net.minecraft.network.play.server.SSetExperiencePacket;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.network.play.server.SSpawnPlayerPacket;
import net.minecraft.network.play.server.SUnloadChunkPacket;
import net.minecraft.network.play.server.SUpdateHealthPacket;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.network.play.server.SWindowItemsPacket;
import net.minecraft.network.play.server.SWindowPropertyPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreCriteria;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerInteractionManager;
import net.minecraft.server.management.PlayerList;
import net.minecraft.stats.ServerStatisticsManager;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.CommandBlockTileEntity;
import net.minecraft.tileentity.SignTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.CooldownTracker;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ServerCooldownTracker;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Unit;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.GameRules;
import net.minecraft.world.GameType;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.hooks.BasicEventHooks;
import net.minecraftforge.fml.network.NetworkHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerPlayerEntity
extends PlayerEntity
implements IContainerListener {
    private static final Logger field_147102_bM = LogManager.getLogger();
    private String field_71148_cg = "en_US";
    public ServerPlayNetHandler field_71135_a;
    public final MinecraftServer field_71133_b;
    public final PlayerInteractionManager field_71134_c;
    private final List<Integer> field_71130_g = Lists.newLinkedList();
    private final PlayerAdvancements field_192042_bX;
    private final ServerStatisticsManager field_147103_bO;
    private float field_130068_bO = Float.MIN_VALUE;
    private int field_184852_bV = Integer.MIN_VALUE;
    private int field_184853_bW = Integer.MIN_VALUE;
    private int field_184854_bX = Integer.MIN_VALUE;
    private int field_184855_bY = Integer.MIN_VALUE;
    private int field_184856_bZ = Integer.MIN_VALUE;
    private float field_71149_ch = -1.0E8f;
    private int field_71146_ci = -99999999;
    private boolean field_71147_cj = true;
    private int field_71144_ck = -99999999;
    private int field_147101_bU = 60;
    private ChatVisibility field_71143_cn;
    private boolean field_71140_co = true;
    private long field_143005_bX = Util.func_211177_b();
    private Entity field_175401_bS;
    private boolean field_184851_cj;
    private boolean field_192040_cp;
    private final ServerRecipeBook field_192041_cq;
    private Vec3d field_193107_ct;
    private int field_193108_cu;
    private boolean field_193109_cv;
    @Nullable
    private Vec3d field_193110_cw;
    private SectionPos field_213851_cv = SectionPos.func_218154_a((int)0, (int)0, (int)0);
    public int field_71139_cq;
    public boolean field_71137_h;
    public int field_71138_i;
    public boolean field_71136_j;

    public ServerPlayerEntity(MinecraftServer server, ServerWorld worldIn, GameProfile profile, PlayerInteractionManager interactionManagerIn) {
        super(worldIn, profile);
        interactionManagerIn.field_73090_b = this;
        this.field_71134_c = interactionManagerIn;
        this.field_71133_b = server;
        this.field_192041_cq = new ServerRecipeBook(server.func_199529_aN());
        this.field_147103_bO = server.func_184103_al().func_152602_a(this);
        this.field_192042_bX = server.func_184103_al().func_192054_h(this);
        this.field_70138_W = 1.0f;
        this.func_205734_a(worldIn);
    }

    private void func_205734_a(ServerWorld p_205734_1_) {
        BlockPos blockpos = p_205734_1_.func_175694_M();
        if (p_205734_1_.field_73011_w.func_191066_m() && p_205734_1_.func_72912_H().func_76077_q() != GameType.ADVENTURE) {
            long k;
            long l;
            int i = Math.max(0, this.field_71133_b.func_184108_a(p_205734_1_));
            int j = MathHelper.func_76128_c((double)p_205734_1_.func_175723_af().func_177729_b(blockpos.func_177958_n(), blockpos.func_177952_p()));
            if (j < i) {
                i = j;
            }
            if (j <= 1) {
                i = 1;
            }
            int i1 = (l = (k = (long)(i * 2 + 1)) * k) > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
            int j1 = this.func_205735_q(i1);
            int k1 = new Random().nextInt(i1);
            for (int l1 = 0; l1 < i1; ++l1) {
                int i2 = (k1 + j1 * l1) % i1;
                int j2 = i2 % (i * 2 + 1);
                int k2 = i2 / (i * 2 + 1);
                BlockPos blockpos1 = p_205734_1_.func_201675_m().func_206921_a(blockpos.func_177958_n() + j2 - i, blockpos.func_177952_p() + k2 - i, false);
                if (blockpos1 == null) continue;
                this.func_174828_a(blockpos1, 0.0f, 0.0f);
                if (!p_205734_1_.func_226669_j_(this)) {
                    continue;
                }
                break;
            }
        } else {
            this.func_174828_a(blockpos, 0.0f, 0.0f);
            while (!p_205734_1_.func_226669_j_(this) && this.func_226278_cu_() < 255.0) {
                this.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + 1.0, this.func_226281_cx_());
            }
        }
    }

    private int func_205735_q(int p_205735_1_) {
        return p_205735_1_ <= 16 ? p_205735_1_ - 1 : 17;
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("playerGameType", 99)) {
            if (this.func_184102_h().func_104056_am()) {
                this.field_71134_c.func_73076_a(this.func_184102_h().func_71265_f());
            } else {
                this.field_71134_c.func_73076_a(GameType.func_77146_a((int)compound.func_74762_e("playerGameType")));
            }
        }
        if (compound.func_150297_b("enteredNetherPosition", 10)) {
            CompoundNBT compoundnbt = compound.func_74775_l("enteredNetherPosition");
            this.field_193110_cw = new Vec3d(compoundnbt.func_74769_h("x"), compoundnbt.func_74769_h("y"), compoundnbt.func_74769_h("z"));
        }
        this.field_192040_cp = compound.func_74767_n("seenCredits");
        if (compound.func_150297_b("recipeBook", 10)) {
            this.field_192041_cq.func_192825_a(compound.func_74775_l("recipeBook"));
        }
        if (this.func_70608_bn()) {
            this.func_213366_dy();
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("playerGameType", this.field_71134_c.func_73081_b().func_77148_a());
        compound.func_74757_a("seenCredits", this.field_192040_cp);
        if (this.field_193110_cw != null) {
            CompoundNBT compoundnbt = new CompoundNBT();
            compoundnbt.func_74780_a("x", this.field_193110_cw.field_72450_a);
            compoundnbt.func_74780_a("y", this.field_193110_cw.field_72448_b);
            compoundnbt.func_74780_a("z", this.field_193110_cw.field_72449_c);
            compound.func_218657_a("enteredNetherPosition", compoundnbt);
        }
        Entity entity1 = this.func_184208_bv();
        Entity entity = this.func_184187_bx();
        if (entity != null && entity1 != this && entity1.func_200601_bK()) {
            CompoundNBT compoundnbt1 = new CompoundNBT();
            CompoundNBT compoundnbt2 = new CompoundNBT();
            entity1.func_70039_c(compoundnbt2);
            compoundnbt1.func_186854_a("Attach", entity.func_110124_au());
            compoundnbt1.func_218657_a("Entity", compoundnbt2);
            compound.func_218657_a("RootVehicle", compoundnbt1);
        }
        compound.func_218657_a("recipeBook", this.field_192041_cq.func_192824_e());
    }

    public void func_195394_a(int p_195394_1_) {
        float f = this.func_71050_bK();
        float f1 = (f - 1.0f) / f;
        this.field_71106_cc = MathHelper.func_76131_a((float)((float)p_195394_1_ / f), (float)0.0f, (float)f1);
        this.field_71144_ck = -1;
    }

    public void func_195399_b(int p_195399_1_) {
        this.field_71068_ca = p_195399_1_;
        this.field_71144_ck = -1;
    }

    @Override
    public void func_82242_a(int levels) {
        super.func_82242_a(levels);
        this.field_71144_ck = -1;
    }

    @Override
    public void func_192024_a(ItemStack enchantedItem, int cost) {
        super.func_192024_a(enchantedItem, cost);
        this.field_71144_ck = -1;
    }

    public void func_71116_b() {
        this.field_71070_bA.func_75132_a(this);
    }

    @Override
    public void func_152111_bt() {
        super.func_152111_bt();
        this.field_71135_a.func_147359_a((IPacket<?>)new SCombatPacket(this.func_110142_aN(), SCombatPacket.Event.ENTER_COMBAT));
    }

    @Override
    public void func_152112_bu() {
        super.func_152112_bu();
        this.field_71135_a.func_147359_a((IPacket<?>)new SCombatPacket(this.func_110142_aN(), SCombatPacket.Event.END_COMBAT));
    }

    @Override
    protected void func_191955_a(BlockState p_191955_1_) {
        CriteriaTriggers.field_192124_d.func_192193_a(this, p_191955_1_);
    }

    @Override
    protected CooldownTracker func_184815_l() {
        return new ServerCooldownTracker(this);
    }

    @Override
    public void func_70071_h_() {
        this.field_71134_c.func_73075_a();
        --this.field_147101_bU;
        if (this.field_70172_ad > 0) {
            --this.field_70172_ad;
        }
        this.field_71070_bA.func_75142_b();
        if (!this.field_70170_p.field_72995_K && !this.field_71070_bA.func_75145_c(this)) {
            this.func_71053_j();
            this.field_71070_bA = this.field_71069_bz;
        }
        while (!this.field_71130_g.isEmpty()) {
            int i = Math.min(this.field_71130_g.size(), Integer.MAX_VALUE);
            int[] aint = new int[i];
            Iterator<Integer> iterator = this.field_71130_g.iterator();
            int j = 0;
            while (iterator.hasNext() && j < i) {
                aint[j++] = iterator.next();
                iterator.remove();
            }
            this.field_71135_a.func_147359_a((IPacket<?>)new SDestroyEntitiesPacket(aint));
        }
        Entity entity = this.func_175398_C();
        if (entity != this) {
            if (entity.func_70089_S()) {
                this.func_70080_a(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), entity.field_70177_z, entity.field_70125_A);
                this.func_71121_q().func_72863_F().func_217221_a(this);
                if (this.func_226564_dU_()) {
                    this.func_175399_e(this);
                }
            } else {
                this.func_175399_e(this);
            }
        }
        CriteriaTriggers.field_193135_v.func_193182_a(this);
        if (this.field_193107_ct != null) {
            CriteriaTriggers.field_193133_t.func_193162_a(this, this.field_193107_ct, this.field_70173_aa - this.field_193108_cu);
        }
        this.field_192042_bX.func_192741_b(this);
    }

    public void func_71127_g() {
        try {
            if (!this.func_175149_v() || this.field_70170_p.func_175667_e(new BlockPos((Entity)this))) {
                super.func_70071_h_();
            }
            for (int i = 0; i < this.field_71071_by.func_70302_i_(); ++i) {
                IPacket ipacket;
                ItemStack itemstack = this.field_71071_by.func_70301_a(i);
                if (!itemstack.func_77973_b().func_77643_m_() || (ipacket = ((AbstractMapItem)itemstack.func_77973_b()).func_150911_c(itemstack, this.field_70170_p, (PlayerEntity)this)) == null) continue;
                this.field_71135_a.func_147359_a(ipacket);
            }
            if (this.func_110143_aJ() != this.field_71149_ch || this.field_71146_ci != this.field_71100_bB.func_75116_a() || this.field_71100_bB.func_75115_e() == 0.0f != this.field_71147_cj) {
                this.field_71135_a.func_147359_a((IPacket<?>)new SUpdateHealthPacket(this.func_110143_aJ(), this.field_71100_bB.func_75116_a(), this.field_71100_bB.func_75115_e()));
                this.field_71149_ch = this.func_110143_aJ();
                this.field_71146_ci = this.field_71100_bB.func_75116_a();
                boolean bl = this.field_71147_cj = this.field_71100_bB.func_75115_e() == 0.0f;
            }
            if (this.func_110143_aJ() + this.func_110139_bj() != this.field_130068_bO) {
                this.field_130068_bO = this.func_110143_aJ() + this.func_110139_bj();
                this.func_184849_a(ScoreCriteria.field_96638_f, MathHelper.func_76123_f((float)this.field_130068_bO));
            }
            if (this.field_71100_bB.func_75116_a() != this.field_184852_bV) {
                this.field_184852_bV = this.field_71100_bB.func_75116_a();
                this.func_184849_a(ScoreCriteria.field_186698_h, MathHelper.func_76123_f((float)this.field_184852_bV));
            }
            if (this.func_70086_ai() != this.field_184853_bW) {
                this.field_184853_bW = this.func_70086_ai();
                this.func_184849_a(ScoreCriteria.field_186699_i, MathHelper.func_76123_f((float)this.field_184853_bW));
            }
            if (this.func_70658_aO() != this.field_184854_bX) {
                this.field_184854_bX = this.func_70658_aO();
                this.func_184849_a(ScoreCriteria.field_186700_j, MathHelper.func_76123_f((float)this.field_184854_bX));
            }
            if (this.field_71067_cb != this.field_184856_bZ) {
                this.field_184856_bZ = this.field_71067_cb;
                this.func_184849_a(ScoreCriteria.field_186701_k, MathHelper.func_76123_f((float)this.field_184856_bZ));
            }
            if (this.field_71068_ca != this.field_184855_bY) {
                this.field_184855_bY = this.field_71068_ca;
                this.func_184849_a(ScoreCriteria.field_186702_l, MathHelper.func_76123_f((float)this.field_184855_bY));
            }
            if (this.field_71067_cb != this.field_71144_ck) {
                this.field_71144_ck = this.field_71067_cb;
                this.field_71135_a.func_147359_a((IPacket<?>)new SSetExperiencePacket(this.field_71106_cc, this.field_71067_cb, this.field_71068_ca));
            }
            if (this.field_70173_aa % 20 == 0) {
                CriteriaTriggers.field_192135_o.func_192215_a(this);
            }
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a(throwable, "Ticking player");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Player being ticked");
            this.func_85029_a(crashreportcategory);
            throw new ReportedException(crashreport);
        }
    }

    private void func_184849_a(ScoreCriteria criteria, int points) {
        this.func_96123_co().func_197893_a(criteria, this.func_195047_I_(), p_195397_1_ -> p_195397_1_.func_96647_c(points));
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        if (ForgeHooks.onLivingDeath((LivingEntity)this, (DamageSource)cause)) {
            return;
        }
        boolean flag = this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223609_l);
        if (flag) {
            ITextComponent itextcomponent = this.func_110142_aN().func_151521_b();
            this.field_71135_a.func_211148_a((IPacket<?>)new SCombatPacket(this.func_110142_aN(), SCombatPacket.Event.ENTITY_DIED, itextcomponent), (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)p_212356_2_ -> {
                if (!p_212356_2_.isSuccess()) {
                    int i = 256;
                    String s = itextcomponent.func_212636_a(256);
                    TranslationTextComponent itextcomponent1 = new TranslationTextComponent("death.attack.message_too_long", new StringTextComponent(s).func_211708_a(TextFormatting.YELLOW));
                    ITextComponent itextcomponent2 = new TranslationTextComponent("death.attack.even_more_magic", this.func_145748_c_()).func_211710_a(arg_0 -> ServerPlayerEntity.lambda$null$1((ITextComponent)itextcomponent1, arg_0));
                    this.field_71135_a.func_147359_a((IPacket<?>)new SCombatPacket(this.func_110142_aN(), SCombatPacket.Event.ENTITY_DIED, itextcomponent2));
                }
            }));
            Team team = this.func_96124_cp();
            if (team != null && team.func_178771_j() != Team.Visible.ALWAYS) {
                if (team.func_178771_j() == Team.Visible.HIDE_FOR_OTHER_TEAMS) {
                    this.field_71133_b.func_184103_al().func_177453_a(this, itextcomponent);
                } else if (team.func_178771_j() == Team.Visible.HIDE_FOR_OWN_TEAM) {
                    this.field_71133_b.func_184103_al().func_177452_b(this, itextcomponent);
                }
            } else {
                this.field_71133_b.func_184103_al().func_148539_a(itextcomponent);
            }
        } else {
            this.field_71135_a.func_147359_a((IPacket<?>)new SCombatPacket(this.func_110142_aN(), SCombatPacket.Event.ENTITY_DIED));
        }
        this.func_192030_dh();
        if (!this.func_175149_v()) {
            this.func_213345_d(cause);
        }
        this.func_96123_co().func_197893_a(ScoreCriteria.field_96642_c, this.func_195047_I_(), Score::func_96648_a);
        LivingEntity livingentity = this.func_94060_bK();
        if (livingentity != null) {
            this.func_71029_a(Stats.field_199091_i.func_199076_b(livingentity.func_200600_R()));
            livingentity.func_191956_a(this, this.field_70744_aE, cause);
            this.func_226298_f_(livingentity);
        }
        this.field_70170_p.func_72960_a(this, (byte)3);
        this.func_195066_a(Stats.field_188069_A);
        this.func_175145_a(Stats.field_199092_j.func_199076_b(Stats.field_188098_h));
        this.func_175145_a(Stats.field_199092_j.func_199076_b(Stats.field_203284_n));
        this.func_70066_B();
        this.func_70052_a(0, false);
        this.func_110142_aN().func_94549_h();
    }

    @Override
    public void func_191956_a(Entity p_191956_1_, int p_191956_2_, DamageSource p_191956_3_) {
        if (p_191956_1_ != this) {
            super.func_191956_a(p_191956_1_, p_191956_2_, p_191956_3_);
            this.func_85039_t(p_191956_2_);
            String s = this.func_195047_I_();
            String s1 = p_191956_1_.func_195047_I_();
            this.func_96123_co().func_197893_a(ScoreCriteria.field_96640_e, s, Score::func_96648_a);
            if (p_191956_1_ instanceof PlayerEntity) {
                this.func_195066_a(Stats.field_75932_A);
                this.func_96123_co().func_197893_a(ScoreCriteria.field_96639_d, s, Score::func_96648_a);
            } else {
                this.func_195066_a(Stats.field_188070_B);
            }
            this.func_195398_a(s, s1, ScoreCriteria.field_197913_m);
            this.func_195398_a(s1, s, ScoreCriteria.field_197914_n);
            CriteriaTriggers.field_192122_b.func_192211_a(this, p_191956_1_, p_191956_3_);
        }
    }

    private void func_195398_a(String p_195398_1_, String p_195398_2_, ScoreCriteria[] p_195398_3_) {
        int i;
        ScorePlayerTeam scoreplayerteam = this.func_96123_co().func_96509_i(p_195398_2_);
        if (scoreplayerteam != null && (i = scoreplayerteam.func_178775_l().func_175746_b()) >= 0 && i < p_195398_3_.length) {
            this.func_96123_co().func_197893_a(p_195398_3_[i], p_195398_1_, Score::func_96648_a);
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        boolean flag;
        if (this.func_180431_b(source)) {
            return false;
        }
        boolean bl = flag = this.field_71133_b.func_71262_S() && this.func_175400_cq() && "fall".equals(source.field_76373_n);
        if (!flag && this.field_147101_bU > 0 && source != DamageSource.field_76380_i) {
            return false;
        }
        if (source instanceof EntityDamageSource) {
            AbstractArrowEntity abstractarrowentity;
            Entity entity1;
            Entity entity = source.func_76346_g();
            if (entity instanceof PlayerEntity && !this.func_96122_a((PlayerEntity)entity)) {
                return false;
            }
            if (entity instanceof AbstractArrowEntity && (entity1 = (abstractarrowentity = (AbstractArrowEntity)entity).func_212360_k()) instanceof PlayerEntity && !this.func_96122_a((PlayerEntity)entity1)) {
                return false;
            }
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    public boolean func_96122_a(PlayerEntity other) {
        return !this.func_175400_cq() ? false : super.func_96122_a(other);
    }

    private boolean func_175400_cq() {
        return this.field_71133_b.func_71219_W();
    }

    @Override
    @Nullable
    public Entity func_212321_a(DimensionType destination) {
        if (!ForgeHooks.onTravelToDimension((Entity)this, (DimensionType)destination)) {
            return null;
        }
        this.field_184851_cj = true;
        DimensionType dimensiontype = this.field_71093_bK;
        if (dimensiontype == DimensionType.field_223229_c_ && destination == DimensionType.field_223227_a_) {
            this.func_213319_R();
            this.func_71121_q().removePlayer(this, true);
            if (!this.field_71136_j) {
                this.field_71136_j = true;
                this.field_71135_a.func_147359_a((IPacket<?>)new SChangeGameStatePacket(4, this.field_192040_cp ? 0.0f : 1.0f));
                this.field_192040_cp = true;
            }
            return this;
        }
        ServerWorld serverworld = this.field_71133_b.func_71218_a(dimensiontype);
        this.field_71093_bK = destination;
        ServerWorld serverworld1 = this.field_71133_b.func_71218_a(destination);
        WorldInfo worldinfo = serverworld1.func_72912_H();
        NetworkHooks.sendDimensionDataPacket((NetworkManager)this.field_71135_a.field_147371_a, (ServerPlayerEntity)this);
        this.field_71135_a.func_147359_a(new SRespawnPacket(destination, WorldInfo.func_227498_c_(worldinfo.func_76063_b()), worldinfo.func_76067_t(), this.field_71134_c.func_73081_b()));
        this.field_71135_a.func_147359_a((IPacket<?>)new SServerDifficultyPacket(worldinfo.func_176130_y(), worldinfo.func_176123_z()));
        PlayerList playerlist = this.field_71133_b.func_184103_al();
        playerlist.func_187243_f(this);
        serverworld.removeEntity(this, true);
        this.revive();
        double d0 = this.func_226277_ct_();
        double d1 = this.func_226278_cu_();
        double d2 = this.func_226281_cx_();
        float f = this.field_70125_A;
        float f1 = this.field_70177_z;
        double d3 = 8.0;
        float f2 = f1;
        serverworld.func_217381_Z().func_76320_a("moving");
        double moveFactor = serverworld.func_201675_m().getMovementFactor() / serverworld1.func_201675_m().getMovementFactor();
        d0 *= moveFactor;
        d2 *= moveFactor;
        if (dimensiontype == DimensionType.field_223227_a_ && destination == DimensionType.field_223228_b_) {
            this.field_193110_cw = this.func_213303_ch();
        } else if (dimensiontype == DimensionType.field_223227_a_ && destination == DimensionType.field_223229_c_) {
            BlockPos blockpos = serverworld1.func_180504_m();
            d0 = blockpos.func_177958_n();
            d1 = blockpos.func_177956_o();
            d2 = blockpos.func_177952_p();
            f1 = 90.0f;
            f = 0.0f;
        }
        this.func_70012_b(d0, d1, d2, f1, f);
        serverworld.func_217381_Z().func_76319_b();
        serverworld.func_217381_Z().func_76320_a("placing");
        double d7 = Math.min(-2.9999872E7, serverworld1.func_175723_af().func_177726_b() + 16.0);
        double d4 = Math.min(-2.9999872E7, serverworld1.func_175723_af().func_177736_c() + 16.0);
        double d5 = Math.min(2.9999872E7, serverworld1.func_175723_af().func_177728_d() - 16.0);
        double d6 = Math.min(2.9999872E7, serverworld1.func_175723_af().func_177733_e() - 16.0);
        d0 = MathHelper.func_151237_a((double)d0, (double)d7, (double)d5);
        d2 = MathHelper.func_151237_a((double)d2, (double)d4, (double)d6);
        this.func_70012_b(d0, d1, d2, f1, f);
        if (destination == DimensionType.field_223229_c_) {
            int i = MathHelper.func_76128_c((double)this.func_226277_ct_());
            int j = MathHelper.func_76128_c((double)this.func_226278_cu_()) - 1;
            int k = MathHelper.func_76128_c((double)this.func_226281_cx_());
            boolean l = true;
            boolean i1 = false;
            for (int j1 = -2; j1 <= 2; ++j1) {
                for (int k1 = -2; k1 <= 2; ++k1) {
                    for (int l1 = -1; l1 < 3; ++l1) {
                        int i2 = i + k1 * 1 + j1 * 0;
                        int j2 = j + l1;
                        int k2 = k + k1 * 0 - j1 * 1;
                        boolean flag = l1 < 0;
                        serverworld1.func_175656_a(new BlockPos(i2, j2, k2), flag ? Blocks.field_150343_Z.func_176223_P() : Blocks.field_150350_a.func_176223_P());
                    }
                }
            }
            this.func_70012_b(i, j, k, f1, 0.0f);
            this.func_213317_d(Vec3d.field_186680_a);
        } else if (!serverworld1.func_85176_s().func_222268_a((Entity)this, f2)) {
            serverworld1.func_85176_s().func_85188_a((Entity)this);
            serverworld1.func_85176_s().func_222268_a((Entity)this, f2);
        }
        serverworld.func_217381_Z().func_76319_b();
        this.func_70029_a(serverworld1);
        serverworld1.func_217447_b(this);
        this.func_213846_b(serverworld);
        this.field_71135_a.func_147364_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), f1, f);
        this.field_71134_c.func_73080_a(serverworld1);
        this.field_71135_a.func_147359_a((IPacket<?>)new SPlayerAbilitiesPacket(this.field_71075_bZ));
        playerlist.func_72354_b(this, serverworld1);
        playerlist.func_72385_f(this);
        for (EffectInstance effectinstance : this.func_70651_bq()) {
            this.field_71135_a.func_147359_a((IPacket<?>)new SPlayEntityEffectPacket(this.func_145782_y(), effectinstance));
        }
        this.field_71135_a.func_147359_a((IPacket<?>)new SPlaySoundEventPacket(1032, BlockPos.field_177992_a, 0, false));
        this.field_71144_ck = -1;
        this.field_71149_ch = -1.0f;
        this.field_71146_ci = -1;
        BasicEventHooks.firePlayerChangedDimensionEvent((PlayerEntity)this, (DimensionType)dimensiontype, (DimensionType)destination);
        return this;
    }

    private void func_213846_b(ServerWorld p_213846_1_) {
        DimensionType dimensiontype = p_213846_1_.field_73011_w.func_186058_p();
        DimensionType dimensiontype1 = this.field_70170_p.field_73011_w.func_186058_p();
        CriteriaTriggers.field_193134_u.func_193143_a(this, dimensiontype, dimensiontype1);
        if (dimensiontype == DimensionType.field_223228_b_ && dimensiontype1 == DimensionType.field_223227_a_ && this.field_193110_cw != null) {
            CriteriaTriggers.field_193131_B.func_193168_a(this, this.field_193110_cw);
        }
        if (dimensiontype1 != DimensionType.field_223228_b_) {
            this.field_193110_cw = null;
        }
    }

    @Override
    public boolean func_174827_a(ServerPlayerEntity player) {
        if (player.func_175149_v()) {
            return this.func_175398_C() == this;
        }
        return this.func_175149_v() ? false : super.func_174827_a(player);
    }

    private void func_147097_b(TileEntity p_147097_1_) {
        SUpdateTileEntityPacket supdatetileentitypacket;
        if (p_147097_1_ != null && (supdatetileentitypacket = p_147097_1_.func_189518_D_()) != null) {
            this.field_71135_a.func_147359_a((IPacket<?>)supdatetileentitypacket);
        }
    }

    @Override
    public void func_71001_a(Entity entityIn, int quantity) {
        super.func_71001_a(entityIn, quantity);
        this.field_71070_bA.func_75142_b();
    }

    @Override
    public Either<PlayerEntity.SleepResult, Unit> func_213819_a(BlockPos at) {
        return super.func_213819_a(at).ifRight(p_213849_1_ -> {
            this.func_195066_a(Stats.field_188064_ad);
            CriteriaTriggers.field_192136_p.func_192215_a(this);
        });
    }

    @Override
    public void func_225652_a_(boolean p_225652_1_, boolean p_225652_2_) {
        if (this.func_70608_bn()) {
            this.func_71121_q().func_72863_F().func_217216_a((Entity)this, (IPacket)new SAnimateHandPacket((Entity)this, 2));
        }
        super.func_225652_a_(p_225652_1_, p_225652_2_);
        if (this.field_71135_a != null) {
            this.field_71135_a.func_147364_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, this.field_70125_A);
        }
    }

    @Override
    public boolean func_184205_a(Entity entityIn, boolean force) {
        Entity entity = this.func_184187_bx();
        if (!super.func_184205_a(entityIn, force)) {
            return false;
        }
        Entity entity1 = this.func_184187_bx();
        if (entity1 != entity && this.field_71135_a != null) {
            this.field_71135_a.func_147364_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, this.field_70125_A);
        }
        return true;
    }

    @Override
    public void func_184210_p() {
        Entity entity = this.func_184187_bx();
        super.func_184210_p();
        Entity entity1 = this.func_184187_bx();
        if (entity1 != entity && this.field_71135_a != null) {
            this.field_71135_a.func_147364_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, this.field_70125_A);
        }
    }

    @Override
    public boolean func_180431_b(DamageSource source) {
        return super.func_180431_b(source) || this.func_184850_K() || this.field_71075_bZ.field_75102_a && source == DamageSource.field_82727_n;
    }

    @Override
    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    @Override
    protected void func_184594_b(BlockPos pos) {
        if (!this.func_175149_v()) {
            super.func_184594_b(pos);
        }
    }

    public void func_71122_b(double y, boolean onGroundIn) {
        BlockPos blockpos = this.func_226268_ag_();
        if (this.field_70170_p.func_175667_e(blockpos)) {
            BlockState blockstate = this.field_70170_p.func_180495_p(blockpos);
            super.func_184231_a(y, onGroundIn, blockstate, blockpos);
        }
    }

    @Override
    public void func_175141_a(SignTileEntity signTile) {
        signTile.func_145912_a((PlayerEntity)this);
        this.field_71135_a.func_147359_a((IPacket<?>)new SOpenSignMenuPacket(signTile.func_174877_v()));
    }

    public void func_71117_bO() {
        this.field_71139_cq = this.field_71139_cq % 100 + 1;
    }

    @Override
    public OptionalInt func_213829_a(@Nullable INamedContainerProvider p_213829_1_) {
        if (p_213829_1_ == null) {
            return OptionalInt.empty();
        }
        if (this.field_71070_bA != this.field_71069_bz) {
            this.func_71053_j();
        }
        this.func_71117_bO();
        Container container = p_213829_1_.createMenu(this.field_71139_cq, this.field_71071_by, (PlayerEntity)this);
        if (container == null) {
            if (this.func_175149_v()) {
                this.func_146105_b(new TranslationTextComponent("container.spectatorCantOpen", new Object[0]).func_211708_a(TextFormatting.RED), true);
            }
            return OptionalInt.empty();
        }
        this.field_71135_a.func_147359_a((IPacket<?>)new SOpenWindowPacket(container.field_75152_c, container.func_216957_a(), p_213829_1_.func_145748_c_()));
        container.func_75132_a(this);
        this.field_71070_bA = container;
        MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((PlayerEntity)this, this.field_71070_bA));
        return OptionalInt.of(this.field_71139_cq);
    }

    @Override
    public void func_213818_a(int p_213818_1_, MerchantOffers p_213818_2_, int p_213818_3_, int p_213818_4_, boolean p_213818_5_, boolean p_213818_6_) {
        this.field_71135_a.func_147359_a((IPacket<?>)new SMerchantOffersPacket(p_213818_1_, p_213818_2_, p_213818_3_, p_213818_4_, p_213818_5_, p_213818_6_));
    }

    @Override
    public void func_184826_a(AbstractHorseEntity horse, IInventory inventoryIn) {
        if (this.field_71070_bA != this.field_71069_bz) {
            this.func_71053_j();
        }
        this.func_71117_bO();
        this.field_71135_a.func_147359_a((IPacket<?>)new SOpenHorseWindowPacket(this.field_71139_cq, inventoryIn.func_70302_i_(), horse.func_145782_y()));
        this.field_71070_bA = new HorseInventoryContainer(this.field_71139_cq, this.field_71071_by, inventoryIn, horse);
        this.field_71070_bA.func_75132_a(this);
        MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((PlayerEntity)this, this.field_71070_bA));
    }

    @Override
    public void func_184814_a(ItemStack stack, Hand hand) {
        Item item = stack.func_77973_b();
        if (item == Items.field_151164_bB) {
            if (WrittenBookItem.func_220050_a((ItemStack)stack, (CommandSource)this.func_195051_bN(), (PlayerEntity)this)) {
                this.field_71070_bA.func_75142_b();
            }
            this.field_71135_a.func_147359_a((IPacket<?>)new SOpenBookWindowPacket(hand));
        }
    }

    @Override
    public void func_184824_a(CommandBlockTileEntity commandBlock) {
        commandBlock.func_184252_d(true);
        this.func_147097_b((TileEntity)commandBlock);
    }

    public void func_71111_a(Container containerToSend, int slotInd, ItemStack stack) {
        if (!(containerToSend.func_75139_a(slotInd) instanceof CraftingResultSlot)) {
            if (containerToSend == this.field_71069_bz) {
                CriteriaTriggers.field_192125_e.func_192208_a(this, this.field_71071_by);
            }
            if (!this.field_71137_h) {
                this.field_71135_a.func_147359_a((IPacket<?>)new SSetSlotPacket(containerToSend.field_75152_c, slotInd, stack));
            }
        }
    }

    public void func_71120_a(Container containerIn) {
        this.func_71110_a(containerIn, containerIn.func_75138_a());
    }

    public void func_71110_a(Container containerToSend, NonNullList<ItemStack> itemsList) {
        this.field_71135_a.func_147359_a((IPacket<?>)new SWindowItemsPacket(containerToSend.field_75152_c, itemsList));
        this.field_71135_a.func_147359_a((IPacket<?>)new SSetSlotPacket(-1, -1, this.field_71071_by.func_70445_o()));
    }

    public void func_71112_a(Container containerIn, int varToUpdate, int newValue) {
        this.field_71135_a.func_147359_a((IPacket<?>)new SWindowPropertyPacket(containerIn.field_75152_c, varToUpdate, newValue));
    }

    @Override
    public void func_71053_j() {
        this.field_71135_a.func_147359_a((IPacket<?>)new SCloseWindowPacket(this.field_71070_bA.field_75152_c));
        this.func_71128_l();
    }

    public void func_71113_k() {
        if (!this.field_71137_h) {
            this.field_71135_a.func_147359_a((IPacket<?>)new SSetSlotPacket(-1, -1, this.field_71071_by.func_70445_o()));
        }
    }

    public void func_71128_l() {
        this.field_71070_bA.func_75134_a(this);
        MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Close((PlayerEntity)this, this.field_71070_bA));
        this.field_71070_bA = this.field_71069_bz;
    }

    public void func_110430_a(float strafe, float forward, boolean jumping, boolean sneaking) {
        if (this.func_184218_aH()) {
            if (strafe >= -1.0f && strafe <= 1.0f) {
                this.field_70702_br = strafe;
            }
            if (forward >= -1.0f && forward <= 1.0f) {
                this.field_191988_bg = forward;
            }
            this.field_70703_bu = jumping;
            this.func_226284_e_(sneaking);
        }
    }

    @Override
    public void func_71064_a(Stat<?> stat, int amount) {
        this.field_147103_bO.func_150871_b((PlayerEntity)this, stat, amount);
        this.func_96123_co().func_197893_a(stat, this.func_195047_I_(), p_195396_1_ -> p_195396_1_.func_96649_a(amount));
    }

    @Override
    public void func_175145_a(Stat<?> stat) {
        this.field_147103_bO.func_150873_a((PlayerEntity)this, stat, 0);
        this.func_96123_co().func_197893_a(stat, this.func_195047_I_(), Score::func_197891_c);
    }

    @Override
    public int func_195065_a(Collection<IRecipe<?>> p_195065_1_) {
        return this.field_192041_cq.func_197926_a(p_195065_1_, this);
    }

    @Override
    public void func_193102_a(ResourceLocation[] p_193102_1_) {
        ArrayList list = Lists.newArrayList();
        for (ResourceLocation resourcelocation : p_193102_1_) {
            this.field_71133_b.func_199529_aN().func_215367_a(resourcelocation).ifPresent(list::add);
        }
        this.func_195065_a(list);
    }

    @Override
    public int func_195069_b(Collection<IRecipe<?>> p_195069_1_) {
        return this.field_192041_cq.func_197925_b(p_195069_1_, this);
    }

    @Override
    public void func_195068_e(int p_195068_1_) {
        super.func_195068_e(p_195068_1_);
        this.field_71144_ck = -1;
    }

    public void func_71123_m() {
        this.field_193109_cv = true;
        this.func_184226_ay();
        if (this.func_70608_bn()) {
            this.func_225652_a_(true, false);
        }
    }

    public boolean func_193105_t() {
        return this.field_193109_cv;
    }

    public void func_71118_n() {
        this.field_71149_ch = -1.0E8f;
    }

    @Override
    public void func_146105_b(ITextComponent chatComponent, boolean actionBar) {
        this.field_71135_a.func_147359_a((IPacket<?>)new SChatPacket(chatComponent, actionBar ? ChatType.GAME_INFO : ChatType.CHAT));
    }

    @Override
    protected void func_71036_o() {
        if (!this.field_184627_bm.func_190926_b() && this.func_184587_cr()) {
            this.field_71135_a.func_147359_a((IPacket<?>)new SEntityStatusPacket((Entity)this, 9));
            super.func_71036_o();
        }
    }

    @Override
    public void func_200602_a(EntityAnchorArgument.Type p_200602_1_, Vec3d p_200602_2_) {
        super.func_200602_a(p_200602_1_, p_200602_2_);
        this.field_71135_a.func_147359_a((IPacket<?>)new SPlayerLookPacket(p_200602_1_, p_200602_2_.field_72450_a, p_200602_2_.field_72448_b, p_200602_2_.field_72449_c));
    }

    public void func_200618_a(EntityAnchorArgument.Type p_200618_1_, Entity p_200618_2_, EntityAnchorArgument.Type p_200618_3_) {
        Vec3d vec3d = p_200618_3_.func_201017_a(p_200618_2_);
        super.func_200602_a(p_200618_1_, vec3d);
        this.field_71135_a.func_147359_a((IPacket<?>)new SPlayerLookPacket(p_200618_1_, p_200618_2_, p_200618_3_));
    }

    public void func_193104_a(ServerPlayerEntity that, boolean keepEverything) {
        CompoundNBT old;
        if (keepEverything) {
            this.field_71071_by.func_70455_b(that.field_71071_by);
            this.func_70606_j(that.func_110143_aJ());
            this.field_71100_bB = that.field_71100_bB;
            this.field_71068_ca = that.field_71068_ca;
            this.field_71067_cb = that.field_71067_cb;
            this.field_71106_cc = that.field_71106_cc;
            this.func_85040_s(that.func_71037_bA());
            this.field_181016_an = that.field_181016_an;
            this.field_181017_ao = that.field_181017_ao;
            this.field_181018_ap = that.field_181018_ap;
        } else if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223600_c) || that.func_175149_v()) {
            this.field_71071_by.func_70455_b(that.field_71071_by);
            this.field_71068_ca = that.field_71068_ca;
            this.field_71067_cb = that.field_71067_cb;
            this.field_71106_cc = that.field_71106_cc;
            this.func_85040_s(that.func_71037_bA());
        }
        this.field_175152_f = that.field_175152_f;
        this.field_71078_a = that.field_71078_a;
        this.func_184212_Q().func_187227_b(field_184827_bp, that.func_184212_Q().func_187225_a(field_184827_bp));
        this.field_71144_ck = -1;
        this.field_71149_ch = -1.0f;
        this.field_71146_ci = -1;
        this.field_192041_cq.func_193824_a((RecipeBook)that.field_192041_cq);
        this.field_71130_g.addAll(that.field_71130_g);
        this.field_192040_cp = that.field_192040_cp;
        this.field_193110_cw = that.field_193110_cw;
        this.func_192029_h(that.func_192023_dk());
        this.func_192031_i(that.func_192025_dl());
        this.spawnPosMap = that.spawnPosMap;
        this.spawnForcedMap = that.spawnForcedMap;
        if (that.field_71093_bK != DimensionType.field_223227_a_) {
            this.field_71077_c = that.field_71077_c;
            this.field_82248_d = that.field_82248_d;
        }
        if ((old = that.getPersistentData()).func_74764_b("PlayerPersisted")) {
            this.getPersistentData().func_218657_a("PlayerPersisted", old.func_74781_a("PlayerPersisted"));
        }
        ForgeEventFactory.onPlayerClone((PlayerEntity)this, (PlayerEntity)that, (!keepEverything ? 1 : 0) != 0);
    }

    @Override
    protected void func_70670_a(EffectInstance id) {
        super.func_70670_a(id);
        this.field_71135_a.func_147359_a((IPacket<?>)new SPlayEntityEffectPacket(this.func_145782_y(), id));
        if (id.func_188419_a() == Effects.field_188424_y) {
            this.field_193108_cu = this.field_70173_aa;
            this.field_193107_ct = this.func_213303_ch();
        }
        CriteriaTriggers.field_193139_z.func_193153_a(this);
    }

    @Override
    protected void func_70695_b(EffectInstance id, boolean p_70695_2_) {
        super.func_70695_b(id, p_70695_2_);
        this.field_71135_a.func_147359_a((IPacket<?>)new SPlayEntityEffectPacket(this.func_145782_y(), id));
        CriteriaTriggers.field_193139_z.func_193153_a(this);
    }

    @Override
    protected void func_70688_c(EffectInstance effect) {
        super.func_70688_c(effect);
        this.field_71135_a.func_147359_a((IPacket<?>)new SRemoveEntityEffectPacket(this.func_145782_y(), effect.func_188419_a()));
        if (effect.func_188419_a() == Effects.field_188424_y) {
            this.field_193107_ct = null;
        }
        CriteriaTriggers.field_193139_z.func_193153_a(this);
    }

    @Override
    public void func_70634_a(double x, double y, double z) {
        this.field_71135_a.func_147364_a(x, y, z, this.field_70177_z, this.field_70125_A);
    }

    @Override
    public void func_225653_b_(double p_225653_1_, double p_225653_3_, double p_225653_5_) {
        this.field_71135_a.func_147364_a(p_225653_1_, p_225653_3_, p_225653_5_, this.field_70177_z, this.field_70125_A);
        this.field_71135_a.func_184342_d();
    }

    @Override
    public void func_71009_b(Entity entityHit) {
        this.func_71121_q().func_72863_F().func_217216_a((Entity)this, (IPacket)new SAnimateHandPacket(entityHit, 4));
    }

    @Override
    public void func_71047_c(Entity entityHit) {
        this.func_71121_q().func_72863_F().func_217216_a((Entity)this, (IPacket)new SAnimateHandPacket(entityHit, 5));
    }

    @Override
    public void func_71016_p() {
        if (this.field_71135_a != null) {
            this.field_71135_a.func_147359_a((IPacket<?>)new SPlayerAbilitiesPacket(this.field_71075_bZ));
            this.func_175135_B();
        }
    }

    public ServerWorld func_71121_q() {
        return (ServerWorld)this.field_70170_p;
    }

    @Override
    public void func_71033_a(GameType gameType) {
        this.field_71134_c.func_73076_a(gameType);
        this.field_71135_a.func_147359_a((IPacket<?>)new SChangeGameStatePacket(3, (float)gameType.func_77148_a()));
        if (gameType == GameType.SPECTATOR) {
            this.func_192030_dh();
            this.func_184210_p();
        } else {
            this.func_175399_e(this);
        }
        this.func_71016_p();
        this.func_175136_bO();
    }

    @Override
    public boolean func_175149_v() {
        return this.field_71134_c.func_73081_b() == GameType.SPECTATOR;
    }

    @Override
    public boolean func_184812_l_() {
        return this.field_71134_c.func_73081_b() == GameType.CREATIVE;
    }

    @Override
    public void func_145747_a(ITextComponent component) {
        this.func_195395_a(component, ChatType.SYSTEM);
    }

    public void func_195395_a(ITextComponent textComponent, ChatType chatTypeIn) {
        this.field_71135_a.func_211148_a((IPacket<?>)new SChatPacket(textComponent, chatTypeIn), (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)p_211144_3_ -> {
            if (!(p_211144_3_.isSuccess() || chatTypeIn != ChatType.GAME_INFO && chatTypeIn != ChatType.SYSTEM)) {
                int i = 256;
                String s = textComponent.func_212636_a(256);
                ITextComponent itextcomponent = new StringTextComponent(s).func_211708_a(TextFormatting.YELLOW);
                this.field_71135_a.func_147359_a((IPacket<?>)new SChatPacket(new TranslationTextComponent("multiplayer.message_not_delivered", itextcomponent).func_211708_a(TextFormatting.RED), ChatType.SYSTEM));
            }
        }));
    }

    public String func_71114_r() {
        String s = this.field_71135_a.field_147371_a.func_74430_c().toString();
        s = s.substring(s.indexOf("/") + 1);
        s = s.substring(0, s.indexOf(":"));
        return s;
    }

    public void func_147100_a(CClientSettingsPacket packetIn) {
        this.field_71148_cg = packetIn.func_149524_c();
        this.field_71143_cn = packetIn.func_149523_e();
        this.field_71140_co = packetIn.func_149520_f();
        this.func_184212_Q().func_187227_b(field_184827_bp, (byte)packetIn.func_149521_d());
        this.func_184212_Q().func_187227_b(field_184828_bq, (byte)(packetIn.func_186991_f() != HandSide.LEFT ? 1 : 0));
    }

    public ChatVisibility func_147096_v() {
        return this.field_71143_cn;
    }

    public void func_175397_a(String url, String hash) {
        this.field_71135_a.func_147359_a((IPacket<?>)new SSendResourcePackPacket(url, hash));
    }

    @Override
    protected int func_184840_I() {
        return this.field_71133_b.func_211833_a(this.func_146103_bH());
    }

    public void func_143004_u() {
        this.field_143005_bX = Util.func_211177_b();
    }

    public ServerStatisticsManager func_147099_x() {
        return this.field_147103_bO;
    }

    public ServerRecipeBook func_192037_E() {
        return this.field_192041_cq;
    }

    public void func_152339_d(Entity entityIn) {
        if (entityIn instanceof PlayerEntity) {
            this.field_71135_a.func_147359_a((IPacket<?>)new SDestroyEntitiesPacket(new int[]{entityIn.func_145782_y()}));
        } else {
            this.field_71130_g.add(entityIn.func_145782_y());
        }
    }

    public void func_184848_d(Entity entityIn) {
        this.field_71130_g.remove((Object)entityIn.func_145782_y());
    }

    @Override
    protected void func_175135_B() {
        if (this.func_175149_v()) {
            this.func_175133_bi();
            this.func_82142_c(true);
        } else {
            super.func_175135_B();
        }
    }

    public Entity func_175398_C() {
        return this.field_175401_bS == null ? this : this.field_175401_bS;
    }

    public void func_175399_e(Entity entityToSpectate) {
        Entity entity = this.func_175398_C();
        Entity entity2 = this.field_175401_bS = entityToSpectate == null ? this : entityToSpectate;
        if (entity != this.field_175401_bS) {
            this.field_71135_a.func_147359_a((IPacket<?>)new SCameraPacket(this.field_175401_bS));
            this.func_70634_a(this.field_175401_bS.func_226277_ct_(), this.field_175401_bS.func_226278_cu_(), this.field_175401_bS.func_226281_cx_());
        }
    }

    @Override
    protected void func_184173_H() {
        if (this.field_71088_bW > 0 && !this.field_184851_cj) {
            --this.field_71088_bW;
        }
    }

    @Override
    public void func_71059_n(Entity targetEntity) {
        if (this.field_71134_c.func_73081_b() == GameType.SPECTATOR) {
            this.func_175399_e(targetEntity);
        } else {
            super.func_71059_n(targetEntity);
        }
    }

    public long func_154331_x() {
        return this.field_143005_bX;
    }

    @Nullable
    public ITextComponent func_175396_E() {
        return null;
    }

    @Override
    public void func_184609_a(Hand hand) {
        super.func_184609_a(hand);
        this.func_184821_cY();
    }

    public boolean func_184850_K() {
        return this.field_184851_cj;
    }

    public void func_184846_L() {
        this.field_184851_cj = false;
    }

    public PlayerAdvancements func_192039_O() {
        return this.field_192042_bX;
    }

    public void func_200619_a(ServerWorld p_200619_1_, double x, double y, double z, float yaw, float pitch) {
        this.func_175399_e(this);
        this.func_184210_p();
        if (p_200619_1_ == this.field_70170_p) {
            this.field_71135_a.func_147364_a(x, y, z, yaw, pitch);
        } else if (ForgeHooks.onTravelToDimension((Entity)this, (DimensionType)p_200619_1_.field_73011_w.func_186058_p())) {
            ServerWorld serverworld = this.func_71121_q();
            this.field_71093_bK = p_200619_1_.field_73011_w.func_186058_p();
            WorldInfo worldinfo = p_200619_1_.func_72912_H();
            NetworkHooks.sendDimensionDataPacket((NetworkManager)this.field_71135_a.field_147371_a, (ServerPlayerEntity)this);
            this.field_71135_a.func_147359_a(new SRespawnPacket(this.field_71093_bK, WorldInfo.func_227498_c_(worldinfo.func_76063_b()), worldinfo.func_76067_t(), this.field_71134_c.func_73081_b()));
            this.field_71135_a.func_147359_a((IPacket<?>)new SServerDifficultyPacket(worldinfo.func_176130_y(), worldinfo.func_176123_z()));
            this.field_71133_b.func_184103_al().func_187243_f(this);
            serverworld.removePlayer(this, true);
            this.revive();
            this.func_70012_b(x, y, z, yaw, pitch);
            this.func_70029_a(p_200619_1_);
            p_200619_1_.func_217446_a(this);
            this.func_213846_b(serverworld);
            this.field_71135_a.func_147364_a(x, y, z, yaw, pitch);
            this.field_71134_c.func_73080_a(p_200619_1_);
            this.field_71133_b.func_184103_al().func_72354_b(this, p_200619_1_);
            this.field_71133_b.func_184103_al().func_72385_f(this);
            BasicEventHooks.firePlayerChangedDimensionEvent((PlayerEntity)this, (DimensionType)p_200619_1_.field_73011_w.func_186058_p(), (DimensionType)this.field_71093_bK);
        }
    }

    public void func_213844_a(ChunkPos p_213844_1_, IPacket<?> p_213844_2_, IPacket<?> p_213844_3_) {
        this.field_71135_a.func_147359_a(p_213844_3_);
        this.field_71135_a.func_147359_a(p_213844_2_);
    }

    public void func_213845_a(ChunkPos p_213845_1_) {
        if (this.func_70089_S()) {
            this.field_71135_a.func_147359_a((IPacket<?>)new SUnloadChunkPacket(p_213845_1_.field_77276_a, p_213845_1_.field_77275_b));
        }
    }

    public SectionPos func_213842_M() {
        return this.field_213851_cv;
    }

    public void func_213850_a(SectionPos sectionPosIn) {
        this.field_213851_cv = sectionPosIn;
    }

    @Override
    public void func_213823_a(SoundEvent p_213823_1_, SoundCategory p_213823_2_, float p_213823_3_, float p_213823_4_) {
        this.field_71135_a.func_147359_a((IPacket<?>)new SPlaySoundEffectPacket(p_213823_1_, p_213823_2_, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), p_213823_3_, p_213823_4_));
    }

    @Override
    public IPacket<?> func_213297_N() {
        return new SSpawnPlayerPacket((PlayerEntity)this);
    }

    @Override
    public ItemEntity func_146097_a(ItemStack droppedItem, boolean dropAround, boolean traceItem) {
        ItemEntity itementity = super.func_146097_a(droppedItem, dropAround, traceItem);
        if (itementity == null) {
            return null;
        }
        if (this.captureDrops() != null) {
            this.captureDrops().add(itementity);
        } else {
            this.field_70170_p.func_217376_c(itementity);
        }
        ItemStack itemstack = itementity.func_92059_d();
        if (traceItem) {
            if (!itemstack.func_190926_b()) {
                this.func_71064_a(Stats.field_188068_aj.func_199076_b(itemstack.func_77973_b()), droppedItem.func_190916_E());
            }
            this.func_195066_a(Stats.field_75952_v);
        }
        return itementity;
    }

    private static /* synthetic */ void lambda$null$1(ITextComponent itextcomponent1, Style p_212357_1_) {
        p_212357_1_.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, itextcomponent1));
    }
}

