/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.resources.SimpleResource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.ScreenshotEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ScreenShotHelper {
    private static final Logger field_148261_a = LogManager.getLogger();
    private static final DateFormat field_74295_a = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");

    public static void func_148260_a(File gameDirectory, int width, int height, Framebuffer buffer, Consumer<ITextComponent> p_148260_4_) {
        ScreenShotHelper.func_148259_a(gameDirectory, null, width, height, buffer, p_148260_4_);
    }

    public static void func_148259_a(File gameDirectory, @Nullable String screenshotName, int width, int height, Framebuffer buffer, Consumer<ITextComponent> p_148259_5_) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> ScreenShotHelper.func_228051_b_(gameDirectory, screenshotName, width, height, buffer, p_148259_5_));
        } else {
            ScreenShotHelper.func_228051_b_(gameDirectory, screenshotName, width, height, buffer, p_148259_5_);
        }
    }

    private static void func_228051_b_(File p_228051_0_, @Nullable String p_228051_1_, int p_228051_2_, int p_228051_3_, Framebuffer p_228051_4_, Consumer<ITextComponent> p_228051_5_) {
        NativeImage nativeimage = ScreenShotHelper.func_198052_a(p_228051_2_, p_228051_3_, p_228051_4_);
        File file1 = new File(p_228051_0_, "screenshots");
        file1.mkdir();
        File file2 = p_228051_1_ == null ? ScreenShotHelper.func_74290_a(file1) : new File(file1, p_228051_1_);
        ScreenshotEvent event = ForgeHooksClient.onScreenshot((NativeImage)nativeimage, (File)file2);
        if (event.isCanceled()) {
            p_228051_5_.accept(event.getCancelMessage());
            return;
        }
        File target = event.getScreenshotFile();
        SimpleResource.field_199031_a.execute(() -> {
            try {
                nativeimage.func_209271_a(target);
                ITextComponent itextcomponent = new StringTextComponent(target.getName()).func_211708_a(TextFormatting.UNDERLINE).func_211710_a(p_228050_1_ -> p_228050_1_.func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_FILE, target.getAbsolutePath())));
                if (event.getResultMessage() != null) {
                    p_228051_5_.accept(event.getResultMessage());
                } else {
                    p_228051_5_.accept((ITextComponent)new TranslationTextComponent("screenshot.success", itextcomponent));
                }
            }
            catch (Exception exception) {
                field_148261_a.warn("Couldn't save screenshot", (Throwable)exception);
                p_228051_5_.accept((ITextComponent)new TranslationTextComponent("screenshot.failure", exception.getMessage()));
            }
            finally {
                nativeimage.close();
            }
        });
    }

    public static NativeImage func_198052_a(int width, int height, Framebuffer framebufferIn) {
        width = framebufferIn.field_147622_a;
        height = framebufferIn.field_147620_b;
        NativeImage nativeimage = new NativeImage(width, height, false);
        RenderSystem.bindTexture((int)framebufferIn.field_147617_g);
        nativeimage.func_195717_a(0, true);
        nativeimage.func_195710_e();
        return nativeimage;
    }

    private static File func_74290_a(File gameDirectory) {
        String s = field_74295_a.format(new Date());
        int i = 1;
        File file1;
        while ((file1 = new File(gameDirectory, s + (i == 1 ? "" : "_" + i) + ".png")).exists()) {
            ++i;
        }
        return file1;
    }
}

