/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.block.pattern.BlockMaterialMatcher;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.profiler.IProfiler;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.NetworkTagManager;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.lighting.WorldLightManager;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.common.extensions.IForgeWorld;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.server.timings.TimeTracker;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public abstract class World
extends CapabilityProvider<World>
implements IWorld,
AutoCloseable,
IForgeWorld {
    protected static final Logger field_195596_d = LogManager.getLogger();
    private static final Direction[] field_200007_a = Direction.values();
    public final List<TileEntity> field_147482_g = Lists.newArrayList();
    public final List<TileEntity> field_175730_i = Lists.newArrayList();
    protected final List<TileEntity> field_147484_a = Lists.newArrayList();
    protected final Set<TileEntity> field_147483_b = Collections.newSetFromMap(new IdentityHashMap());
    private final Thread field_217407_c;
    private int field_73008_k;
    protected int field_73005_l = new Random().nextInt();
    protected final int field_73006_m = 1013904223;
    public float field_73003_n;
    public float field_73004_o;
    public float field_73018_p;
    public float field_73017_q;
    public final Random field_73012_v = new Random();
    public final Dimension field_73011_w;
    protected final AbstractChunkProvider field_73020_y;
    protected final WorldInfo field_72986_A;
    private final IProfiler field_72984_F;
    public final boolean field_72995_K;
    protected boolean field_147481_N;
    private final WorldBorder field_175728_M;
    private final BiomeManager field_226689_w_;
    public boolean restoringBlockSnapshots = false;
    public boolean captureBlockSnapshots = false;
    public ArrayList<BlockSnapshot> capturedBlockSnapshots = new ArrayList();
    private double maxEntityRadius = 2.0;

    protected World(WorldInfo info, DimensionType dimType, BiFunction<World, Dimension, AbstractChunkProvider> provider, IProfiler profilerIn, boolean remote) {
        super(World.class);
        this.field_72984_F = profilerIn;
        this.field_72986_A = info;
        this.field_73011_w = dimType.func_218270_a(this);
        this.field_73020_y = provider.apply(this, this.field_73011_w);
        this.field_72995_K = remote;
        this.field_175728_M = this.field_73011_w.func_177501_r();
        this.field_217407_c = Thread.currentThread();
        this.field_226689_w_ = new BiomeManager((BiomeManager.IBiomeReader)this, remote ? info.func_76063_b() : WorldInfo.func_227498_c_(info.func_76063_b()), dimType.func_227176_e_());
    }

    @Override
    public boolean func_201670_d() {
        return this.field_72995_K;
    }

    @Nullable
    public MinecraftServer func_73046_m() {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_72974_f() {
        this.func_175652_B(new BlockPos(8, 64, 8));
    }

    public BlockState func_184141_c(BlockPos pos) {
        BlockPos blockpos = new BlockPos(pos.func_177958_n(), this.func_181545_F(), pos.func_177952_p());
        while (!this.func_175623_d(blockpos.func_177984_a())) {
            blockpos = blockpos.func_177984_a();
        }
        return this.func_180495_p(blockpos);
    }

    public static boolean func_175701_a(BlockPos pos) {
        return !World.func_189509_E(pos) && pos.func_177958_n() >= -30000000 && pos.func_177952_p() >= -30000000 && pos.func_177958_n() < 30000000 && pos.func_177952_p() < 30000000;
    }

    public static boolean func_189509_E(BlockPos pos) {
        return World.func_217405_b(pos.func_177956_o());
    }

    public static boolean func_217405_b(int y) {
        return y < 0 || y >= 256;
    }

    public Chunk func_175726_f(BlockPos pos) {
        return this.func_212866_a_(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
    }

    @Override
    public Chunk func_212866_a_(int chunkX, int chunkZ) {
        return (Chunk)this.func_217348_a(chunkX, chunkZ, ChunkStatus.field_222617_m);
    }

    @Override
    public IChunk func_217353_a(int x, int z, ChunkStatus requiredStatus, boolean nonnull) {
        IChunk ichunk = this.field_73020_y.func_212849_a_(x, z, requiredStatus, nonnull);
        if (ichunk == null && nonnull) {
            throw new IllegalStateException("Should always be able to create a chunk!");
        }
        return ichunk;
    }

    public boolean func_180501_a(BlockPos pos, BlockState newState, int flags) {
        if (World.func_189509_E(pos)) {
            return false;
        }
        if (!this.field_72995_K && this.field_72986_A.func_76067_t() == WorldType.field_180272_g) {
            return false;
        }
        Chunk chunk = this.func_175726_f(pos);
        Block block = newState.func_177230_c();
        pos = pos.func_185334_h();
        BlockSnapshot blockSnapshot = null;
        if (this.captureBlockSnapshots && !this.field_72995_K) {
            blockSnapshot = BlockSnapshot.getBlockSnapshot((IWorld)this, (BlockPos)pos, (int)flags);
            this.capturedBlockSnapshots.add(blockSnapshot);
        }
        BlockState old = this.func_180495_p(pos);
        int oldLight = old.getLightValue((IBlockReader)((Object)this), pos);
        int oldOpacity = old.func_200016_a((IBlockReader)((Object)this), pos);
        BlockState blockstate = chunk.func_177436_a(pos, newState, (flags & 0x40) != 0);
        if (blockstate == null) {
            if (blockSnapshot != null) {
                this.capturedBlockSnapshots.remove(blockSnapshot);
            }
            return false;
        }
        BlockState blockstate1 = this.func_180495_p(pos);
        if (blockstate1 != blockstate && (blockstate1.func_200016_a((IBlockReader)((Object)this), pos) != oldOpacity || blockstate1.getLightValue((IBlockReader)((Object)this), pos) != oldLight || blockstate1.func_215691_g() || blockstate.func_215691_g())) {
            this.field_72984_F.func_76320_a("queueCheckLight");
            this.func_72863_F().func_212863_j_().func_215568_a(pos);
            this.field_72984_F.func_76319_b();
        }
        if (blockSnapshot == null) {
            this.markAndNotifyBlock(pos, chunk, blockstate, newState, flags);
        }
        return true;
    }

    public void markAndNotifyBlock(BlockPos pos, @Nullable Chunk chunk, BlockState blockstate, BlockState newState, int flags) {
        Block block = newState.func_177230_c();
        BlockState blockstate1 = this.func_180495_p(pos);
        if (blockstate1 == newState) {
            if (blockstate != blockstate1) {
                this.func_225319_b(pos, blockstate, blockstate1);
            }
            if ((flags & 2) != 0 && (!this.field_72995_K || (flags & 4) == 0) && (this.field_72995_K || chunk == null || chunk.func_217321_u() != null && chunk.func_217321_u().func_219065_a(ChunkHolder.LocationType.TICKING))) {
                this.func_184138_a(pos, blockstate, newState, flags);
            }
            if (!this.field_72995_K && (flags & 1) != 0) {
                this.func_195592_c(pos, blockstate.func_177230_c());
                if (newState.func_185912_n()) {
                    this.func_175666_e(pos, block);
                }
            }
            if ((flags & 0x10) == 0) {
                int i = flags & 0xFFFFFFFE;
                blockstate.func_196948_b(this, pos, i);
                newState.func_196946_a(this, pos, i);
                newState.func_196948_b(this, pos, i);
            }
            this.func_217393_a(pos, blockstate, blockstate1);
        }
    }

    public void func_217393_a(BlockPos p_217393_1_, BlockState p_217393_2_, BlockState p_217393_3_) {
    }

    public boolean func_217377_a(BlockPos pos, boolean isMoving) {
        IFluidState ifluidstate = this.func_204610_c(pos);
        return this.func_180501_a(pos, ifluidstate.func_206883_i(), 3 | (isMoving ? 64 : 0));
    }

    public boolean func_225521_a_(BlockPos p_225521_1_, boolean p_225521_2_, @Nullable Entity p_225521_3_) {
        BlockState blockstate = this.func_180495_p(p_225521_1_);
        if (blockstate.isAir((IBlockReader)((Object)this), p_225521_1_)) {
            return false;
        }
        IFluidState ifluidstate = this.func_204610_c(p_225521_1_);
        this.func_217379_c(2001, p_225521_1_, Block.func_196246_j(blockstate));
        if (p_225521_2_) {
            TileEntity tileentity = blockstate.hasTileEntity() ? this.func_175625_s(p_225521_1_) : null;
            Block.func_220054_a(blockstate, this, p_225521_1_, tileentity, p_225521_3_, ItemStack.field_190927_a);
        }
        return this.func_180501_a(p_225521_1_, ifluidstate.func_206883_i(), 3);
    }

    public boolean func_175656_a(BlockPos pos, BlockState state) {
        return this.func_180501_a(pos, state, 3);
    }

    public abstract void func_184138_a(BlockPos var1, BlockState var2, BlockState var3, int var4);

    @Override
    public void func_195592_c(BlockPos pos, Block blockIn) {
        if (this.field_72986_A.func_76067_t() != WorldType.field_180272_g) {
            this.func_195593_d(pos, blockIn);
        }
    }

    public void func_225319_b(BlockPos p_225319_1_, BlockState p_225319_2_, BlockState p_225319_3_) {
    }

    public void func_195593_d(BlockPos pos, Block blockIn) {
        if (ForgeEventFactory.onNeighborNotify((World)this, (BlockPos)pos, (BlockState)this.func_180495_p(pos), EnumSet.allOf(Direction.class), (boolean)false).isCanceled()) {
            return;
        }
        this.func_190524_a(pos.func_177976_e(), blockIn, pos);
        this.func_190524_a(pos.func_177974_f(), blockIn, pos);
        this.func_190524_a(pos.func_177977_b(), blockIn, pos);
        this.func_190524_a(pos.func_177984_a(), blockIn, pos);
        this.func_190524_a(pos.func_177978_c(), blockIn, pos);
        this.func_190524_a(pos.func_177968_d(), blockIn, pos);
    }

    public void func_175695_a(BlockPos pos, Block blockType, Direction skipSide) {
        EnumSet<Direction> directions = EnumSet.allOf(Direction.class);
        directions.remove((Object)skipSide);
        if (ForgeEventFactory.onNeighborNotify((World)this, (BlockPos)pos, (BlockState)this.func_180495_p(pos), directions, (boolean)false).isCanceled()) {
            return;
        }
        if (skipSide != Direction.WEST) {
            this.func_190524_a(pos.func_177976_e(), blockType, pos);
        }
        if (skipSide != Direction.EAST) {
            this.func_190524_a(pos.func_177974_f(), blockType, pos);
        }
        if (skipSide != Direction.DOWN) {
            this.func_190524_a(pos.func_177977_b(), blockType, pos);
        }
        if (skipSide != Direction.UP) {
            this.func_190524_a(pos.func_177984_a(), blockType, pos);
        }
        if (skipSide != Direction.NORTH) {
            this.func_190524_a(pos.func_177978_c(), blockType, pos);
        }
        if (skipSide != Direction.SOUTH) {
            this.func_190524_a(pos.func_177968_d(), blockType, pos);
        }
    }

    public void func_190524_a(BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.field_72995_K) {
            BlockState blockstate = this.func_180495_p(pos);
            try {
                blockstate.func_215697_a(this, pos, blockIn, fromPos, false);
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a(throwable, "Exception while updating neighbours");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Block being updated");
                crashreportcategory.func_189529_a("Source block type", (ICrashReportDetail<String>)((ICrashReportDetail)() -> {
                    try {
                        return String.format("ID #%s (%s // %s)", blockIn.getRegistryName(), blockIn.func_149739_a(), ((Object)((Object)blockIn)).getClass().getCanonicalName());
                    }
                    catch (Throwable var2) {
                        return "ID #" + blockIn.getRegistryName();
                    }
                }));
                CrashReportCategory.func_175750_a(crashreportcategory, pos, blockstate);
                throw new ReportedException(crashreport);
            }
        }
    }

    @Override
    public int func_201676_a(Heightmap.Type heightmapType, int x, int z) {
        int i = x >= -30000000 && z >= -30000000 && x < 30000000 && z < 30000000 ? (this.func_217354_b(x >> 4, z >> 4) ? this.func_212866_a_(x >> 4, z >> 4).func_201576_a(heightmapType, x & 0xF, z & 0xF) + 1 : 0) : this.func_181545_F() + 1;
        return i;
    }

    public WorldLightManager func_225524_e_() {
        return this.func_72863_F().func_212863_j_();
    }

    public BlockState func_180495_p(BlockPos pos) {
        if (World.func_189509_E(pos)) {
            return Blocks.field_201940_ji.func_176223_P();
        }
        Chunk chunk = this.func_212866_a_(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
        return chunk.func_180495_p(pos);
    }

    public IFluidState func_204610_c(BlockPos pos) {
        if (World.func_189509_E(pos)) {
            return Fluids.field_204541_a.func_207188_f();
        }
        Chunk chunk = this.func_175726_f(pos);
        return chunk.func_204610_c(pos);
    }

    public boolean func_72935_r() {
        return this.field_73011_w.isDaytime();
    }

    public boolean func_226690_K_() {
        return this.field_73011_w.func_186058_p() == DimensionType.field_223227_a_ && !this.func_72935_r();
    }

    @Override
    public void func_184133_a(@Nullable PlayerEntity player, BlockPos pos, SoundEvent soundIn, SoundCategory category, float volume, float pitch) {
        this.func_184148_a(player, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, soundIn, category, volume, pitch);
    }

    public abstract void func_184148_a(@Nullable PlayerEntity var1, double var2, double var4, double var6, SoundEvent var8, SoundCategory var9, float var10, float var11);

    public abstract void func_217384_a(@Nullable PlayerEntity var1, Entity var2, SoundEvent var3, SoundCategory var4, float var5, float var6);

    public void func_184134_a(double x, double y, double z, SoundEvent soundIn, SoundCategory category, float volume, float pitch, boolean distanceDelay) {
    }

    @Override
    public void func_195594_a(IParticleData particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_195590_a(IParticleData particleData, boolean forceAlwaysRender, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
    }

    public void func_195589_b(IParticleData particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
    }

    public void func_217404_b(IParticleData p_217404_1_, boolean p_217404_2_, double p_217404_3_, double p_217404_5_, double p_217404_7_, double p_217404_9_, double p_217404_11_, double p_217404_13_) {
    }

    public float func_72929_e(float partialTicks) {
        float f = this.func_72826_c(partialTicks);
        return f * ((float)Math.PI * 2);
    }

    public boolean func_175700_a(TileEntity tile) {
        if (tile.func_145831_w() != this) {
            tile.func_226984_a_(this, tile.func_174877_v());
        }
        if (this.field_147481_N) {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = () -> Registry.field_212626_o.func_177774_c(tile.func_200662_C());
            supplierArray[1] = tile::func_174877_v;
            field_195596_d.error("Adding block entity while ticking: {} @ {}", supplierArray);
            return this.field_147484_a.add(tile);
        }
        boolean flag = this.field_147482_g.add(tile);
        if (flag && tile instanceof ITickableTileEntity) {
            this.field_175730_i.add(tile);
        }
        tile.onLoad();
        if (this.field_72995_K) {
            BlockPos blockpos = tile.func_174877_v();
            BlockState blockstate = this.func_180495_p(blockpos);
            this.func_184138_a(blockpos, blockstate, blockstate, 2);
        }
        return flag;
    }

    public void func_147448_a(Collection<TileEntity> tileEntityCollection) {
        if (this.field_147481_N) {
            tileEntityCollection.stream().filter(te -> te.func_145831_w() != this).forEach(te -> te.func_226984_a_(this, te.func_174877_v()));
            this.field_147484_a.addAll(tileEntityCollection);
        } else {
            for (TileEntity tileentity : tileEntityCollection) {
                this.func_175700_a(tileentity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_217391_K() {
        IProfiler iprofiler = this.func_217381_Z();
        iprofiler.func_76320_a("blockEntities");
        this.field_147481_N = true;
        if (!this.field_147483_b.isEmpty()) {
            this.field_147483_b.forEach(e -> e.onChunkUnloaded());
            this.field_175730_i.removeAll(this.field_147483_b);
            this.field_147482_g.removeAll(this.field_147483_b);
            this.field_147483_b.clear();
        }
        Iterator<TileEntity> iterator = this.field_175730_i.iterator();
        while (iterator.hasNext()) {
            Chunk chunk;
            TileEntity tileentity;
            block14: {
                BlockPos blockpos;
                tileentity = iterator.next();
                if (!tileentity.func_145837_r() && tileentity.func_145830_o() && this.field_73020_y.func_222866_a(blockpos = tileentity.func_174877_v()) && this.func_175723_af().func_177746_a(blockpos)) {
                    try {
                        TimeTracker.TILE_ENTITY_UPDATE.trackStart((Object)tileentity);
                        iprofiler.func_194340_a(() -> String.valueOf(tileentity.func_200662_C().getRegistryName()));
                        if (tileentity.func_200662_C().func_223045_a(this.func_180495_p(blockpos).func_177230_c())) {
                            ((ITickableTileEntity)tileentity).func_73660_a();
                        } else {
                            tileentity.func_222814_r();
                        }
                        iprofiler.func_76319_b();
                    }
                    catch (Throwable throwable) {
                        CrashReport crashreport = CrashReport.func_85055_a(throwable, "Ticking block entity");
                        CrashReportCategory crashreportcategory = crashreport.func_85058_a("Block entity being ticked");
                        tileentity.func_145828_a(crashreportcategory);
                        if (((Boolean)ForgeConfig.SERVER.removeErroringTileEntities.get()).booleanValue()) {
                            LogManager.getLogger().fatal("{}", (Object)crashreport.func_71502_e());
                            tileentity.func_145843_s();
                            this.func_175713_t(tileentity.func_174877_v());
                            break block14;
                        }
                        throw new ReportedException(crashreport);
                    }
                    finally {
                        TimeTracker.TILE_ENTITY_UPDATE.trackEnd((Object)tileentity);
                    }
                }
            }
            if (!tileentity.func_145837_r()) continue;
            iterator.remove();
            this.field_147482_g.remove((Object)tileentity);
            if (!this.func_175667_e(tileentity.func_174877_v()) || (chunk = this.func_175726_f(tileentity.func_174877_v())).func_177424_a(tileentity.func_174877_v(), Chunk.CreateEntityType.CHECK) != tileentity) continue;
            chunk.func_177425_e(tileentity.func_174877_v());
        }
        this.field_147481_N = false;
        iprofiler.func_219895_b("pendingBlockEntities");
        if (!this.field_147484_a.isEmpty()) {
            for (int i = 0; i < this.field_147484_a.size(); ++i) {
                TileEntity tileentity1 = this.field_147484_a.get(i);
                if (tileentity1.func_145837_r()) continue;
                if (!this.field_147482_g.contains((Object)tileentity1)) {
                    this.func_175700_a(tileentity1);
                }
                if (!this.func_175667_e(tileentity1.func_174877_v())) continue;
                Chunk chunk = this.func_175726_f(tileentity1.func_174877_v());
                BlockState blockstate = chunk.func_180495_p(tileentity1.func_174877_v());
                chunk.func_177426_a(tileentity1.func_174877_v(), tileentity1);
                this.func_184138_a(tileentity1.func_174877_v(), blockstate, blockstate, 3);
            }
            this.field_147484_a.clear();
        }
        iprofiler.func_76319_b();
    }

    public void func_217390_a(Consumer<Entity> p_217390_1_, Entity p_217390_2_) {
        try {
            TimeTracker.ENTITY_UPDATE.trackStart((Object)p_217390_2_);
            p_217390_1_.accept(p_217390_2_);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a(throwable, "Ticking entity");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Entity being ticked");
            p_217390_2_.func_85029_a(crashreportcategory);
            throw new ReportedException(crashreport);
        }
        finally {
            TimeTracker.ENTITY_UPDATE.trackEnd((Object)p_217390_2_);
        }
    }

    public boolean func_72829_c(AxisAlignedBB bb) {
        int i = MathHelper.func_76128_c((double)bb.field_72340_a);
        int j = MathHelper.func_76143_f((double)bb.field_72336_d);
        int k = MathHelper.func_76128_c((double)bb.field_72338_b);
        int l = MathHelper.func_76143_f((double)bb.field_72337_e);
        int i1 = MathHelper.func_76128_c((double)bb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)bb.field_72334_f);
        try (BlockPos.PooledMutable blockpos$pooledmutable = BlockPos.PooledMutable.func_185346_s();){
            for (int k1 = i; k1 < j; ++k1) {
                for (int l1 = k; l1 < l; ++l1) {
                    for (int i2 = i1; i2 < j1; ++i2) {
                        boolean flag;
                        BlockState blockstate = this.func_180495_p((BlockPos)blockpos$pooledmutable.func_181079_c(k1, l1, i2));
                        if (blockstate.isAir((IBlockReader)((Object)this), (BlockPos)blockpos$pooledmutable)) continue;
                        boolean bl = flag = true;
                        return bl;
                    }
                }
            }
            boolean bl = false;
            return bl;
        }
    }

    public boolean func_147470_e(AxisAlignedBB bb) {
        int j1;
        int i = MathHelper.func_76128_c((double)bb.field_72340_a);
        int j = MathHelper.func_76143_f((double)bb.field_72336_d);
        int k = MathHelper.func_76128_c((double)bb.field_72338_b);
        int l = MathHelper.func_76143_f((double)bb.field_72337_e);
        int i1 = MathHelper.func_76128_c((double)bb.field_72339_c);
        if (this.func_217344_a(i, k, i1, j, l, j1 = MathHelper.func_76143_f((double)bb.field_72334_f))) {
            try (BlockPos.PooledMutable blockpos$pooledmutable = BlockPos.PooledMutable.func_185346_s();){
                for (int k1 = i; k1 < j; ++k1) {
                    for (int l1 = k; l1 < l; ++l1) {
                        for (int i2 = i1; i2 < j1; ++i2) {
                            boolean flag;
                            BlockState state = this.func_180495_p((BlockPos)blockpos$pooledmutable.func_181079_c(k1, l1, i2));
                            if (!state.isBurning((IBlockReader)((Object)this), (BlockPos)blockpos$pooledmutable)) continue;
                            boolean bl = flag = true;
                            return bl;
                        }
                    }
                }
                boolean bl = false;
                return bl;
            }
        }
        return false;
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public BlockState func_203067_a(AxisAlignedBB area, Block blockIn) {
        int j1;
        int i = MathHelper.func_76128_c((double)area.field_72340_a);
        int j = MathHelper.func_76143_f((double)area.field_72336_d);
        int k = MathHelper.func_76128_c((double)area.field_72338_b);
        int l = MathHelper.func_76143_f((double)area.field_72337_e);
        int i1 = MathHelper.func_76128_c((double)area.field_72339_c);
        if (this.func_217344_a(i, k, i1, j, l, j1 = MathHelper.func_76143_f((double)area.field_72334_f))) {
            try (BlockPos.PooledMutable blockpos$pooledmutable = BlockPos.PooledMutable.func_185346_s();){
                for (int k1 = i; k1 < j; ++k1) {
                    for (int l1 = k; l1 < l; ++l1) {
                        for (int i2 = i1; i2 < j1; ++i2) {
                            BlockState blockstate = this.func_180495_p((BlockPos)blockpos$pooledmutable.func_181079_c(k1, l1, i2));
                            if (blockstate.func_177230_c() != blockIn) continue;
                            BlockState blockState = blockstate;
                            return blockState;
                        }
                    }
                }
                BlockState blockState = null;
                return blockState;
            }
        }
        return null;
    }

    public boolean func_72875_a(AxisAlignedBB bb, Material materialIn) {
        int i = MathHelper.func_76128_c((double)bb.field_72340_a);
        int j = MathHelper.func_76143_f((double)bb.field_72336_d);
        int k = MathHelper.func_76128_c((double)bb.field_72338_b);
        int l = MathHelper.func_76143_f((double)bb.field_72337_e);
        int i1 = MathHelper.func_76128_c((double)bb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)bb.field_72334_f);
        BlockMaterialMatcher blockmaterialmatcher = BlockMaterialMatcher.func_189886_a((Material)materialIn);
        return BlockPos.func_218287_a((int)i, (int)k, (int)i1, (int)(j - 1), (int)(l - 1), (int)(j1 - 1)).anyMatch(p_217397_2_ -> blockmaterialmatcher.test(this.func_180495_p((BlockPos)p_217397_2_)));
    }

    public Explosion func_217385_a(@Nullable Entity p_217385_1_, double p_217385_2_, double p_217385_4_, double p_217385_6_, float p_217385_8_, Explosion.Mode p_217385_9_) {
        return this.func_217401_a(p_217385_1_, null, p_217385_2_, p_217385_4_, p_217385_6_, p_217385_8_, false, p_217385_9_);
    }

    public Explosion func_217398_a(@Nullable Entity p_217398_1_, double p_217398_2_, double p_217398_4_, double p_217398_6_, float p_217398_8_, boolean p_217398_9_, Explosion.Mode p_217398_10_) {
        return this.func_217401_a(p_217398_1_, null, p_217398_2_, p_217398_4_, p_217398_6_, p_217398_8_, p_217398_9_, p_217398_10_);
    }

    public Explosion func_217401_a(@Nullable Entity p_217401_1_, @Nullable DamageSource p_217401_2_, double p_217401_3_, double p_217401_5_, double p_217401_7_, float p_217401_9_, boolean p_217401_10_, Explosion.Mode p_217401_11_) {
        Explosion explosion = new Explosion(this, p_217401_1_, p_217401_3_, p_217401_5_, p_217401_7_, p_217401_9_, p_217401_10_, p_217401_11_);
        if (p_217401_2_ != null) {
            explosion.func_199592_a(p_217401_2_);
        }
        if (ForgeEventFactory.onExplosionStart((World)this, (Explosion)explosion)) {
            return explosion;
        }
        explosion.func_77278_a();
        explosion.func_77279_a(true);
        return explosion;
    }

    public boolean func_175719_a(@Nullable PlayerEntity player, BlockPos pos, Direction side) {
        if (this.func_180495_p(pos = pos.func_177972_a(side)).func_177230_c() == Blocks.field_150480_ab) {
            this.func_217378_a(player, 1009, pos, 0);
            this.func_217377_a(pos, false);
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public String func_72827_u() {
        return this.field_73020_y.func_73148_d();
    }

    @Nullable
    public TileEntity func_175625_s(BlockPos pos) {
        if (World.func_189509_E(pos)) {
            return null;
        }
        if (!this.field_72995_K && Thread.currentThread() != this.field_217407_c) {
            return null;
        }
        TileEntity tileentity = null;
        if (this.field_147481_N) {
            tileentity = this.func_189508_F(pos);
        }
        if (tileentity == null) {
            tileentity = this.func_175726_f(pos).func_177424_a(pos, Chunk.CreateEntityType.IMMEDIATE);
        }
        if (tileentity == null) {
            tileentity = this.func_189508_F(pos);
        }
        return tileentity;
    }

    @Nullable
    private TileEntity func_189508_F(BlockPos pos) {
        for (int i = 0; i < this.field_147484_a.size(); ++i) {
            TileEntity tileentity = this.field_147484_a.get(i);
            if (tileentity.func_145837_r() || !tileentity.func_174877_v().equals((Object)pos)) continue;
            return tileentity;
        }
        return null;
    }

    public void func_175690_a(BlockPos pos, @Nullable TileEntity tileEntityIn) {
        if (!World.func_189509_E(pos)) {
            pos = pos.func_185334_h();
            if (tileEntityIn != null && !tileEntityIn.func_145837_r()) {
                if (this.field_147481_N) {
                    tileEntityIn.func_226984_a_(this, pos);
                    Iterator<TileEntity> iterator = this.field_147484_a.iterator();
                    while (iterator.hasNext()) {
                        TileEntity tileentity = iterator.next();
                        if (!tileentity.func_174877_v().equals((Object)pos)) continue;
                        tileentity.func_145843_s();
                        iterator.remove();
                    }
                    this.field_147484_a.add(tileEntityIn);
                } else {
                    Chunk chunk = this.func_175726_f(pos);
                    if (chunk != null) {
                        chunk.func_177426_a(pos, tileEntityIn);
                    }
                    this.func_175700_a(tileEntityIn);
                }
            }
        }
    }

    public void func_175713_t(BlockPos pos) {
        TileEntity tileentity = this.func_175625_s(pos);
        if (tileentity != null && this.field_147481_N) {
            tileentity.func_145843_s();
            this.field_147484_a.remove((Object)tileentity);
            if (!(tileentity instanceof ITickableTileEntity)) {
                this.field_147482_g.remove((Object)tileentity);
            }
        } else {
            if (tileentity != null) {
                this.field_147484_a.remove((Object)tileentity);
                this.field_147482_g.remove((Object)tileentity);
                this.field_175730_i.remove((Object)tileentity);
            }
            this.func_175726_f(pos).func_177425_e(pos);
        }
        this.func_175666_e(pos, this.func_180495_p(pos).func_177230_c());
    }

    public boolean func_195588_v(BlockPos pos) {
        return World.func_189509_E(pos) ? false : this.field_73020_y.func_73149_a(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
    }

    public boolean func_217400_a(BlockPos p_217400_1_, Entity p_217400_2_) {
        if (World.func_189509_E(p_217400_1_)) {
            return false;
        }
        IChunk ichunk = this.func_217353_a(p_217400_1_.func_177958_n() >> 4, p_217400_1_.func_177952_p() >> 4, ChunkStatus.field_222617_m, false);
        return ichunk == null ? false : ichunk.func_180495_p(p_217400_1_).func_215682_a((IBlockReader)((Object)this), p_217400_1_, p_217400_2_);
    }

    public void func_72966_v() {
        double d0 = 1.0 - (double)(this.func_72867_j(1.0f) * 5.0f) / 16.0;
        double d1 = 1.0 - (double)(this.func_72819_i(1.0f) * 5.0f) / 16.0;
        double d2 = 0.5 + 2.0 * MathHelper.func_151237_a((double)MathHelper.func_76134_b((float)(this.func_72826_c(1.0f) * ((float)Math.PI * 2))), (double)-0.25, (double)0.25);
        this.field_73008_k = (int)((1.0 - d2 * d0 * d1) * 11.0);
    }

    public void func_72891_a(boolean hostile, boolean peaceful) {
        this.func_72863_F().func_217203_a(hostile, peaceful);
        this.func_201675_m().setAllowedSpawnTypes(hostile, peaceful);
    }

    protected void func_72947_a() {
        this.field_73011_w.calculateInitialWeather();
    }

    public void calculateInitialWeatherBody() {
        if (this.field_72986_A.func_76059_o()) {
            this.field_73004_o = 1.0f;
            if (this.field_72986_A.func_76061_m()) {
                this.field_73017_q = 1.0f;
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.field_73020_y.close();
    }

    @Override
    @Nullable
    public IBlockReader func_225522_c_(int p_225522_1_, int p_225522_2_) {
        return this.func_217353_a(p_225522_1_, p_225522_2_, ChunkStatus.field_222617_m, false);
    }

    public List<Entity> func_175674_a(@Nullable Entity entityIn, AxisAlignedBB boundingBox, @Nullable Predicate<? super Entity> predicate) {
        ArrayList list = Lists.newArrayList();
        int i = MathHelper.func_76128_c((double)((boundingBox.field_72340_a - this.getMaxEntityRadius()) / 16.0));
        int j = MathHelper.func_76128_c((double)((boundingBox.field_72336_d + this.getMaxEntityRadius()) / 16.0));
        int k = MathHelper.func_76128_c((double)((boundingBox.field_72339_c - this.getMaxEntityRadius()) / 16.0));
        int l = MathHelper.func_76128_c((double)((boundingBox.field_72334_f + this.getMaxEntityRadius()) / 16.0));
        for (int i1 = i; i1 <= j; ++i1) {
            for (int j1 = k; j1 <= l; ++j1) {
                Chunk chunk = this.func_72863_F().func_217205_a(i1, j1, false);
                if (chunk == null) continue;
                chunk.func_177414_a(entityIn, boundingBox, list, predicate);
            }
        }
        return list;
    }

    public <T extends Entity> List<T> func_217394_a(@Nullable EntityType<T> p_217394_1_, AxisAlignedBB p_217394_2_, Predicate<? super T> p_217394_3_) {
        int i = MathHelper.func_76128_c((double)((p_217394_2_.field_72340_a - this.getMaxEntityRadius()) / 16.0));
        int j = MathHelper.func_76143_f((double)((p_217394_2_.field_72336_d + this.getMaxEntityRadius()) / 16.0));
        int k = MathHelper.func_76128_c((double)((p_217394_2_.field_72339_c - this.getMaxEntityRadius()) / 16.0));
        int l = MathHelper.func_76143_f((double)((p_217394_2_.field_72334_f + this.getMaxEntityRadius()) / 16.0));
        ArrayList list = Lists.newArrayList();
        for (int i1 = i; i1 < j; ++i1) {
            for (int j1 = k; j1 < l; ++j1) {
                Chunk chunk = this.func_72863_F().func_217205_a(i1, j1, false);
                if (chunk == null) continue;
                chunk.func_217313_a(p_217394_1_, p_217394_2_, list, p_217394_3_);
            }
        }
        return list;
    }

    public <T extends Entity> List<T> func_175647_a(Class<? extends T> clazz, AxisAlignedBB aabb, @Nullable Predicate<? super T> filter) {
        int i = MathHelper.func_76128_c((double)((aabb.field_72340_a - this.getMaxEntityRadius()) / 16.0));
        int j = MathHelper.func_76143_f((double)((aabb.field_72336_d + this.getMaxEntityRadius()) / 16.0));
        int k = MathHelper.func_76128_c((double)((aabb.field_72339_c - this.getMaxEntityRadius()) / 16.0));
        int l = MathHelper.func_76143_f((double)((aabb.field_72334_f + this.getMaxEntityRadius()) / 16.0));
        ArrayList list = Lists.newArrayList();
        AbstractChunkProvider abstractchunkprovider = this.func_72863_F();
        for (int i1 = i; i1 < j; ++i1) {
            for (int j1 = k; j1 < l; ++j1) {
                Chunk chunk = abstractchunkprovider.func_217205_a(i1, j1, false);
                if (chunk == null) continue;
                chunk.func_177430_a(clazz, aabb, list, filter);
            }
        }
        return list;
    }

    public <T extends Entity> List<T> func_225316_b(Class<? extends T> p_225316_1_, AxisAlignedBB p_225316_2_, @Nullable Predicate<? super T> p_225316_3_) {
        int i = MathHelper.func_76128_c((double)((p_225316_2_.field_72340_a - this.getMaxEntityRadius()) / 16.0));
        int j = MathHelper.func_76143_f((double)((p_225316_2_.field_72336_d + this.getMaxEntityRadius()) / 16.0));
        int k = MathHelper.func_76128_c((double)((p_225316_2_.field_72339_c - this.getMaxEntityRadius()) / 16.0));
        int l = MathHelper.func_76143_f((double)((p_225316_2_.field_72334_f + this.getMaxEntityRadius()) / 16.0));
        ArrayList list = Lists.newArrayList();
        AbstractChunkProvider abstractchunkprovider = this.func_72863_F();
        for (int i1 = i; i1 < j; ++i1) {
            for (int j1 = k; j1 < l; ++j1) {
                Chunk chunk = abstractchunkprovider.func_225313_a(i1, j1);
                if (chunk == null) continue;
                chunk.func_177430_a(p_225316_1_, p_225316_2_, list, p_225316_3_);
            }
        }
        return list;
    }

    @Nullable
    public abstract Entity func_73045_a(int var1);

    public void func_175646_b(BlockPos pos, TileEntity unusedTileEntity) {
        if (this.func_175667_e(pos)) {
            this.func_175726_f(pos).func_76630_e();
        }
    }

    @Override
    public int func_181545_F() {
        return this.func_201675_m().getSeaLevel();
    }

    @Override
    public World func_201672_e() {
        return this;
    }

    public WorldType func_175624_G() {
        return this.field_72986_A.func_76067_t();
    }

    public int func_175676_y(BlockPos pos) {
        int i = 0;
        if ((i = Math.max(i, this.func_175627_a(pos.func_177977_b(), Direction.DOWN))) >= 15) {
            return i;
        }
        if ((i = Math.max(i, this.func_175627_a(pos.func_177984_a(), Direction.UP))) >= 15) {
            return i;
        }
        if ((i = Math.max(i, this.func_175627_a(pos.func_177978_c(), Direction.NORTH))) >= 15) {
            return i;
        }
        if ((i = Math.max(i, this.func_175627_a(pos.func_177968_d(), Direction.SOUTH))) >= 15) {
            return i;
        }
        if ((i = Math.max(i, this.func_175627_a(pos.func_177976_e(), Direction.WEST))) >= 15) {
            return i;
        }
        return (i = Math.max(i, this.func_175627_a(pos.func_177974_f(), Direction.EAST))) >= 15 ? i : i;
    }

    public boolean func_175709_b(BlockPos pos, Direction side) {
        return this.func_175651_c(pos, side) > 0;
    }

    public int func_175651_c(BlockPos pos, Direction facing) {
        BlockState blockstate = this.func_180495_p(pos);
        return blockstate.shouldCheckWeakPower(this, pos, facing) ? this.func_175676_y(pos) : blockstate.func_185911_a((IBlockReader)((Object)this), pos, facing);
    }

    public boolean func_175640_z(BlockPos pos) {
        if (this.func_175651_c(pos.func_177977_b(), Direction.DOWN) > 0) {
            return true;
        }
        if (this.func_175651_c(pos.func_177984_a(), Direction.UP) > 0) {
            return true;
        }
        if (this.func_175651_c(pos.func_177978_c(), Direction.NORTH) > 0) {
            return true;
        }
        if (this.func_175651_c(pos.func_177968_d(), Direction.SOUTH) > 0) {
            return true;
        }
        if (this.func_175651_c(pos.func_177976_e(), Direction.WEST) > 0) {
            return true;
        }
        return this.func_175651_c(pos.func_177974_f(), Direction.EAST) > 0;
    }

    public int func_175687_A(BlockPos pos) {
        int i = 0;
        for (Direction direction : field_200007_a) {
            int j = this.func_175651_c(pos.func_177972_a(direction), direction);
            if (j >= 15) {
                return 15;
            }
            if (j <= i) continue;
            i = j;
        }
        return i;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_72882_A() {
    }

    public void func_82738_a(long worldTime) {
        this.field_72986_A.func_82572_b(worldTime);
    }

    @Override
    public long func_72905_C() {
        return this.field_73011_w.getSeed();
    }

    public long func_82737_E() {
        return this.field_72986_A.func_82573_f();
    }

    public long func_72820_D() {
        return this.field_73011_w.getWorldTime();
    }

    public void func_72877_b(long time) {
        this.field_73011_w.setWorldTime(time);
    }

    protected void func_217389_a() {
        this.func_82738_a(this.field_72986_A.func_82573_f() + 1L);
        if (this.field_72986_A.func_82574_x().func_223586_b(GameRules.field_223607_j)) {
            this.func_72877_b(this.field_72986_A.func_76073_f() + 1L);
        }
    }

    @Override
    public BlockPos func_175694_M() {
        BlockPos blockpos = this.field_73011_w.getSpawnPoint();
        if (!this.func_175723_af().func_177746_a(blockpos)) {
            blockpos = this.func_205770_a(Heightmap.Type.MOTION_BLOCKING, new BlockPos(this.func_175723_af().func_177731_f(), 0.0, this.func_175723_af().func_177721_g()));
        }
        return blockpos;
    }

    public void func_175652_B(BlockPos pos) {
        this.field_73011_w.setSpawnPoint(pos);
    }

    public boolean func_175660_a(PlayerEntity player, BlockPos pos) {
        return this.field_73011_w.canMineBlock(player, pos);
    }

    public boolean canMineBlockBody(PlayerEntity player, BlockPos pos) {
        return true;
    }

    public void func_72960_a(Entity entityIn, byte state) {
    }

    @Override
    public AbstractChunkProvider func_72863_F() {
        return this.field_73020_y;
    }

    public void func_175641_c(BlockPos pos, Block blockIn, int eventID, int eventParam) {
        this.func_180495_p(pos).func_189547_a(this, pos, eventID, eventParam);
    }

    @Override
    public WorldInfo func_72912_H() {
        return this.field_72986_A;
    }

    public GameRules func_82736_K() {
        return this.field_72986_A.func_82574_x();
    }

    public float func_72819_i(float delta) {
        return MathHelper.func_219799_g((float)delta, (float)this.field_73018_p, (float)this.field_73017_q) * this.func_72867_j(delta);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_147442_i(float strength) {
        this.field_73018_p = strength;
        this.field_73017_q = strength;
    }

    public float func_72867_j(float delta) {
        return MathHelper.func_219799_g((float)delta, (float)this.field_73003_n, (float)this.field_73004_o);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_72894_k(float strength) {
        this.field_73003_n = strength;
        this.field_73004_o = strength;
    }

    public boolean func_72911_I() {
        if (this.field_73011_w.func_191066_m() && !this.field_73011_w.func_177495_o()) {
            return (double)this.func_72819_i(1.0f) > 0.9;
        }
        return false;
    }

    public boolean func_72896_J() {
        return (double)this.func_72867_j(1.0f) > 0.2;
    }

    public boolean func_175727_C(BlockPos position) {
        if (!this.func_72896_J()) {
            return false;
        }
        if (!this.func_226660_f_(position)) {
            return false;
        }
        if (this.func_205770_a(Heightmap.Type.MOTION_BLOCKING, position).func_177956_o() > position.func_177956_o()) {
            return false;
        }
        return this.func_226691_t_(position).func_201851_b() == Biome.RainType.RAIN;
    }

    public boolean func_180502_D(BlockPos pos) {
        return this.field_73011_w.isHighHumidity(pos);
    }

    @Nullable
    public abstract MapData func_217406_a(String var1);

    public abstract void func_217399_a(MapData var1);

    public abstract int func_217395_y();

    public void func_175669_a(int id, BlockPos pos, int data) {
    }

    public int func_72940_L() {
        return this.field_73011_w.getActualHeight();
    }

    public CrashReportCategory func_72914_a(CrashReport report) {
        CrashReportCategory crashreportcategory = report.func_85057_a("Affected level", 1);
        crashreportcategory.func_189529_a("All players", (ICrashReportDetail<String>)((ICrashReportDetail)() -> this.func_217369_A().size() + " total; " + this.func_217369_A()));
        crashreportcategory.func_189529_a("Chunk stats", (ICrashReportDetail<String>)((ICrashReportDetail)() -> ((AbstractChunkProvider)this.field_73020_y).func_73148_d()));
        crashreportcategory.func_189529_a("Level dimension", (ICrashReportDetail<String>)((ICrashReportDetail)() -> this.field_73011_w.func_186058_p().toString()));
        try {
            this.field_72986_A.func_85118_a(crashreportcategory);
        }
        catch (Throwable throwable) {
            crashreportcategory.func_71499_a("Level Data Unobtainable", throwable);
        }
        return crashreportcategory;
    }

    public abstract void func_175715_c(int var1, BlockPos var2, int var3);

    @OnlyIn(value=Dist.CLIENT)
    public void func_92088_a(double x, double y, double z, double motionX, double motionY, double motionZ, @Nullable CompoundNBT compound) {
    }

    public abstract Scoreboard func_96441_U();

    public void func_175666_e(BlockPos pos, Block blockIn) {
        for (Direction direction : Direction.values()) {
            BlockPos blockpos = pos.func_177972_a(direction);
            if (!this.func_175667_e(blockpos)) continue;
            BlockState blockstate = this.func_180495_p(blockpos);
            blockstate.onNeighborChange(this, blockpos, pos);
            if (!blockstate.func_215686_e((IBlockReader)((Object)this), blockpos) || !(blockstate = this.func_180495_p(blockpos = blockpos.func_177972_a(direction))).getWeakChanges(this, blockpos)) continue;
            blockstate.func_215697_a(this, blockpos, blockIn, pos, false);
        }
    }

    @Override
    public DifficultyInstance func_175649_E(BlockPos pos) {
        long i = 0L;
        float f = 0.0f;
        if (this.func_175667_e(pos)) {
            f = this.func_130001_d();
            i = this.func_175726_f(pos).func_177416_w();
        }
        return new DifficultyInstance(this.func_175659_aa(), this.func_72820_D(), i, f);
    }

    @Override
    public int func_175657_ab() {
        return this.field_73008_k;
    }

    public void func_225605_c_(int p_225605_1_) {
    }

    public WorldBorder func_175723_af() {
        return this.field_175728_M;
    }

    public void func_184135_a(IPacket<?> packetIn) {
        throw new UnsupportedOperationException("Can't send packets to server unless you're on the client.");
    }

    @Override
    public Dimension func_201675_m() {
        return this.field_73011_w;
    }

    @Override
    public Random func_201674_k() {
        return this.field_73012_v;
    }

    public boolean func_217375_a(BlockPos p_217375_1_, Predicate<BlockState> p_217375_2_) {
        return p_217375_2_.test(this.func_180495_p(p_217375_1_));
    }

    public abstract RecipeManager func_199532_z();

    public abstract NetworkTagManager func_205772_D();

    public BlockPos func_217383_a(int p_217383_1_, int p_217383_2_, int p_217383_3_, int p_217383_4_) {
        this.field_73005_l = this.field_73005_l * 3 + 1013904223;
        int i = this.field_73005_l >> 2;
        return new BlockPos(p_217383_1_ + (i & 0xF), p_217383_2_ + (i >> 16 & p_217383_4_), p_217383_3_ + (i >> 8 & 0xF));
    }

    public boolean func_217402_u() {
        return false;
    }

    public IProfiler func_217381_Z() {
        return this.field_72984_F;
    }

    @Override
    public BiomeManager func_225523_d_() {
        return this.field_226689_w_;
    }

    public double getMaxEntityRadius() {
        return this.maxEntityRadius;
    }

    public double increaseMaxEntityRadius(double value) {
        if (value > this.maxEntityRadius) {
            this.maxEntityRadius = value;
        }
        return this.maxEntityRadius;
    }
}

