/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.biome;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.longs.Long2FloatLinkedOpenHashMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.Util;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.FoliageColors;
import net.minecraft.world.GrassColors;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.PerlinNoiseGenerator;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.carver.ICarverConfig;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Biome
extends ForgeRegistryEntry<Biome> {
    public static final Logger field_150586_aC = LogManager.getLogger();
    public static final Set<Biome> field_201870_ab = Sets.newHashSet();
    public static final ObjectIntIdentityMap<Biome> field_185373_j = new ObjectIntIdentityMap();
    protected static final PerlinNoiseGenerator field_150605_ac = new PerlinNoiseGenerator(new SharedSeedRandom(1234L), 0, 0);
    public static final PerlinNoiseGenerator field_180281_af = new PerlinNoiseGenerator(new SharedSeedRandom(2345L), 0, 0);
    @Nullable
    protected String field_205405_aL;
    protected final float field_76748_D;
    protected final float field_76749_E;
    protected final float field_76750_F;
    protected final float field_76751_G;
    protected final int field_76759_H;
    protected final int field_204275_aE;
    private final int field_229978_u_;
    @Nullable
    protected final String field_185364_H;
    protected final ConfiguredSurfaceBuilder<?> field_201875_ar;
    protected final Category field_201877_au;
    protected final RainType field_201878_av;
    protected final Map<GenerationStage.Carving, List<ConfiguredCarver<?>>> field_201871_ag = Maps.newHashMap();
    protected final Map<GenerationStage.Decoration, List<ConfiguredFeature<?, ?>>> field_201872_ah = Maps.newHashMap();
    protected final List<ConfiguredFeature<?, ?>> field_201873_ai = Lists.newArrayList();
    protected final Map<Structure<?>, IFeatureConfig> field_201874_aj = Maps.newHashMap();
    private final Map<EntityClassification, List<SpawnListEntry>> field_201880_ax = Maps.newHashMap();
    private final ThreadLocal<Long2FloatLinkedOpenHashMap> field_225488_v = ThreadLocal.withInitial(() -> (Long2FloatLinkedOpenHashMap)Util.func_199748_a(() -> {
        Long2FloatLinkedOpenHashMap long2floatlinkedopenhashmap = new Long2FloatLinkedOpenHashMap(1024, 0.25f){

            protected void rehash(int p_rehash_1_) {
            }
        };
        long2floatlinkedopenhashmap.defaultReturnValue(Float.NaN);
        return long2floatlinkedopenhashmap;
    }));

    @Nullable
    public static Biome func_185356_b(Biome biome) {
        return (Biome)((Object)field_185373_j.func_148745_a(Registry.field_212624_m.func_148757_b(biome)));
    }

    public static <C extends ICarverConfig> ConfiguredCarver<C> func_203606_a(WorldCarver<C> carver, C config) {
        return new ConfiguredCarver(carver, config);
    }

    protected Biome(Builder biomeBuilder) {
        if (biomeBuilder.field_205422_a != null && biomeBuilder.field_205423_b != null && biomeBuilder.field_205424_c != null && biomeBuilder.field_205425_d != null && biomeBuilder.field_205426_e != null && biomeBuilder.field_205427_f != null && biomeBuilder.field_205428_g != null && biomeBuilder.field_205429_h != null && biomeBuilder.field_205430_i != null) {
            this.field_201875_ar = biomeBuilder.field_205422_a;
            this.field_201878_av = biomeBuilder.field_205423_b;
            this.field_201877_au = biomeBuilder.field_205424_c;
            this.field_76748_D = biomeBuilder.field_205425_d.floatValue();
            this.field_76749_E = biomeBuilder.field_205426_e.floatValue();
            this.field_76750_F = biomeBuilder.field_205427_f.floatValue();
            this.field_76751_G = biomeBuilder.field_205428_g.floatValue();
            this.field_76759_H = biomeBuilder.field_205429_h;
            this.field_204275_aE = biomeBuilder.field_205430_i;
            this.field_229978_u_ = this.func_229979_u_();
            this.field_185364_H = biomeBuilder.field_205431_j;
            for (GenerationStage.Decoration decoration : GenerationStage.Decoration.values()) {
                this.field_201872_ah.put(decoration, Lists.newArrayList());
            }
            for (EntityClassification entityClassification : EntityClassification.values()) {
                this.field_201880_ax.put(entityClassification, Lists.newArrayList());
            }
        } else {
            throw new IllegalStateException("You are missing parameters to build a proper biome for " + ((Object)((Object)this)).getClass().getSimpleName() + "\n" + biomeBuilder);
        }
    }

    public boolean func_185363_b() {
        return this.field_185364_H != null;
    }

    private int func_229979_u_() {
        float f = this.field_76750_F;
        f /= 3.0f;
        f = MathHelper.func_76131_a((float)f, (float)-1.0f, (float)1.0f);
        return MathHelper.func_181758_c((float)(0.62222224f - f * 0.05f), (float)(0.5f + f * 0.1f), (float)1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_225529_c_() {
        return this.field_229978_u_;
    }

    protected void func_201866_a(EntityClassification type, SpawnListEntry spawnListEntry) {
        this.field_201880_ax.computeIfAbsent(type, k -> Lists.newArrayList()).add(spawnListEntry);
    }

    public List<SpawnListEntry> func_76747_a(EntityClassification creatureType) {
        return this.field_201880_ax.computeIfAbsent(creatureType, k -> Lists.newArrayList());
    }

    public RainType func_201851_b() {
        return this.field_201878_av;
    }

    public boolean func_76736_e() {
        return this.func_76727_i() > 0.85f;
    }

    public float func_76741_f() {
        return 0.1f;
    }

    public float func_180626_a(BlockPos pos) {
        if (pos.func_177956_o() > 64) {
            float f = (float)(field_150605_ac.func_215464_a((double)((float)pos.func_177958_n() / 8.0f), (double)((float)pos.func_177952_p() / 8.0f), false) * 4.0);
            return this.func_185353_n() - (f + (float)pos.func_177956_o() - 64.0f) * 0.05f / 30.0f;
        }
        return this.func_185353_n();
    }

    public final float func_225486_c(BlockPos p_225486_1_) {
        long i = p_225486_1_.func_218275_a();
        Long2FloatLinkedOpenHashMap long2floatlinkedopenhashmap = this.field_225488_v.get();
        float f = long2floatlinkedopenhashmap.get(i);
        if (!Float.isNaN(f)) {
            return f;
        }
        float f1 = this.func_180626_a(p_225486_1_);
        if (long2floatlinkedopenhashmap.size() == 1024) {
            long2floatlinkedopenhashmap.removeFirstFloat();
        }
        long2floatlinkedopenhashmap.put(i, f1);
        return f1;
    }

    public boolean func_201848_a(IWorldReader worldIn, BlockPos pos) {
        return this.func_201854_a(worldIn, pos, true);
    }

    public boolean func_201854_a(IWorldReader worldIn, BlockPos water, boolean mustBeAtEdge) {
        if (this.func_225486_c(water) >= 0.15f) {
            return false;
        }
        if (water.func_177956_o() >= 0 && water.func_177956_o() < worldIn.func_201675_m().getHeight() && worldIn.func_226658_a_(LightType.BLOCK, water) < 10) {
            BlockState blockstate = worldIn.func_180495_p(water);
            IFluidState ifluidstate = worldIn.func_204610_c(water);
            if (ifluidstate.func_206886_c() == Fluids.field_204546_a && blockstate.func_177230_c() instanceof FlowingFluidBlock) {
                boolean flag;
                if (!mustBeAtEdge) {
                    return true;
                }
                boolean bl = flag = worldIn.func_201671_F(water.func_177976_e()) && worldIn.func_201671_F(water.func_177974_f()) && worldIn.func_201671_F(water.func_177978_c()) && worldIn.func_201671_F(water.func_177968_d());
                if (!flag) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean func_201850_b(IWorldReader worldIn, BlockPos pos) {
        BlockState blockstate;
        if (this.func_225486_c(pos) >= 0.15f) {
            return false;
        }
        return pos.func_177956_o() >= 0 && pos.func_177956_o() < 256 && worldIn.func_226658_a_(LightType.BLOCK, pos) < 10 && (blockstate = worldIn.func_180495_p(pos)).isAir((IBlockReader)((Object)worldIn), pos) && Blocks.field_150433_aE.func_176223_P().func_196955_c(worldIn, pos);
    }

    public void func_203611_a(GenerationStage.Decoration decorationStage, ConfiguredFeature<?, ?> featureIn) {
        if (featureIn.field_222737_a == Feature.field_214484_aL) {
            this.field_201873_ai.add(featureIn);
        }
        this.field_201872_ah.get(decorationStage).add(featureIn);
    }

    public <C extends ICarverConfig> void func_203609_a(GenerationStage.Carving stage, ConfiguredCarver<C> carver) {
        this.field_201871_ag.computeIfAbsent(stage, p_203604_0_ -> Lists.newArrayList()).add(carver);
    }

    public List<ConfiguredCarver<?>> func_203603_a(GenerationStage.Carving stage) {
        return this.field_201871_ag.computeIfAbsent(stage, p_203610_0_ -> Lists.newArrayList());
    }

    public <C extends IFeatureConfig> void func_226711_a_(ConfiguredFeature<C, ? extends Structure<C>> p_226711_1_) {
        this.field_201874_aj.put((Structure<?>)p_226711_1_.field_222737_a, p_226711_1_.field_222738_b);
    }

    public <C extends IFeatureConfig> boolean func_201858_a(Structure<C> structureIn) {
        return this.field_201874_aj.containsKey(structureIn);
    }

    @Nullable
    public <C extends IFeatureConfig> C func_201857_b(Structure<C> structureIn) {
        return (C)this.field_201874_aj.get(structureIn);
    }

    public List<ConfiguredFeature<?, ?>> func_201853_g() {
        return this.field_201873_ai;
    }

    public List<ConfiguredFeature<?, ?>> func_203607_a(GenerationStage.Decoration decorationStage) {
        return this.field_201872_ah.get(decorationStage);
    }

    public void func_203608_a(GenerationStage.Decoration stage, ChunkGenerator<? extends GenerationSettings> chunkGenerator, IWorld worldIn, long seed, SharedSeedRandom random, BlockPos pos) {
        int i = 0;
        for (ConfiguredFeature<?, ?> configuredfeature : this.field_201872_ah.get(stage)) {
            random.func_202426_b(seed, i, stage.ordinal());
            try {
                configuredfeature.func_222734_a(worldIn, chunkGenerator, (Random)random, pos);
            }
            catch (Exception exception) {
                CrashReport crashreport = CrashReport.func_85055_a(exception, "Feature placement");
                crashreport.func_85058_a("Feature").func_71507_a("Id", Registry.field_218379_q.func_177774_c(configuredfeature.field_222737_a)).func_189529_a("Description", (ICrashReportDetail<String>)((ICrashReportDetail)() -> ((Object)((Object)configuredfeature.field_222737_a)).toString()));
                throw new ReportedException(crashreport);
            }
            ++i;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_225528_a_(double p_225528_1_, double p_225528_3_) {
        double d0 = MathHelper.func_76131_a((float)this.func_185353_n(), (float)0.0f, (float)1.0f);
        double d1 = MathHelper.func_76131_a((float)this.func_76727_i(), (float)0.0f, (float)1.0f);
        return GrassColors.func_77480_a((double)d0, (double)d1);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_225527_a_() {
        double d0 = MathHelper.func_76131_a((float)this.func_185353_n(), (float)0.0f, (float)1.0f);
        double d1 = MathHelper.func_76131_a((float)this.func_76727_i(), (float)0.0f, (float)1.0f);
        return FoliageColors.func_77470_a((double)d0, (double)d1);
    }

    public void func_206854_a(Random random, IChunk chunkIn, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, long seed) {
        this.field_201875_ar.func_215451_a(seed);
        this.field_201875_ar.func_215450_a(random, chunkIn, this, x, z, startHeight, noise, defaultBlock, defaultFluid, seaLevel, seed);
    }

    public TempCategory func_150561_m() {
        if (this.field_201877_au == Category.OCEAN) {
            return TempCategory.OCEAN;
        }
        if ((double)this.func_185353_n() < 0.2) {
            return TempCategory.COLD;
        }
        return (double)this.func_185353_n() < 1.0 ? TempCategory.MEDIUM : TempCategory.WARM;
    }

    public final float func_185355_j() {
        return this.field_76748_D;
    }

    public final float func_76727_i() {
        return this.field_76751_G;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ITextComponent func_205403_k() {
        return new TranslationTextComponent(this.func_210773_k(), new Object[0]);
    }

    public String func_210773_k() {
        if (this.field_205405_aL == null) {
            this.field_205405_aL = Util.func_200697_a((String)"biome", (ResourceLocation)Registry.field_212624_m.func_177774_c(this));
        }
        return this.field_205405_aL;
    }

    public final float func_185360_m() {
        return this.field_76749_E;
    }

    public final float func_185353_n() {
        return this.field_76750_F;
    }

    public final int func_185361_o() {
        return this.field_76759_H;
    }

    public final int func_204274_p() {
        return this.field_204275_aE;
    }

    public final Category func_201856_r() {
        return this.field_201877_au;
    }

    public ConfiguredSurfaceBuilder<?> func_205401_q() {
        return this.field_201875_ar;
    }

    public ISurfaceBuilderConfig func_203944_q() {
        return this.field_201875_ar.func_215452_a();
    }

    @Nullable
    public String func_205402_s() {
        return this.field_185364_H;
    }

    public Biome getRiver() {
        if (this == Biomes.field_76774_n) {
            return Biomes.field_76777_m;
        }
        if (this == Biomes.field_76789_p || this == Biomes.field_76788_q) {
            return Biomes.field_76788_q;
        }
        return Biomes.field_76781_i;
    }

    public static enum TempCategory {
        OCEAN("ocean"),
        COLD("cold"),
        MEDIUM("medium"),
        WARM("warm");

        private static final Map<String, TempCategory> field_222358_e;
        private final String field_222359_f;

        private TempCategory(String p_i50594_3_) {
            this.field_222359_f = p_i50594_3_;
        }

        public String func_222357_a() {
            return this.field_222359_f;
        }

        static {
            field_222358_e = Arrays.stream(TempCategory.values()).collect(Collectors.toMap(TempCategory::func_222357_a, p_222356_0_ -> p_222356_0_));
        }
    }

    public static class FlowerEntry
    extends WeightedRandom.Item {
        private final BlockState state;

        public FlowerEntry(BlockState state, int weight) {
            super(weight);
            this.state = state;
        }

        public BlockState getState() {
            return this.state;
        }
    }

    public static class SpawnListEntry
    extends WeightedRandom.Item {
        public final EntityType<?> field_200702_b;
        public final int field_76301_c;
        public final int field_76299_d;

        public SpawnListEntry(EntityType<?> entityTypeIn, int weight, int minGroupCountIn, int maxGroupCountIn) {
            super(weight);
            this.field_200702_b = entityTypeIn;
            this.field_76301_c = minGroupCountIn;
            this.field_76299_d = maxGroupCountIn;
        }

        public String toString() {
            return EntityType.func_200718_a(this.field_200702_b) + "*(" + this.field_76301_c + "-" + this.field_76299_d + "):" + this.field_76292_a;
        }
    }

    public static enum RainType {
        NONE("none"),
        RAIN("rain"),
        SNOW("snow");

        private static final Map<String, RainType> field_222362_d;
        private final String field_222363_e;

        private RainType(String name) {
            this.field_222363_e = name;
        }

        public String func_222361_a() {
            return this.field_222363_e;
        }

        static {
            field_222362_d = Arrays.stream(RainType.values()).collect(Collectors.toMap(RainType::func_222361_a, p_222360_0_ -> p_222360_0_));
        }
    }

    public static enum Category {
        NONE("none"),
        TAIGA("taiga"),
        EXTREME_HILLS("extreme_hills"),
        JUNGLE("jungle"),
        MESA("mesa"),
        PLAINS("plains"),
        SAVANNA("savanna"),
        ICY("icy"),
        THEEND("the_end"),
        BEACH("beach"),
        FOREST("forest"),
        OCEAN("ocean"),
        DESERT("desert"),
        RIVER("river"),
        SWAMP("swamp"),
        MUSHROOM("mushroom"),
        NETHER("nether");

        private static final Map<String, Category> field_222354_r;
        private final String field_222355_s;

        private Category(String name) {
            this.field_222355_s = name;
        }

        public String func_222352_a() {
            return this.field_222355_s;
        }

        static {
            field_222354_r = Arrays.stream(Category.values()).collect(Collectors.toMap(Category::func_222352_a, p_222353_0_ -> p_222353_0_));
        }
    }

    public static class Builder {
        @Nullable
        private ConfiguredSurfaceBuilder<?> field_205422_a;
        @Nullable
        private RainType field_205423_b;
        @Nullable
        private Category field_205424_c;
        @Nullable
        private Float field_205425_d;
        @Nullable
        private Float field_205426_e;
        @Nullable
        private Float field_205427_f;
        @Nullable
        private Float field_205428_g;
        @Nullable
        private Integer field_205429_h;
        @Nullable
        private Integer field_205430_i;
        @Nullable
        private String field_205431_j;

        public <SC extends ISurfaceBuilderConfig> Builder func_222351_a(SurfaceBuilder<SC> p_222351_1_, SC p_222351_2_) {
            this.field_205422_a = new ConfiguredSurfaceBuilder(p_222351_1_, p_222351_2_);
            return this;
        }

        public Builder func_205416_a(ConfiguredSurfaceBuilder<?> surfaceBuilderIn) {
            this.field_205422_a = surfaceBuilderIn;
            return this;
        }

        public Builder func_205415_a(RainType precipitationIn) {
            this.field_205423_b = precipitationIn;
            return this;
        }

        public Builder func_205419_a(Category biomeCategory) {
            this.field_205424_c = biomeCategory;
            return this;
        }

        public Builder func_205421_a(float depthIn) {
            this.field_205425_d = Float.valueOf(depthIn);
            return this;
        }

        public Builder func_205420_b(float scaleIn) {
            this.field_205426_e = Float.valueOf(scaleIn);
            return this;
        }

        public Builder func_205414_c(float temperatureIn) {
            this.field_205427_f = Float.valueOf(temperatureIn);
            return this;
        }

        public Builder func_205417_d(float downfallIn) {
            this.field_205428_g = Float.valueOf(downfallIn);
            return this;
        }

        public Builder func_205412_a(int waterColorIn) {
            this.field_205429_h = waterColorIn;
            return this;
        }

        public Builder func_205413_b(int waterFogColorIn) {
            this.field_205430_i = waterFogColorIn;
            return this;
        }

        public Builder func_205418_a(@Nullable String parentIn) {
            this.field_205431_j = parentIn;
            return this;
        }

        public String toString() {
            return "BiomeBuilder{\nsurfaceBuilder=" + this.field_205422_a + ",\nprecipitation=" + (Object)((Object)this.field_205423_b) + ",\nbiomeCategory=" + (Object)((Object)this.field_205424_c) + ",\ndepth=" + this.field_205425_d + ",\nscale=" + this.field_205426_e + ",\ntemperature=" + this.field_205427_f + ",\ndownfall=" + this.field_205428_g + ",\nwaterColor=" + this.field_205429_h + ",\nwaterFogColor=" + this.field_205430_i + ",\nparent='" + this.field_205431_j + '\'' + "\n" + '}';
        }
    }
}

