/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SMapDataPacket;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.storage.MapBanner;
import net.minecraft.world.storage.MapDecoration;
import net.minecraft.world.storage.MapFrame;
import net.minecraft.world.storage.WorldSavedData;

public class MapData
extends WorldSavedData {
    public int field_76201_a;
    public int field_76199_b;
    public DimensionType field_76200_c;
    public boolean field_186210_e;
    public boolean field_191096_f;
    public byte field_76197_d;
    public byte[] field_76198_e = new byte[16384];
    public boolean field_215161_h;
    public final List<MapInfo> field_76196_g = Lists.newArrayList();
    private final Map<PlayerEntity, MapInfo> field_76202_j = Maps.newHashMap();
    private final Map<String, MapBanner> field_204270_k = Maps.newHashMap();
    public final Map<String, MapDecoration> field_76203_h = Maps.newLinkedHashMap();
    private final Map<String, MapFrame> field_212442_l = Maps.newHashMap();

    public MapData(String mapname) {
        super(mapname);
    }

    public void func_212440_a(int p_212440_1_, int p_212440_2_, int p_212440_3_, boolean p_212440_4_, boolean p_212440_5_, DimensionType p_212440_6_) {
        this.field_76197_d = (byte)p_212440_3_;
        this.func_176054_a(p_212440_1_, p_212440_2_, this.field_76197_d);
        this.field_76200_c = p_212440_6_;
        this.field_186210_e = p_212440_4_;
        this.field_191096_f = p_212440_5_;
        this.func_76185_a();
    }

    public void func_176054_a(double x, double z, int mapScale) {
        int i = 128 * (1 << mapScale);
        int j = MathHelper.func_76128_c((double)((x + 64.0) / (double)i));
        int k = MathHelper.func_76128_c((double)((z + 64.0) / (double)i));
        this.field_76201_a = j * i + i / 2 - 64;
        this.field_76199_b = k * i + i / 2 - 64;
    }

    @Override
    public void func_76184_a(CompoundNBT nbt) {
        int i = nbt.func_74762_e("dimension");
        DimensionType dimensiontype = DimensionType.func_186069_a(i);
        if (dimensiontype == null) {
            throw new IllegalArgumentException("Invalid map dimension: " + i);
        }
        this.field_76200_c = dimensiontype;
        this.field_76201_a = nbt.func_74762_e("xCenter");
        this.field_76199_b = nbt.func_74762_e("zCenter");
        this.field_76197_d = (byte)MathHelper.func_76125_a((int)nbt.func_74771_c("scale"), (int)0, (int)4);
        this.field_186210_e = !nbt.func_150297_b("trackingPosition", 1) || nbt.func_74767_n("trackingPosition");
        this.field_191096_f = nbt.func_74767_n("unlimitedTracking");
        this.field_215161_h = nbt.func_74767_n("locked");
        this.field_76198_e = nbt.func_74770_j("colors");
        if (this.field_76198_e.length != 16384) {
            this.field_76198_e = new byte[16384];
        }
        ListNBT listnbt = nbt.func_150295_c("banners", 10);
        for (int j = 0; j < listnbt.size(); ++j) {
            MapBanner mapbanner = MapBanner.func_204300_a((CompoundNBT)listnbt.func_150305_b(j));
            this.field_204270_k.put(mapbanner.func_204299_f(), mapbanner);
            this.func_191095_a(mapbanner.func_204305_c(), null, mapbanner.func_204299_f(), mapbanner.func_204304_a().func_177958_n(), mapbanner.func_204304_a().func_177952_p(), 180.0, mapbanner.func_204302_d());
        }
        ListNBT listnbt1 = nbt.func_150295_c("frames", 10);
        for (int k = 0; k < listnbt1.size(); ++k) {
            MapFrame mapframe = MapFrame.func_212765_a((CompoundNBT)listnbt1.func_150305_b(k));
            this.field_212442_l.put(mapframe.func_212767_e(), mapframe);
            this.func_191095_a(MapDecoration.Type.FRAME, null, "frame-" + mapframe.func_212769_d(), mapframe.func_212764_b().func_177958_n(), mapframe.func_212764_b().func_177952_p(), mapframe.func_212768_c(), null);
        }
    }

    @Override
    public CompoundNBT func_189551_b(CompoundNBT compound) {
        compound.func_74768_a("dimension", this.field_76200_c.func_186068_a());
        compound.func_74768_a("xCenter", this.field_76201_a);
        compound.func_74768_a("zCenter", this.field_76199_b);
        compound.func_74774_a("scale", this.field_76197_d);
        compound.func_74773_a("colors", this.field_76198_e);
        compound.func_74757_a("trackingPosition", this.field_186210_e);
        compound.func_74757_a("unlimitedTracking", this.field_191096_f);
        compound.func_74757_a("locked", this.field_215161_h);
        ListNBT listnbt = new ListNBT();
        for (MapBanner mapbanner : this.field_204270_k.values()) {
            listnbt.add((Object)mapbanner.func_204303_e());
        }
        compound.func_218657_a("banners", (INBT)listnbt);
        ListNBT listnbt1 = new ListNBT();
        for (MapFrame mapframe : this.field_212442_l.values()) {
            listnbt1.add((Object)mapframe.func_212770_a());
        }
        compound.func_218657_a("frames", (INBT)listnbt1);
        return compound;
    }

    public void func_215160_a(MapData p_215160_1_) {
        this.field_215161_h = true;
        this.field_76201_a = p_215160_1_.field_76201_a;
        this.field_76199_b = p_215160_1_.field_76199_b;
        this.field_204270_k.putAll(p_215160_1_.field_204270_k);
        this.field_76203_h.putAll(p_215160_1_.field_76203_h);
        System.arraycopy(p_215160_1_.field_76198_e, 0, this.field_76198_e, 0, p_215160_1_.field_76198_e.length);
        this.func_76185_a();
    }

    public void func_76191_a(PlayerEntity player, ItemStack mapStack) {
        CompoundNBT compoundnbt;
        if (!this.field_76202_j.containsKey((Object)player)) {
            MapInfo mapdata$mapinfo = new MapInfo(player);
            this.field_76202_j.put(player, mapdata$mapinfo);
            this.field_76196_g.add(mapdata$mapinfo);
        }
        if (!player.field_71071_by.func_70431_c(mapStack)) {
            this.field_76203_h.remove(player.func_200200_C_().getString());
        }
        for (int i = 0; i < this.field_76196_g.size(); ++i) {
            MapInfo mapdata$mapinfo1 = this.field_76196_g.get(i);
            String s = mapdata$mapinfo1.field_76211_a.func_200200_C_().getString();
            if (!mapdata$mapinfo1.field_76211_a.field_70128_L && (mapdata$mapinfo1.field_76211_a.field_71071_by.func_70431_c(mapStack) || mapStack.func_82839_y())) {
                if (mapStack.func_82839_y() || mapdata$mapinfo1.field_76211_a.field_71093_bK != this.field_76200_c || !this.field_186210_e) continue;
                this.func_191095_a(MapDecoration.Type.PLAYER, mapdata$mapinfo1.field_76211_a.field_70170_p, s, mapdata$mapinfo1.field_76211_a.func_226277_ct_(), mapdata$mapinfo1.field_76211_a.func_226281_cx_(), mapdata$mapinfo1.field_76211_a.field_70177_z, null);
                continue;
            }
            this.field_76202_j.remove((Object)mapdata$mapinfo1.field_76211_a);
            this.field_76196_g.remove(mapdata$mapinfo1);
            this.field_76203_h.remove(s);
        }
        if (mapStack.func_82839_y() && this.field_186210_e) {
            ItemFrameEntity itemframeentity = mapStack.func_82836_z();
            BlockPos blockpos = itemframeentity.func_174857_n();
            MapFrame mapframe1 = this.field_212442_l.get(MapFrame.func_212766_a((BlockPos)blockpos));
            if (mapframe1 != null && itemframeentity.func_145782_y() != mapframe1.func_212769_d() && this.field_212442_l.containsKey(mapframe1.func_212767_e())) {
                this.field_76203_h.remove("frame-" + mapframe1.func_212769_d());
            }
            MapFrame mapframe = new MapFrame(blockpos, itemframeentity.func_174811_aO().func_176736_b() * 90, itemframeentity.func_145782_y());
            this.func_191095_a(MapDecoration.Type.FRAME, player.field_70170_p, "frame-" + itemframeentity.func_145782_y(), blockpos.func_177958_n(), blockpos.func_177952_p(), itemframeentity.func_174811_aO().func_176736_b() * 90, null);
            this.field_212442_l.put(mapframe.func_212767_e(), mapframe);
        }
        if ((compoundnbt = mapStack.func_77978_p()) != null && compoundnbt.func_150297_b("Decorations", 9)) {
            ListNBT listnbt = compoundnbt.func_150295_c("Decorations", 10);
            for (int j = 0; j < listnbt.size(); ++j) {
                CompoundNBT compoundnbt1 = listnbt.func_150305_b(j);
                if (this.field_76203_h.containsKey(compoundnbt1.func_74779_i("id"))) continue;
                this.func_191095_a(MapDecoration.Type.func_191159_a(compoundnbt1.func_74771_c("type")), player.field_70170_p, compoundnbt1.func_74779_i("id"), compoundnbt1.func_74769_h("x"), compoundnbt1.func_74769_h("z"), compoundnbt1.func_74769_h("rot"), null);
            }
        }
    }

    public static void func_191094_a(ItemStack map, BlockPos target, String decorationName, MapDecoration.Type type) {
        ListNBT listnbt;
        if (map.func_77942_o() && map.func_77978_p().func_150297_b("Decorations", 9)) {
            listnbt = map.func_77978_p().func_150295_c("Decorations", 10);
        } else {
            listnbt = new ListNBT();
            map.func_77983_a("Decorations", (INBT)listnbt);
        }
        CompoundNBT compoundnbt = new CompoundNBT();
        compoundnbt.func_74774_a("type", type.func_191163_a());
        compoundnbt.func_74778_a("id", decorationName);
        compoundnbt.func_74780_a("x", target.func_177958_n());
        compoundnbt.func_74780_a("z", target.func_177952_p());
        compoundnbt.func_74780_a("rot", 180.0);
        listnbt.add((Object)compoundnbt);
        if (type.func_191162_c()) {
            CompoundNBT compoundnbt1 = map.func_190925_c("display");
            compoundnbt1.func_74768_a("MapColor", type.func_191161_d());
        }
    }

    private void func_191095_a(MapDecoration.Type type, @Nullable IWorld worldIn, String decorationName, double worldX, double worldZ, double rotationIn, @Nullable ITextComponent p_191095_10_) {
        byte b2;
        int i = 1 << this.field_76197_d;
        float f = (float)(worldX - (double)this.field_76201_a) / (float)i;
        float f1 = (float)(worldZ - (double)this.field_76199_b) / (float)i;
        byte b0 = (byte)((double)(f * 2.0f) + 0.5);
        byte b1 = (byte)((double)(f1 * 2.0f) + 0.5);
        int j = 63;
        if (f >= -63.0f && f1 >= -63.0f && f <= 63.0f && f1 <= 63.0f) {
            b2 = (byte)((rotationIn += rotationIn < 0.0 ? -8.0 : 8.0) * 16.0 / 360.0);
            if (worldIn != null && worldIn.func_201672_e().field_73011_w.shouldMapSpin(decorationName, worldX, worldZ, rotationIn)) {
                int l = (int)(worldIn.func_201672_e().func_72820_D() / 10L);
                b2 = (byte)(l * l * 34187121 + l * 121 >> 15 & 0xF);
            }
        } else {
            if (type != MapDecoration.Type.PLAYER) {
                this.field_76203_h.remove(decorationName);
                return;
            }
            int k = 320;
            if (Math.abs(f) < 320.0f && Math.abs(f1) < 320.0f) {
                type = MapDecoration.Type.PLAYER_OFF_MAP;
            } else {
                if (!this.field_191096_f) {
                    this.field_76203_h.remove(decorationName);
                    return;
                }
                type = MapDecoration.Type.PLAYER_OFF_LIMITS;
            }
            b2 = 0;
            if (f <= -63.0f) {
                b0 = -128;
            }
            if (f1 <= -63.0f) {
                b1 = -128;
            }
            if (f >= 63.0f) {
                b0 = 127;
            }
            if (f1 >= 63.0f) {
                b1 = 127;
            }
        }
        this.field_76203_h.put(decorationName, new MapDecoration(type, b0, b1, b2, p_191095_10_));
    }

    @Nullable
    public IPacket<?> func_176052_a(ItemStack mapStack, IBlockReader worldIn, PlayerEntity player) {
        MapInfo mapdata$mapinfo = this.field_76202_j.get((Object)player);
        return mapdata$mapinfo == null ? null : mapdata$mapinfo.func_176101_a(mapStack);
    }

    public void func_176053_a(int x, int y) {
        this.func_76185_a();
        for (MapInfo mapdata$mapinfo : this.field_76196_g) {
            mapdata$mapinfo.func_176102_a(x, y);
        }
    }

    public MapInfo func_82568_a(PlayerEntity player) {
        MapInfo mapdata$mapinfo = this.field_76202_j.get((Object)player);
        if (mapdata$mapinfo == null) {
            mapdata$mapinfo = new MapInfo(player);
            this.field_76202_j.put(player, mapdata$mapinfo);
            this.field_76196_g.add(mapdata$mapinfo);
        }
        return mapdata$mapinfo;
    }

    public void func_204269_a(IWorld p_204269_1_, BlockPos p_204269_2_) {
        float f = (float)p_204269_2_.func_177958_n() + 0.5f;
        float f1 = (float)p_204269_2_.func_177952_p() + 0.5f;
        int i = 1 << this.field_76197_d;
        float f2 = (f - (float)this.field_76201_a) / (float)i;
        float f3 = (f1 - (float)this.field_76199_b) / (float)i;
        int j = 63;
        boolean flag = false;
        if (f2 >= -63.0f && f3 >= -63.0f && f2 <= 63.0f && f3 <= 63.0f) {
            MapBanner mapbanner = MapBanner.func_204301_a((IBlockReader)((Object)p_204269_1_), (BlockPos)p_204269_2_);
            if (mapbanner == null) {
                return;
            }
            boolean flag1 = true;
            if (this.field_204270_k.containsKey(mapbanner.func_204299_f()) && this.field_204270_k.get(mapbanner.func_204299_f()).equals((Object)mapbanner)) {
                this.field_204270_k.remove(mapbanner.func_204299_f());
                this.field_76203_h.remove(mapbanner.func_204299_f());
                flag1 = false;
                flag = true;
            }
            if (flag1) {
                this.field_204270_k.put(mapbanner.func_204299_f(), mapbanner);
                this.func_191095_a(mapbanner.func_204305_c(), p_204269_1_, mapbanner.func_204299_f(), f, f1, 180.0, mapbanner.func_204302_d());
                flag = true;
            }
            if (flag) {
                this.func_76185_a();
            }
        }
    }

    public void func_204268_a(IBlockReader p_204268_1_, int p_204268_2_, int p_204268_3_) {
        Iterator<MapBanner> iterator = this.field_204270_k.values().iterator();
        while (iterator.hasNext()) {
            MapBanner mapbanner1;
            MapBanner mapbanner = iterator.next();
            if (mapbanner.func_204304_a().func_177958_n() != p_204268_2_ || mapbanner.func_204304_a().func_177952_p() != p_204268_3_ || mapbanner.equals((Object)(mapbanner1 = MapBanner.func_204301_a((IBlockReader)p_204268_1_, (BlockPos)mapbanner.func_204304_a())))) continue;
            iterator.remove();
            this.field_76203_h.remove(mapbanner.func_204299_f());
        }
    }

    public void func_212441_a(BlockPos pos, int entityIdIn) {
        this.field_76203_h.remove("frame-" + entityIdIn);
        this.field_212442_l.remove(MapFrame.func_212766_a((BlockPos)pos));
    }

    public class MapInfo {
        public final PlayerEntity field_76211_a;
        private boolean field_176105_d = true;
        private int field_176106_e;
        private int field_176103_f;
        private int field_176104_g = 127;
        private int field_176108_h = 127;
        private int field_176109_i;
        public int field_82569_d;

        public MapInfo(PlayerEntity player) {
            this.field_76211_a = player;
        }

        @Nullable
        public IPacket<?> func_176101_a(ItemStack stack) {
            if (this.field_176105_d) {
                this.field_176105_d = false;
                return new SMapDataPacket(FilledMapItem.func_195949_f(stack), MapData.this.field_76197_d, MapData.this.field_186210_e, MapData.this.field_215161_h, MapData.this.field_76203_h.values(), MapData.this.field_76198_e, this.field_176106_e, this.field_176103_f, this.field_176104_g + 1 - this.field_176106_e, this.field_176108_h + 1 - this.field_176103_f);
            }
            return this.field_176109_i++ % 5 == 0 ? new SMapDataPacket(FilledMapItem.func_195949_f(stack), MapData.this.field_76197_d, MapData.this.field_186210_e, MapData.this.field_215161_h, MapData.this.field_76203_h.values(), MapData.this.field_76198_e, 0, 0, 0, 0) : null;
        }

        public void func_176102_a(int x, int y) {
            if (this.field_176105_d) {
                this.field_176106_e = Math.min(this.field_176106_e, x);
                this.field_176103_f = Math.min(this.field_176103_f, y);
                this.field_176104_g = Math.max(this.field_176104_g, x);
                this.field_176108_h = Math.max(this.field_176108_h, y);
            } else {
                this.field_176105_d = true;
                this.field_176106_e = x;
                this.field_176103_f = y;
                this.field_176104_g = x;
                this.field_176108_h = y;
            }
        }
    }
}

