/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.coremod;

import cpw.mods.modlauncher.api.ITransformer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import jdk.nashorn.api.scripting.NashornScriptEngineFactory;
import net.minecraftforge.coremod.CoreMod;
import net.minecraftforge.forgespi.coremod.ICoreModFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class CoreModEngine {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker COREMOD = MarkerManager.getMarker((String)"COREMOD");
    private List<CoreMod> coreMods = new ArrayList<CoreMod>();
    private static final List<String> ALLOWED_CLASSES = Arrays.asList("net.minecraftforge.coremod.api.ASMAPI", "org.objectweb.asm.Opcodes", "org.objectweb.asm.tree.AbstractInsnNode", "org.objectweb.asm.tree.FieldInsnNode", "org.objectweb.asm.tree.FrameNode", "org.objectweb.asm.tree.IincInsnNode", "org.objectweb.asm.tree.InsnNode", "org.objectweb.asm.tree.IntInsnNode", "org.objectweb.asm.tree.InsnList", "org.objectweb.asm.tree.InvokeDynamicInsnNode", "org.objectweb.asm.tree.JumpInsnNode", "org.objectweb.asm.tree.LabelNode", "org.objectweb.asm.tree.LdcInsnNode", "org.objectweb.asm.tree.LineNumberNode", "org.objectweb.asm.tree.LocalVariableAnnotationNode", "org.objectweb.asm.tree.LocalVariableNode", "org.objectweb.asm.tree.LookupSwitchInsnNode", "org.objectweb.asm.tree.MethodInsnNode", "org.objectweb.asm.tree.MultiANewArrayInsnNode", "org.objectweb.asm.tree.TableSwitchInsnNode", "org.objectweb.asm.tree.TryCatchBlockNode", "org.objectweb.asm.tree.TypeAnnotationNode", "org.objectweb.asm.tree.TypeInsnNode", "org.objectweb.asm.tree.VarInsnNode", "org.objectweb.asm.tree.FieldNode", "org.objectweb.asm.tree.MethodNode", "org.objectweb.asm.tree.ParameterNode", "org.objectweb.asm.Attribute", "org.objectweb.asm.Handle", "org.objectweb.asm.Label", "org.objectweb.asm.Type", "org.objectweb.asm.TypePath", "org.objectweb.asm.TypeReference");

    void loadCoreMod(ICoreModFile coremod) {
        NashornScriptEngineFactory nashornScriptEngineFactory = new NashornScriptEngineFactory();
        ScriptEngine scriptEngine = nashornScriptEngineFactory.getScriptEngine(s -> ALLOWED_CLASSES.stream().anyMatch(s::equals));
        ScriptContext jsContext = scriptEngine.getContext();
        jsContext.removeAttribute("load", jsContext.getAttributesScope("load"));
        jsContext.removeAttribute("quit", jsContext.getAttributesScope("quit"));
        jsContext.removeAttribute("loadWithNewGlobal", jsContext.getAttributesScope("loadWithNewGlobal"));
        jsContext.removeAttribute("exit", jsContext.getAttributesScope("exit"));
        this.coreMods.add(new CoreMod(coremod, scriptEngine));
    }

    public List<ITransformer<?>> initializeCoreMods() {
        this.coreMods.forEach(this::initialize);
        return this.coreMods.stream().map(CoreMod::buildTransformers).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private void initialize(CoreMod coreMod) {
        LOGGER.debug(COREMOD, "Loading CoreMod from {}", (Object)coreMod.getPath());
        coreMod.initialize();
        if (coreMod.hasError()) {
            LOGGER.error(COREMOD, "Error occurred initializing CoreMod", (Throwable)coreMod.getError());
        } else {
            LOGGER.debug(COREMOD, "CoreMod loaded successfully");
        }
    }
}

