/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.datafixers.DataFixer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.net.Proxy;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyPair;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MinecraftServer
extends ait<tb>
implements ajq,
cp,
AutoCloseable,
Runnable {
    private static final Logger h = LogManager.getLogger();
    public static final File b = new File("usercache.json");
    private static final CompletableFuture<aca> i = CompletableFuture.completedFuture(aca.a);
    public static final bjx c = new bjx("North Carolina".hashCode(), bjq.b, true, false, bka.b).a();
    private final crm j;
    private final ajp k = new ajp("server", this, t.b());
    private final File l;
    private final List<Runnable> m = Lists.newArrayList();
    private final aii n = new aii(this::aj);
    private final xu o;
    protected final xn d;
    private final rw p = new rw();
    private final Random q = new Random();
    private final DataFixer r;
    private String s;
    private int t = -1;
    private final Map<cbf, xd> u = Maps.newIdentityHashMap();
    private zo v;
    private volatile boolean w = true;
    private boolean x;
    private int y;
    protected final Proxy e;
    private boolean z;
    private boolean A;
    private boolean B;
    private boolean C;
    private boolean D;
    private boolean E;
    @Nullable
    private String F;
    private int G;
    private int H;
    public final long[] f = new long[100];
    @Nullable
    private KeyPair I;
    @Nullable
    private String J;
    private final String K;
    private boolean M;
    private boolean N;
    private String O = "";
    private String P = "";
    private volatile boolean Q;
    private long R;
    @Nullable
    private lf S;
    private boolean T;
    private boolean U;
    @Nullable
    private final YggdrasilAuthenticationService V;
    private final MinecraftSessionService W;
    private final GameProfileRepository X;
    private final zk Y;
    private long Z;
    protected final Thread g = t.a(new Thread((Runnable)this, "Server thread"), (T thread2) -> thread2.setUncaughtExceptionHandler((thread, throwable) -> h.error((Object)throwable)));
    private long aa = t.b();
    private long ab;
    private boolean ac;
    private final yz ae = new zg(yf.b, this.g);
    private final yq<yt> af = new yq<yt>(yt::new);
    @Nullable
    private yo ag;
    private final cr ah;
    private final bgu ai = new bgu();
    private final abb aj = new abb();
    private final ta ak = new ta(this);
    @Nullable
    private crg al;
    private final td am = new td(this);
    private final crz an = new crz();
    private final cry ao = new cry(this.an);
    private final sx ap = new sx();
    private final sy aq = new sy(this);
    private final abj ar = new abj();
    private boolean as;
    private boolean at;
    private boolean au;
    private float av;
    private final Executor aw;
    @Nullable
    private String ax;

    public MinecraftServer(File file, Proxy proxy, DataFixer dataFixer, cr cr2, YggdrasilAuthenticationService yggdrasilAuthenticationService, MinecraftSessionService minecraftSessionService, GameProfileRepository gameProfileRepository, zk zk2, xn xn2, String string) {
        super("Server");
        this.e = proxy;
        this.ah = cr2;
        this.V = yggdrasilAuthenticationService;
        this.W = minecraftSessionService;
        this.X = gameProfileRepository;
        this.Y = zk2;
        this.l = file;
        this.o = new xu(this);
        this.d = xn2;
        this.j = new crm(file.toPath(), file.toPath().resolve("../backups"), dataFixer);
        this.r = dataFixer;
        this.ae.a(this.aj);
        this.ae.a(this.an);
        this.ae.a(this.ai);
        this.ae.a(this.ao);
        this.ae.a(this.aq);
        this.ae.a(this.ap);
        this.aw = t.e();
        this.K = string;
    }

    @Override
    private void a(cri cri2) {
        cwj cwj2 = cri2.a(cwj::new, "scoreboard");
        cwj2.a(this.aM());
        this.aM().a(new cqx(cwj2));
    }

    protected abstract boolean d() throws IOException;

    @Override
    protected void a(String string) {
        if (this.S().a(string)) {
            h.info("Converting map!");
            this.b(new lp("menu.convertingLevel", new Object[0]));
            this.S().a(string, new abs(){
                private long b = t.b();

                @Override
                public void a(lf lf2) {
                }

                @Override
                public void a(int n2) {
                    if (t.b() - this.b >= 1000L) {
                        this.b = t.b();
                        h.info("Converting... {}%", (Object)n2);
                    }
                }

                @Override
                public void c(lf lf2) {
                }
            });
        }
        if (this.at) {
            h.info("Forcing world upgrade!");
            crj crj2 = this.S().b(this.O());
            if (crj2 != null) {
                aiw aiw2 = new aiw(this.O(), this.S(), crj2, this.au);
                lf \u26032 = null;
                while (!aiw2.b()) {
                    lf lf2 = aiw2.g();
                    if (\u26032 != lf2) {
                        \u26032 = lf2;
                        h.info(aiw2.g().getString());
                    }
                    if ((\u2603 = aiw2.d()) > 0) {
                        int n2 = aiw2.e() + aiw2.f();
                        h.info("{}% completed ({} / {} chunks)...", (Object)abr.d((float)n2 / (float)\u2603 * 100.0f), (Object)n2, (Object)\u2603);
                    }
                    if (this.ae()) {
                        aiw2.a();
                        continue;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    protected synchronized void b(lf lf2) {
        this.S = lf2;
    }

    protected void a(String string, String string2, long l22, bka bka2, JsonElement jsonElement) {
        bjx \u26033;
        this.a(string);
        this.b(new lp("menu.loadingLevel", new Object[0]));
        crk crk2 = this.S().a(string, this);
        this.a(this.O(), crk2);
        crj \u26032 = crk2.c();
        if (\u26032 == null) {
            if (this.R()) {
                \u26033 = c;
            } else {
                long l22;
                \u26033 = new bjx(l22, this.g(), this.f(), this.i(), bka2);
                \u26033.a(jsonElement);
                if (this.N) {
                    \u26033.a();
                }
            }
            \u26032 = new crj(\u26033, string2);
        } else {
            \u26032.a(string2);
            \u26033 = new bjx(\u26032);
        }
        this.a(crk2.a(), \u26032);
        xm xm2 = this.d.create(11);
        this.a(crk2, \u26032, \u26033, xm2);
        this.a(this.h(), true);
        this.a(xm2);
    }

    protected void a(crk crk2, crj crj22, bjx bjx2, xm xm2) {
        xd xd2;
        if (this.R()) {
            crj22.a(c);
        }
        xd xd3 = new xd(this, this.aw, crk2, crj22, cbf.a, this.n, xm2);
        this.u.put(cbf.a, xd3);
        cri \u26032 = xd3.x();
        this.a(\u26032);
        this.al = new crg(\u26032);
        xd3.f().b(crj22);
        xd2 = this.a(cbf.a);
        if (!crj22.u()) {
            crj crj22;
            try {
                xd2.a(bjx2);
                if (crj22.s() == bka.h) {
                    this.a(crj22);
                }
                crj22.d(true);
            }
            catch (Throwable throwable) {
                h h2 = h.a(throwable, "Exception initializing level");
                try {
                    xd2.a(h2);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw new q(h2);
            }
            crj22.d(true);
        }
        this.af().a(xd2);
        if (crj22.P() != null) {
            this.aR().a(crj22.P());
        }
        for (cbf cbf2 : cbf.a()) {
            if (cbf2 == cbf.a) continue;
            this.u.put(cbf2, new wv(xd2, this, this.aw, crk2, cbf2, (aim)this.n, xm2));
        }
    }

    @Override
    private void a(crj crj2) {
        crj2.f(false);
        crj2.c(true);
        crj2.b(false);
        crj2.a(false);
        crj2.g(1000000000);
        crj2.b(6000L);
        crj2.a(bjq.e);
        crj2.g(false);
        crj2.a(ajf.a);
        crj2.e(true);
        crj2.v().a(bjp.j).a(false, this);
    }

    protected void a(File file, crj crj2) {
        this.af.a(new ys());
        this.ag = new yo(new File(file, "datapacks"));
        this.af.a(this.ag);
        this.af.a();
        ArrayList arrayList = Lists.newArrayList();
        for (String string : crj2.O()) {
            yt yt2 = this.af.a(string);
            if (yt2 != null) {
                arrayList.add(yt2);
                continue;
            }
            h.warn("Missing data pack {}", (Object)string);
        }
        this.af.a(arrayList);
        this.b(crj2);
        this.ba();
    }

    @Override
    protected void a(xm xm2) {
        this.b(new lp("menu.generatingTerrain", new Object[0]));
        xd xd2 = this.a(cbf.a);
        h.info("Preparing start region for dimension " + cbf.a(xd2.p.n()));
        fk \u26032 = xd2.s_();
        xm2.a(new bje(\u26032));
        xb \u26033 = xd2.m();
        \u26033.a().a(500);
        this.aa = t.b();
        \u26033.a(xi.a, new bje(\u26032), 11, aca.a);
        while (\u26033.b() != 441) {
            this.aa = t.b() + 10L;
            this.u();
        }
        this.aa = t.b() + 10L;
        this.u();
        for (cbf cbf2 : cbf.a()) {
            bjo bjo2 = this.a(cbf2).x().b(bjo::new, "chunks");
            if (bjo2 == null) continue;
            xd \u26034 = this.a(cbf2);
            LongIterator \u26035 = bjo2.a().iterator();
            while (\u26035.hasNext()) {
                long l2 = \u26035.nextLong();
                bje \u26036 = new bje(l2);
                \u26034.m().a(\u26036, true);
            }
        }
        this.aa = t.b() + 10L;
        this.u();
        xm2.b();
        \u26033.a().a(5);
    }

    protected void a(String string, crk crk2) {
        File file = new File(crk2.a(), "resources.zip");
        if (file.isFile()) {
            try {
                this.a("level://" + URLEncoder.encode(string, StandardCharsets.UTF_8.toString()) + "/" + "resources.zip", "");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                h.warn("Something went wrong url encoding {}", (Object)string);
            }
        }
    }

    public abstract boolean f();

    public abstract bjq g();

    public abstract ajf h();

    public abstract boolean i();

    public abstract int j();

    public abstract int k();

    public abstract boolean l();

    public boolean a(boolean bl2, boolean bl3, boolean bl4) {
        boolean bl5 = false;
        for (xd xd2 : this.C()) {
            if (!bl2) {
                h.info("Saving chunks for level '{}'/{}", (Object)xd2.i().i(), (Object)cbf.a(xd2.p.n()));
            }
            try {
                xd2.a(null, bl3, xd2.b && !bl4);
            }
            catch (bjv bjv2) {
                h.warn(bjv2.getMessage());
            }
            bl5 = true;
        }
        xd xd2 = this.a(cbf.a);
        crj crj2 = xd2.i();
        xd2.f().a(crj2);
        crj2.c(this.aR().c());
        xd2.w().a(crj2, this.af().r());
        return bl5;
    }

    @Override
    public void close() {
        this.r();
    }

    protected void r() {
        h.info("Stopping server");
        if (this.ag() != null) {
            this.ag().b();
        }
        if (this.v != null) {
            h.info("Saving players");
            this.v.i();
            this.v.s();
        }
        h.info("Saving worlds");
        for (xd xd2 : this.C()) {
            if (xd2 == null) continue;
            xd2.b = false;
        }
        this.a(false, true, false);
        for (xd xd2 : this.C()) {
            if (xd2 == null) continue;
            try {
                xd2.close();
            }
            catch (IOException iOException) {
                h.error("Exception closing the level", (Throwable)iOException);
            }
        }
        if (this.k.d()) {
            this.k.e();
        }
    }

    public String s() {
        return this.s;
    }

    public void b(String string) {
        this.s = string;
    }

    public boolean h_() {
        return this.w;
    }

    @Override
    public void a(boolean bl2) {
        this.w = false;
        if (bl2) {
            try {
                this.g.join();
            }
            catch (InterruptedException interruptedException) {
                h.error("Error while shutting down", (Throwable)interruptedException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.d()) {
                this.aa = t.b();
                this.p.a(new lo(this.F));
                this.p.a(new rw.c(s.a().getName(), s.a().getProtocolVersion()));
                this.a(this.p);
                while (this.w) {
                    long l2 = t.b() - this.aa;
                    if (l2 > 2000L && this.aa - this.R >= 15000L) {
                        \u2603 = l2 / 50L;
                        h.warn("Can't keep up! Is the server overloaded? Running {}ms or {} ticks behind", (Object)l2, (Object)\u2603);
                        this.aa += \u2603 * 50L;
                        this.R = this.aa;
                    }
                    this.aa += 50L;
                    if (this.T) {
                        this.T = false;
                        this.n.d().d();
                    }
                    this.n.a();
                    this.n.a("tick");
                    this.a(this::aY);
                    this.n.b("nextTickWait");
                    this.ac = true;
                    this.ab = Math.max(t.b() + 50L, this.aa);
                    this.u();
                    this.n.c();
                    this.n.b();
                    this.Q = true;
                }
            } else {
                this.a((h)null);
            }
        }
        catch (Throwable throwable) {
            h.error("Encountered an unexpected exception", throwable);
            h h2 = throwable instanceof q ? this.b(((q)throwable).a()) : this.b(new h("Exception in server tick loop", throwable));
            File \u26032 = new File(new File(this.y(), "crash-reports"), "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
            if (h2.a(\u26032)) {
                h.error("This crash report has been saved to: {}", (Object)\u26032.getAbsolutePath());
            } else {
                h.error("We were unable to save this crash report to disk.");
            }
            this.a(h2);
        }
        finally {
            try {
                this.x = true;
                this.r();
            }
            catch (Throwable \u26033) {
                h.error("Exception stopping the server", \u26033);
            }
            finally {
                this.e();
            }
        }
    }

    private boolean aY() {
        return this.bl() || t.b() < (this.ac ? this.ab : this.aa);
    }

    protected void u() {
        this.bj();
        this.c(() -> !this.aY());
    }

    protected tb a(Runnable runnable) {
        return new tb(this.y, runnable);
    }

    protected boolean a(tb tb2) {
        return tb2.a() + 3 < this.y || this.aY();
    }

    @Override
    public boolean v() {
        boolean bl2;
        this.ac = bl2 = this.aZ();
        return bl2;
    }

    private boolean aZ() {
        if (super.v()) {
            return true;
        }
        if (this.aY()) {
            for (xd xd2 : this.C()) {
                if (!xd2.m().d()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void a(rw rw2) {
        File file = this.d("server-icon.png");
        if (!file.exists()) {
            file = this.S().b(this.O(), "icon.png");
        }
        if (file.isFile()) {
            ByteBuf byteBuf = Unpooled.buffer();
            try {
                BufferedImage bufferedImage = ImageIO.read(file);
                Validate.validState((bufferedImage.getWidth() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                Validate.validState((bufferedImage.getHeight() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                ImageIO.write((RenderedImage)bufferedImage, "PNG", (OutputStream)new ByteBufOutputStream(byteBuf));
                ByteBuffer \u26032 = Base64.getEncoder().encode(byteBuf.nioBuffer());
                rw2.a("data:image/png;base64," + StandardCharsets.UTF_8.decode(\u26032));
            }
            catch (Exception exception) {
                h.error("Couldn't load server icon", (Throwable)exception);
            }
            finally {
                byteBuf.release();
            }
        }
    }

    public File y() {
        return new File(".");
    }

    @Override
    protected void a(h h2) {
    }

    protected void e() {
    }

    @Override
    protected void a(BooleanSupplier booleanSupplier) {
        long l2 = t.c();
        ++this.y;
        this.b(booleanSupplier);
        if (l2 - this.Z >= 5000000000L) {
            this.Z = l2;
            this.p.a(new rw.a(this.F(), this.E()));
            GameProfile[] gameProfileArray = new GameProfile[Math.min(this.E(), 12)];
            int \u26032 = abr.a(this.q, 0, this.E() - gameProfileArray.length);
            for (int i2 = 0; i2 < gameProfileArray.length; ++i2) {
                gameProfileArray[i2] = this.v.t().get(\u26032 + i2).ed();
            }
            Collections.shuffle(Arrays.asList(gameProfileArray));
            this.p.b().a(gameProfileArray);
        }
        if (this.y % 6000 == 0) {
            h.debug("Autosave started");
            this.n.a("save");
            this.v.i();
            this.a(true, false, false);
            this.n.c();
            h.debug("Autosave finished");
        }
        this.n.a("snooper");
        if (!this.k.d() && this.y > 100) {
            this.k.a();
        }
        if (this.y % 6000 == 0) {
            this.k.b();
        }
        this.n.c();
        this.n.a("tallying");
        long l3 = t.c() - l2;
        this.f[this.y % 100] = l3;
        \u2603 = l3;
        this.av = this.av * 0.8f + (float)\u2603 / 1000000.0f * 0.19999999f;
        \u2603 = t.c();
        this.ar.a(\u2603 - l2);
        this.n.c();
    }

    protected void b(BooleanSupplier booleanSupplier) {
        this.n.a("commandFunctions");
        this.aD().e();
        this.n.b("levels");
        for (xd xd2 : this.C()) {
            if (xd2.p.n() != cbf.a && !this.z()) continue;
            this.n.a(() -> xd2.i().i() + " " + gb.B.b(xd2.p.n()));
            if (this.y % 20 == 0) {
                this.n.a("timeSync");
                this.v.a(new ov(xd2.R(), xd2.S(), xd2.T().b(bjp.j)), xd2.p.n());
                this.n.c();
            }
            this.n.a("tick");
            try {
                xd2.a(booleanSupplier);
            }
            catch (Throwable throwable) {
                h h2 = h.a(throwable, "Exception ticking world");
                xd2.a(h2);
                throw new q(h2);
            }
            this.n.c();
            this.n.c();
        }
        this.n.b("connection");
        this.ag().c();
        this.n.b("players");
        this.v.d();
        if (s.b) {
            jc.a.b();
        }
        this.n.b("server gui refresh");
        for (int i2 = 0; i2 < this.m.size(); ++i2) {
            this.m.get(i2).run();
        }
        this.n.c();
    }

    public boolean z() {
        return true;
    }

    public void b(Runnable runnable) {
        this.m.add(runnable);
    }

    public static void main(String[] stringArray) {
        OptionParser optionParser = new OptionParser();
        OptionSpecBuilder \u26032 = optionParser.accepts("nogui");
        OptionSpecBuilder \u26033 = optionParser.accepts("initSettings", "Initializes 'server.properties' and 'eula.txt', then quits");
        OptionSpecBuilder \u26034 = optionParser.accepts("demo");
        OptionSpecBuilder \u26035 = optionParser.accepts("bonusChest");
        OptionSpecBuilder \u26036 = optionParser.accepts("forceUpgrade");
        OptionSpecBuilder \u26037 = optionParser.accepts("eraseCache");
        AbstractOptionSpec \u26038 = optionParser.accepts("help").forHelp();
        ArgumentAcceptingOptionSpec \u26039 = optionParser.accepts("singleplayer").withRequiredArg();
        ArgumentAcceptingOptionSpec \u260310 = optionParser.accepts("universe").withRequiredArg().defaultsTo((Object)".", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec \u260311 = optionParser.accepts("world").withRequiredArg();
        ArgumentAcceptingOptionSpec \u260312 = optionParser.accepts("port").withRequiredArg().ofType(Integer.class).defaultsTo((Object)-1, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec \u260313 = optionParser.accepts("serverId").withRequiredArg();
        NonOptionArgumentSpec \u260314 = optionParser.nonOptions();
        try {
            OptionSet optionSet = optionParser.parse(stringArray);
            if (optionSet.has((OptionSpec)\u26038)) {
                optionParser.printHelpOn((OutputStream)System.err);
                return;
            }
            Path \u260315 = Paths.get("server.properties", new String[0]);
            wf \u260316 = new wf(\u260315);
            \u260316.b();
            Path \u260317 = Paths.get("eula.txt", new String[0]);
            st \u260318 = new st(\u260317);
            if (optionSet.has((OptionSpec)\u26033)) {
                h.info("Initialized '" + \u260315.toAbsolutePath().toString() + "' and '" + \u260317.toAbsolutePath().toString() + "'");
                return;
            }
            if (!\u260318.a()) {
                h.info("You need to agree to the EULA in order to run the server. Go to eula.txt for more info.");
                return;
            }
            so.a();
            so.c();
            String \u260319 = (String)optionSet.valueOf((OptionSpec)\u260310);
            YggdrasilAuthenticationService \u260320 = new YggdrasilAuthenticationService(Proxy.NO_PROXY, UUID.randomUUID().toString());
            MinecraftSessionService \u260321 = \u260320.createMinecraftSessionService();
            GameProfileRepository \u260322 = \u260320.createProfileRepository();
            zk \u260323 = new zk(\u260322, new File(\u260319, b.getName()));
            String \u260324 = (String)Optional.ofNullable(optionSet.valueOf((OptionSpec)\u260311)).orElse(\u260316.a().o);
            final wd \u260325 = new wd(new File(\u260319), \u260316, ace.a(), \u260320, \u260321, \u260322, \u260323, xo::new, \u260324);
            \u260325.i((String)optionSet.valueOf((OptionSpec)\u26039));
            \u260325.a((Integer)optionSet.valueOf((OptionSpec)\u260312));
            \u260325.e(optionSet.has((OptionSpec)\u26034));
            \u260325.f(optionSet.has((OptionSpec)\u26035));
            \u260325.b(optionSet.has((OptionSpec)\u26036));
            \u260325.c(optionSet.has((OptionSpec)\u26037));
            \u260325.c((String)optionSet.valueOf((OptionSpec)\u260313));
            boolean bl2 = \u2603 = !optionSet.has((OptionSpec)\u26032) && !optionSet.valuesOf((OptionSpec)\u260314).contains("nogui");
            if (\u2603 && !GraphicsEnvironment.isHeadless()) {
                \u260325.bb();
            }
            \u260325.A();
            Thread \u260326 = new Thread("Server Shutdown Thread"){

                @Override
                public void run() {
                    \u260325.a(true);
                }
            };
            \u260326.setUncaughtExceptionHandler(new k(h));
            Runtime.getRuntime().addShutdownHook(\u260326);
        }
        catch (Exception exception) {
            h.fatal("Failed to start the minecraft server", (Throwable)exception);
        }
    }

    protected void c(String string) {
        this.ax = string;
    }

    protected void b(boolean bl2) {
        this.at = bl2;
    }

    protected void c(boolean bl2) {
        this.au = bl2;
    }

    public void A() {
        this.g.start();
    }

    public File d(String string) {
        return new File(this.y(), string);
    }

    public void e(String string) {
        h.info(string);
    }

    public void f(String string) {
        h.warn(string);
    }

    public xd a(cbf cbf2) {
        return this.u.get(cbf2);
    }

    public Iterable<xd> C() {
        return this.u.values();
    }

    public String D() {
        return s.a().getName();
    }

    public int E() {
        return this.v.n();
    }

    public int F() {
        return this.v.o();
    }

    public String[] G() {
        return this.v.e();
    }

    public boolean I() {
        return false;
    }

    @Override
    public void g(String string) {
        h.error(string);
    }

    @Override
    public void h(String string) {
        if (this.I()) {
            h.info(string);
        }
    }

    public String getServerModName() {
        return "vanilla";
    }

    public h b(h h2) {
        if (this.v != null) {
            h2.g().a("Player Count", () -> this.v.n() + " / " + this.v.o() + "; " + this.v.t());
        }
        h2.g().a("Data Packs", () -> {
            StringBuilder stringBuilder = new StringBuilder();
            for (yt yt2 : this.af.d()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(yt2.e());
                if (yt2.c().a()) continue;
                stringBuilder.append(" (incompatible)");
            }
            return stringBuilder.toString();
        });
        if (this.ax != null) {
            h2.g().a("Server Id", () -> this.ax);
        }
        return h2;
    }

    public boolean J() {
        return this.l != null;
    }

    @Override
    public void a(lf lf2) {
        h.info(lf2.getString());
    }

    public KeyPair K() {
        return this.I;
    }

    public int L() {
        return this.t;
    }

    @Override
    public void a(int n2) {
        this.t = n2;
    }

    public String M() {
        return this.J;
    }

    public void i(String string) {
        this.J = string;
    }

    public boolean N() {
        return this.J != null;
    }

    public String O() {
        return this.K;
    }

    @Override
    public void a(KeyPair keyPair) {
        this.I = keyPair;
    }

    public void a(ajf ajf2, boolean bl2) {
        for (xd xd2 : this.C()) {
            crj crj2 = xd2.i();
            if (!bl2 && crj2.x()) continue;
            if (crj2.r()) {
                crj2.a(ajf.d);
                xd2.a(true, true);
                continue;
            }
            if (this.N()) {
                crj2.a(ajf2);
                xd2.a(xd2.aa() != ajf.a, true);
                continue;
            }
            crj2.a(ajf2);
            xd2.a(this.Q(), this.B);
        }
        this.af().t().forEach(this::a);
    }

    public void d(boolean bl2) {
        for (xd xd2 : this.C()) {
            crj crj2 = xd2.i();
            crj2.e(bl2);
        }
        this.af().t().forEach(this::a);
    }

    @Override
    private void a(xe xe2) {
        crj crj2 = xe2.s().i();
        xe2.b.a(new ml(crj2.w(), crj2.x()));
    }

    protected boolean Q() {
        return true;
    }

    public boolean R() {
        return this.M;
    }

    public void e(boolean bl2) {
        this.M = bl2;
    }

    public void f(boolean bl2) {
        this.N = bl2;
    }

    public crm S() {
        return this.j;
    }

    public String T() {
        return this.O;
    }

    public String U() {
        return this.P;
    }

    public void a(String string, String string2) {
        this.O = string;
        this.P = string2;
    }

    @Override
    public void a(ajp ajp22) {
        ajp ajp22;
        ajp22.a("whitelist_enabled", false);
        ajp22.a("whitelist_count", 0);
        if (this.v != null) {
            ajp22.a("players_current", this.E());
            ajp22.a("players_max", this.F());
            ajp22.a("players_seen", this.a(cbf.a).w().d().length);
        }
        ajp22.a("uses_auth", this.z);
        ajp22.a("gui_state", this.ai() ? "enabled" : "disabled");
        ajp22.a("run_time", (t.b() - ajp22.g()) / 60L * 1000L);
        ajp22.a("avg_tick_ms", (int)(abr.a(this.f) * 1.0E-6));
        int n2 = 0;
        for (xd xd2 : this.C()) {
            if (xd2 == null) continue;
            crj crj2 = xd2.i();
            ajp22.a("world[" + n2 + "][dimension]", xd2.p.n());
            ajp22.a("world[" + n2 + "][mode]", (Object)crj2.p());
            ajp22.a("world[" + n2 + "][difficulty]", (Object)xd2.aa());
            ajp22.a("world[" + n2 + "][hardcore]", crj2.r());
            ajp22.a("world[" + n2 + "][generator_name]", crj2.s().a());
            ajp22.a("world[" + n2 + "][generator_version]", crj2.s().e());
            ajp22.a("world[" + n2 + "][height]", this.G);
            ajp22.a("world[" + n2 + "][chunks_loaded]", xd2.m().h());
            ++n2;
        }
        ajp22.a("worlds", n2);
    }

    public abstract boolean m();

    public boolean W() {
        return this.z;
    }

    @Override
    public void g(boolean bl2) {
        this.z = bl2;
    }

    public boolean X() {
        return this.A;
    }

    @Override
    public void h(boolean bl2) {
        this.A = bl2;
    }

    public boolean Y() {
        return this.B;
    }

    public void i(boolean bl2) {
        this.B = bl2;
    }

    public boolean Z() {
        return this.C;
    }

    public abstract boolean n();

    public void j(boolean bl2) {
        this.C = bl2;
    }

    public boolean aa() {
        return this.D;
    }

    public void k(boolean bl2) {
        this.D = bl2;
    }

    public boolean ab() {
        return this.E;
    }

    public void l(boolean bl2) {
        this.E = bl2;
    }

    public abstract boolean o();

    public String ac() {
        return this.F;
    }

    public void k(String string) {
        this.F = string;
    }

    public int ad() {
        return this.G;
    }

    public void b(int n2) {
        this.G = n2;
    }

    public boolean ae() {
        return this.x;
    }

    public zo af() {
        return this.v;
    }

    @Override
    public void a(zo zo2) {
        this.v = zo2;
    }

    public abstract boolean p();

    @Override
    public void a(bjq bjq2) {
        for (xd xd2 : this.C()) {
            xd2.i().a(bjq2);
        }
    }

    @Nullable
    public xu ag() {
        return this.o;
    }

    public boolean ai() {
        return false;
    }

    public abstract boolean a(bjq var1, boolean var2, int var3);

    public int aj() {
        return this.y;
    }

    public void ak() {
        this.T = true;
    }

    public int an() {
        return 16;
    }

    public boolean a(bjt bjt2, fk fk2, ayg ayg2) {
        return false;
    }

    public void m(boolean bl2) {
        this.U = bl2;
    }

    public boolean ao() {
        return this.U;
    }

    public int aq() {
        return this.H;
    }

    public void c(int n2) {
        this.H = n2;
    }

    public MinecraftSessionService ar() {
        return this.W;
    }

    public GameProfileRepository as() {
        return this.X;
    }

    public zk at() {
        return this.Y;
    }

    public rw au() {
        return this.p;
    }

    public void av() {
        this.Z = 0L;
    }

    public int aw() {
        return 29999984;
    }

    @Override
    public boolean ax() {
        return super.ax() && !this.ae();
    }

    @Override
    public Thread ay() {
        return this.g;
    }

    public int az() {
        return 256;
    }

    public long aA() {
        return this.aa;
    }

    public DataFixer aB() {
        return this.r;
    }

    public int a(@Nullable xd xd2) {
        if (xd2 != null) {
            return xd2.T().c(bjp.q);
        }
        return 10;
    }

    public sx aC() {
        return this.ap;
    }

    public sy aD() {
        return this.aq;
    }

    public void aE() {
        if (!this.bf()) {
            this.execute(this::aE);
            return;
        }
        this.af().i();
        this.af.a();
        this.b(this.a(cbf.a).i());
        this.af().u();
        this.ba();
    }

    private void b(crj crj2) {
        ArrayList arrayList = Lists.newArrayList(this.af.d());
        for (yt yt3 : this.af.b()) {
            if (crj2.N().contains(yt3.e()) || arrayList.contains(yt3)) continue;
            h.info("Found new data pack {}, loading it automatically", (Object)yt3.e());
            yt3.h().a(arrayList, yt3, (T yt2) -> yt2, false);
        }
        this.af.a(arrayList);
        ArrayList arrayList2 = Lists.newArrayList();
        this.af.d().forEach(yt2 -> arrayList2.add(yt2.d()));
        CompletableFuture<aca> completableFuture = this.ae.a(this.aw, this, arrayList2, i);
        this.c(completableFuture::isDone);
        try {
            completableFuture.get();
        }
        catch (Exception \u26033) {
            h.error("Failed to reload data packs", (Throwable)\u26033);
        }
        crj2.O().clear();
        crj2.N().clear();
        this.af.d().forEach(yt2 -> crj2.O().add(yt2.e()));
        this.af.b().forEach(yt2 -> {
            if (!this.af.d().contains(yt2)) {
                crj2.N().add(yt2.e());
            }
        });
    }

    @Override
    public void a(cq cq2) {
        if (!this.aS()) {
            return;
        }
        zo zo2 = cq2.j().af();
        zv \u26032 = zo2.j();
        if (!\u26032.b()) {
            return;
        }
        ArrayList \u26033 = Lists.newArrayList(zo2.t());
        for (xe xe2 : \u26033) {
            if (\u26032.a(xe2.ed())) continue;
            xe2.b.b(new lp("multiplayer.disconnect.not_whitelisted", new Object[0]));
        }
    }

    public yz aF() {
        return this.ae;
    }

    public yq<yt> aG() {
        return this.af;
    }

    public cr aI() {
        return this.ah;
    }

    public cq aJ() {
        return new cq(this, this.a(cbf.a) == null ? cvi.a : new cvi(this.a(cbf.a).s_()), cvh.a, this.a(cbf.a), 4, "Server", new lo("Server"), this, null);
    }

    @Override
    public boolean a() {
        return true;
    }

    @Override
    public boolean b() {
        return true;
    }

    public bgu aK() {
        return this.ai;
    }

    public abb aL() {
        return this.aj;
    }

    public ta aM() {
        return this.ak;
    }

    public crg aN() {
        if (this.al == null) {
            throw new NullPointerException("Called before server init");
        }
        return this.al;
    }

    public cry aO() {
        return this.ao;
    }

    public crz aP() {
        return this.an;
    }

    public bjp aQ() {
        return this.a(cbf.a).T();
    }

    public td aR() {
        return this.am;
    }

    public boolean aS() {
        return this.as;
    }

    public void n(boolean bl2) {
        this.as = bl2;
    }

    public float aT() {
        return this.av;
    }

    public int b(GameProfile gameProfile) {
        if (this.af().h(gameProfile)) {
            zq zq2 = (zq)this.af().l().b(gameProfile);
            if (zq2 != null) {
                return zq2.a();
            }
            if (this.a(gameProfile)) {
                return 4;
            }
            if (this.N()) {
                return this.af().v() ? 4 : 0;
            }
            return this.j();
        }
        return 0;
    }

    public aii aV() {
        return this.n;
    }

    public Executor aW() {
        return this.aw;
    }

    public abstract boolean a(GameProfile var1);

    @Override
    public void a(Path path) throws IOException {
        \u2603 = path.resolve("levels");
        for (Map.Entry<cbf, xd> entry : this.u.entrySet()) {
            sm sm2 = cbf.a(entry.getKey());
            Path \u26032 = \u2603.resolve(sm2.b()).resolve(sm2.a());
            Files.createDirectories(\u26032, new FileAttribute[0]);
            entry.getValue().a(\u26032);
        }
        this.d(path.resolve("gamerules.txt"));
        this.e(path.resolve("classpath.txt"));
        this.c(path.resolve("example_crash.txt"));
        this.b(path.resolve("stats.txt"));
        this.f(path.resolve("threads.txt"));
    }

    private void b(Path path) throws IOException {
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
            bufferedWriter.write(String.format("pending_tasks: %d\n", this.bg()));
            bufferedWriter.write(String.format("average_tick_time: %f\n", Float.valueOf(this.aT())));
            bufferedWriter.write(String.format("tick_times: %s\n", Arrays.toString(this.f)));
            bufferedWriter.write(String.format("queue: %s\n", t.e()));
        }
    }

    private void c(Path path) throws IOException {
        h h2 = new h("Server dump", new Exception("dummy"));
        this.b(h2);
        try (BufferedWriter \u26032 = Files.newBufferedWriter(path, new OpenOption[0]);){
            \u26032.write(h2.e());
        }
    }

    private void d(Path path) throws IOException {
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
            final ArrayList arrayList = Lists.newArrayList();
            final bjp \u26032 = this.aQ();
            bjp.a(new bjp.b(){

                @Override
                public <T extends bjp.f<T>> void a(bjp.d<T> d2, bjp.e<T> e2) {
                    arrayList.add(String.format("%s=%s\n", d2.a(), ((bjp.f)\u26032.a(d2)).toString()));
                }
            });
            for (String string : arrayList) {
                bufferedWriter.write(string);
            }
        }
    }

    private void e(Path path) throws IOException {
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
            String string = System.getProperty("java.class.path");
            \u2603 = System.getProperty("path.separator");
            for (String string2 : Splitter.on((String)\u2603).split((CharSequence)string)) {
                bufferedWriter.write(string2);
                bufferedWriter.write("\n");
            }
        }
    }

    private void f(Path path) throws IOException {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] \u26032 = threadMXBean.dumpAllThreads(true, true);
        Arrays.sort(\u26032, Comparator.comparing(ThreadInfo::getThreadName));
        try (BufferedWriter \u26033 = Files.newBufferedWriter(path, new OpenOption[0]);){
            for (ThreadInfo threadInfo : \u26032) {
                \u26033.write(threadInfo.toString());
                ((Writer)\u26033).write(10);
            }
        }
    }

    private void ba() {
        bpe.m.forEach(byg::c);
    }

    @Override
    public /* synthetic */ boolean c(Runnable runnable) {
        return this.a((tb)runnable);
    }

    @Override
    public /* synthetic */ Runnable d(Runnable runnable) {
        return this.a(runnable);
    }
}

