/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai.brain.task;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.memory.WalkTarget;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityPosWrapper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.server.ServerWorld;

public class WalkToVillagerBabiesTask
extends Task<CreatureEntity> {
    public WalkToVillagerBabiesTask() {
        super((Map<MemoryModuleType<?>, MemoryModuleStatus>)ImmutableMap.of(MemoryModuleType.field_220947_h, (Object)((Object)MemoryModuleStatus.VALUE_PRESENT), MemoryModuleType.field_220950_k, (Object)((Object)MemoryModuleStatus.VALUE_ABSENT), MemoryModuleType.field_220951_l, (Object)((Object)MemoryModuleStatus.REGISTERED), MemoryModuleType.field_220952_m, (Object)((Object)MemoryModuleStatus.REGISTERED)));
    }

    @Override
    protected boolean func_212832_a_(ServerWorld serverWorld, CreatureEntity creatureEntity) {
        return serverWorld.func_201674_k().nextInt(10) == 0 && this.func_220501_e(creatureEntity);
    }

    @Override
    protected void func_212831_a_(ServerWorld serverWorld, CreatureEntity creatureEntity, long l) {
        LivingEntity livingEntity2 = this.func_220500_b(creatureEntity);
        if (livingEntity2 != null) {
            this.func_220508_a(serverWorld, creatureEntity, livingEntity2);
            return;
        }
        Optional<LivingEntity> \u26032 = this.func_220497_b(creatureEntity);
        if (\u26032.isPresent()) {
            WalkToVillagerBabiesTask.func_220498_a(creatureEntity, \u26032.get());
            return;
        }
        this.func_220510_a(creatureEntity).ifPresent(livingEntity -> WalkToVillagerBabiesTask.func_220498_a(creatureEntity, livingEntity));
    }

    private void func_220508_a(ServerWorld serverWorld, CreatureEntity creatureEntity, LivingEntity livingEntity) {
        for (int i = 0; i < 10; ++i) {
            Vec3d vec3d = RandomPositionGenerator.func_191377_b(creatureEntity, 20, 8);
            if (vec3d == null || !serverWorld.func_217483_b_(new BlockPos(vec3d))) continue;
            creatureEntity.func_213375_cj().func_218205_a(MemoryModuleType.field_220950_k, new WalkTarget(vec3d, 0.6f, 0));
            return;
        }
    }

    private static void func_220498_a(CreatureEntity creatureEntity, LivingEntity livingEntity) {
        Brain<?> brain = creatureEntity.func_213375_cj();
        brain.func_218205_a(MemoryModuleType.field_220952_m, livingEntity);
        brain.func_218205_a(MemoryModuleType.field_220951_l, new EntityPosWrapper(livingEntity));
        brain.func_218205_a(MemoryModuleType.field_220950_k, new WalkTarget(new EntityPosWrapper(livingEntity), 0.6f, 1));
    }

    private Optional<LivingEntity> func_220510_a(CreatureEntity creatureEntity) {
        return this.func_220503_d(creatureEntity).stream().findAny();
    }

    private Optional<LivingEntity> func_220497_b(CreatureEntity creatureEntity) {
        Map<LivingEntity, Integer> map = this.func_220505_c(creatureEntity);
        return map.entrySet().stream().sorted(Comparator.comparingInt(Map.Entry::getValue)).filter(entry -> (Integer)entry.getValue() > 0 && (Integer)entry.getValue() <= 5).map(Map.Entry::getKey).findFirst();
    }

    private Map<LivingEntity, Integer> func_220505_c(CreatureEntity creatureEntity) {
        HashMap hashMap = Maps.newHashMap();
        this.func_220503_d(creatureEntity).stream().filter(this::func_220502_c).forEach(livingEntity2 -> hashMap.compute(this.func_220495_a((LivingEntity)livingEntity2), (livingEntity, n) -> n == null ? 1 : n + 1));
        return hashMap;
    }

    private List<LivingEntity> func_220503_d(CreatureEntity creatureEntity) {
        return creatureEntity.func_213375_cj().func_218207_c(MemoryModuleType.field_220947_h).get();
    }

    private LivingEntity func_220495_a(LivingEntity livingEntity) {
        return livingEntity.func_213375_cj().func_218207_c(MemoryModuleType.field_220952_m).get();
    }

    @Nullable
    private LivingEntity func_220500_b(LivingEntity livingEntity) {
        return livingEntity.func_213375_cj().func_218207_c(MemoryModuleType.field_220947_h).get().stream().filter(livingEntity2 -> this.func_220499_a(livingEntity, (LivingEntity)livingEntity2)).findAny().orElse(null);
    }

    private boolean func_220502_c(LivingEntity livingEntity) {
        return livingEntity.func_213375_cj().func_218207_c(MemoryModuleType.field_220952_m).isPresent();
    }

    private boolean func_220499_a(LivingEntity livingEntity, LivingEntity livingEntity3) {
        return livingEntity3.func_213375_cj().func_218207_c(MemoryModuleType.field_220952_m).filter(livingEntity2 -> livingEntity2 == livingEntity).isPresent();
    }

    private boolean func_220501_e(CreatureEntity creatureEntity) {
        return creatureEntity.func_213375_cj().func_218191_a(MemoryModuleType.field_220947_h);
    }
}

