/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.math;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3d;

public class AxisAlignedBB {
    public final double field_72340_a;
    public final double field_72338_b;
    public final double field_72339_c;
    public final double field_72336_d;
    public final double field_72337_e;
    public final double field_72334_f;

    public AxisAlignedBB(double d, double d2, double d3, double d4, double d5, double d6) {
        this.field_72340_a = Math.min(d, d4);
        this.field_72338_b = Math.min(d2, d5);
        this.field_72339_c = Math.min(d3, d6);
        this.field_72336_d = Math.max(d, d4);
        this.field_72337_e = Math.max(d2, d5);
        this.field_72334_f = Math.max(d3, d6);
    }

    public AxisAlignedBB(BlockPos blockPos) {
        this(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p(), blockPos.func_177958_n() + 1, blockPos.func_177956_o() + 1, blockPos.func_177952_p() + 1);
    }

    public AxisAlignedBB(BlockPos blockPos, BlockPos blockPos2) {
        this(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p(), blockPos2.func_177958_n(), blockPos2.func_177956_o(), blockPos2.func_177952_p());
    }

    public AxisAlignedBB(Vec3d vec3d, Vec3d vec3d2) {
        this(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, vec3d2.field_72450_a, vec3d2.field_72448_b, vec3d2.field_72449_c);
    }

    public static AxisAlignedBB func_216363_a(MutableBoundingBox mutableBoundingBox) {
        return new AxisAlignedBB(mutableBoundingBox.field_78897_a, mutableBoundingBox.field_78895_b, mutableBoundingBox.field_78896_c, mutableBoundingBox.field_78893_d + 1, mutableBoundingBox.field_78894_e + 1, mutableBoundingBox.field_78892_f + 1);
    }

    public double func_197745_a(Direction.Axis axis) {
        return axis.func_196051_a(this.field_72340_a, this.field_72338_b, this.field_72339_c);
    }

    public double func_197742_b(Direction.Axis axis) {
        return axis.func_196051_a(this.field_72336_d, this.field_72337_e, this.field_72334_f);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AxisAlignedBB)) {
            return false;
        }
        AxisAlignedBB axisAlignedBB = (AxisAlignedBB)object;
        if (Double.compare(axisAlignedBB.field_72340_a, this.field_72340_a) != 0) {
            return false;
        }
        if (Double.compare(axisAlignedBB.field_72338_b, this.field_72338_b) != 0) {
            return false;
        }
        if (Double.compare(axisAlignedBB.field_72339_c, this.field_72339_c) != 0) {
            return false;
        }
        if (Double.compare(axisAlignedBB.field_72336_d, this.field_72336_d) != 0) {
            return false;
        }
        if (Double.compare(axisAlignedBB.field_72337_e, this.field_72337_e) != 0) {
            return false;
        }
        return Double.compare(axisAlignedBB.field_72334_f, this.field_72334_f) == 0;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.field_72340_a);
        int \u26032 = (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.field_72338_b);
        \u26032 = 31 * \u26032 + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.field_72339_c);
        \u26032 = 31 * \u26032 + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.field_72336_d);
        \u26032 = 31 * \u26032 + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.field_72337_e);
        \u26032 = 31 * \u26032 + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.field_72334_f);
        \u26032 = 31 * \u26032 + (int)(l ^ l >>> 32);
        return \u26032;
    }

    public AxisAlignedBB func_191195_a(double d, double d2, double d3) {
        \u2603 = this.field_72340_a;
        \u2603 = this.field_72338_b;
        \u2603 = this.field_72339_c;
        \u2603 = this.field_72336_d;
        \u2603 = this.field_72337_e;
        \u2603 = this.field_72334_f;
        if (d < 0.0) {
            \u2603 -= d;
        } else if (d > 0.0) {
            \u2603 -= d;
        }
        if (d2 < 0.0) {
            \u2603 -= d2;
        } else if (d2 > 0.0) {
            \u2603 -= d2;
        }
        if (d3 < 0.0) {
            \u2603 -= d3;
        } else if (d3 > 0.0) {
            \u2603 -= d3;
        }
        return new AxisAlignedBB(\u2603, \u2603, \u2603, \u2603, \u2603, \u2603);
    }

    public AxisAlignedBB func_216361_a(Vec3d vec3d) {
        return this.func_72321_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
    }

    public AxisAlignedBB func_72321_a(double d, double d2, double d3) {
        \u2603 = this.field_72340_a;
        \u2603 = this.field_72338_b;
        \u2603 = this.field_72339_c;
        \u2603 = this.field_72336_d;
        \u2603 = this.field_72337_e;
        \u2603 = this.field_72334_f;
        if (d < 0.0) {
            \u2603 += d;
        } else if (d > 0.0) {
            \u2603 += d;
        }
        if (d2 < 0.0) {
            \u2603 += d2;
        } else if (d2 > 0.0) {
            \u2603 += d2;
        }
        if (d3 < 0.0) {
            \u2603 += d3;
        } else if (d3 > 0.0) {
            \u2603 += d3;
        }
        return new AxisAlignedBB(\u2603, \u2603, \u2603, \u2603, \u2603, \u2603);
    }

    public AxisAlignedBB func_72314_b(double d, double d2, double d3) {
        \u2603 = this.field_72340_a - d;
        \u2603 = this.field_72338_b - d2;
        \u2603 = this.field_72339_c - d3;
        \u2603 = this.field_72336_d + d;
        \u2603 = this.field_72337_e + d2;
        \u2603 = this.field_72334_f + d3;
        return new AxisAlignedBB(\u2603, \u2603, \u2603, \u2603, \u2603, \u2603);
    }

    public AxisAlignedBB func_186662_g(double d) {
        return this.func_72314_b(d, d, d);
    }

    public AxisAlignedBB func_191500_a(AxisAlignedBB axisAlignedBB) {
        double d = Math.max(this.field_72340_a, axisAlignedBB.field_72340_a);
        \u2603 = Math.max(this.field_72338_b, axisAlignedBB.field_72338_b);
        \u2603 = Math.max(this.field_72339_c, axisAlignedBB.field_72339_c);
        \u2603 = Math.min(this.field_72336_d, axisAlignedBB.field_72336_d);
        \u2603 = Math.min(this.field_72337_e, axisAlignedBB.field_72337_e);
        \u2603 = Math.min(this.field_72334_f, axisAlignedBB.field_72334_f);
        return new AxisAlignedBB(d, \u2603, \u2603, \u2603, \u2603, \u2603);
    }

    public AxisAlignedBB func_111270_a(AxisAlignedBB axisAlignedBB) {
        double d = Math.min(this.field_72340_a, axisAlignedBB.field_72340_a);
        \u2603 = Math.min(this.field_72338_b, axisAlignedBB.field_72338_b);
        \u2603 = Math.min(this.field_72339_c, axisAlignedBB.field_72339_c);
        \u2603 = Math.max(this.field_72336_d, axisAlignedBB.field_72336_d);
        \u2603 = Math.max(this.field_72337_e, axisAlignedBB.field_72337_e);
        \u2603 = Math.max(this.field_72334_f, axisAlignedBB.field_72334_f);
        return new AxisAlignedBB(d, \u2603, \u2603, \u2603, \u2603, \u2603);
    }

    public AxisAlignedBB func_72317_d(double d, double d2, double d3) {
        return new AxisAlignedBB(this.field_72340_a + d, this.field_72338_b + d2, this.field_72339_c + d3, this.field_72336_d + d, this.field_72337_e + d2, this.field_72334_f + d3);
    }

    public AxisAlignedBB func_186670_a(BlockPos blockPos) {
        return new AxisAlignedBB(this.field_72340_a + (double)blockPos.func_177958_n(), this.field_72338_b + (double)blockPos.func_177956_o(), this.field_72339_c + (double)blockPos.func_177952_p(), this.field_72336_d + (double)blockPos.func_177958_n(), this.field_72337_e + (double)blockPos.func_177956_o(), this.field_72334_f + (double)blockPos.func_177952_p());
    }

    public AxisAlignedBB func_191194_a(Vec3d vec3d) {
        return this.func_72317_d(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
    }

    public boolean func_72326_a(AxisAlignedBB axisAlignedBB) {
        return this.func_186668_a(axisAlignedBB.field_72340_a, axisAlignedBB.field_72338_b, axisAlignedBB.field_72339_c, axisAlignedBB.field_72336_d, axisAlignedBB.field_72337_e, axisAlignedBB.field_72334_f);
    }

    public boolean func_186668_a(double d, double d2, double d3, double d4, double d5, double d6) {
        return this.field_72340_a < d4 && this.field_72336_d > d && this.field_72338_b < d5 && this.field_72337_e > d2 && this.field_72339_c < d6 && this.field_72334_f > d3;
    }

    public boolean func_72318_a(Vec3d vec3d) {
        return this.func_197744_e(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
    }

    public boolean func_197744_e(double d, double d2, double d3) {
        return d >= this.field_72340_a && d < this.field_72336_d && d2 >= this.field_72338_b && d2 < this.field_72337_e && d3 >= this.field_72339_c && d3 < this.field_72334_f;
    }

    public double func_72320_b() {
        double d = this.func_216364_b();
        \u2603 = this.func_216360_c();
        \u2603 = this.func_216362_d();
        return (d + \u2603 + \u2603) / 3.0;
    }

    public double func_216364_b() {
        return this.field_72336_d - this.field_72340_a;
    }

    public double func_216360_c() {
        return this.field_72337_e - this.field_72338_b;
    }

    public double func_216362_d() {
        return this.field_72334_f - this.field_72339_c;
    }

    public AxisAlignedBB func_186664_h(double d) {
        return this.func_186662_g(-d);
    }

    public Optional<Vec3d> func_216365_b(Vec3d vec3d, Vec3d vec3d2) {
        double[] dArray = new double[]{1.0};
        double \u26032 = vec3d2.field_72450_a - vec3d.field_72450_a;
        double \u26033 = vec3d2.field_72448_b - vec3d.field_72448_b;
        double \u26034 = vec3d2.field_72449_c - vec3d.field_72449_c;
        Direction \u26035 = AxisAlignedBB.func_197741_a(this, vec3d, dArray, null, \u26032, \u26033, \u26034);
        if (\u26035 == null) {
            return Optional.empty();
        }
        double \u26036 = dArray[0];
        return Optional.of(vec3d.func_72441_c(\u26036 * \u26032, \u26036 * \u26033, \u26036 * \u26034));
    }

    @Nullable
    public static BlockRayTraceResult func_197743_a(Iterable<AxisAlignedBB> iterable, Vec3d vec3d, Vec3d vec3d2, BlockPos blockPos) {
        double[] dArray = new double[]{1.0};
        Direction \u26032 = null;
        double \u26033 = vec3d2.field_72450_a - vec3d.field_72450_a;
        double \u26034 = vec3d2.field_72448_b - vec3d.field_72448_b;
        double \u26035 = vec3d2.field_72449_c - vec3d.field_72449_c;
        for (AxisAlignedBB axisAlignedBB : iterable) {
            \u26032 = AxisAlignedBB.func_197741_a(axisAlignedBB.func_186670_a(blockPos), vec3d, dArray, \u26032, \u26033, \u26034, \u26035);
        }
        if (\u26032 == null) {
            return null;
        }
        double \u26036 = dArray[0];
        return new BlockRayTraceResult(vec3d.func_72441_c(\u26036 * \u26033, \u26036 * \u26034, \u26036 * \u26035), \u26032, blockPos, false);
    }

    @Nullable
    private static Direction func_197741_a(AxisAlignedBB axisAlignedBB, Vec3d vec3d, double[] dArray, @Nullable Direction direction2, double d4, double d22, double d32) {
        double d32;
        double d22;
        double d4;
        Direction direction2;
        if (d4 > 1.0E-7) {
            direction2 = AxisAlignedBB.func_197740_a(dArray, direction2, d4, d22, d32, axisAlignedBB.field_72340_a, axisAlignedBB.field_72338_b, axisAlignedBB.field_72337_e, axisAlignedBB.field_72339_c, axisAlignedBB.field_72334_f, Direction.WEST, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
        } else if (d4 < -1.0E-7) {
            direction2 = AxisAlignedBB.func_197740_a(dArray, direction2, d4, d22, d32, axisAlignedBB.field_72336_d, axisAlignedBB.field_72338_b, axisAlignedBB.field_72337_e, axisAlignedBB.field_72339_c, axisAlignedBB.field_72334_f, Direction.EAST, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
        }
        if (d22 > 1.0E-7) {
            direction2 = AxisAlignedBB.func_197740_a(dArray, direction2, d22, d32, d4, axisAlignedBB.field_72338_b, axisAlignedBB.field_72339_c, axisAlignedBB.field_72334_f, axisAlignedBB.field_72340_a, axisAlignedBB.field_72336_d, Direction.DOWN, vec3d.field_72448_b, vec3d.field_72449_c, vec3d.field_72450_a);
        } else if (d22 < -1.0E-7) {
            direction2 = AxisAlignedBB.func_197740_a(dArray, direction2, d22, d32, d4, axisAlignedBB.field_72337_e, axisAlignedBB.field_72339_c, axisAlignedBB.field_72334_f, axisAlignedBB.field_72340_a, axisAlignedBB.field_72336_d, Direction.UP, vec3d.field_72448_b, vec3d.field_72449_c, vec3d.field_72450_a);
        }
        if (d32 > 1.0E-7) {
            direction2 = AxisAlignedBB.func_197740_a(dArray, direction2, d32, d4, d22, axisAlignedBB.field_72339_c, axisAlignedBB.field_72340_a, axisAlignedBB.field_72336_d, axisAlignedBB.field_72338_b, axisAlignedBB.field_72337_e, Direction.NORTH, vec3d.field_72449_c, vec3d.field_72450_a, vec3d.field_72448_b);
        } else if (d32 < -1.0E-7) {
            direction2 = AxisAlignedBB.func_197740_a(dArray, direction2, d32, d4, d22, axisAlignedBB.field_72334_f, axisAlignedBB.field_72340_a, axisAlignedBB.field_72336_d, axisAlignedBB.field_72338_b, axisAlignedBB.field_72337_e, Direction.SOUTH, vec3d.field_72449_c, vec3d.field_72450_a, vec3d.field_72448_b);
        }
        return direction2;
    }

    @Nullable
    private static Direction func_197740_a(double[] dArray, @Nullable Direction direction, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, Direction direction2, double d9, double d10, double d11) {
        \u2603 = (d4 - d9) / d;
        \u2603 = d10 + \u2603 * d2;
        \u2603 = d11 + \u2603 * d3;
        if (0.0 < \u2603 && \u2603 < dArray[0] && d5 - 1.0E-7 < \u2603 && \u2603 < d6 + 1.0E-7 && d7 - 1.0E-7 < \u2603 && \u2603 < d8 + 1.0E-7) {
            dArray[0] = \u2603;
            return direction2;
        }
        return direction;
    }

    public String toString() {
        return "box[" + this.field_72340_a + ", " + this.field_72338_b + ", " + this.field_72339_c + "] -> [" + this.field_72336_d + ", " + this.field_72337_e + ", " + this.field_72334_f + "]";
    }

    public Vec3d func_189972_c() {
        return new Vec3d(MathHelper.func_219803_d(0.5, this.field_72340_a, this.field_72336_d), MathHelper.func_219803_d(0.5, this.field_72338_b, this.field_72337_e), MathHelper.func_219803_d(0.5, this.field_72339_c, this.field_72334_f));
    }
}

