/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.block.pattern.BlockMaterialMatcher;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.profiler.IProfiler;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.NetworkTagManager;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.lighting.WorldLightManager;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.WorldInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public abstract class World
implements IWorld,
AutoCloseable {
    protected static final Logger field_195596_d = LogManager.getLogger();
    private static final Direction[] field_200007_a = Direction.values();
    public final List<TileEntity> field_147482_g = Lists.newArrayList();
    public final List<TileEntity> field_175730_i = Lists.newArrayList();
    protected final List<TileEntity> field_147484_a = Lists.newArrayList();
    protected final List<TileEntity> field_147483_b = Lists.newArrayList();
    private final Thread field_217407_c;
    private int field_73008_k;
    protected int field_73005_l = new Random().nextInt();
    protected final int field_73006_m = 1013904223;
    protected float field_73003_n;
    protected float field_73004_o;
    protected float field_73018_p;
    protected float field_73017_q;
    public final Random field_73012_v = new Random();
    public final Dimension field_73011_w;
    protected final AbstractChunkProvider field_73020_y;
    protected final WorldInfo field_72986_A;
    private final IProfiler field_72984_F;
    public final boolean field_72995_K;
    protected boolean field_147481_N;
    private final WorldBorder field_175728_M;
    private final BiomeManager field_226689_w_;

    protected World(WorldInfo worldInfo, DimensionType dimensionType, BiFunction<World, Dimension, AbstractChunkProvider> biFunction, IProfiler iProfiler, boolean bl) {
        this.field_72984_F = iProfiler;
        this.field_72986_A = worldInfo;
        this.field_73011_w = dimensionType.func_218270_a(this);
        this.field_73020_y = biFunction.apply(this, this.field_73011_w);
        this.field_72995_K = bl;
        this.field_175728_M = this.field_73011_w.func_177501_r();
        this.field_217407_c = Thread.currentThread();
        this.field_226689_w_ = new BiomeManager(this, bl ? worldInfo.func_76063_b() : WorldInfo.func_227498_c_(worldInfo.func_76063_b()), dimensionType.func_227176_e_());
    }

    @Override
    public boolean func_201670_d() {
        return this.field_72995_K;
    }

    @Nullable
    public MinecraftServer func_73046_m() {
        return null;
    }

    public BlockState func_184141_c(BlockPos blockPos) {
        \u2603 = new BlockPos(blockPos.func_177958_n(), this.func_181545_F(), blockPos.func_177952_p());
        while (!this.func_175623_d(\u2603.func_177984_a())) {
            \u2603 = \u2603.func_177984_a();
        }
        return this.func_180495_p(\u2603);
    }

    public static boolean func_175701_a(BlockPos blockPos) {
        return !World.func_189509_E(blockPos) && blockPos.func_177958_n() >= -30000000 && blockPos.func_177952_p() >= -30000000 && blockPos.func_177958_n() < 30000000 && blockPos.func_177952_p() < 30000000;
    }

    public static boolean func_189509_E(BlockPos blockPos) {
        return World.func_217405_b(blockPos.func_177956_o());
    }

    public static boolean func_217405_b(int n) {
        return n < 0 || n >= 256;
    }

    public Chunk func_175726_f(BlockPos blockPos) {
        return this.func_212866_a_(blockPos.func_177958_n() >> 4, blockPos.func_177952_p() >> 4);
    }

    @Override
    public Chunk func_212866_a_(int n, int n2) {
        return (Chunk)this.func_217348_a(n, n2, ChunkStatus.field_222617_m);
    }

    @Override
    public IChunk func_217353_a(int n, int n2, ChunkStatus chunkStatus, boolean bl) {
        IChunk iChunk = this.field_73020_y.func_212849_a_(n, n2, chunkStatus, bl);
        if (iChunk == null && bl) {
            throw new IllegalStateException("Should always be able to create a chunk!");
        }
        return iChunk;
    }

    @Override
    public boolean func_180501_a(BlockPos blockPos2, BlockState blockState, int n) {
        if (World.func_189509_E(blockPos2)) {
            return false;
        }
        if (!this.field_72995_K && this.field_72986_A.func_76067_t() == WorldType.field_180272_g) {
            return false;
        }
        Chunk chunk = this.func_175726_f(blockPos2);
        Block \u26032 = blockState.func_177230_c();
        BlockState \u26033 = chunk.func_177436_a(blockPos2, blockState, (n & 0x40) != 0);
        if (\u26033 != null) {
            BlockState blockState2 = this.func_180495_p(blockPos2);
            if (blockState2 != \u26033 && (blockState2.func_200016_a(this, blockPos2) != \u26033.func_200016_a(this, blockPos2) || blockState2.func_185906_d() != \u26033.func_185906_d() || blockState2.func_215691_g() || \u26033.func_215691_g())) {
                this.field_72984_F.func_76320_a("queueCheckLight");
                this.func_72863_F().func_212863_j_().func_215568_a(blockPos2);
                this.field_72984_F.func_76319_b();
            }
            if (blockState2 == blockState) {
                BlockPos blockPos2;
                if (\u26033 != blockState2) {
                    this.func_225319_b(blockPos2, \u26033, blockState2);
                }
                if ((n & 2) != 0 && (!this.field_72995_K || (n & 4) == 0) && (this.field_72995_K || chunk.func_217321_u() != null && chunk.func_217321_u().func_219065_a(ChunkHolder.LocationType.TICKING))) {
                    this.func_184138_a(blockPos2, \u26033, blockState, n);
                }
                if (!this.field_72995_K && (n & 1) != 0) {
                    this.func_195592_c(blockPos2, \u26033.func_177230_c());
                    if (blockState.func_185912_n()) {
                        this.func_175666_e(blockPos2, \u26032);
                    }
                }
                if ((n & 0x10) == 0) {
                    int n2 = n & 0xFFFFFFFE;
                    \u26033.func_196948_b(this, blockPos2, n2);
                    blockState.func_196946_a(this, blockPos2, n2);
                    blockState.func_196948_b(this, blockPos2, n2);
                }
                this.func_217393_a(blockPos2, \u26033, blockState2);
            }
            return true;
        }
        return false;
    }

    public void func_217393_a(BlockPos blockPos, BlockState blockState, BlockState blockState2) {
    }

    @Override
    public boolean func_217377_a(BlockPos blockPos, boolean bl) {
        IFluidState iFluidState = this.func_204610_c(blockPos);
        return this.func_180501_a(blockPos, iFluidState.func_206883_i(), 3 | (bl ? 64 : 0));
    }

    @Override
    public boolean func_225521_a_(BlockPos blockPos2, boolean bl, @Nullable Entity entity) {
        BlockPos blockPos2;
        BlockState blockState = this.func_180495_p(blockPos2);
        if (blockState.func_196958_f()) {
            return false;
        }
        IFluidState \u26032 = this.func_204610_c(blockPos2);
        this.func_217379_c(2001, blockPos2, Block.func_196246_j(blockState));
        if (bl) {
            TileEntity tileEntity = blockState.func_177230_c().func_149716_u() ? this.func_175625_s(blockPos2) : null;
            Block.func_220054_a(blockState, this, blockPos2, tileEntity, entity, ItemStack.field_190927_a);
        }
        return this.func_180501_a(blockPos2, \u26032.func_206883_i(), 3);
    }

    public boolean func_175656_a(BlockPos blockPos, BlockState blockState) {
        return this.func_180501_a(blockPos, blockState, 3);
    }

    public abstract void func_184138_a(BlockPos var1, BlockState var2, BlockState var3, int var4);

    @Override
    public void func_195592_c(BlockPos blockPos, Block block) {
        if (this.field_72986_A.func_76067_t() != WorldType.field_180272_g) {
            this.func_195593_d(blockPos, block);
        }
    }

    public void func_225319_b(BlockPos blockPos, BlockState blockState, BlockState blockState2) {
    }

    public void func_195593_d(BlockPos blockPos, Block block) {
        this.func_190524_a(blockPos.func_177976_e(), block, blockPos);
        this.func_190524_a(blockPos.func_177974_f(), block, blockPos);
        this.func_190524_a(blockPos.func_177977_b(), block, blockPos);
        this.func_190524_a(blockPos.func_177984_a(), block, blockPos);
        this.func_190524_a(blockPos.func_177978_c(), block, blockPos);
        this.func_190524_a(blockPos.func_177968_d(), block, blockPos);
    }

    public void func_175695_a(BlockPos blockPos, Block block, Direction direction) {
        if (direction != Direction.WEST) {
            this.func_190524_a(blockPos.func_177976_e(), block, blockPos);
        }
        if (direction != Direction.EAST) {
            this.func_190524_a(blockPos.func_177974_f(), block, blockPos);
        }
        if (direction != Direction.DOWN) {
            this.func_190524_a(blockPos.func_177977_b(), block, blockPos);
        }
        if (direction != Direction.UP) {
            this.func_190524_a(blockPos.func_177984_a(), block, blockPos);
        }
        if (direction != Direction.NORTH) {
            this.func_190524_a(blockPos.func_177978_c(), block, blockPos);
        }
        if (direction != Direction.SOUTH) {
            this.func_190524_a(blockPos.func_177968_d(), block, blockPos);
        }
    }

    public void func_190524_a(BlockPos blockPos, Block block, BlockPos blockPos2) {
        if (this.field_72995_K) {
            return;
        }
        BlockState blockState = this.func_180495_p(blockPos);
        try {
            blockState.func_215697_a(this, blockPos, block, blockPos2, false);
        }
        catch (Throwable \u26032) {
            CrashReport crashReport = CrashReport.func_85055_a(\u26032, "Exception while updating neighbours");
            CrashReportCategory \u26033 = crashReport.func_85058_a("Block being updated");
            \u26033.func_189529_a("Source block type", () -> {
                try {
                    return String.format("ID #%s (%s // %s)", Registry.field_212618_g.func_177774_c(block), block.func_149739_a(), block.getClass().getCanonicalName());
                }
                catch (Throwable throwable) {
                    return "ID #" + Registry.field_212618_g.func_177774_c(block);
                }
            });
            CrashReportCategory.func_175750_a(\u26033, blockPos, blockState);
            throw new ReportedException(crashReport);
        }
    }

    @Override
    public int func_201676_a(Heightmap.Type type, int n, int n2) {
        \u2603 = n < -30000000 || n2 < -30000000 || n >= 30000000 || n2 >= 30000000 ? this.func_181545_F() + 1 : (this.func_217354_b(n >> 4, n2 >> 4) ? this.func_212866_a_(n >> 4, n2 >> 4).func_201576_a(type, n & 0xF, n2 & 0xF) + 1 : 0);
        return \u2603;
    }

    @Override
    public WorldLightManager func_225524_e_() {
        return this.func_72863_F().func_212863_j_();
    }

    @Override
    public BlockState func_180495_p(BlockPos blockPos) {
        if (World.func_189509_E(blockPos)) {
            return Blocks.field_201940_ji.func_176223_P();
        }
        Chunk chunk = this.func_212866_a_(blockPos.func_177958_n() >> 4, blockPos.func_177952_p() >> 4);
        return chunk.func_180495_p(blockPos);
    }

    @Override
    public IFluidState func_204610_c(BlockPos blockPos) {
        if (World.func_189509_E(blockPos)) {
            return Fluids.field_204541_a.func_207188_f();
        }
        Chunk chunk = this.func_175726_f(blockPos);
        return chunk.func_204610_c(blockPos);
    }

    public boolean func_72935_r() {
        return this.field_73011_w.func_186058_p() == DimensionType.field_223227_a_ && this.field_73008_k < 4;
    }

    public boolean func_226690_K_() {
        return this.field_73011_w.func_186058_p() == DimensionType.field_223227_a_ && !this.func_72935_r();
    }

    @Override
    public void func_184133_a(@Nullable PlayerEntity playerEntity, BlockPos blockPos, SoundEvent soundEvent, SoundCategory soundCategory, float f, float f2) {
        this.func_184148_a(playerEntity, (double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.5, (double)blockPos.func_177952_p() + 0.5, soundEvent, soundCategory, f, f2);
    }

    public abstract void func_184148_a(@Nullable PlayerEntity var1, double var2, double var4, double var6, SoundEvent var8, SoundCategory var9, float var10, float var11);

    public abstract void func_217384_a(@Nullable PlayerEntity var1, Entity var2, SoundEvent var3, SoundCategory var4, float var5, float var6);

    public void func_184134_a(double d, double d2, double d3, SoundEvent soundEvent, SoundCategory soundCategory, float f, float f2, boolean bl) {
    }

    @Override
    public void func_195594_a(IParticleData iParticleData, double d, double d2, double d3, double d4, double d5, double d6) {
    }

    public void func_195589_b(IParticleData iParticleData, double d, double d2, double d3, double d4, double d5, double d6) {
    }

    public void func_217404_b(IParticleData iParticleData, boolean bl, double d, double d2, double d3, double d4, double d5, double d6) {
    }

    public float func_72929_e(float f) {
        \u2603 = this.func_72826_c(f);
        return \u2603 * ((float)Math.PI * 2);
    }

    public boolean func_175700_a(TileEntity tileEntity) {
        if (this.field_147481_N) {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = () -> Registry.field_212626_o.func_177774_c(tileEntity.func_200662_C());
            supplierArray[1] = tileEntity::func_174877_v;
            field_195596_d.error("Adding block entity while ticking: {} @ {}", supplierArray);
        }
        if ((\u2603 = this.field_147482_g.add(tileEntity)) && tileEntity instanceof ITickableTileEntity) {
            this.field_175730_i.add(tileEntity);
        }
        if (this.field_72995_K) {
            BlockPos blockPos = tileEntity.func_174877_v();
            BlockState \u26032 = this.func_180495_p(blockPos);
            this.func_184138_a(blockPos, \u26032, \u26032, 2);
        }
        return \u2603;
    }

    public void func_147448_a(Collection<TileEntity> collection) {
        if (this.field_147481_N) {
            this.field_147484_a.addAll(collection);
        } else {
            for (TileEntity tileEntity : collection) {
                this.func_175700_a(tileEntity);
            }
        }
    }

    public void func_217391_K() {
        IProfiler iProfiler = this.func_217381_Z();
        iProfiler.func_76320_a("blockEntities");
        if (!this.field_147483_b.isEmpty()) {
            this.field_175730_i.removeAll(this.field_147483_b);
            this.field_147482_g.removeAll(this.field_147483_b);
            this.field_147483_b.clear();
        }
        this.field_147481_N = true;
        Iterator<TileEntity> \u26032 = this.field_175730_i.iterator();
        while (\u26032.hasNext()) {
            TileEntity tileEntity = \u26032.next();
            if (!tileEntity.func_145837_r() && tileEntity.func_145830_o() && this.field_73020_y.func_222866_a((BlockPos)(object = tileEntity.func_174877_v())) && this.func_175723_af().func_177746_a((BlockPos)object)) {
                try {
                    iProfiler.func_194340_a(() -> String.valueOf(TileEntityType.func_200969_a(tileEntity.func_200662_C())));
                    if (tileEntity.func_200662_C().func_223045_a(this.func_180495_p((BlockPos)object).func_177230_c())) {
                        ((ITickableTileEntity)((Object)tileEntity)).func_73660_a();
                    } else {
                        tileEntity.func_222814_r();
                    }
                    iProfiler.func_76319_b();
                }
                catch (Throwable throwable) {
                    CrashReport crashReport = CrashReport.func_85055_a(throwable, "Ticking block entity");
                    CrashReportCategory \u26033 = crashReport.func_85058_a("Block entity being ticked");
                    tileEntity.func_145828_a(\u26033);
                    throw new ReportedException(crashReport);
                }
            }
            if (!tileEntity.func_145837_r()) continue;
            \u26032.remove();
            this.field_147482_g.remove(tileEntity);
            if (!this.func_175667_e(tileEntity.func_174877_v())) continue;
            this.func_175726_f(tileEntity.func_174877_v()).func_177425_e(tileEntity.func_174877_v());
        }
        this.field_147481_N = false;
        iProfiler.func_219895_b("pendingBlockEntities");
        if (!this.field_147484_a.isEmpty()) {
            for (int i = 0; i < this.field_147484_a.size(); ++i) {
                Object object = this.field_147484_a.get(i);
                if (((TileEntity)object).func_145837_r()) continue;
                if (!this.field_147482_g.contains(object)) {
                    this.func_175700_a((TileEntity)object);
                }
                if (!this.func_175667_e(((TileEntity)object).func_174877_v())) continue;
                Chunk \u26034 = this.func_175726_f(((TileEntity)object).func_174877_v());
                BlockState \u26035 = \u26034.func_180495_p(((TileEntity)object).func_174877_v());
                \u26034.func_177426_a(((TileEntity)object).func_174877_v(), (TileEntity)object);
                this.func_184138_a(((TileEntity)object).func_174877_v(), \u26035, \u26035, 3);
            }
            this.field_147484_a.clear();
        }
        iProfiler.func_76319_b();
    }

    public void func_217390_a(Consumer<Entity> consumer, Entity entity) {
        try {
            consumer.accept(entity);
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.func_85055_a(throwable, "Ticking entity");
            CrashReportCategory \u26032 = crashReport.func_85058_a("Entity being ticked");
            entity.func_85029_a(\u26032);
            throw new ReportedException(crashReport);
        }
    }

    public boolean func_72829_c(AxisAlignedBB axisAlignedBB) {
        int n = MathHelper.func_76128_c(axisAlignedBB.field_72340_a);
        \u2603 = MathHelper.func_76143_f(axisAlignedBB.field_72336_d);
        \u2603 = MathHelper.func_76128_c(axisAlignedBB.field_72338_b);
        \u2603 = MathHelper.func_76143_f(axisAlignedBB.field_72337_e);
        \u2603 = MathHelper.func_76128_c(axisAlignedBB.field_72339_c);
        \u2603 = MathHelper.func_76143_f(axisAlignedBB.field_72334_f);
        try (BlockPos.PooledMutable \u26032 = BlockPos.PooledMutable.func_185346_s();){
            for (\u2603 = n; \u2603 < \u2603; ++\u2603) {
                for (\u2603 = \u2603; \u2603 < \u2603; ++\u2603) {
                    for (\u2603 = \u2603; \u2603 < \u2603; ++\u2603) {
                        BlockState blockState = this.func_180495_p(\u26032.func_181079_c(\u2603, \u2603, \u2603));
                        if (blockState.func_196958_f()) continue;
                        boolean bl = true;
                        return bl;
                    }
                }
            }
        }
        return false;
    }

    public boolean func_147470_e(AxisAlignedBB axisAlignedBB) {
        int n = MathHelper.func_76128_c(axisAlignedBB.field_72340_a);
        \u2603 = MathHelper.func_76143_f(axisAlignedBB.field_72336_d);
        \u2603 = MathHelper.func_76128_c(axisAlignedBB.field_72338_b);
        \u2603 = MathHelper.func_76143_f(axisAlignedBB.field_72337_e);
        \u2603 = MathHelper.func_76128_c(axisAlignedBB.field_72339_c);
        if (this.func_217344_a(n, \u2603, \u2603, \u2603, \u2603, \u2603 = MathHelper.func_76143_f(axisAlignedBB.field_72334_f))) {
            try (BlockPos.PooledMutable pooledMutable = BlockPos.PooledMutable.func_185346_s();){
                for (int i = n; i < \u2603; ++i) {
                    for (\u2603 = \u2603; \u2603 < \u2603; ++\u2603) {
                        for (\u2603 = \u2603; \u2603 < \u2603; ++\u2603) {
                            Block block = this.func_180495_p(pooledMutable.func_181079_c(i, \u2603, \u2603)).func_177230_c();
                            if (block != Blocks.field_150480_ab && block != Blocks.field_150353_l) continue;
                            boolean bl = true;
                            return bl;
                        }
                    }
                }
            }
        }
        return false;
    }

    public boolean func_72875_a(AxisAlignedBB axisAlignedBB, Material material) {
        int n = MathHelper.func_76128_c(axisAlignedBB.field_72340_a);
        \u2603 = MathHelper.func_76143_f(axisAlignedBB.field_72336_d);
        \u2603 = MathHelper.func_76128_c(axisAlignedBB.field_72338_b);
        \u2603 = MathHelper.func_76143_f(axisAlignedBB.field_72337_e);
        \u2603 = MathHelper.func_76128_c(axisAlignedBB.field_72339_c);
        \u2603 = MathHelper.func_76143_f(axisAlignedBB.field_72334_f);
        BlockMaterialMatcher \u26032 = BlockMaterialMatcher.func_189886_a(material);
        return BlockPos.func_218287_a(n, \u2603, \u2603, \u2603 - 1, \u2603 - 1, \u2603 - 1).anyMatch(blockPos -> \u26032.test(this.func_180495_p((BlockPos)blockPos)));
    }

    public Explosion func_217385_a(@Nullable Entity entity, double d, double d2, double d3, float f, Explosion.Mode mode) {
        return this.func_217401_a(entity, null, d, d2, d3, f, false, mode);
    }

    public Explosion func_217398_a(@Nullable Entity entity, double d, double d2, double d3, float f, boolean bl, Explosion.Mode mode) {
        return this.func_217401_a(entity, null, d, d2, d3, f, bl, mode);
    }

    public Explosion func_217401_a(@Nullable Entity entity, @Nullable DamageSource damageSource, double d, double d2, double d3, float f, boolean bl, Explosion.Mode mode) {
        Explosion explosion = new Explosion(this, entity, d, d2, d3, f, bl, mode);
        if (damageSource != null) {
            explosion.func_199592_a(damageSource);
        }
        explosion.func_77278_a();
        explosion.func_77279_a(true);
        return explosion;
    }

    public boolean func_175719_a(@Nullable PlayerEntity playerEntity, BlockPos blockPos, Direction direction) {
        if (this.func_180495_p(blockPos = blockPos.func_177972_a(direction)).func_177230_c() == Blocks.field_150480_ab) {
            this.func_217378_a(playerEntity, 1009, blockPos, 0);
            this.func_217377_a(blockPos, false);
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public TileEntity func_175625_s(BlockPos blockPos) {
        if (World.func_189509_E(blockPos)) {
            return null;
        }
        if (!this.field_72995_K && Thread.currentThread() != this.field_217407_c) {
            return null;
        }
        TileEntity tileEntity = null;
        if (this.field_147481_N) {
            tileEntity = this.func_189508_F(blockPos);
        }
        if (tileEntity == null) {
            tileEntity = this.func_175726_f(blockPos).func_177424_a(blockPos, Chunk.CreateEntityType.IMMEDIATE);
        }
        if (tileEntity == null) {
            tileEntity = this.func_189508_F(blockPos);
        }
        return tileEntity;
    }

    @Nullable
    private TileEntity func_189508_F(BlockPos blockPos) {
        for (int i = 0; i < this.field_147484_a.size(); ++i) {
            TileEntity tileEntity = this.field_147484_a.get(i);
            if (tileEntity.func_145837_r() || !tileEntity.func_174877_v().equals(blockPos)) continue;
            return tileEntity;
        }
        return null;
    }

    public void func_175690_a(BlockPos blockPos2, @Nullable TileEntity tileEntity2) {
        if (World.func_189509_E(blockPos2)) {
            return;
        }
        if (tileEntity2 != null && !tileEntity2.func_145837_r()) {
            if (this.field_147481_N) {
                TileEntity tileEntity2;
                tileEntity2.func_226984_a_(this, blockPos2);
                Iterator<TileEntity> iterator = this.field_147484_a.iterator();
                while (iterator.hasNext()) {
                    TileEntity tileEntity3 = iterator.next();
                    if (!tileEntity3.func_174877_v().equals(blockPos2)) continue;
                    tileEntity3.func_145843_s();
                    iterator.remove();
                }
                this.field_147484_a.add(tileEntity2);
            } else {
                BlockPos blockPos2;
                this.func_175726_f(blockPos2).func_177426_a(blockPos2, tileEntity2);
                this.func_175700_a(tileEntity2);
            }
        }
    }

    public void func_175713_t(BlockPos blockPos) {
        TileEntity tileEntity = this.func_175625_s(blockPos);
        if (tileEntity != null && this.field_147481_N) {
            tileEntity.func_145843_s();
            this.field_147484_a.remove(tileEntity);
        } else {
            if (tileEntity != null) {
                this.field_147484_a.remove(tileEntity);
                this.field_147482_g.remove(tileEntity);
                this.field_175730_i.remove(tileEntity);
            }
            this.func_175726_f(blockPos).func_177425_e(blockPos);
        }
    }

    public boolean func_195588_v(BlockPos blockPos) {
        if (World.func_189509_E(blockPos)) {
            return false;
        }
        return this.field_73020_y.func_73149_a(blockPos.func_177958_n() >> 4, blockPos.func_177952_p() >> 4);
    }

    public boolean func_217400_a(BlockPos blockPos, Entity entity) {
        if (World.func_189509_E(blockPos)) {
            return false;
        }
        IChunk iChunk = this.func_217353_a(blockPos.func_177958_n() >> 4, blockPos.func_177952_p() >> 4, ChunkStatus.field_222617_m, false);
        if (iChunk == null) {
            return false;
        }
        return iChunk.func_180495_p(blockPos).func_215682_a(this, blockPos, entity);
    }

    public void func_72966_v() {
        double d = 1.0 - (double)(this.func_72867_j(1.0f) * 5.0f) / 16.0;
        \u2603 = 1.0 - (double)(this.func_72819_i(1.0f) * 5.0f) / 16.0;
        \u2603 = 0.5 + 2.0 * MathHelper.func_151237_a(MathHelper.func_76134_b(this.func_72826_c(1.0f) * ((float)Math.PI * 2)), -0.25, 0.25);
        this.field_73008_k = (int)((1.0 - \u2603 * d * \u2603) * 11.0);
    }

    public void func_72891_a(boolean bl, boolean bl2) {
        this.func_72863_F().func_217203_a(bl, bl2);
    }

    protected void func_72947_a() {
        if (this.field_72986_A.func_76059_o()) {
            this.field_73004_o = 1.0f;
            if (this.field_72986_A.func_76061_m()) {
                this.field_73017_q = 1.0f;
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.field_73020_y.close();
    }

    @Override
    @Nullable
    public IBlockReader func_225522_c_(int n, int n2) {
        return this.func_217353_a(n, n2, ChunkStatus.field_222617_m, false);
    }

    @Override
    public List<Entity> func_175674_a(@Nullable Entity entity, AxisAlignedBB axisAlignedBB, @Nullable Predicate<? super Entity> predicate) {
        ArrayList arrayList = Lists.newArrayList();
        int \u26032 = MathHelper.func_76128_c((axisAlignedBB.field_72340_a - 2.0) / 16.0);
        int \u26033 = MathHelper.func_76128_c((axisAlignedBB.field_72336_d + 2.0) / 16.0);
        int \u26034 = MathHelper.func_76128_c((axisAlignedBB.field_72339_c - 2.0) / 16.0);
        int \u26035 = MathHelper.func_76128_c((axisAlignedBB.field_72334_f + 2.0) / 16.0);
        for (int i = \u26032; i <= \u26033; ++i) {
            for (\u2603 = \u26034; \u2603 <= \u26035; ++\u2603) {
                Chunk chunk = this.func_72863_F().func_217205_a(i, \u2603, false);
                if (chunk == null) continue;
                chunk.func_177414_a(entity, axisAlignedBB, arrayList, predicate);
            }
        }
        return arrayList;
    }

    public <T extends Entity> List<T> func_217394_a(@Nullable EntityType<T> entityType, AxisAlignedBB axisAlignedBB, Predicate<? super T> predicate) {
        int n = MathHelper.func_76128_c((axisAlignedBB.field_72340_a - 2.0) / 16.0);
        \u2603 = MathHelper.func_76143_f((axisAlignedBB.field_72336_d + 2.0) / 16.0);
        \u2603 = MathHelper.func_76128_c((axisAlignedBB.field_72339_c - 2.0) / 16.0);
        \u2603 = MathHelper.func_76143_f((axisAlignedBB.field_72334_f + 2.0) / 16.0);
        ArrayList \u26032 = Lists.newArrayList();
        for (\u2603 = n; \u2603 < \u2603; ++\u2603) {
            for (\u2603 = \u2603; \u2603 < \u2603; ++\u2603) {
                Chunk chunk = this.func_72863_F().func_217205_a(\u2603, \u2603, false);
                if (chunk == null) continue;
                chunk.func_217313_a(entityType, axisAlignedBB, \u26032, predicate);
            }
        }
        return \u26032;
    }

    @Override
    public <T extends Entity> List<T> func_175647_a(Class<? extends T> clazz, AxisAlignedBB axisAlignedBB, @Nullable Predicate<? super T> predicate) {
        int n = MathHelper.func_76128_c((axisAlignedBB.field_72340_a - 2.0) / 16.0);
        \u2603 = MathHelper.func_76143_f((axisAlignedBB.field_72336_d + 2.0) / 16.0);
        \u2603 = MathHelper.func_76128_c((axisAlignedBB.field_72339_c - 2.0) / 16.0);
        \u2603 = MathHelper.func_76143_f((axisAlignedBB.field_72334_f + 2.0) / 16.0);
        ArrayList \u26032 = Lists.newArrayList();
        AbstractChunkProvider \u26033 = this.func_72863_F();
        for (\u2603 = n; \u2603 < \u2603; ++\u2603) {
            for (\u2603 = \u2603; \u2603 < \u2603; ++\u2603) {
                Chunk chunk = \u26033.func_217205_a(\u2603, \u2603, false);
                if (chunk == null) continue;
                chunk.func_177430_a(clazz, axisAlignedBB, \u26032, predicate);
            }
        }
        return \u26032;
    }

    @Override
    public <T extends Entity> List<T> func_225316_b(Class<? extends T> clazz, AxisAlignedBB axisAlignedBB, @Nullable Predicate<? super T> predicate) {
        int n = MathHelper.func_76128_c((axisAlignedBB.field_72340_a - 2.0) / 16.0);
        \u2603 = MathHelper.func_76143_f((axisAlignedBB.field_72336_d + 2.0) / 16.0);
        \u2603 = MathHelper.func_76128_c((axisAlignedBB.field_72339_c - 2.0) / 16.0);
        \u2603 = MathHelper.func_76143_f((axisAlignedBB.field_72334_f + 2.0) / 16.0);
        ArrayList \u26032 = Lists.newArrayList();
        AbstractChunkProvider \u26033 = this.func_72863_F();
        for (\u2603 = n; \u2603 < \u2603; ++\u2603) {
            for (\u2603 = \u2603; \u2603 < \u2603; ++\u2603) {
                Chunk chunk = \u26033.func_225313_a(\u2603, \u2603);
                if (chunk == null) continue;
                chunk.func_177430_a(clazz, axisAlignedBB, \u26032, predicate);
            }
        }
        return \u26032;
    }

    @Nullable
    public abstract Entity func_73045_a(int var1);

    public void func_175646_b(BlockPos blockPos, TileEntity tileEntity) {
        if (this.func_175667_e(blockPos)) {
            this.func_175726_f(blockPos).func_76630_e();
        }
    }

    @Override
    public int func_181545_F() {
        return 63;
    }

    @Override
    public World func_201672_e() {
        return this;
    }

    public WorldType func_175624_G() {
        return this.field_72986_A.func_76067_t();
    }

    public int func_175676_y(BlockPos blockPos) {
        int n = 0;
        if ((n = Math.max(n, this.func_175627_a(blockPos.func_177977_b(), Direction.DOWN))) >= 15) {
            return n;
        }
        if ((n = Math.max(n, this.func_175627_a(blockPos.func_177984_a(), Direction.UP))) >= 15) {
            return n;
        }
        if ((n = Math.max(n, this.func_175627_a(blockPos.func_177978_c(), Direction.NORTH))) >= 15) {
            return n;
        }
        if ((n = Math.max(n, this.func_175627_a(blockPos.func_177968_d(), Direction.SOUTH))) >= 15) {
            return n;
        }
        if ((n = Math.max(n, this.func_175627_a(blockPos.func_177976_e(), Direction.WEST))) >= 15) {
            return n;
        }
        if ((n = Math.max(n, this.func_175627_a(blockPos.func_177974_f(), Direction.EAST))) >= 15) {
            return n;
        }
        return n;
    }

    public boolean func_175709_b(BlockPos blockPos, Direction direction) {
        return this.func_175651_c(blockPos, direction) > 0;
    }

    public int func_175651_c(BlockPos blockPos, Direction direction) {
        BlockState blockState = this.func_180495_p(blockPos);
        if (blockState.func_215686_e(this, blockPos)) {
            return this.func_175676_y(blockPos);
        }
        return blockState.func_185911_a(this, blockPos, direction);
    }

    public boolean func_175640_z(BlockPos blockPos) {
        if (this.func_175651_c(blockPos.func_177977_b(), Direction.DOWN) > 0) {
            return true;
        }
        if (this.func_175651_c(blockPos.func_177984_a(), Direction.UP) > 0) {
            return true;
        }
        if (this.func_175651_c(blockPos.func_177978_c(), Direction.NORTH) > 0) {
            return true;
        }
        if (this.func_175651_c(blockPos.func_177968_d(), Direction.SOUTH) > 0) {
            return true;
        }
        if (this.func_175651_c(blockPos.func_177976_e(), Direction.WEST) > 0) {
            return true;
        }
        return this.func_175651_c(blockPos.func_177974_f(), Direction.EAST) > 0;
    }

    public int func_175687_A(BlockPos blockPos) {
        int n = 0;
        for (Direction direction : field_200007_a) {
            int n2 = this.func_175651_c(blockPos.func_177972_a(direction), direction);
            if (n2 >= 15) {
                return 15;
            }
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public void func_82738_a(long l) {
        this.field_72986_A.func_82572_b(l);
    }

    @Override
    public long func_72905_C() {
        return this.field_72986_A.func_76063_b();
    }

    public long func_82737_E() {
        return this.field_72986_A.func_82573_f();
    }

    public long func_72820_D() {
        return this.field_72986_A.func_76073_f();
    }

    public void func_72877_b(long l) {
        this.field_72986_A.func_76068_b(l);
    }

    protected void func_217389_a() {
        this.func_82738_a(this.field_72986_A.func_82573_f() + 1L);
        if (this.field_72986_A.func_82574_x().func_223586_b(GameRules.field_223607_j)) {
            this.func_72877_b(this.field_72986_A.func_76073_f() + 1L);
        }
    }

    public BlockPos func_175694_M() {
        BlockPos blockPos = new BlockPos(this.field_72986_A.func_76079_c(), this.field_72986_A.func_76075_d(), this.field_72986_A.func_76074_e());
        if (!this.func_175723_af().func_177746_a(blockPos)) {
            blockPos = this.func_205770_a(Heightmap.Type.MOTION_BLOCKING, new BlockPos(this.func_175723_af().func_177731_f(), 0.0, this.func_175723_af().func_177721_g()));
        }
        return blockPos;
    }

    public void func_175652_B(BlockPos blockPos) {
        this.field_72986_A.func_176143_a(blockPos);
    }

    public boolean func_175660_a(PlayerEntity playerEntity, BlockPos blockPos) {
        return true;
    }

    public void func_72960_a(Entity entity, byte by) {
    }

    @Override
    public AbstractChunkProvider func_72863_F() {
        return this.field_73020_y;
    }

    public void func_175641_c(BlockPos blockPos, Block block, int n, int n2) {
        this.func_180495_p(blockPos).func_189547_a(this, blockPos, n, n2);
    }

    @Override
    public WorldInfo func_72912_H() {
        return this.field_72986_A;
    }

    public GameRules func_82736_K() {
        return this.field_72986_A.func_82574_x();
    }

    public float func_72819_i(float f) {
        return MathHelper.func_219799_g(f, this.field_73018_p, this.field_73017_q) * this.func_72867_j(f);
    }

    public float func_72867_j(float f) {
        return MathHelper.func_219799_g(f, this.field_73003_n, this.field_73004_o);
    }

    public boolean func_72911_I() {
        if (!this.field_73011_w.func_191066_m() || this.field_73011_w.func_177495_o()) {
            return false;
        }
        return (double)this.func_72819_i(1.0f) > 0.9;
    }

    public boolean func_72896_J() {
        return (double)this.func_72867_j(1.0f) > 0.2;
    }

    public boolean func_175727_C(BlockPos blockPos) {
        if (!this.func_72896_J()) {
            return false;
        }
        if (!this.func_226660_f_(blockPos)) {
            return false;
        }
        if (this.func_205770_a(Heightmap.Type.MOTION_BLOCKING, blockPos).func_177956_o() > blockPos.func_177956_o()) {
            return false;
        }
        return this.func_226691_t_(blockPos).func_201851_b() == Biome.RainType.RAIN;
    }

    public boolean func_180502_D(BlockPos blockPos) {
        Biome biome = this.func_226691_t_(blockPos);
        return biome.func_76736_e();
    }

    @Nullable
    public abstract MapData func_217406_a(String var1);

    public abstract void func_217399_a(MapData var1);

    public abstract int func_217395_y();

    public void func_175669_a(int n, BlockPos blockPos, int n2) {
    }

    public int func_72940_L() {
        return this.field_73011_w.func_177495_o() ? 128 : 256;
    }

    public CrashReportCategory func_72914_a(CrashReport crashReport) {
        CrashReportCategory crashReportCategory = crashReport.func_85057_a("Affected level", 1);
        crashReportCategory.func_189529_a("All players", () -> this.func_217369_A().size() + " total; " + this.func_217369_A());
        crashReportCategory.func_189529_a("Chunk stats", this.field_73020_y::func_73148_d);
        crashReportCategory.func_189529_a("Level dimension", () -> this.field_73011_w.func_186058_p().toString());
        try {
            this.field_72986_A.func_85118_a(crashReportCategory);
        }
        catch (Throwable \u26032) {
            crashReportCategory.func_71499_a("Level Data Unobtainable", \u26032);
        }
        return crashReportCategory;
    }

    public abstract void func_175715_c(int var1, BlockPos var2, int var3);

    public abstract Scoreboard func_96441_U();

    public void func_175666_e(BlockPos blockPos, Block block) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos blockPos2 = blockPos.func_177972_a(direction);
            if (!this.func_175667_e(blockPos2)) continue;
            BlockState \u26032 = this.func_180495_p(blockPos2);
            if (\u26032.func_177230_c() == Blocks.field_196762_fd) {
                \u26032.func_215697_a(this, blockPos2, block, blockPos, false);
                continue;
            }
            if (!\u26032.func_215686_e(this, blockPos2) || (\u26032 = this.func_180495_p(blockPos2 = blockPos2.func_177972_a(direction))).func_177230_c() != Blocks.field_196762_fd) continue;
            \u26032.func_215697_a(this, blockPos2, block, blockPos, false);
        }
    }

    @Override
    public DifficultyInstance func_175649_E(BlockPos blockPos) {
        long l = 0L;
        float \u26032 = 0.0f;
        if (this.func_175667_e(blockPos)) {
            \u26032 = this.func_130001_d();
            l = this.func_175726_f(blockPos).func_177416_w();
        }
        return new DifficultyInstance(this.func_175659_aa(), this.func_72820_D(), l, \u26032);
    }

    @Override
    public int func_175657_ab() {
        return this.field_73008_k;
    }

    public void func_225605_c_(int n) {
    }

    @Override
    public WorldBorder func_175723_af() {
        return this.field_175728_M;
    }

    public void func_184135_a(IPacket<?> iPacket) {
        throw new UnsupportedOperationException("Can't send packets to server unless you're on the client.");
    }

    @Override
    public Dimension func_201675_m() {
        return this.field_73011_w;
    }

    @Override
    public Random func_201674_k() {
        return this.field_73012_v;
    }

    @Override
    public boolean func_217375_a(BlockPos blockPos, Predicate<BlockState> predicate) {
        return predicate.test(this.func_180495_p(blockPos));
    }

    public abstract RecipeManager func_199532_z();

    public abstract NetworkTagManager func_205772_D();

    public BlockPos func_217383_a(int n, int n2, int n3, int n4) {
        this.field_73005_l = this.field_73005_l * 3 + 1013904223;
        \u2603 = this.field_73005_l >> 2;
        return new BlockPos(n + (\u2603 & 0xF), n2 + (\u2603 >> 16 & n4), n3 + (\u2603 >> 8 & 0xF));
    }

    public boolean func_217402_u() {
        return false;
    }

    public IProfiler func_217381_Z() {
        return this.field_72984_F;
    }

    @Override
    public BiomeManager func_225523_d_() {
        return this.field_226689_w_;
    }

    @Override
    public /* synthetic */ IChunk func_212866_a_(int n, int n2) {
        return this.func_212866_a_(n, n2);
    }
}

