/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.Dynamic;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.BitSetVoxelShapePart;
import net.minecraft.util.math.shapes.VoxelShapePart;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.treedecorator.TreeDecorator;

public abstract class AbstractTreeFeature<T extends BaseTreeFeatureConfig>
extends Feature<T> {
    public AbstractTreeFeature(Function<Dynamic<?>, ? extends T> function) {
        super(function);
    }

    protected static boolean func_214587_a(IWorldGenerationBaseReader iWorldGenerationBaseReader, BlockPos blockPos) {
        return iWorldGenerationBaseReader.func_217375_a(blockPos, blockState -> {
            Block block = blockState.func_177230_c();
            return blockState.func_196958_f() || blockState.func_203425_a(BlockTags.field_206952_E) || AbstractTreeFeature.func_227250_b_(block) || block.func_203417_a(BlockTags.field_200031_h) || block.func_203417_a(BlockTags.field_200030_g) || block == Blocks.field_150395_bd;
        });
    }

    public static boolean func_214574_b(IWorldGenerationBaseReader iWorldGenerationBaseReader, BlockPos blockPos) {
        return iWorldGenerationBaseReader.func_217375_a(blockPos, BlockState::func_196958_f);
    }

    protected static boolean func_214578_c(IWorldGenerationBaseReader iWorldGenerationBaseReader, BlockPos blockPos) {
        return iWorldGenerationBaseReader.func_217375_a(blockPos, blockState -> {
            Block block = blockState.func_177230_c();
            return AbstractTreeFeature.func_227250_b_(block) && block != Blocks.field_196658_i && block != Blocks.field_150391_bh;
        });
    }

    protected static boolean func_227222_d_(IWorldGenerationBaseReader iWorldGenerationBaseReader, BlockPos blockPos) {
        return iWorldGenerationBaseReader.func_217375_a(blockPos, blockState -> blockState.func_177230_c() == Blocks.field_150395_bd);
    }

    public static boolean func_214571_e(IWorldGenerationBaseReader iWorldGenerationBaseReader, BlockPos blockPos) {
        return iWorldGenerationBaseReader.func_217375_a(blockPos, blockState -> blockState.func_177230_c() == Blocks.field_150355_j);
    }

    public static boolean func_214572_g(IWorldGenerationBaseReader iWorldGenerationBaseReader, BlockPos blockPos) {
        return iWorldGenerationBaseReader.func_217375_a(blockPos, blockState -> blockState.func_196958_f() || blockState.func_203425_a(BlockTags.field_206952_E));
    }

    public static boolean func_214589_h(IWorldGenerationBaseReader iWorldGenerationBaseReader, BlockPos blockPos) {
        return iWorldGenerationBaseReader.func_217375_a(blockPos, blockState -> AbstractTreeFeature.func_227250_b_(blockState.func_177230_c()));
    }

    protected static boolean func_214585_i(IWorldGenerationBaseReader iWorldGenerationBaseReader, BlockPos blockPos) {
        return iWorldGenerationBaseReader.func_217375_a(blockPos, blockState -> {
            Block block = blockState.func_177230_c();
            return AbstractTreeFeature.func_227250_b_(block) || block == Blocks.field_150458_ak;
        });
    }

    public static boolean func_214576_j(IWorldGenerationBaseReader iWorldGenerationBaseReader, BlockPos blockPos) {
        return iWorldGenerationBaseReader.func_217375_a(blockPos, blockState -> {
            Material material = blockState.func_185904_a();
            return material == Material.field_151582_l;
        });
    }

    protected void func_214584_a(IWorldGenerationReader iWorldGenerationReader, BlockPos blockPos) {
        if (!AbstractTreeFeature.func_214578_c(iWorldGenerationReader, blockPos)) {
            this.func_202278_a(iWorldGenerationReader, blockPos, Blocks.field_150346_d.func_176223_P());
        }
    }

    protected boolean func_227216_a_(IWorldGenerationReader iWorldGenerationReader, Random random, BlockPos blockPos, Set<BlockPos> set, MutableBoundingBox mutableBoundingBox, BaseTreeFeatureConfig baseTreeFeatureConfig) {
        if (AbstractTreeFeature.func_214572_g(iWorldGenerationReader, blockPos) || AbstractTreeFeature.func_214576_j(iWorldGenerationReader, blockPos) || AbstractTreeFeature.func_214571_e(iWorldGenerationReader, blockPos)) {
            this.func_227217_a_(iWorldGenerationReader, blockPos, baseTreeFeatureConfig.field_227368_m_.func_225574_a_(random, blockPos), mutableBoundingBox);
            set.add(blockPos.func_185334_h());
            return true;
        }
        return false;
    }

    protected boolean func_227219_b_(IWorldGenerationReader iWorldGenerationReader, Random random, BlockPos blockPos, Set<BlockPos> set, MutableBoundingBox mutableBoundingBox, BaseTreeFeatureConfig baseTreeFeatureConfig) {
        if (AbstractTreeFeature.func_214572_g(iWorldGenerationReader, blockPos) || AbstractTreeFeature.func_214576_j(iWorldGenerationReader, blockPos) || AbstractTreeFeature.func_214571_e(iWorldGenerationReader, blockPos)) {
            this.func_227217_a_(iWorldGenerationReader, blockPos, baseTreeFeatureConfig.field_227369_n_.func_225574_a_(random, blockPos), mutableBoundingBox);
            set.add(blockPos.func_185334_h());
            return true;
        }
        return false;
    }

    @Override
    protected void func_202278_a(IWorldWriter iWorldWriter, BlockPos blockPos, BlockState blockState) {
        this.func_208521_b(iWorldWriter, blockPos, blockState);
    }

    protected final void func_227217_a_(IWorldWriter iWorldWriter, BlockPos blockPos, BlockState blockState, MutableBoundingBox mutableBoundingBox) {
        this.func_208521_b(iWorldWriter, blockPos, blockState);
        mutableBoundingBox.func_78888_b(new MutableBoundingBox(blockPos, blockPos));
    }

    private void func_208521_b(IWorldWriter iWorldWriter, BlockPos blockPos, BlockState blockState) {
        iWorldWriter.func_180501_a(blockPos, blockState, 19);
    }

    @Override
    public final boolean func_212245_a(IWorld iWorld, ChunkGenerator<? extends GenerationSettings> chunkGenerator, Random random, BlockPos blockPos, T t) {
        HashSet hashSet = Sets.newHashSet();
        \u2603 = Sets.newHashSet();
        \u2603 = Sets.newHashSet();
        MutableBoundingBox \u26032 = MutableBoundingBox.func_78887_a();
        boolean \u26033 = this.func_225557_a_(iWorld, random, blockPos, hashSet, \u2603, \u26032, t);
        if (\u26032.field_78897_a > \u26032.field_78893_d || !\u26033 || hashSet.isEmpty()) {
            return false;
        }
        if (!((BaseTreeFeatureConfig)t).field_227370_o_.isEmpty()) {
            Object object = Lists.newArrayList((Iterable)hashSet);
            ArrayList \u26034 = Lists.newArrayList((Iterable)\u2603);
            object.sort(Comparator.comparingInt(Vec3i::func_177956_o));
            \u26034.sort(Comparator.comparingInt(Vec3i::func_177956_o));
            ((BaseTreeFeatureConfig)t).field_227370_o_.forEach(arg_0 -> AbstractTreeFeature.func_227215_a_(iWorld, random, (List)object, \u26034, \u2603, \u26032, arg_0));
        }
        object = this.func_227214_a_(iWorld, \u26032, hashSet, \u2603);
        Template.func_222857_a(iWorld, 3, (VoxelShapePart)object, \u26032.field_78897_a, \u26032.field_78895_b, \u26032.field_78896_c);
        return true;
    }

    private VoxelShapePart func_227214_a_(IWorld iWorld, MutableBoundingBox mutableBoundingBox, Set<BlockPos> set3, Set<BlockPos> set2) {
        ArrayList arrayList = Lists.newArrayList();
        BitSetVoxelShapePart \u26032 = new BitSetVoxelShapePart(mutableBoundingBox.func_78883_b(), mutableBoundingBox.func_78882_c(), mutableBoundingBox.func_78880_d());
        int \u26033 = 6;
        for (int i = 0; i < 6; ++i) {
            arrayList.add(Sets.newHashSet());
        }
        try (BlockPos.PooledMutable pooledMutable = BlockPos.PooledMutable.func_185346_s();){
            Set<BlockPos> set3;
            for (Object \u26034 : Lists.newArrayList(set2)) {
                if (!mutableBoundingBox.func_175898_b((Vec3i)\u26034)) continue;
                ((VoxelShapePart)\u26032).func_199625_a(((Vec3i)\u26034).func_177958_n() - mutableBoundingBox.field_78897_a, ((Vec3i)\u26034).func_177956_o() - mutableBoundingBox.field_78895_b, ((Vec3i)\u26034).func_177952_p() - mutableBoundingBox.field_78896_c, true, true);
            }
            for (Object \u26034 : Lists.newArrayList(set3)) {
                if (mutableBoundingBox.func_175898_b((Vec3i)\u26034)) {
                    ((VoxelShapePart)\u26032).func_199625_a(((Vec3i)\u26034).func_177958_n() - mutableBoundingBox.field_78897_a, ((Vec3i)\u26034).func_177956_o() - mutableBoundingBox.field_78895_b, ((Vec3i)\u26034).func_177952_p() - mutableBoundingBox.field_78896_c, true, true);
                }
                for (Direction direction : Direction.values()) {
                    pooledMutable.func_189533_g((Vec3i)\u26034).func_189536_c(direction);
                    if (set3.contains(pooledMutable) || !(\u2603 = iWorld.func_180495_p(pooledMutable)).func_196959_b(BlockStateProperties.field_208514_aa)) continue;
                    ((Set)arrayList.get(0)).add(pooledMutable.func_185334_h());
                    this.func_208521_b(iWorld, pooledMutable, (BlockState)\u2603.func_206870_a(BlockStateProperties.field_208514_aa, 1));
                    if (!mutableBoundingBox.func_175898_b(pooledMutable)) continue;
                    ((VoxelShapePart)\u26032).func_199625_a(pooledMutable.func_177958_n() - mutableBoundingBox.field_78897_a, pooledMutable.func_177956_o() - mutableBoundingBox.field_78895_b, pooledMutable.func_177952_p() - mutableBoundingBox.field_78896_c, true, true);
                }
            }
            for (int i = 1; i < 6; ++i) {
                Object \u26034;
                \u26034 = (Set)arrayList.get(i - 1);
                Set set4 = (Set)arrayList.get(i);
                Iterator iterator = \u26034.iterator();
                while (iterator.hasNext()) {
                    BlockPos blockPos = (BlockPos)iterator.next();
                    if (mutableBoundingBox.func_175898_b(blockPos)) {
                        ((VoxelShapePart)\u26032).func_199625_a(blockPos.func_177958_n() - mutableBoundingBox.field_78897_a, blockPos.func_177956_o() - mutableBoundingBox.field_78895_b, blockPos.func_177952_p() - mutableBoundingBox.field_78896_c, true, true);
                    }
                    for (Direction direction : Direction.values()) {
                        pooledMutable.func_189533_g(blockPos).func_189536_c(direction);
                        if (\u26034.contains(pooledMutable) || set4.contains(pooledMutable) || !(\u2603 = iWorld.func_180495_p(pooledMutable)).func_196959_b(BlockStateProperties.field_208514_aa) || (\u2603 = \u2603.func_177229_b(BlockStateProperties.field_208514_aa).intValue()) <= i + 1) continue;
                        BlockState blockState = (BlockState)\u2603.func_206870_a(BlockStateProperties.field_208514_aa, i + 1);
                        this.func_208521_b(iWorld, pooledMutable, blockState);
                        if (mutableBoundingBox.func_175898_b(pooledMutable)) {
                            ((VoxelShapePart)\u26032).func_199625_a(pooledMutable.func_177958_n() - mutableBoundingBox.field_78897_a, pooledMutable.func_177956_o() - mutableBoundingBox.field_78895_b, pooledMutable.func_177952_p() - mutableBoundingBox.field_78896_c, true, true);
                        }
                        set4.add(pooledMutable.func_185334_h());
                    }
                }
            }
        }
        return \u26032;
    }

    protected abstract boolean func_225557_a_(IWorldGenerationReader var1, Random var2, BlockPos var3, Set<BlockPos> var4, Set<BlockPos> var5, MutableBoundingBox var6, T var7);

    private static /* synthetic */ void func_227215_a_(IWorld iWorld, Random random, List list, List list2, Set set, MutableBoundingBox mutableBoundingBox, TreeDecorator treeDecorator) {
        treeDecorator.func_225576_a_(iWorld, random, list, list2, set, mutableBoundingBox);
    }
}

