/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.EnumMap;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.TransformationMatrix;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverride;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.model.TransformationHelper;

public class PerspectiveMapWrapper
implements IDynamicBakedModel {
    private final IBakedModel parent;
    private final ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix> transforms;
    private final OverrideListWrapper overrides = new OverrideListWrapper();

    public PerspectiveMapWrapper(IBakedModel parent, ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix> transforms) {
        this.parent = parent;
        this.transforms = transforms;
    }

    public PerspectiveMapWrapper(IBakedModel parent, IModelTransform state) {
        this(parent, PerspectiveMapWrapper.getTransforms(state));
    }

    public static ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix> getTransforms(IModelTransform state) {
        EnumMap<ItemCameraTransforms.TransformType, TransformationMatrix> map = new EnumMap<ItemCameraTransforms.TransformType, TransformationMatrix>(ItemCameraTransforms.TransformType.class);
        for (ItemCameraTransforms.TransformType type : ItemCameraTransforms.TransformType.values()) {
            TransformationMatrix tr = state.getPartTransformation((Object)type);
            if (tr.isIdentity()) continue;
            map.put(type, tr);
        }
        return ImmutableMap.copyOf(map);
    }

    public static ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix> getTransforms(ItemCameraTransforms transforms) {
        EnumMap<ItemCameraTransforms.TransformType, TransformationMatrix> map = new EnumMap<ItemCameraTransforms.TransformType, TransformationMatrix>(ItemCameraTransforms.TransformType.class);
        for (ItemCameraTransforms.TransformType type : ItemCameraTransforms.TransformType.values()) {
            if (!transforms.func_181687_c(type)) continue;
            map.put(type, TransformationHelper.toTransformation(transforms.func_181688_b(type)));
        }
        return ImmutableMap.copyOf(map);
    }

    public static ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix> getTransformsWithFallback(IModelTransform state, ItemCameraTransforms transforms) {
        EnumMap<ItemCameraTransforms.TransformType, TransformationMatrix> map = new EnumMap<ItemCameraTransforms.TransformType, TransformationMatrix>(ItemCameraTransforms.TransformType.class);
        for (ItemCameraTransforms.TransformType type : ItemCameraTransforms.TransformType.values()) {
            TransformationMatrix tr = state.getPartTransformation((Object)type);
            if (!tr.isIdentity()) {
                map.put(type, tr);
                continue;
            }
            if (!transforms.func_181687_c(type)) continue;
            map.put(type, TransformationHelper.toTransformation(transforms.func_181688_b(type)));
        }
        return ImmutableMap.copyOf(map);
    }

    public static IBakedModel handlePerspective(IBakedModel model, ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix> transforms, ItemCameraTransforms.TransformType cameraTransformType, MatrixStack mat) {
        TransformationMatrix tr = (TransformationMatrix)transforms.getOrDefault((Object)cameraTransformType, (Object)TransformationMatrix.func_227983_a_());
        if (!tr.isIdentity()) {
            tr.push(mat);
        }
        return model;
    }

    public static IBakedModel handlePerspective(IBakedModel model, IModelTransform state, ItemCameraTransforms.TransformType cameraTransformType, MatrixStack mat) {
        TransformationMatrix tr = state.getPartTransformation((Object)cameraTransformType);
        if (!tr.isIdentity()) {
            tr.push(mat);
        }
        return model;
    }

    public boolean func_177555_b() {
        return this.parent.func_177555_b();
    }

    public boolean isAmbientOcclusion(BlockState state) {
        return this.parent.isAmbientOcclusion(state);
    }

    public boolean func_177556_c() {
        return this.parent.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.parent.func_188618_c();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.parent.func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return this.parent.func_177552_f();
    }

    @Override
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData extraData) {
        return this.parent.getQuads(state, side, rand, extraData);
    }

    public ItemOverrideList func_188617_f() {
        return this.overrides;
    }

    public boolean doesHandlePerspectives() {
        return true;
    }

    public IBakedModel handlePerspective(ItemCameraTransforms.TransformType cameraTransformType, MatrixStack mat) {
        return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.transforms, cameraTransformType, mat);
    }

    private class OverrideListWrapper
    extends ItemOverrideList {
        @Nullable
        public IBakedModel func_209581_a(IBakedModel model, ItemStack stack, @Nullable World worldIn, @Nullable LivingEntity entityIn) {
            model = PerspectiveMapWrapper.this.parent.func_188617_f().func_209581_a(PerspectiveMapWrapper.this.parent, stack, worldIn, entityIn);
            return new PerspectiveMapWrapper(model, (ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix>)PerspectiveMapWrapper.this.transforms);
        }

        public ImmutableList<ItemOverride> getOverrides() {
            return PerspectiveMapWrapper.this.parent.func_188617_f().getOverrides();
        }
    }
}

