/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common;

import com.google.common.base.Preconditions;
import cpw.mods.modlauncher.api.INameMappingService;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fml.loading.FMLLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class ObfuscationReflectionHelper {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker REFLECTION = MarkerManager.getMarker((String)"REFLECTION");

    @Nonnull
    public static String remapName(INameMappingService.Domain domain, String name) {
        return FMLLoader.getNameFunction((String)"srg").map(f -> (String)f.apply(domain, name)).orElse(name);
    }

    @Nullable
    public static <T, E> T getPrivateValue(Class<? super E> classToAccess, E instance, String fieldName) {
        try {
            return (T)ObfuscationReflectionHelper.findField(classToAccess, fieldName).get(instance);
        }
        catch (UnableToFindFieldException e) {
            LOGGER.error(REFLECTION, "Unable to locate field {} ({}) on type {}", (Object)fieldName, (Object)ObfuscationReflectionHelper.remapName(INameMappingService.Domain.FIELD, fieldName), (Object)classToAccess.getName(), (Object)e);
            throw e;
        }
        catch (IllegalAccessException e) {
            LOGGER.error(REFLECTION, "Unable to access field {} ({}) on type {}", (Object)fieldName, (Object)ObfuscationReflectionHelper.remapName(INameMappingService.Domain.FIELD, fieldName), (Object)classToAccess.getName(), (Object)e);
            throw new UnableToAccessFieldException(e);
        }
    }

    public static <T, E> void setPrivateValue(@Nonnull Class<? super T> classToAccess, @Nonnull T instance, @Nullable E value, @Nonnull String fieldName) {
        try {
            ObfuscationReflectionHelper.findField(classToAccess, fieldName).set(instance, value);
        }
        catch (UnableToFindFieldException e) {
            LOGGER.error("Unable to locate any field {} on type {}", (Object)fieldName, (Object)classToAccess.getName(), (Object)e);
            throw e;
        }
        catch (IllegalAccessException e) {
            LOGGER.error("Unable to set any field {} on type {}", (Object)fieldName, (Object)classToAccess.getName(), (Object)e);
            throw new UnableToAccessFieldException(e);
        }
    }

    @Nonnull
    public static Method findMethod(@Nonnull Class<?> clazz, @Nonnull String methodName, Class<?> ... parameterTypes) {
        Preconditions.checkNotNull(clazz, (Object)"Class to find method on cannot be null.");
        Preconditions.checkNotNull((Object)methodName, (Object)"Name of method to find cannot be null.");
        Preconditions.checkArgument((!methodName.isEmpty() ? 1 : 0) != 0, (Object)"Name of method to find cannot be empty.");
        Preconditions.checkNotNull(parameterTypes, (Object)"Parameter types of method to find cannot be null.");
        try {
            Method m = clazz.getDeclaredMethod(ObfuscationReflectionHelper.remapName(INameMappingService.Domain.METHOD, methodName), parameterTypes);
            m.setAccessible(true);
            return m;
        }
        catch (Exception e) {
            throw new UnableToFindMethodException(e);
        }
    }

    @Nonnull
    public static <T> Constructor<T> findConstructor(@Nonnull Class<T> clazz, Class<?> ... parameterTypes) {
        Preconditions.checkNotNull(clazz, (Object)"Class to find constructor on cannot be null.");
        Preconditions.checkNotNull(parameterTypes, (Object)"Parameter types of constructor to find cannot be null.");
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(parameterTypes);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (NoSuchMethodException e) {
            StringBuilder desc = new StringBuilder();
            desc.append(clazz.getSimpleName());
            StringJoiner joiner = new StringJoiner(", ", "(", ")");
            for (Class<?> type : parameterTypes) {
                joiner.add(type.getSimpleName());
            }
            desc.append(joiner);
            throw new UnknownConstructorException("Could not find constructor '" + desc.toString() + "' in " + clazz);
        }
    }

    @Nonnull
    public static <T> Field findField(@Nonnull Class<? super T> clazz, @Nonnull String fieldName) {
        Preconditions.checkNotNull(clazz, (Object)"Class to find field on cannot be null.");
        Preconditions.checkNotNull((Object)fieldName, (Object)"Name of field to find cannot be null.");
        Preconditions.checkArgument((!fieldName.isEmpty() ? 1 : 0) != 0, (Object)"Name of field to find cannot be empty.");
        try {
            Field f = clazz.getDeclaredField(ObfuscationReflectionHelper.remapName(INameMappingService.Domain.FIELD, fieldName));
            f.setAccessible(true);
            return f;
        }
        catch (Exception e) {
            throw new UnableToFindFieldException(e);
        }
    }

    public static class UnknownConstructorException
    extends RuntimeException {
        public UnknownConstructorException(String message) {
            super(message);
        }
    }

    public static class UnableToFindMethodException
    extends RuntimeException {
        public UnableToFindMethodException(Throwable failed) {
            super(failed);
        }
    }

    public static class UnableToFindFieldException
    extends RuntimeException {
        private UnableToFindFieldException(Exception e) {
            super(e);
        }
    }

    public static class UnableToAccessFieldException
    extends RuntimeException {
        private UnableToAccessFieldException(Exception e) {
            super(e);
        }
    }
}

