/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.RailState;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.RailShape;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public abstract class AbstractRailBlock
extends Block {
    protected static final VoxelShape field_185590_a = Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 2.0, 16.0);
    protected static final VoxelShape field_190959_b = Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 8.0, 16.0);
    private final boolean field_196277_c;

    public static boolean func_208488_a(World worldIn, BlockPos pos) {
        return AbstractRailBlock.func_208487_j(worldIn.func_180495_p(pos));
    }

    public static boolean func_208487_j(BlockState state) {
        return state.func_203425_a(BlockTags.field_203437_y);
    }

    protected AbstractRailBlock(boolean p_i48444_1_, Block.Properties p_i48444_2_) {
        super(p_i48444_2_);
        this.field_196277_c = p_i48444_1_;
    }

    public boolean func_208490_b() {
        return this.field_196277_c;
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        RailShape railshape = state.func_177230_c() == this ? this.getRailDirection(state, worldIn, pos, null) : null;
        return railshape != null && railshape.func_208092_c() ? field_190959_b : field_185590_a;
    }

    @Override
    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return AbstractRailBlock.func_220064_c((IBlockReader)((Object)worldIn), pos.func_177977_b());
    }

    @Override
    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (oldState.func_177230_c() != state.func_177230_c()) {
            state = this.func_208489_a(worldIn, pos, state, true);
            if (this.field_196277_c) {
                state.func_215697_a(worldIn, pos, this, pos, isMoving);
            }
        }
    }

    @Override
    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!worldIn.field_72995_K) {
            RailShape railshape = this.getRailDirection(state, (IBlockReader)((Object)worldIn), pos, null);
            boolean flag = false;
            BlockPos blockpos = pos.func_177977_b();
            if (!AbstractRailBlock.func_220064_c((IBlockReader)((Object)worldIn), blockpos)) {
                flag = true;
            }
            BlockPos blockpos1 = pos.func_177974_f();
            if (railshape == RailShape.ASCENDING_EAST && !AbstractRailBlock.func_220064_c((IBlockReader)((Object)worldIn), blockpos1)) {
                flag = true;
            } else {
                BlockPos blockpos2 = pos.func_177976_e();
                if (railshape == RailShape.ASCENDING_WEST && !AbstractRailBlock.func_220064_c((IBlockReader)((Object)worldIn), blockpos2)) {
                    flag = true;
                } else {
                    BlockPos blockpos3 = pos.func_177978_c();
                    if (railshape == RailShape.ASCENDING_NORTH && !AbstractRailBlock.func_220064_c((IBlockReader)((Object)worldIn), blockpos3)) {
                        flag = true;
                    } else {
                        BlockPos blockpos4 = pos.func_177968_d();
                        if (railshape == RailShape.ASCENDING_SOUTH && !AbstractRailBlock.func_220064_c((IBlockReader)((Object)worldIn), blockpos4)) {
                            flag = true;
                        }
                    }
                }
            }
            if (flag && !worldIn.func_175623_d(pos)) {
                if (!isMoving) {
                    AbstractRailBlock.func_220075_c(state, worldIn, pos);
                }
                worldIn.func_217377_a(pos, isMoving);
            } else {
                this.func_189541_b(state, worldIn, pos, blockIn);
            }
        }
    }

    protected void func_189541_b(BlockState state, World worldIn, BlockPos pos, Block blockIn) {
    }

    protected BlockState func_208489_a(World worldIn, BlockPos pos, BlockState state, boolean placing) {
        if (worldIn.field_72995_K) {
            return state;
        }
        RailShape railshape = (RailShape)state.func_177229_b(this.func_176560_l());
        return new RailState(worldIn, pos, state).func_226941_a_(worldIn.func_175640_z(pos), placing, railshape).func_196916_c();
    }

    @Override
    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.NORMAL;
    }

    @Override
    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!isMoving) {
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
            if (this.getRailDirection(state, (IBlockReader)((Object)worldIn), pos, null).func_208092_c()) {
                worldIn.func_195593_d(pos.func_177984_a(), this);
            }
            if (this.field_196277_c) {
                worldIn.func_195593_d(pos, this);
                worldIn.func_195593_d(pos.func_177977_b(), this);
            }
        }
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState blockstate = super.func_176223_P();
        Direction direction = context.func_195992_f();
        boolean flag = direction == Direction.EAST || direction == Direction.WEST;
        return (BlockState)((Object)blockstate.func_206870_a(this.func_176560_l(), (Comparable)(flag ? RailShape.EAST_WEST : RailShape.NORTH_SOUTH)));
    }

    public abstract IProperty<RailShape> func_176560_l();

    public boolean isFlexibleRail(BlockState state, IBlockReader world, BlockPos pos) {
        return !this.field_196277_c;
    }

    public boolean canMakeSlopes(BlockState state, IBlockReader world, BlockPos pos) {
        return true;
    }

    public RailShape getRailDirection(BlockState state, IBlockReader world, BlockPos pos, @Nullable AbstractMinecartEntity cart) {
        return (RailShape)state.func_177229_b(this.func_176560_l());
    }

    public float getRailMaxSpeed(BlockState state, World world, BlockPos pos, AbstractMinecartEntity cart) {
        return 0.4f;
    }

    public void onMinecartPass(BlockState state, World world, BlockPos pos, AbstractMinecartEntity cart) {
    }
}

