/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Floats;
import com.mojang.blaze3d.vertex.DefaultColorVertexBuilder;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mojang.blaze3d.vertex.IVertexConsumer;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.IntArrays;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.BitSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class BufferBuilder
extends DefaultColorVertexBuilder
implements IVertexConsumer {
    private static final Logger field_187316_a = LogManager.getLogger();
    private ByteBuffer field_179001_a;
    private final List<DrawState> field_227821_i_ = Lists.newArrayList();
    private int field_227822_j_ = 0;
    private int field_227823_k_ = 0;
    private int field_227824_l_ = 0;
    private int field_227825_m_ = 0;
    private int field_178997_d;
    @Nullable
    private VertexFormatElement field_181677_f;
    private int field_181678_g;
    private int field_179006_k;
    private VertexFormat field_179011_q;
    private boolean field_227826_s_;
    private boolean field_227827_t_;
    private boolean field_179010_r;

    public BufferBuilder(int bufferSizeIn) {
        this.field_179001_a = GLAllocation.func_74524_c((int)(bufferSizeIn * 4));
    }

    protected void func_227831_b_() {
        this.func_181670_b(this.field_179011_q.func_177338_f());
    }

    private void func_181670_b(int increaseAmount) {
        if (this.field_227824_l_ + increaseAmount > this.field_179001_a.capacity()) {
            int i = this.field_179001_a.capacity();
            int j = i + BufferBuilder.func_216566_c(increaseAmount);
            field_187316_a.debug("Needed to grow BufferBuilder buffer: Old size {} bytes, new size {} bytes.", (Object)i, (Object)j);
            ByteBuffer bytebuffer = GLAllocation.func_74524_c((int)j);
            ((Buffer)this.field_179001_a).position(0);
            bytebuffer.put(this.field_179001_a);
            ((Buffer)bytebuffer).rewind();
            this.field_179001_a = bytebuffer;
        }
    }

    private static int func_216566_c(int xIn) {
        int j;
        int i = 0x200000;
        if (xIn == 0) {
            return i;
        }
        if (xIn < 0) {
            i *= -1;
        }
        return (j = xIn % i) == 0 ? xIn : xIn + i - j;
    }

    public void func_181674_a(float cameraX, float cameraY, float cameraZ) {
        ((Buffer)this.field_179001_a).clear();
        FloatBuffer floatbuffer = this.field_179001_a.asFloatBuffer();
        int i = this.field_178997_d / 4;
        float[] afloat = new float[i];
        for (int j = 0; j < i; ++j) {
            afloat[j] = BufferBuilder.func_181665_a(floatbuffer, cameraX, cameraY, cameraZ, this.field_179011_q.func_181719_f(), this.field_227823_k_ / 4 + j * this.field_179011_q.func_177338_f());
        }
        int[] aint = new int[i];
        int k = 0;
        while (k < aint.length) {
            aint[k] = k++;
        }
        IntArrays.mergeSort((int[])aint, (p_227830_1_, p_227830_2_) -> Floats.compare((float)afloat[p_227830_2_], (float)afloat[p_227830_1_]));
        BitSet bitset = new BitSet();
        FloatBuffer floatbuffer1 = GLAllocation.func_74529_h((int)(this.field_179011_q.func_181719_f() * 4));
        int l = bitset.nextClearBit(0);
        while (l < aint.length) {
            int i1 = aint[l];
            if (i1 != l) {
                this.func_227829_a_(floatbuffer, i1);
                ((Buffer)floatbuffer1).clear();
                floatbuffer1.put(floatbuffer);
                int j1 = i1;
                int k1 = aint[i1];
                while (j1 != l) {
                    this.func_227829_a_(floatbuffer, k1);
                    FloatBuffer floatbuffer2 = floatbuffer.slice();
                    this.func_227829_a_(floatbuffer, j1);
                    floatbuffer.put(floatbuffer2);
                    bitset.set(j1);
                    j1 = k1;
                    k1 = aint[k1];
                }
                this.func_227829_a_(floatbuffer, l);
                ((Buffer)floatbuffer1).flip();
                floatbuffer.put(floatbuffer1);
            }
            bitset.set(l);
            l = bitset.nextClearBit(l + 1);
        }
    }

    private void func_227829_a_(FloatBuffer floatBufferIn, int indexIn) {
        int i = this.field_179011_q.func_181719_f() * 4;
        ((Buffer)floatBufferIn).limit(this.field_227823_k_ / 4 + (indexIn + 1) * i);
        ((Buffer)floatBufferIn).position(this.field_227823_k_ / 4 + indexIn * i);
    }

    public State func_181672_a() {
        ((Buffer)this.field_179001_a).limit(this.field_227824_l_);
        ((Buffer)this.field_179001_a).position(this.field_227823_k_);
        ByteBuffer bytebuffer = ByteBuffer.allocate(this.field_178997_d * this.field_179011_q.func_177338_f());
        bytebuffer.put(this.field_179001_a);
        ((Buffer)this.field_179001_a).clear();
        return new State(bytebuffer, this.field_179011_q);
    }

    private static float func_181665_a(FloatBuffer floatBufferIn, float x, float y, float z, int integerSize, int offset) {
        float f = floatBufferIn.get(offset + integerSize * 0 + 0);
        float f1 = floatBufferIn.get(offset + integerSize * 0 + 1);
        float f2 = floatBufferIn.get(offset + integerSize * 0 + 2);
        float f3 = floatBufferIn.get(offset + integerSize * 1 + 0);
        float f4 = floatBufferIn.get(offset + integerSize * 1 + 1);
        float f5 = floatBufferIn.get(offset + integerSize * 1 + 2);
        float f6 = floatBufferIn.get(offset + integerSize * 2 + 0);
        float f7 = floatBufferIn.get(offset + integerSize * 2 + 1);
        float f8 = floatBufferIn.get(offset + integerSize * 2 + 2);
        float f9 = floatBufferIn.get(offset + integerSize * 3 + 0);
        float f10 = floatBufferIn.get(offset + integerSize * 3 + 1);
        float f11 = floatBufferIn.get(offset + integerSize * 3 + 2);
        float f12 = (f + f3 + f6 + f9) * 0.25f - x;
        float f13 = (f1 + f4 + f7 + f10) * 0.25f - y;
        float f14 = (f2 + f5 + f8 + f11) * 0.25f - z;
        return f12 * f12 + f13 * f13 + f14 * f14;
    }

    public void func_178993_a(State state) {
        ((Buffer)state.field_227841_a_).clear();
        int i = state.field_227841_a_.capacity();
        this.func_181670_b(i);
        ((Buffer)this.field_179001_a).limit(this.field_179001_a.capacity());
        ((Buffer)this.field_179001_a).position(this.field_227823_k_);
        this.field_179001_a.put(state.field_227841_a_);
        ((Buffer)this.field_179001_a).clear();
        VertexFormat vertexformat = state.field_179018_e;
        this.func_227828_a_(vertexformat);
        this.field_178997_d = i / vertexformat.func_177338_f();
        this.field_227824_l_ = this.field_227823_k_ + this.field_178997_d * vertexformat.func_177338_f();
    }

    public void func_181668_a(int glMode, VertexFormat format) {
        if (this.field_179010_r) {
            throw new IllegalStateException("Already building!");
        }
        this.field_179010_r = true;
        this.field_179006_k = glMode;
        this.func_227828_a_(format);
        this.field_181677_f = (VertexFormatElement)format.func_227894_c_().get(0);
        this.field_181678_g = 0;
        ((Buffer)this.field_179001_a).clear();
    }

    private void func_227828_a_(VertexFormat vertexFormatIn) {
        if (this.field_179011_q != vertexFormatIn) {
            this.field_179011_q = vertexFormatIn;
            boolean flag = vertexFormatIn == DefaultVertexFormats.field_227849_i_;
            boolean flag1 = vertexFormatIn == DefaultVertexFormats.field_176600_a;
            this.field_227826_s_ = flag || flag1;
            this.field_227827_t_ = flag;
        }
    }

    public void func_178977_d() {
        if (!this.field_179010_r) {
            throw new IllegalStateException("Not building!");
        }
        this.field_179010_r = false;
        this.field_227821_i_.add(new DrawState(this.field_179011_q, this.field_178997_d, this.field_179006_k));
        this.field_227823_k_ += this.field_178997_d * this.field_179011_q.func_177338_f();
        this.field_178997_d = 0;
        this.field_181677_f = null;
        this.field_181678_g = 0;
    }

    public void func_225589_a_(int indexIn, byte byteIn) {
        this.field_179001_a.put(this.field_227824_l_ + indexIn, byteIn);
    }

    public void func_225591_a_(int indexIn, short shortIn) {
        this.field_179001_a.putShort(this.field_227824_l_ + indexIn, shortIn);
    }

    public void func_225590_a_(int indexIn, float floatIn) {
        this.field_179001_a.putFloat(this.field_227824_l_ + indexIn, floatIn);
    }

    public void func_181675_d() {
        if (this.field_181678_g != 0) {
            throw new IllegalStateException("Not filled all elements of the vertex");
        }
        ++this.field_178997_d;
        this.func_227831_b_();
    }

    public void func_181667_k() {
        VertexFormatElement vertexformatelement;
        ImmutableList<VertexFormatElement> immutablelist = this.field_179011_q.func_227894_c_();
        this.field_181678_g = (this.field_181678_g + 1) % immutablelist.size();
        this.field_227824_l_ += this.field_181677_f.func_177368_f();
        this.field_181677_f = vertexformatelement = (VertexFormatElement)immutablelist.get(this.field_181678_g);
        if (vertexformatelement.func_177375_c() == VertexFormatElement.Usage.PADDING) {
            this.func_181667_k();
        }
        if (this.field_227854_a_ && this.field_181677_f.func_177375_c() == VertexFormatElement.Usage.COLOR) {
            super.func_225586_a_(this.field_227855_b_, this.field_227856_c_, this.field_227857_d_, this.field_227858_e_);
        }
    }

    public IVertexBuilder func_225586_a_(int red, int green, int blue, int alpha) {
        if (this.field_227854_a_) {
            throw new IllegalStateException();
        }
        return super.func_225586_a_(red, green, blue, alpha);
    }

    public void func_225588_a_(float x, float y, float z, float red, float green, float blue, float alpha, float texU, float texV, int overlayUV, int lightmapUV, float normalX, float normalY, float normalZ) {
        if (this.field_227854_a_) {
            throw new IllegalStateException();
        }
        if (this.field_227826_s_) {
            int i;
            this.func_225590_a_(0, x);
            this.func_225590_a_(4, y);
            this.func_225590_a_(8, z);
            this.func_225589_a_(12, (byte)(red * 255.0f));
            this.func_225589_a_(13, (byte)(green * 255.0f));
            this.func_225589_a_(14, (byte)(blue * 255.0f));
            this.func_225589_a_(15, (byte)(alpha * 255.0f));
            this.func_225590_a_(16, texU);
            this.func_225590_a_(20, texV);
            if (this.field_227827_t_) {
                this.func_225591_a_(24, (short)(overlayUV & 0xFFFF));
                this.func_225591_a_(26, (short)(overlayUV >> 16 & 0xFFFF));
                i = 28;
            } else {
                i = 24;
            }
            this.func_225591_a_(i + 0, (short)(lightmapUV & 0xFFFF));
            this.func_225591_a_(i + 2, (short)(lightmapUV >> 16 & 0xFFFF));
            this.func_225589_a_(i + 4, IVertexConsumer.func_227846_a_((float)normalX));
            this.func_225589_a_(i + 5, IVertexConsumer.func_227846_a_((float)normalY));
            this.func_225589_a_(i + 6, IVertexConsumer.func_227846_a_((float)normalZ));
            this.field_227824_l_ += i + 8;
            this.func_181675_d();
        } else {
            super.func_225588_a_(x, y, z, red, green, blue, alpha, texU, texV, overlayUV, lightmapUV, normalX, normalY, normalZ);
        }
    }

    public Pair<DrawState, ByteBuffer> func_227832_f_() {
        DrawState bufferbuilder$drawstate = this.field_227821_i_.get(this.field_227822_j_++);
        ((Buffer)this.field_179001_a).position(this.field_227825_m_);
        this.field_227825_m_ += bufferbuilder$drawstate.func_227839_b_() * bufferbuilder$drawstate.func_227838_a_().func_177338_f();
        ((Buffer)this.field_179001_a).limit(this.field_227825_m_);
        if (this.field_227822_j_ == this.field_227821_i_.size() && this.field_178997_d == 0) {
            this.func_178965_a();
        }
        ByteBuffer bytebuffer = this.field_179001_a.slice();
        bytebuffer.order(this.field_179001_a.order());
        ((Buffer)this.field_179001_a).clear();
        return Pair.of((Object)bufferbuilder$drawstate, (Object)bytebuffer);
    }

    public void func_178965_a() {
        if (this.field_227823_k_ != this.field_227825_m_) {
            field_187316_a.warn("Bytes mismatch " + this.field_227823_k_ + " " + this.field_227825_m_);
        }
        this.func_227833_h_();
    }

    public void func_227833_h_() {
        this.field_227823_k_ = 0;
        this.field_227825_m_ = 0;
        this.field_227824_l_ = 0;
        this.field_227821_i_.clear();
        this.field_227822_j_ = 0;
    }

    public VertexFormatElement func_225592_i_() {
        if (this.field_181677_f == null) {
            throw new IllegalStateException("BufferBuilder not started");
        }
        return this.field_181677_f;
    }

    public boolean func_227834_j_() {
        return this.field_179010_r;
    }

    public void putBulkData(ByteBuffer buffer) {
        this.func_181670_b(buffer.limit() + this.field_179011_q.func_177338_f());
        ((Buffer)this.field_179001_a).position(this.field_178997_d * this.field_179011_q.func_177338_f());
        this.field_179001_a.put(buffer);
        this.field_178997_d += buffer.limit() / this.field_179011_q.func_177338_f();
        this.field_227824_l_ += buffer.limit();
    }

    public VertexFormat getVertexFormat() {
        return this.field_179011_q;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class State {
        private final ByteBuffer field_227841_a_;
        private final VertexFormat field_179018_e;

        private State(ByteBuffer byteBufferIn, VertexFormat vertexFormatIn) {
            this.field_227841_a_ = byteBufferIn;
            this.field_179018_e = vertexFormatIn;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class DrawState {
        private final VertexFormat field_227835_a_;
        private final int field_227836_b_;
        private final int field_227837_c_;

        private DrawState(VertexFormat formatIn, int vertexCountIn, int drawModeIn) {
            this.field_227835_a_ = formatIn;
            this.field_227836_b_ = vertexCountIn;
            this.field_227837_c_ = drawModeIn;
        }

        public VertexFormat func_227838_a_() {
            return this.field_227835_a_;
        }

        public int func_227839_b_() {
            return this.field_227836_b_;
        }

        public int func_227840_c_() {
            return this.field_227837_c_;
        }
    }
}

