/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class RenderState {
    protected final String field_228509_a_;
    private final Runnable field_228507_Q_;
    private final Runnable field_228508_R_;
    protected static final TransparencyState field_228510_b_ = new TransparencyState("no_transparency", () -> RenderSystem.disableBlend(), () -> {});
    protected static final TransparencyState field_228511_c_ = new TransparencyState("additive_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    protected static final TransparencyState field_228512_d_ = new TransparencyState("lightning_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    protected static final TransparencyState field_228513_e_ = new TransparencyState("glint_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    protected static final TransparencyState field_228514_f_ = new TransparencyState("crumbling_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    protected static final TransparencyState field_228515_g_ = new TransparencyState("translucent_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
    }, () -> RenderSystem.disableBlend());
    protected static final AlphaState field_228516_h_ = new AlphaState(0.0f);
    protected static final AlphaState field_228517_i_ = new AlphaState(0.003921569f);
    protected static final AlphaState field_228518_j_ = new AlphaState(0.5f);
    protected static final ShadeModelState field_228519_k_ = new ShadeModelState(false);
    protected static final ShadeModelState field_228520_l_ = new ShadeModelState(true);
    protected static final TextureState field_228521_m_ = new TextureState(AtlasTexture.field_110575_b, false, true);
    protected static final TextureState field_228522_n_ = new TextureState(AtlasTexture.field_110575_b, false, false);
    protected static final TextureState field_228523_o_ = new TextureState();
    protected static final TexturingState field_228524_p_ = new TexturingState("default_texturing", () -> {}, () -> {});
    protected static final TexturingState field_228525_q_ = new TexturingState("outline_texturing", () -> RenderSystem.setupOutline(), () -> RenderSystem.teardownOutline());
    protected static final TexturingState field_228526_r_ = new TexturingState("glint_texturing", () -> RenderState.func_228548_a_(8.0f), () -> {
        RenderSystem.matrixMode((int)5890);
        RenderSystem.popMatrix();
        RenderSystem.matrixMode((int)5888);
    });
    protected static final TexturingState field_228527_s_ = new TexturingState("entity_glint_texturing", () -> RenderState.func_228548_a_(0.16f), () -> {
        RenderSystem.matrixMode((int)5890);
        RenderSystem.popMatrix();
        RenderSystem.matrixMode((int)5888);
    });
    protected static final LightmapState field_228528_t_ = new LightmapState(true);
    protected static final LightmapState field_228529_u_ = new LightmapState(false);
    protected static final OverlayState field_228530_v_ = new OverlayState(true);
    protected static final OverlayState field_228531_w_ = new OverlayState(false);
    protected static final DiffuseLightingState field_228532_x_ = new DiffuseLightingState(true);
    protected static final DiffuseLightingState field_228533_y_ = new DiffuseLightingState(false);
    protected static final CullState field_228534_z_ = new CullState(true);
    protected static final CullState field_228491_A_ = new CullState(false);
    protected static final DepthTestState field_228492_B_ = new DepthTestState(519);
    protected static final DepthTestState field_228493_C_ = new DepthTestState(514);
    protected static final DepthTestState field_228494_D_ = new DepthTestState(515);
    protected static final WriteMaskState field_228495_E_ = new WriteMaskState(true, true);
    protected static final WriteMaskState field_228496_F_ = new WriteMaskState(true, false);
    protected static final WriteMaskState field_228497_G_ = new WriteMaskState(false, true);
    protected static final LayerState field_228498_H_ = new LayerState("no_layering", () -> {}, () -> {});
    protected static final LayerState field_228499_I_ = new LayerState("polygon_offset_layering", () -> {
        RenderSystem.polygonOffset((float)-1.0f, (float)-10.0f);
        RenderSystem.enablePolygonOffset();
    }, () -> {
        RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
        RenderSystem.disablePolygonOffset();
    });
    protected static final LayerState field_228500_J_ = new LayerState("projection_layering", () -> {
        RenderSystem.matrixMode((int)5889);
        RenderSystem.pushMatrix();
        RenderSystem.scalef((float)1.0f, (float)1.0f, (float)0.999f);
        RenderSystem.matrixMode((int)5888);
    }, () -> {
        RenderSystem.matrixMode((int)5889);
        RenderSystem.popMatrix();
        RenderSystem.matrixMode((int)5888);
    });
    protected static final FogState field_228501_K_ = new FogState("no_fog", () -> {}, () -> {});
    protected static final FogState field_228502_L_ = new FogState("fog", () -> {
        FogRenderer.func_228373_b_();
        RenderSystem.enableFog();
    }, () -> RenderSystem.disableFog());
    protected static final FogState field_228503_M_ = new FogState("black_fog", () -> {
        RenderSystem.fog((int)2918, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        RenderSystem.enableFog();
    }, () -> {
        FogRenderer.func_228373_b_();
        RenderSystem.disableFog();
    });
    protected static final TargetState field_228504_N_ = new TargetState("main_target", () -> {}, () -> {});
    protected static final TargetState field_228505_O_ = new TargetState("outline_target", () -> Minecraft.func_71410_x().field_71438_f.func_228448_p_().func_147610_a(false), () -> Minecraft.func_71410_x().func_147110_a().func_147610_a(false));
    protected static final LineState field_228506_P_ = new LineState(OptionalDouble.of(1.0));

    public RenderState(String nameIn, Runnable setupTaskIn, Runnable clearTaskIn) {
        this.field_228509_a_ = nameIn;
        this.field_228507_Q_ = setupTaskIn;
        this.field_228508_R_ = clearTaskIn;
    }

    public void func_228547_a_() {
        this.field_228507_Q_.run();
    }

    public void func_228549_b_() {
        this.field_228508_R_.run();
    }

    public boolean equals(@Nullable Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (p_equals_1_ != null && this.getClass() == p_equals_1_.getClass()) {
            RenderState renderstate = (RenderState)p_equals_1_;
            return this.field_228509_a_.equals(renderstate.field_228509_a_);
        }
        return false;
    }

    public int hashCode() {
        return this.field_228509_a_.hashCode();
    }

    private static void func_228548_a_(float scaleIn) {
        RenderSystem.matrixMode((int)5890);
        RenderSystem.pushMatrix();
        RenderSystem.loadIdentity();
        long i = Util.func_211177_b() * 8L;
        float f = (float)(i % 110000L) / 110000.0f;
        float f1 = (float)(i % 30000L) / 30000.0f;
        RenderSystem.translatef((float)(-f), (float)f1, (float)0.0f);
        RenderSystem.rotatef((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        RenderSystem.scalef((float)scaleIn, (float)scaleIn, (float)scaleIn);
        RenderSystem.matrixMode((int)5888);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class WriteMaskState
    extends RenderState {
        private final boolean field_228610_Q_;
        private final boolean field_228611_R_;

        public WriteMaskState(boolean p_i225991_1_, boolean p_i225991_2_) {
            super("write_mask_state", () -> {
                if (!p_i225991_2_) {
                    RenderSystem.depthMask((boolean)p_i225991_2_);
                }
                if (!p_i225991_1_) {
                    RenderSystem.colorMask((boolean)p_i225991_1_, (boolean)p_i225991_1_, (boolean)p_i225991_1_, (boolean)p_i225991_1_);
                }
            }, () -> {
                if (!p_i225991_2_) {
                    RenderSystem.depthMask((boolean)true);
                }
                if (!p_i225991_1_) {
                    RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                }
            });
            this.field_228610_Q_ = p_i225991_1_;
            this.field_228611_R_ = p_i225991_2_;
        }

        @Override
        public boolean equals(Object p_equals_1_) {
            if (this == p_equals_1_) {
                return true;
            }
            if (p_equals_1_ != null && this.getClass() == p_equals_1_.getClass()) {
                WriteMaskState renderstate$writemaskstate = (WriteMaskState)p_equals_1_;
                return this.field_228610_Q_ == renderstate$writemaskstate.field_228610_Q_ && this.field_228611_R_ == renderstate$writemaskstate.field_228611_R_;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.field_228610_Q_, this.field_228611_R_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class TransparencyState
    extends RenderState {
        public TransparencyState(String p_i225990_1_, Runnable p_i225990_2_, Runnable p_i225990_3_) {
            super(p_i225990_1_, p_i225990_2_, p_i225990_3_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class TexturingState
    extends RenderState {
        public TexturingState(String p_i225989_1_, Runnable p_i225989_2_, Runnable p_i225989_3_) {
            super(p_i225989_1_, p_i225989_2_, p_i225989_3_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class TextureState
    extends RenderState {
        private final Optional<ResourceLocation> field_228602_Q_;
        private final boolean field_228603_R_;
        private final boolean field_228604_S_;

        public TextureState(ResourceLocation p_i225988_1_, boolean p_i225988_2_, boolean p_i225988_3_) {
            super("texture", () -> {
                RenderSystem.enableTexture();
                TextureManager texturemanager = Minecraft.func_71410_x().func_110434_K();
                texturemanager.func_110577_a(p_i225988_1_);
                texturemanager.func_229267_b_(p_i225988_1_).func_174937_a(p_i225988_2_, p_i225988_3_);
            }, () -> {});
            this.field_228602_Q_ = Optional.of(p_i225988_1_);
            this.field_228603_R_ = p_i225988_2_;
            this.field_228604_S_ = p_i225988_3_;
        }

        public TextureState() {
            super("texture", () -> RenderSystem.disableTexture(), () -> RenderSystem.enableTexture());
            this.field_228602_Q_ = Optional.empty();
            this.field_228603_R_ = false;
            this.field_228604_S_ = false;
        }

        @Override
        public boolean equals(Object p_equals_1_) {
            if (this == p_equals_1_) {
                return true;
            }
            if (p_equals_1_ != null && this.getClass() == p_equals_1_.getClass()) {
                TextureState renderstate$texturestate = (TextureState)p_equals_1_;
                return this.field_228602_Q_.equals(renderstate$texturestate.field_228602_Q_) && this.field_228603_R_ == renderstate$texturestate.field_228603_R_ && this.field_228604_S_ == renderstate$texturestate.field_228604_S_;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.field_228602_Q_.hashCode();
        }

        protected Optional<ResourceLocation> func_228606_c_() {
            return this.field_228602_Q_;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class TargetState
    extends RenderState {
        public TargetState(String p_i225984_1_, Runnable p_i225984_2_, Runnable p_i225984_3_) {
            super(p_i225984_1_, p_i225984_2_, p_i225984_3_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ShadeModelState
    extends RenderState {
        private final boolean field_228599_Q_;

        public ShadeModelState(boolean p_i225987_1_) {
            super("shade_model", () -> RenderSystem.shadeModel((int)(p_i225987_1_ ? 7425 : 7424)), () -> RenderSystem.shadeModel((int)7424));
            this.field_228599_Q_ = p_i225987_1_;
        }

        @Override
        public boolean equals(Object p_equals_1_) {
            if (this == p_equals_1_) {
                return true;
            }
            if (p_equals_1_ != null && this.getClass() == p_equals_1_.getClass()) {
                ShadeModelState renderstate$shademodelstate = (ShadeModelState)p_equals_1_;
                return this.field_228599_Q_ == renderstate$shademodelstate.field_228599_Q_;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Boolean.hashCode(this.field_228599_Q_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class PortalTexturingState
    extends TexturingState {
        private final int field_228596_Q_;

        public PortalTexturingState(int p_i225986_1_) {
            super("portal_texturing", () -> {
                RenderSystem.matrixMode((int)5890);
                RenderSystem.pushMatrix();
                RenderSystem.loadIdentity();
                RenderSystem.translatef((float)0.5f, (float)0.5f, (float)0.0f);
                RenderSystem.scalef((float)0.5f, (float)0.5f, (float)1.0f);
                RenderSystem.translatef((float)(17.0f / (float)p_i225986_1_), (float)((2.0f + (float)p_i225986_1_ / 1.5f) * ((float)(Util.func_211177_b() % 800000L) / 800000.0f)), (float)0.0f);
                RenderSystem.rotatef((float)(((float)(p_i225986_1_ * p_i225986_1_) * 4321.0f + (float)p_i225986_1_ * 9.0f) * 2.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                RenderSystem.scalef((float)(4.5f - (float)p_i225986_1_ / 4.0f), (float)(4.5f - (float)p_i225986_1_ / 4.0f), (float)1.0f);
                RenderSystem.mulTextureByProjModelView();
                RenderSystem.matrixMode((int)5888);
                RenderSystem.setupEndPortalTexGen();
            }, () -> {
                RenderSystem.matrixMode((int)5890);
                RenderSystem.popMatrix();
                RenderSystem.matrixMode((int)5888);
                RenderSystem.clearTexGen();
            });
            this.field_228596_Q_ = p_i225986_1_;
        }

        @Override
        public boolean equals(Object p_equals_1_) {
            if (this == p_equals_1_) {
                return true;
            }
            if (p_equals_1_ != null && this.getClass() == p_equals_1_.getClass()) {
                PortalTexturingState renderstate$portaltexturingstate = (PortalTexturingState)p_equals_1_;
                return this.field_228596_Q_ == renderstate$portaltexturingstate.field_228596_Q_;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Integer.hashCode(this.field_228596_Q_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class OverlayState
    extends BooleanState {
        public OverlayState(boolean p_i225985_1_) {
            super("overlay", () -> {
                if (p_i225985_1_) {
                    Minecraft.func_71410_x().field_71460_t.func_228385_m_().func_229198_a_();
                }
            }, () -> {
                if (p_i225985_1_) {
                    Minecraft.func_71410_x().field_71460_t.func_228385_m_().func_229203_b_();
                }
            }, p_i225985_1_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class OffsetTexturingState
    extends TexturingState {
        private final float field_228590_Q_;
        private final float field_228591_R_;

        public OffsetTexturingState(float p_i225983_1_, float p_i225983_2_) {
            super("offset_texturing", () -> {
                RenderSystem.matrixMode((int)5890);
                RenderSystem.pushMatrix();
                RenderSystem.loadIdentity();
                RenderSystem.translatef((float)p_i225983_1_, (float)p_i225983_2_, (float)0.0f);
                RenderSystem.matrixMode((int)5888);
            }, () -> {
                RenderSystem.matrixMode((int)5890);
                RenderSystem.popMatrix();
                RenderSystem.matrixMode((int)5888);
            });
            this.field_228590_Q_ = p_i225983_1_;
            this.field_228591_R_ = p_i225983_2_;
        }

        @Override
        public boolean equals(Object p_equals_1_) {
            if (this == p_equals_1_) {
                return true;
            }
            if (p_equals_1_ != null && this.getClass() == p_equals_1_.getClass()) {
                OffsetTexturingState renderstate$offsettexturingstate = (OffsetTexturingState)p_equals_1_;
                return Float.compare(renderstate$offsettexturingstate.field_228590_Q_, this.field_228590_Q_) == 0 && Float.compare(renderstate$offsettexturingstate.field_228591_R_, this.field_228591_R_) == 0;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hash(Float.valueOf(this.field_228590_Q_), Float.valueOf(this.field_228591_R_));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class LineState
    extends RenderState {
        private final OptionalDouble field_228587_Q_;

        public LineState(OptionalDouble p_i225982_1_) {
            super("line_width", () -> {
                if (!Objects.equals(p_i225982_1_, OptionalDouble.of(1.0))) {
                    if (p_i225982_1_.isPresent()) {
                        RenderSystem.lineWidth((float)((float)p_i225982_1_.getAsDouble()));
                    } else {
                        RenderSystem.lineWidth((float)Math.max(2.5f, (float)Minecraft.func_71410_x().func_228018_at_().func_198109_k() / 1920.0f * 2.5f));
                    }
                }
            }, () -> {
                if (!Objects.equals(p_i225982_1_, OptionalDouble.of(1.0))) {
                    RenderSystem.lineWidth((float)1.0f);
                }
            });
            this.field_228587_Q_ = p_i225982_1_;
        }

        @Override
        public boolean equals(@Nullable Object p_equals_1_) {
            if (this == p_equals_1_) {
                return true;
            }
            if (p_equals_1_ != null && this.getClass() == p_equals_1_.getClass()) {
                return !super.equals(p_equals_1_) ? false : Objects.equals(this.field_228587_Q_, ((LineState)p_equals_1_).field_228587_Q_);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.field_228587_Q_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class LightmapState
    extends BooleanState {
        public LightmapState(boolean p_i225981_1_) {
            super("lightmap", () -> {
                if (p_i225981_1_) {
                    Minecraft.func_71410_x().field_71460_t.func_228384_l_().func_205109_c();
                }
            }, () -> {
                if (p_i225981_1_) {
                    Minecraft.func_71410_x().field_71460_t.func_228384_l_().func_205108_b();
                }
            }, p_i225981_1_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class LayerState
    extends RenderState {
        public LayerState(String p_i225980_1_, Runnable p_i225980_2_, Runnable p_i225980_3_) {
            super(p_i225980_1_, p_i225980_2_, p_i225980_3_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FogState
    extends RenderState {
        public FogState(String p_i225979_1_, Runnable p_i225979_2_, Runnable p_i225979_3_) {
            super(p_i225979_1_, p_i225979_2_, p_i225979_3_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class DiffuseLightingState
    extends BooleanState {
        public DiffuseLightingState(boolean p_i225978_1_) {
            super("diffuse_lighting", () -> {
                if (p_i225978_1_) {
                    RenderHelper.func_227780_a_();
                }
            }, () -> {
                if (p_i225978_1_) {
                    RenderHelper.func_74518_a();
                }
            }, p_i225978_1_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class DepthTestState
    extends RenderState {
        private final int field_228580_Q_;

        public DepthTestState(int p_i225977_1_) {
            super("depth_test", () -> {
                if (p_i225977_1_ != 519) {
                    RenderSystem.enableDepthTest();
                    RenderSystem.depthFunc((int)p_i225977_1_);
                }
            }, () -> {
                if (p_i225977_1_ != 519) {
                    RenderSystem.disableDepthTest();
                    RenderSystem.depthFunc((int)515);
                }
            });
            this.field_228580_Q_ = p_i225977_1_;
        }

        @Override
        public boolean equals(Object p_equals_1_) {
            if (this == p_equals_1_) {
                return true;
            }
            if (p_equals_1_ != null && this.getClass() == p_equals_1_.getClass()) {
                DepthTestState renderstate$depthteststate = (DepthTestState)p_equals_1_;
                return this.field_228580_Q_ == renderstate$depthteststate.field_228580_Q_;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Integer.hashCode(this.field_228580_Q_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class CullState
    extends BooleanState {
        public CullState(boolean p_i225976_1_) {
            super("cull", () -> {
                if (p_i225976_1_) {
                    RenderSystem.enableCull();
                }
            }, () -> {
                if (p_i225976_1_) {
                    RenderSystem.disableCull();
                }
            }, p_i225976_1_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class BooleanState
    extends RenderState {
        private final boolean field_228577_Q_;

        public BooleanState(String p_i225975_1_, Runnable p_i225975_2_, Runnable p_i225975_3_, boolean p_i225975_4_) {
            super(p_i225975_1_, p_i225975_2_, p_i225975_3_);
            this.field_228577_Q_ = p_i225975_4_;
        }

        @Override
        public boolean equals(Object p_equals_1_) {
            if (this == p_equals_1_) {
                return true;
            }
            if (p_equals_1_ != null && this.getClass() == p_equals_1_.getClass()) {
                BooleanState renderstate$booleanstate = (BooleanState)p_equals_1_;
                return this.field_228577_Q_ == renderstate$booleanstate.field_228577_Q_;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Boolean.hashCode(this.field_228577_Q_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class AlphaState
    extends RenderState {
        private final float field_228574_Q_;

        public AlphaState(float refIn) {
            super("alpha", () -> {
                if (refIn > 0.0f) {
                    RenderSystem.enableAlphaTest();
                    RenderSystem.alphaFunc((int)516, (float)refIn);
                } else {
                    RenderSystem.disableAlphaTest();
                }
            }, () -> {
                RenderSystem.disableAlphaTest();
                RenderSystem.defaultAlphaFunc();
            });
            this.field_228574_Q_ = refIn;
        }

        @Override
        public boolean equals(@Nullable Object p_equals_1_) {
            if (this == p_equals_1_) {
                return true;
            }
            if (p_equals_1_ != null && this.getClass() == p_equals_1_.getClass()) {
                if (!super.equals(p_equals_1_)) {
                    return false;
                }
                return this.field_228574_Q_ == ((AlphaState)p_equals_1_).field_228574_Q_;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), Float.valueOf(this.field_228574_Q_));
        }
    }
}

