/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public abstract class LivingRenderer<T extends LivingEntity, M extends EntityModel<T>>
extends EntityRenderer<T>
implements IEntityRenderer<T, M> {
    private static final Logger field_147923_a = LogManager.getLogger();
    protected M field_77045_g;
    protected final List<LayerRenderer<T, M>> field_177097_h = Lists.newArrayList();

    public LivingRenderer(EntityRendererManager rendererManager, M entityModelIn, float shadowSizeIn) {
        super(rendererManager);
        this.field_77045_g = entityModelIn;
        this.field_76989_e = shadowSizeIn;
    }

    public final boolean func_177094_a(LayerRenderer<T, M> layer) {
        return this.field_177097_h.add(layer);
    }

    public M func_217764_d() {
        return this.field_77045_g;
    }

    @Override
    public void func_225623_a_(T entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        Direction direction;
        boolean shouldSit;
        if (MinecraftForge.EVENT_BUS.post((Event)new RenderLivingEvent.Pre(entityIn, this, partialTicks, matrixStackIn, bufferIn, packedLightIn))) {
            return;
        }
        matrixStackIn.func_227860_a_();
        ((EntityModel)this.field_77045_g).field_217112_c = this.func_77040_d(entityIn, partialTicks);
        ((EntityModel)this.field_77045_g).field_217113_d = shouldSit = ((Entity)((Object)entityIn)).func_184218_aH() && ((Entity)((Object)entityIn)).func_184187_bx() != null && ((Entity)((Object)entityIn)).func_184187_bx().shouldRiderSit();
        ((EntityModel)this.field_77045_g).field_217114_e = ((LivingEntity)((Object)entityIn)).func_70631_g_();
        float f = MathHelper.func_219805_h((float)partialTicks, (float)((LivingEntity)((Object)entityIn)).field_70760_ar, (float)((LivingEntity)((Object)entityIn)).field_70761_aq);
        float f1 = MathHelper.func_219805_h((float)partialTicks, (float)((LivingEntity)((Object)entityIn)).field_70758_at, (float)((LivingEntity)((Object)entityIn)).field_70759_as);
        float f2 = f1 - f;
        if (shouldSit && ((Entity)((Object)entityIn)).func_184187_bx() instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)((Entity)((Object)entityIn)).func_184187_bx();
            f = MathHelper.func_219805_h((float)partialTicks, (float)livingentity.field_70760_ar, (float)livingentity.field_70761_aq);
            f2 = f1 - f;
            float f3 = MathHelper.func_76142_g((float)f2);
            if (f3 < -85.0f) {
                f3 = -85.0f;
            }
            if (f3 >= 85.0f) {
                f3 = 85.0f;
            }
            f = f1 - f3;
            if (f3 * f3 > 2500.0f) {
                f += f3 * 0.2f;
            }
            f2 = f1 - f;
        }
        float f6 = MathHelper.func_219799_g((float)partialTicks, (float)((LivingEntity)((Object)entityIn)).field_70127_C, (float)((LivingEntity)((Object)entityIn)).field_70125_A);
        if (((Entity)((Object)entityIn)).func_213283_Z() == Pose.SLEEPING && (direction = ((LivingEntity)((Object)entityIn)).func_213376_dz()) != null) {
            float f4 = ((Entity)((Object)entityIn)).func_213307_e(Pose.STANDING) - 0.1f;
            matrixStackIn.func_227861_a_((double)((float)(-direction.func_82601_c()) * f4), 0.0, (double)((float)(-direction.func_82599_e()) * f4));
        }
        float f7 = this.func_77044_a(entityIn, partialTicks);
        this.func_225621_a_(entityIn, matrixStackIn, f7, f, partialTicks);
        matrixStackIn.func_227862_a_(-1.0f, -1.0f, 1.0f);
        this.func_225620_a_(entityIn, matrixStackIn, partialTicks);
        matrixStackIn.func_227861_a_(0.0, (double)-1.501f, 0.0);
        float f8 = 0.0f;
        float f5 = 0.0f;
        if (!shouldSit && ((LivingEntity)((Object)entityIn)).func_70089_S()) {
            f8 = MathHelper.func_219799_g((float)partialTicks, (float)((LivingEntity)((Object)entityIn)).field_184618_aE, (float)((LivingEntity)((Object)entityIn)).field_70721_aZ);
            f5 = ((LivingEntity)((Object)entityIn)).field_184619_aG - ((LivingEntity)((Object)entityIn)).field_70721_aZ * (1.0f - partialTicks);
            if (((LivingEntity)((Object)entityIn)).func_70631_g_()) {
                f5 *= 3.0f;
            }
            if (f8 > 1.0f) {
                f8 = 1.0f;
            }
        }
        this.field_77045_g.func_212843_a_(entityIn, f5, f8, partialTicks);
        this.field_77045_g.func_225597_a_(entityIn, f5, f8, f7, f2, f6);
        boolean flag = this.func_225622_a_(entityIn);
        boolean flag1 = !flag && !((Entity)((Object)entityIn)).func_98034_c(Minecraft.func_71410_x().field_71439_g);
        RenderType rendertype = this.func_230042_a_(entityIn, flag, flag1);
        if (rendertype != null) {
            IVertexBuilder ivertexbuilder = bufferIn.getBuffer(rendertype);
            int i = LivingRenderer.func_229117_c_(entityIn, this.func_225625_b_(entityIn, partialTicks));
            this.field_77045_g.func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, i, 1.0f, 1.0f, 1.0f, flag1 ? 0.15f : 1.0f);
        }
        if (!((Entity)((Object)entityIn)).func_175149_v()) {
            for (LayerRenderer<T, M> layerrenderer : this.field_177097_h) {
                layerrenderer.func_225628_a_(matrixStackIn, bufferIn, packedLightIn, entityIn, f5, f8, partialTicks, f7, f2, f6);
            }
        }
        matrixStackIn.func_227865_b_();
        super.func_225623_a_(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        MinecraftForge.EVENT_BUS.post((Event)new RenderLivingEvent.Post(entityIn, this, partialTicks, matrixStackIn, bufferIn, packedLightIn));
    }

    @Nullable
    protected RenderType func_230042_a_(T p_230042_1_, boolean p_230042_2_, boolean p_230042_3_) {
        ResourceLocation resourcelocation = this.func_110775_a(p_230042_1_);
        if (p_230042_3_) {
            return RenderType.func_228644_e_((ResourceLocation)resourcelocation);
        }
        if (p_230042_2_) {
            return this.field_77045_g.func_228282_a_(resourcelocation);
        }
        return ((Entity)((Object)p_230042_1_)).func_225510_bt_() ? RenderType.func_228654_j_((ResourceLocation)resourcelocation) : null;
    }

    public static int func_229117_c_(LivingEntity livingEntityIn, float uIn) {
        return OverlayTexture.func_229201_a_((int)OverlayTexture.func_229199_a_((float)uIn), (int)OverlayTexture.func_229202_a_((livingEntityIn.field_70737_aN > 0 || livingEntityIn.field_70725_aQ > 0 ? 1 : 0) != 0));
    }

    protected boolean func_225622_a_(T livingEntityIn) {
        return !((Entity)((Object)livingEntityIn)).func_82150_aj();
    }

    private static float func_217765_a(Direction facingIn) {
        switch (facingIn) {
            case SOUTH: {
                return 90.0f;
            }
            case WEST: {
                return 0.0f;
            }
            case NORTH: {
                return 270.0f;
            }
            case EAST: {
                return 180.0f;
            }
        }
        return 0.0f;
    }

    protected void func_225621_a_(T entityLiving, MatrixStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks) {
        String s;
        Pose pose = ((Entity)((Object)entityLiving)).func_213283_Z();
        if (pose != Pose.SLEEPING) {
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - rotationYaw));
        }
        if (((LivingEntity)((Object)entityLiving)).field_70725_aQ > 0) {
            float f = ((float)((LivingEntity)((Object)entityLiving)).field_70725_aQ + partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((f = MathHelper.func_76129_c((float)f)) > 1.0f) {
                f = 1.0f;
            }
            matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(f * this.func_77037_a(entityLiving)));
        } else if (((LivingEntity)((Object)entityLiving)).func_204805_cN()) {
            matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f - ((LivingEntity)((Object)entityLiving)).field_70125_A));
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(((float)((LivingEntity)((Object)entityLiving)).field_70173_aa + partialTicks) * -75.0f));
        } else if (pose == Pose.SLEEPING) {
            Direction direction = ((LivingEntity)((Object)entityLiving)).func_213376_dz();
            float f1 = direction != null ? LivingRenderer.func_217765_a(direction) : rotationYaw;
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(f1));
            matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(this.func_77037_a(entityLiving)));
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(270.0f));
        } else if ((((Entity)((Object)entityLiving)).func_145818_k_() || entityLiving instanceof PlayerEntity) && ("Dinnerbone".equals(s = TextFormatting.func_110646_a((String)((Entity)((Object)entityLiving)).func_200200_C_().getString())) || "Grumm".equals(s)) && (!(entityLiving instanceof PlayerEntity) || ((PlayerEntity)((Object)entityLiving)).func_175148_a(PlayerModelPart.CAPE))) {
            matrixStackIn.func_227861_a_(0.0, (double)(((Entity)((Object)entityLiving)).func_213302_cg() + 0.1f), 0.0);
            matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        }
    }

    protected float func_77040_d(T livingBase, float partialTickTime) {
        return ((LivingEntity)((Object)livingBase)).func_70678_g(partialTickTime);
    }

    protected float func_77044_a(T livingBase, float partialTicks) {
        return (float)((LivingEntity)((Object)livingBase)).field_70173_aa + partialTicks;
    }

    protected float func_77037_a(T entityLivingBaseIn) {
        return 90.0f;
    }

    protected float func_225625_b_(T livingEntityIn, float partialTicks) {
        return 0.0f;
    }

    protected void func_225620_a_(T entitylivingbaseIn, MatrixStack matrixStackIn, float partialTickTime) {
    }

    @Override
    protected boolean func_177070_b(T entity) {
        boolean flag;
        float f;
        double d0 = this.field_76990_c.func_229099_b_((Entity)((Object)entity));
        float f2 = f = ((Entity)((Object)entity)).func_226273_bm_() ? 32.0f : 64.0f;
        if (d0 >= (double)(f * f)) {
            return false;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        ClientPlayerEntity clientplayerentity = minecraft.field_71439_g;
        boolean bl = flag = !((Entity)((Object)entity)).func_98034_c(clientplayerentity);
        if (entity != clientplayerentity) {
            Team team = ((Entity)((Object)entity)).func_96124_cp();
            Team team1 = clientplayerentity.func_96124_cp();
            if (team != null) {
                Team.Visible team$visible = team.func_178770_i();
                switch (team$visible) {
                    case ALWAYS: {
                        return flag;
                    }
                    case NEVER: {
                        return false;
                    }
                    case HIDE_FOR_OTHER_TEAMS: {
                        return team1 == null ? flag : team.func_142054_a(team1) && (team.func_98297_h() || flag);
                    }
                    case HIDE_FOR_OWN_TEAM: {
                        return team1 == null ? flag : !team.func_142054_a(team1) && flag;
                    }
                }
                return true;
            }
        }
        return Minecraft.func_71382_s() && entity != minecraft.func_175606_aa() && flag && !((Entity)((Object)entity)).func_184207_aI();
    }
}

