/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity.layers;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;

@OnlyIn(value=Dist.CLIENT)
public abstract class ArmorLayer<T extends LivingEntity, M extends BipedModel<T>, A extends BipedModel<T>>
extends LayerRenderer<T, M> {
    protected final A field_177189_c;
    protected final A field_177186_d;
    private static final Map<String, ResourceLocation> field_177191_j = Maps.newHashMap();

    protected ArmorLayer(IEntityRenderer<T, M> entityRendererIn, A modelLeggingsIn, A modelArmorIn) {
        super(entityRendererIn);
        this.field_177189_c = modelLeggingsIn;
        this.field_177186_d = modelArmorIn;
    }

    public void func_225628_a_(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        this.func_229129_a_(matrixStackIn, bufferIn, entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, EquipmentSlotType.CHEST, packedLightIn);
        this.func_229129_a_(matrixStackIn, bufferIn, entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, EquipmentSlotType.LEGS, packedLightIn);
        this.func_229129_a_(matrixStackIn, bufferIn, entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, EquipmentSlotType.FEET, packedLightIn);
        this.func_229129_a_(matrixStackIn, bufferIn, entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, EquipmentSlotType.HEAD, packedLightIn);
    }

    private void func_229129_a_(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, T entityLivingBaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, EquipmentSlotType slotIn, int packedLightIn) {
        ArmorItem armoritem;
        ItemStack itemstack = ((LivingEntity)((Object)entityLivingBaseIn)).func_184582_a(slotIn);
        if (itemstack.func_77973_b() instanceof ArmorItem && (armoritem = (ArmorItem)itemstack.func_77973_b()).func_185083_B_() == slotIn) {
            A a = this.func_215337_a(slotIn);
            a = this.getArmorModelHook(entityLivingBaseIn, itemstack, slotIn, a);
            ((BipedModel)this.func_215332_c()).func_217148_a(a);
            a.func_212843_a_(entityLivingBaseIn, limbSwing, limbSwingAmount, partialTicks);
            this.func_188359_a(a, slotIn);
            a.func_225597_a_(entityLivingBaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            boolean flag = this.func_188363_b(slotIn);
            boolean flag1 = itemstack.func_77962_s();
            if (armoritem instanceof IDyeableArmorItem) {
                int i = ((IDyeableArmorItem)armoritem).func_200886_f(itemstack);
                float f = (float)(i >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(i & 0xFF) / 255.0f;
                this.renderArmor(matrixStackIn, bufferIn, packedLightIn, flag1, a, f, f1, f2, this.getArmorResource((Entity)((Object)entityLivingBaseIn), itemstack, slotIn, null));
                this.renderArmor(matrixStackIn, bufferIn, packedLightIn, flag1, a, 1.0f, 1.0f, 1.0f, this.getArmorResource((Entity)((Object)entityLivingBaseIn), itemstack, slotIn, "overlay"));
            } else {
                this.renderArmor(matrixStackIn, bufferIn, packedLightIn, flag1, a, 1.0f, 1.0f, 1.0f, this.getArmorResource((Entity)((Object)entityLivingBaseIn), itemstack, slotIn, null));
            }
        }
    }

    private void func_229128_a_(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, ArmorItem armorItemIn, boolean glintIn, A modelIn, boolean legSlotIn, float red, float green, float blue, @Nullable String overlayIn) {
        this.renderArmor(matrixStackIn, bufferIn, packedLightIn, glintIn, modelIn, red, green, blue, this.func_177178_a(armorItemIn, legSlotIn, overlayIn));
    }

    private void renderArmor(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, boolean glintIn, A modelIn, float red, float green, float blue, ResourceLocation armorResource) {
        IVertexBuilder ivertexbuilder = ItemRenderer.func_229113_a_(bufferIn, RenderType.func_228640_c_((ResourceLocation)armorResource), false, glintIn);
        modelIn.func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, red, green, blue, 1.0f);
    }

    public A func_215337_a(EquipmentSlotType slotIn) {
        return this.func_188363_b(slotIn) ? this.field_177189_c : this.field_177186_d;
    }

    private boolean func_188363_b(EquipmentSlotType slotIn) {
        return slotIn == EquipmentSlotType.LEGS;
    }

    @Deprecated
    private ResourceLocation func_177178_a(ArmorItem armor, boolean legSlotIn, @Nullable String suffixOverlayIn) {
        String s = "textures/models/armor/" + armor.func_200880_d().func_200897_d() + "_layer_" + (legSlotIn ? 2 : 1) + (suffixOverlayIn == null ? "" : "_" + suffixOverlayIn) + ".png";
        return field_177191_j.computeIfAbsent(s, ResourceLocation::new);
    }

    protected abstract void func_188359_a(A var1, EquipmentSlotType var2);

    protected abstract void func_177194_a(A var1);

    protected A getArmorModelHook(T entity, ItemStack itemStack, EquipmentSlotType slot, A model) {
        return model;
    }

    public ResourceLocation getArmorResource(Entity entity, ItemStack stack, EquipmentSlotType slot, @Nullable String type) {
        ArmorItem item = (ArmorItem)stack.func_77973_b();
        String texture = item.func_200880_d().func_200897_d();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        String s1 = String.format("%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, this.func_188363_b(slot) ? 2 : 1, type == null ? "" : String.format("_%s", type));
        ResourceLocation resourcelocation = field_177191_j.get(s1 = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)stack, (String)s1, (EquipmentSlotType)slot, (String)type));
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s1);
            field_177191_j.put(s1, resourcelocation);
        }
        return resourcelocation;
    }
}

