/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.item;

import java.util.OptionalInt;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SSpawnObjectPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

@OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
public class FireworkRocketEntity
extends Entity
implements IRendersAsItem,
IProjectile {
    private static final DataParameter<ItemStack> field_184566_a = EntityDataManager.func_187226_a(FireworkRocketEntity.class, DataSerializers.field_187196_f);
    private static final DataParameter<OptionalInt> field_191512_b = EntityDataManager.func_187226_a(FireworkRocketEntity.class, DataSerializers.field_218814_r);
    private static final DataParameter<Boolean> field_213895_d = EntityDataManager.func_187226_a(FireworkRocketEntity.class, DataSerializers.field_187198_h);
    private int field_92056_a;
    private int field_92055_b;
    private LivingEntity field_191513_e;

    public FireworkRocketEntity(EntityType<? extends FireworkRocketEntity> p_i50164_1_, World p_i50164_2_) {
        super(p_i50164_1_, p_i50164_2_);
    }

    @Override
    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(field_184566_a, ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(field_191512_b, OptionalInt.empty());
        this.field_70180_af.func_187214_a(field_213895_d, false);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        return distance < 4096.0 && !this.func_191511_j();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_145770_h(double x, double y, double z) {
        return super.func_145770_h(x, y, z) && !this.func_191511_j();
    }

    public FireworkRocketEntity(World worldIn, double x, double y, double z, ItemStack givenItem) {
        super(EntityType.field_200810_x, worldIn);
        this.field_92056_a = 0;
        this.func_70107_b(x, y, z);
        int i = 1;
        if (!givenItem.func_190926_b() && givenItem.func_77942_o()) {
            this.field_70180_af.func_187227_b(field_184566_a, givenItem.func_77946_l());
            i += givenItem.func_190925_c("Fireworks").func_74771_c("Flight");
        }
        this.func_213293_j(this.field_70146_Z.nextGaussian() * 0.001, 0.05, this.field_70146_Z.nextGaussian() * 0.001);
        this.field_92055_b = 10 * i + this.field_70146_Z.nextInt(6) + this.field_70146_Z.nextInt(7);
    }

    public FireworkRocketEntity(World p_i47367_1_, ItemStack p_i47367_2_, LivingEntity p_i47367_3_) {
        this(p_i47367_1_, p_i47367_3_.func_226277_ct_(), p_i47367_3_.func_226278_cu_(), p_i47367_3_.func_226281_cx_(), p_i47367_2_);
        this.field_70180_af.func_187227_b(field_191512_b, OptionalInt.of(p_i47367_3_.func_145782_y()));
        this.field_191513_e = p_i47367_3_;
    }

    public FireworkRocketEntity(World p_i50165_1_, ItemStack p_i50165_2_, double p_i50165_3_, double p_i50165_5_, double p_i50165_7_, boolean p_i50165_9_) {
        this(p_i50165_1_, p_i50165_3_, p_i50165_5_, p_i50165_7_, p_i50165_2_);
        this.field_70180_af.func_187227_b(field_213895_d, p_i50165_9_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.func_213293_j(x, y, z);
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.2957763671875);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f) * 57.2957763671875);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_191511_j()) {
            if (this.field_191513_e == null) {
                this.field_70180_af.func_187225_a(field_191512_b).ifPresent(p_213891_1_ -> {
                    Entity entity = this.field_70170_p.func_73045_a(p_213891_1_);
                    if (entity instanceof LivingEntity) {
                        this.field_191513_e = (LivingEntity)entity;
                    }
                });
            }
            if (this.field_191513_e != null) {
                if (this.field_191513_e.func_184613_cA()) {
                    Vec3d vec3d = this.field_191513_e.func_70040_Z();
                    double d0 = 1.5;
                    double d1 = 0.1;
                    Vec3d vec3d1 = this.field_191513_e.func_213322_ci();
                    this.field_191513_e.func_213317_d(vec3d1.func_72441_c(vec3d.field_72450_a * 0.1 + (vec3d.field_72450_a * 1.5 - vec3d1.field_72450_a) * 0.5, vec3d.field_72448_b * 0.1 + (vec3d.field_72448_b * 1.5 - vec3d1.field_72448_b) * 0.5, vec3d.field_72449_c * 0.1 + (vec3d.field_72449_c * 1.5 - vec3d1.field_72449_c) * 0.5));
                }
                this.func_70107_b(this.field_191513_e.func_226277_ct_(), this.field_191513_e.func_226278_cu_(), this.field_191513_e.func_226281_cx_());
                this.func_213317_d(this.field_191513_e.func_213322_ci());
            }
        } else {
            if (!this.func_213889_i()) {
                this.func_213317_d(this.func_213322_ci().func_216372_d(1.15, 1.0, 1.15).func_72441_c(0.0, 0.04, 0.0));
            }
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        }
        Vec3d vec3d2 = this.func_213322_ci();
        RayTraceResult raytraceresult = ProjectileHelper.func_221267_a(this, this.func_174813_aQ().func_216361_a(vec3d2).func_186662_g(1.0), p_213890_0_ -> !p_213890_0_.func_175149_v() && p_213890_0_.func_70089_S() && p_213890_0_.func_70067_L(), RayTraceContext.BlockMode.COLLIDER, true);
        if (!this.field_70145_X) {
            this.func_213892_a(raytraceresult);
            this.field_70160_al = true;
        }
        float f = MathHelper.func_76133_a((double)FireworkRocketEntity.func_213296_b(vec3d2));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)vec3d2.field_72450_a, (double)vec3d2.field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)vec3d2.field_72448_b, (double)f) * 57.2957763671875);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = MathHelper.func_219799_g((float)0.2f, (float)this.field_70127_C, (float)this.field_70125_A);
        this.field_70177_z = MathHelper.func_219799_g((float)0.2f, (float)this.field_70126_B, (float)this.field_70177_z);
        if (this.field_92056_a == 0 && !this.func_174814_R()) {
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187631_bo, SoundCategory.AMBIENT, 3.0f, 1.0f);
        }
        ++this.field_92056_a;
        if (this.field_70170_p.field_72995_K && this.field_92056_a % 2 < 2) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197629_v, this.func_226277_ct_(), this.func_226278_cu_() - 0.3, this.func_226281_cx_(), this.field_70146_Z.nextGaussian() * 0.05, -this.func_213322_ci().field_72448_b * 0.5, this.field_70146_Z.nextGaussian() * 0.05);
        }
        if (!this.field_70170_p.field_72995_K && this.field_92056_a > this.field_92055_b) {
            this.func_213893_k();
        }
    }

    private void func_213893_k() {
        this.field_70170_p.func_72960_a(this, (byte)17);
        this.func_191510_k();
        this.func_70106_y();
    }

    protected void func_213892_a(RayTraceResult p_213892_1_) {
        if (p_213892_1_.func_216346_c() != RayTraceResult.Type.MISS && ForgeEventFactory.onProjectileImpact((FireworkRocketEntity)this, (RayTraceResult)p_213892_1_)) {
            return;
        }
        if (p_213892_1_.func_216346_c() == RayTraceResult.Type.ENTITY && !this.field_70170_p.field_72995_K) {
            this.func_213893_k();
        } else if (this.field_70132_H) {
            BlockPos blockpos = p_213892_1_.func_216346_c() == RayTraceResult.Type.BLOCK ? new BlockPos((Vec3i)((BlockRayTraceResult)p_213892_1_).func_216350_a()) : new BlockPos((Entity)this);
            this.field_70170_p.func_180495_p(blockpos).func_196950_a(this.field_70170_p, blockpos, this);
            if (this.func_213894_l()) {
                this.func_213893_k();
            }
        }
    }

    private boolean func_213894_l() {
        ItemStack itemstack = this.field_70180_af.func_187225_a(field_184566_a);
        CompoundNBT compoundnbt = itemstack.func_190926_b() ? null : itemstack.func_179543_a("Fireworks");
        ListNBT listnbt = compoundnbt != null ? compoundnbt.func_150295_c("Explosions", 10) : null;
        return listnbt != null && !listnbt.isEmpty();
    }

    private void func_191510_k() {
        ListNBT listnbt;
        float f = 0.0f;
        ItemStack itemstack = this.field_70180_af.func_187225_a(field_184566_a);
        CompoundNBT compoundnbt = itemstack.func_190926_b() ? null : itemstack.func_179543_a("Fireworks");
        ListNBT listNBT = listnbt = compoundnbt != null ? compoundnbt.func_150295_c("Explosions", 10) : null;
        if (listnbt != null && !listnbt.isEmpty()) {
            f = 5.0f + (float)(listnbt.size() * 2);
        }
        if (f > 0.0f) {
            if (this.field_191513_e != null) {
                this.field_191513_e.func_70097_a(DamageSource.field_191552_t, 5.0f + (float)(listnbt.size() * 2));
            }
            double d0 = 5.0;
            Vec3d vec3d = this.func_213303_ch();
            for (LivingEntity livingentity : this.field_70170_p.func_217357_a(LivingEntity.class, this.func_174813_aQ().func_186662_g(5.0))) {
                if (livingentity == this.field_191513_e || this.func_70068_e(livingentity) > 25.0) continue;
                boolean flag = false;
                for (int i = 0; i < 2; ++i) {
                    Vec3d vec3d1 = new Vec3d(livingentity.func_226277_ct_(), livingentity.func_226283_e_(0.5 * (double)i), livingentity.func_226281_cx_());
                    BlockRayTraceResult raytraceresult = this.field_70170_p.func_217299_a(new RayTraceContext(vec3d, vec3d1, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, this));
                    if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS) continue;
                    flag = true;
                    break;
                }
                if (!flag) continue;
                float f1 = f * (float)Math.sqrt((5.0 - (double)this.func_70032_d(livingentity)) / 5.0);
                livingentity.func_70097_a(DamageSource.field_191552_t, f1);
            }
        }
    }

    private boolean func_191511_j() {
        return this.field_70180_af.func_187225_a(field_191512_b).isPresent();
    }

    public boolean func_213889_i() {
        return this.field_70180_af.func_187225_a(field_213895_d);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 17 && this.field_70170_p.field_72995_K) {
            if (!this.func_213894_l()) {
                for (int i = 0; i < this.field_70146_Z.nextInt(3) + 2; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197598_I, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70146_Z.nextGaussian() * 0.05, 0.005, this.field_70146_Z.nextGaussian() * 0.05);
                }
            } else {
                ItemStack itemstack = this.field_70180_af.func_187225_a(field_184566_a);
                CompoundNBT compoundnbt = itemstack.func_190926_b() ? null : itemstack.func_179543_a("Fireworks");
                Vec3d vec3d = this.func_213322_ci();
                this.field_70170_p.func_92088_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, compoundnbt);
            }
        }
        super.func_70103_a(id);
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a("Life", this.field_92056_a);
        compound.func_74768_a("LifeTime", this.field_92055_b);
        ItemStack itemstack = this.field_70180_af.func_187225_a(field_184566_a);
        if (!itemstack.func_190926_b()) {
            compound.func_218657_a("FireworksItem", itemstack.func_77955_b(new CompoundNBT()));
        }
        compound.func_74757_a("ShotAtAngle", this.field_70180_af.func_187225_a(field_213895_d));
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        this.field_92056_a = compound.func_74762_e("Life");
        this.field_92055_b = compound.func_74762_e("LifeTime");
        ItemStack itemstack = ItemStack.func_199557_a(compound.func_74775_l("FireworksItem"));
        if (!itemstack.func_190926_b()) {
            this.field_70180_af.func_187227_b(field_184566_a, itemstack);
        }
        if (compound.func_74764_b("ShotAtAngle")) {
            this.field_70180_af.func_187227_b(field_213895_d, compound.func_74767_n("ShotAtAngle"));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack func_184543_l() {
        ItemStack itemstack = this.field_70180_af.func_187225_a(field_184566_a);
        return itemstack.func_190926_b() ? new ItemStack(Items.field_196152_dE) : itemstack;
    }

    @Override
    public boolean func_70075_an() {
        return false;
    }

    @Override
    public IPacket<?> func_213297_N() {
        return new SSpawnObjectPacket((Entity)this);
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        float f = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f;
        y /= (double)f;
        z /= (double)f;
        x += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        y += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        z += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        this.func_213293_j(x *= (double)velocity, y *= (double)velocity, z *= (double)velocity);
    }
}

