/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.Dynamic;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.AcaciaFeature;
import net.minecraft.world.gen.feature.BambooFeature;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.BigBrownMushroomFeature;
import net.minecraft.world.gen.feature.BigMushroomFeatureConfig;
import net.minecraft.world.gen.feature.BigRedMushroomFeature;
import net.minecraft.world.gen.feature.BlockBlobConfig;
import net.minecraft.world.gen.feature.BlockBlobFeature;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.BlockPileFeature;
import net.minecraft.world.gen.feature.BlockStateFeatureConfig;
import net.minecraft.world.gen.feature.BlockStateProvidingFeatureConfig;
import net.minecraft.world.gen.feature.BlockWithContextConfig;
import net.minecraft.world.gen.feature.BlockWithContextFeature;
import net.minecraft.world.gen.feature.BlueIceFeature;
import net.minecraft.world.gen.feature.BonusChestFeature;
import net.minecraft.world.gen.feature.ChorusPlantFeature;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.CoralClawFeature;
import net.minecraft.world.gen.feature.CoralMushroomFeature;
import net.minecraft.world.gen.feature.CoralTreeFeature;
import net.minecraft.world.gen.feature.DarkOakTreeFeature;
import net.minecraft.world.gen.feature.DecoratedFeature;
import net.minecraft.world.gen.feature.DecoratedFeatureConfig;
import net.minecraft.world.gen.feature.DecoratedFlowerFeature;
import net.minecraft.world.gen.feature.DefaultFlowersFeature;
import net.minecraft.world.gen.feature.DesertWellsFeature;
import net.minecraft.world.gen.feature.DungeonsFeature;
import net.minecraft.world.gen.feature.EndGatewayConfig;
import net.minecraft.world.gen.feature.EndGatewayFeature;
import net.minecraft.world.gen.feature.EndIslandFeature;
import net.minecraft.world.gen.feature.EndSpikeFeature;
import net.minecraft.world.gen.feature.EndSpikeFeatureConfig;
import net.minecraft.world.gen.feature.FancyTreeFeature;
import net.minecraft.world.gen.feature.FeatureRadiusConfig;
import net.minecraft.world.gen.feature.FillLayerConfig;
import net.minecraft.world.gen.feature.FillLayerFeature;
import net.minecraft.world.gen.feature.FlowersFeature;
import net.minecraft.world.gen.feature.FossilsFeature;
import net.minecraft.world.gen.feature.GlowstoneBlobFeature;
import net.minecraft.world.gen.feature.HugeTreeFeatureConfig;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.IceAndSnowFeature;
import net.minecraft.world.gen.feature.IcePathFeature;
import net.minecraft.world.gen.feature.IceSpikeFeature;
import net.minecraft.world.gen.feature.IcebergFeature;
import net.minecraft.world.gen.feature.KelpFeature;
import net.minecraft.world.gen.feature.LakesFeature;
import net.minecraft.world.gen.feature.LiquidsConfig;
import net.minecraft.world.gen.feature.MegaJungleFeature;
import net.minecraft.world.gen.feature.MegaPineTree;
import net.minecraft.world.gen.feature.MultipleRandomFeature;
import net.minecraft.world.gen.feature.MultipleRandomFeatureConfig;
import net.minecraft.world.gen.feature.MultipleWithChanceRandomFeature;
import net.minecraft.world.gen.feature.MultipleWithChanceRandomFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.NoOpFeature;
import net.minecraft.world.gen.feature.OreFeature;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraft.world.gen.feature.RandomPatchFeature;
import net.minecraft.world.gen.feature.ReplaceBlockConfig;
import net.minecraft.world.gen.feature.ReplaceBlockFeature;
import net.minecraft.world.gen.feature.SeaGrassConfig;
import net.minecraft.world.gen.feature.SeaGrassFeature;
import net.minecraft.world.gen.feature.SeaPickleFeature;
import net.minecraft.world.gen.feature.ShrubFeature;
import net.minecraft.world.gen.feature.SingleRandomFeature;
import net.minecraft.world.gen.feature.SingleRandomFeatureConfig;
import net.minecraft.world.gen.feature.SphereReplaceConfig;
import net.minecraft.world.gen.feature.SphereReplaceFeature;
import net.minecraft.world.gen.feature.SpringFeature;
import net.minecraft.world.gen.feature.TreeFeature;
import net.minecraft.world.gen.feature.TreeFeatureConfig;
import net.minecraft.world.gen.feature.TwoFeatureChoiceConfig;
import net.minecraft.world.gen.feature.TwoFeatureChoiceFeature;
import net.minecraft.world.gen.feature.VinesFeature;
import net.minecraft.world.gen.feature.VoidStartPlatformFeature;
import net.minecraft.world.gen.feature.structure.BuriedTreasureConfig;
import net.minecraft.world.gen.feature.structure.BuriedTreasureStructure;
import net.minecraft.world.gen.feature.structure.DesertPyramidStructure;
import net.minecraft.world.gen.feature.structure.EndCityStructure;
import net.minecraft.world.gen.feature.structure.FortressStructure;
import net.minecraft.world.gen.feature.structure.IglooStructure;
import net.minecraft.world.gen.feature.structure.JunglePyramidStructure;
import net.minecraft.world.gen.feature.structure.MineshaftConfig;
import net.minecraft.world.gen.feature.structure.MineshaftStructure;
import net.minecraft.world.gen.feature.structure.OceanMonumentStructure;
import net.minecraft.world.gen.feature.structure.OceanRuinConfig;
import net.minecraft.world.gen.feature.structure.OceanRuinStructure;
import net.minecraft.world.gen.feature.structure.PillagerOutpostStructure;
import net.minecraft.world.gen.feature.structure.ShipwreckConfig;
import net.minecraft.world.gen.feature.structure.ShipwreckStructure;
import net.minecraft.world.gen.feature.structure.StrongholdStructure;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.SwampHutStructure;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.structure.VillageStructure;
import net.minecraft.world.gen.feature.structure.WoodlandMansionStructure;
import net.minecraft.world.gen.placement.CountConfig;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.GameData;

public abstract class Feature<FC extends IFeatureConfig>
extends ForgeRegistryEntry<Feature<?>> {
    public static final Structure<NoFeatureConfig> field_214536_b = (Structure)Feature.func_214468_a("pillager_outpost", new PillagerOutpostStructure(NoFeatureConfig::func_214639_a));
    public static final Structure<MineshaftConfig> field_202329_g = (Structure)Feature.func_214468_a("mineshaft", new MineshaftStructure(MineshaftConfig::func_214638_a));
    public static final Structure<NoFeatureConfig> field_202330_h = (Structure)Feature.func_214468_a("woodland_mansion", new WoodlandMansionStructure(NoFeatureConfig::func_214639_a));
    public static final Structure<NoFeatureConfig> field_202331_i = (Structure)Feature.func_214468_a("jungle_temple", new JunglePyramidStructure(NoFeatureConfig::func_214639_a));
    public static final Structure<NoFeatureConfig> field_202332_j = (Structure)Feature.func_214468_a("desert_pyramid", new DesertPyramidStructure(NoFeatureConfig::func_214639_a));
    public static final Structure<NoFeatureConfig> field_202333_k = (Structure)Feature.func_214468_a("igloo", new IglooStructure(NoFeatureConfig::func_214639_a));
    public static final Structure<ShipwreckConfig> field_204751_l = (Structure)Feature.func_214468_a("shipwreck", new ShipwreckStructure(ShipwreckConfig::func_214658_a));
    public static final SwampHutStructure field_202334_l = Feature.func_214468_a("swamp_hut", new SwampHutStructure(NoFeatureConfig::func_214639_a));
    public static final Structure<NoFeatureConfig> field_202335_m = (Structure)Feature.func_214468_a("stronghold", new StrongholdStructure(NoFeatureConfig::func_214639_a));
    public static final Structure<NoFeatureConfig> field_202336_n = (Structure)Feature.func_214468_a("ocean_monument", new OceanMonumentStructure(NoFeatureConfig::func_214639_a));
    public static final Structure<OceanRuinConfig> field_204029_o = (Structure)Feature.func_214468_a("ocean_ruin", new OceanRuinStructure(OceanRuinConfig::func_214640_a));
    public static final Structure<NoFeatureConfig> field_202337_o = (Structure)Feature.func_214468_a("nether_bridge", new FortressStructure(NoFeatureConfig::func_214639_a));
    public static final Structure<NoFeatureConfig> field_204292_r = (Structure)Feature.func_214468_a("end_city", new EndCityStructure(NoFeatureConfig::func_214639_a));
    public static final Structure<BuriedTreasureConfig> field_214549_o = (Structure)Feature.func_214468_a("buried_treasure", new BuriedTreasureStructure(BuriedTreasureConfig::func_214684_a));
    public static final Structure<VillageConfig> field_214550_p = (Structure)Feature.func_214468_a("village", new VillageStructure(VillageConfig::func_214679_a));
    public static final Feature<NoFeatureConfig> field_227245_q_ = Feature.func_214468_a("no_op", new NoOpFeature(NoFeatureConfig::func_214639_a));
    public static final Feature<TreeFeatureConfig> field_202301_A = Feature.func_214468_a("normal_tree", new TreeFeature((Function<Dynamic<?>, ? extends TreeFeatureConfig>)((Function<Dynamic<?>, TreeFeatureConfig>)TreeFeatureConfig::func_227338_a_)));
    public static final Feature<TreeFeatureConfig> field_227246_s_ = Feature.func_214468_a("acacia_tree", new AcaciaFeature((Function<Dynamic<?>, ? extends TreeFeatureConfig>)((Function<Dynamic<?>, TreeFeatureConfig>)TreeFeatureConfig::deserializeAcacia)));
    public static final Feature<TreeFeatureConfig> field_202339_q = Feature.func_214468_a("fancy_tree", new FancyTreeFeature(TreeFeatureConfig::func_227338_a_));
    public static final Feature<BaseTreeFeatureConfig> field_202342_t = Feature.func_214468_a("jungle_ground_bush", new ShrubFeature((Function<Dynamic<?>, ? extends BaseTreeFeatureConfig>)((Function<Dynamic<?>, BaseTreeFeatureConfig>)BaseTreeFeatureConfig::deserializeJungle)));
    public static final Feature<HugeTreeFeatureConfig> field_214551_w = Feature.func_214468_a("dark_oak_tree", new DarkOakTreeFeature((Function<Dynamic<?>, ? extends HugeTreeFeatureConfig>)((Function<Dynamic<?>, HugeTreeFeatureConfig>)HugeTreeFeatureConfig::deserializeDarkOak)));
    public static final Feature<HugeTreeFeatureConfig> field_202302_B = Feature.func_214468_a("mega_jungle_tree", new MegaJungleFeature((Function<Dynamic<?>, ? extends HugeTreeFeatureConfig>)((Function<Dynamic<?>, HugeTreeFeatureConfig>)HugeTreeFeatureConfig::deserializeJungle)));
    public static final Feature<HugeTreeFeatureConfig> field_202304_D = Feature.func_214468_a("mega_spruce_tree", new MegaPineTree((Function<Dynamic<?>, ? extends HugeTreeFeatureConfig>)((Function<Dynamic<?>, HugeTreeFeatureConfig>)HugeTreeFeatureConfig::deserializeSpruce)));
    public static final FlowersFeature<BlockClusterFeatureConfig> field_227247_y_ = (FlowersFeature)Feature.func_214468_a("flower", new DefaultFlowersFeature(BlockClusterFeatureConfig::func_227300_a_));
    public static final Feature<BlockClusterFeatureConfig> field_227248_z_ = Feature.func_214468_a("random_patch", new RandomPatchFeature(BlockClusterFeatureConfig::func_227300_a_));
    public static final Feature<BlockStateProvidingFeatureConfig> field_227244_A_ = Feature.func_214468_a("block_pile", new BlockPileFeature(BlockStateProvidingFeatureConfig::func_227269_a_));
    public static final Feature<LiquidsConfig> field_202295_ao = Feature.func_214468_a("spring_feature", new SpringFeature((Function<Dynamic<?>, ? extends LiquidsConfig>)((Function<Dynamic<?>, LiquidsConfig>)LiquidsConfig::func_214677_a)));
    public static final Feature<NoFeatureConfig> field_202298_ar = Feature.func_214468_a("chorus_plant", new ChorusPlantFeature(NoFeatureConfig::func_214639_a));
    public static final Feature<ReplaceBlockConfig> field_202294_an = Feature.func_214468_a("emerald_ore", new ReplaceBlockFeature(ReplaceBlockConfig::func_214657_a));
    public static final Feature<NoFeatureConfig> field_202312_L = Feature.func_214468_a("void_start_platform", new VoidStartPlatformFeature(NoFeatureConfig::func_214639_a));
    public static final Feature<NoFeatureConfig> field_202315_O = Feature.func_214468_a("desert_well", new DesertWellsFeature(NoFeatureConfig::func_214639_a));
    public static final Feature<NoFeatureConfig> field_202316_P = Feature.func_214468_a("fossil", new FossilsFeature(NoFeatureConfig::func_214639_a));
    public static final Feature<BigMushroomFeatureConfig> field_202318_R = Feature.func_214468_a("huge_red_mushroom", new BigRedMushroomFeature((Function<Dynamic<?>, ? extends BigMushroomFeatureConfig>)((Function<Dynamic<?>, BigMushroomFeatureConfig>)BigMushroomFeatureConfig::func_222853_a)));
    public static final Feature<BigMushroomFeatureConfig> field_202319_S = Feature.func_214468_a("huge_brown_mushroom", new BigBrownMushroomFeature((Function<Dynamic<?>, ? extends BigMushroomFeatureConfig>)((Function<Dynamic<?>, BigMushroomFeatureConfig>)BigMushroomFeatureConfig::func_222853_a)));
    public static final Feature<NoFeatureConfig> field_202320_T = Feature.func_214468_a("ice_spike", new IceSpikeFeature((Function<Dynamic<?>, ? extends NoFeatureConfig>)((Function<Dynamic<?>, NoFeatureConfig>)NoFeatureConfig::func_214639_a)));
    public static final Feature<NoFeatureConfig> field_202321_U = Feature.func_214468_a("glowstone_blob", new GlowstoneBlobFeature((Function<Dynamic<?>, ? extends NoFeatureConfig>)((Function<Dynamic<?>, NoFeatureConfig>)NoFeatureConfig::func_214639_a)));
    public static final Feature<NoFeatureConfig> field_202325_Y = Feature.func_214468_a("freeze_top_layer", new IceAndSnowFeature(NoFeatureConfig::func_214639_a));
    public static final Feature<NoFeatureConfig> field_202326_Z = Feature.func_214468_a("vines", new VinesFeature((Function<Dynamic<?>, ? extends NoFeatureConfig>)((Function<Dynamic<?>, NoFeatureConfig>)NoFeatureConfig::func_214639_a)));
    public static final Feature<NoFeatureConfig> field_202282_ab = Feature.func_214468_a("monster_room", new DungeonsFeature((Function<Dynamic<?>, ? extends NoFeatureConfig>)((Function<Dynamic<?>, NoFeatureConfig>)NoFeatureConfig::func_214639_a)));
    public static final Feature<NoFeatureConfig> field_205171_af = Feature.func_214468_a("blue_ice", new BlueIceFeature(NoFeatureConfig::func_214639_a));
    public static final Feature<BlockStateFeatureConfig> field_205172_ag = Feature.func_214468_a("iceberg", new IcebergFeature(BlockStateFeatureConfig::func_227271_a_));
    public static final Feature<BlockBlobConfig> field_202283_ac = Feature.func_214468_a("forest_rock", new BlockBlobFeature(BlockBlobConfig::func_214682_a));
    public static final Feature<SphereReplaceConfig> field_202285_ae = Feature.func_214468_a("disk", new SphereReplaceFeature(SphereReplaceConfig::func_214691_a));
    public static final Feature<FeatureRadiusConfig> field_202288_ah = Feature.func_214468_a("ice_patch", new IcePathFeature(FeatureRadiusConfig::func_214706_a));
    public static final Feature<BlockStateFeatureConfig> field_202289_ai = Feature.func_214468_a("lake", new LakesFeature(BlockStateFeatureConfig::func_227271_a_));
    public static final Feature<OreFeatureConfig> field_202290_aj = Feature.func_214468_a("ore", new OreFeature(OreFeatureConfig::func_214641_a));
    public static final Feature<EndSpikeFeatureConfig> field_202296_ap = Feature.func_214468_a("end_spike", new EndSpikeFeature(EndSpikeFeatureConfig::func_214673_a));
    public static final Feature<NoFeatureConfig> field_202297_aq = Feature.func_214468_a("end_island", new EndIslandFeature(NoFeatureConfig::func_214639_a));
    public static final Feature<EndGatewayConfig> field_202299_as = Feature.func_214468_a("end_gateway", new EndGatewayFeature(EndGatewayConfig::func_214697_a));
    public static final Feature<SeaGrassConfig> field_203234_at = Feature.func_214468_a("seagrass", new SeaGrassFeature(SeaGrassConfig::func_214659_a));
    public static final Feature<NoFeatureConfig> field_203235_au = Feature.func_214468_a("kelp", new KelpFeature(NoFeatureConfig::func_214639_a));
    public static final Feature<NoFeatureConfig> field_204621_ay = Feature.func_214468_a("coral_tree", new CoralTreeFeature(NoFeatureConfig::func_214639_a));
    public static final Feature<NoFeatureConfig> field_204622_az = Feature.func_214468_a("coral_mushroom", new CoralMushroomFeature(NoFeatureConfig::func_214639_a));
    public static final Feature<NoFeatureConfig> field_204619_aA = Feature.func_214468_a("coral_claw", new CoralClawFeature(NoFeatureConfig::func_214639_a));
    public static final Feature<CountConfig> field_204914_aC = Feature.func_214468_a("sea_pickle", new SeaPickleFeature(CountConfig::func_214687_a));
    public static final Feature<BlockWithContextConfig> field_206922_aF = Feature.func_214468_a("simple_block", new BlockWithContextFeature(BlockWithContextConfig::func_214663_a));
    public static final Feature<ProbabilityConfig> field_214482_aJ = Feature.func_214468_a("bamboo", new BambooFeature(ProbabilityConfig::func_214645_a));
    public static final Feature<FillLayerConfig> field_214486_aN = Feature.func_214468_a("fill_layer", new FillLayerFeature(FillLayerConfig::func_214635_a));
    public static final BonusChestFeature field_214487_aO = Feature.func_214468_a("bonus_chest", new BonusChestFeature(NoFeatureConfig::func_214639_a));
    public static final Feature<MultipleWithChanceRandomFeatureConfig> field_202291_ak = Feature.func_214468_a("random_random_selector", new MultipleRandomFeature(MultipleWithChanceRandomFeatureConfig::func_214653_a));
    public static final Feature<MultipleRandomFeatureConfig> field_202292_al = Feature.func_214468_a("random_selector", new MultipleWithChanceRandomFeature(MultipleRandomFeatureConfig::func_214648_a));
    public static final Feature<SingleRandomFeature> field_204620_ao = Feature.func_214468_a("simple_random_selector", new SingleRandomFeatureConfig(SingleRandomFeature::func_214664_a));
    public static final Feature<TwoFeatureChoiceConfig> field_202293_am = Feature.func_214468_a("random_boolean_selector", new TwoFeatureChoiceFeature(TwoFeatureChoiceConfig::func_227287_a_));
    public static final Feature<DecoratedFeatureConfig> field_214483_aK = Feature.func_214468_a("decorated", new DecoratedFeature(DecoratedFeatureConfig::func_214688_a));
    public static final Feature<DecoratedFeatureConfig> field_214484_aL = Feature.func_214468_a("decorated_flower", new DecoratedFlowerFeature(DecoratedFeatureConfig::func_214688_a));
    public static final BiMap<String, Structure<?>> field_202300_at = (BiMap)Util.func_200696_a((Object)GameData.getStructureMap(), p_205170_0_ -> {});
    public static final List<Structure<?>> field_214488_aQ = ImmutableList.of(field_214536_b, field_214550_p);
    private final Function<Dynamic<?>, ? extends FC> field_214535_a;

    private static <C extends IFeatureConfig, F extends Feature<C>> F func_214468_a(String key, F value) {
        return (F)((Object)Registry.func_218325_a(Registry.field_218379_q, key, value));
    }

    public Feature(Function<Dynamic<?>, ? extends FC> configFactoryIn) {
        this.field_214535_a = configFactoryIn;
    }

    public ConfiguredFeature<FC, ?> func_225566_b_(FC p_225566_1_) {
        return new ConfiguredFeature(this, p_225566_1_);
    }

    public FC func_214470_a(Dynamic<?> p_214470_1_) {
        return (FC)((IFeatureConfig)this.field_214535_a.apply(p_214470_1_));
    }

    protected void func_202278_a(IWorldWriter worldIn, BlockPos pos, BlockState state) {
        worldIn.func_180501_a(pos, state, 3);
    }

    public abstract boolean func_212245_a(IWorld var1, ChunkGenerator<? extends GenerationSettings> var2, Random var3, BlockPos var4, FC var5);

    public List<Biome.SpawnListEntry> func_202279_e() {
        return Collections.emptyList();
    }

    public List<Biome.SpawnListEntry> func_214469_f() {
        return Collections.emptyList();
    }

    protected static boolean func_227249_a_(Block blockIn) {
        return Tags.Blocks.STONE.func_199685_a_(blockIn);
    }

    protected static boolean func_227250_b_(Block blockIn) {
        return Tags.Blocks.DIRT.func_199685_a_(blockIn);
    }
}

