/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.monster.SpellcastingIllagerEntity;
import net.minecraft.entity.monster.VexEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.EvokerFangsEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;

public class EvokerEntity
extends SpellcastingIllagerEntity {
    private SheepEntity field_190763_bw;

    public EvokerEntity(EntityType<? extends EvokerEntity> entityType, World world) {
        super((EntityType<? extends SpellcastingIllagerEntity>)entityType, world);
        this.field_70728_aV = 10;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, new SwimGoal(this));
        this.field_70714_bg.func_75776_a(1, new CastingSpellGoal());
        this.field_70714_bg.func_75776_a(2, new AvoidEntityGoal<PlayerEntity>(this, PlayerEntity.class, 8.0f, 0.6, 1.0));
        this.field_70714_bg.func_75776_a(4, new SummonSpellGoal());
        this.field_70714_bg.func_75776_a(5, new AttackSpellGoal());
        this.field_70714_bg.func_75776_a(6, new WololoSpellGoal());
        this.field_70714_bg.func_75776_a(8, new RandomWalkingGoal(this, 0.6));
        this.field_70714_bg.func_75776_a(9, new LookAtGoal(this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, new LookAtGoal(this, MobEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, new HurtByTargetGoal(this, AbstractRaiderEntity.class).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, new NearestAttackableTargetGoal<PlayerEntity>((MobEntity)this, PlayerEntity.class, true).func_190882_b(300));
        this.field_70715_bh.func_75776_a(3, new NearestAttackableTargetGoal<AbstractVillagerEntity>((MobEntity)this, AbstractVillagerEntity.class, false).func_190882_b(300));
        this.field_70715_bh.func_75776_a(3, new NearestAttackableTargetGoal<IronGolemEntity>((MobEntity)this, IronGolemEntity.class, false));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(12.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(24.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT) {
        super.func_70037_a(compoundNBT);
    }

    @Override
    public SoundEvent func_213654_dW() {
        return SoundEvents.field_219624_cV;
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
    }

    @Override
    protected void func_70619_bc() {
        super.func_70619_bc();
    }

    @Override
    public boolean func_184191_r(Entity entity) {
        if (entity == null) {
            return false;
        }
        if (entity == this) {
            return true;
        }
        if (super.func_184191_r(entity)) {
            return true;
        }
        if (entity instanceof VexEntity) {
            return this.func_184191_r(((VexEntity)entity).func_190645_o());
        }
        if (entity instanceof LivingEntity && ((LivingEntity)entity).func_70668_bt() == CreatureAttribute.field_223225_d_) {
            return this.func_96124_cp() == null && entity.func_96124_cp() == null;
        }
        return false;
    }

    @Override
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_191243_bm;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_191245_bo;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_191246_bp;
    }

    private void func_190748_a(@Nullable SheepEntity sheepEntity) {
        this.field_190763_bw = sheepEntity;
    }

    @Nullable
    private SheepEntity func_190751_dj() {
        return this.field_190763_bw;
    }

    @Override
    protected SoundEvent func_193086_dk() {
        return SoundEvents.field_191244_bn;
    }

    @Override
    public void func_213660_a(int n, boolean bl) {
    }

    public class WololoSpellGoal
    extends SpellcastingIllagerEntity.UseSpellGoal {
        private final EntityPredicate field_220845_e;

        public WololoSpellGoal() {
            super(EvokerEntity.this);
            this.field_220845_e = new EntityPredicate().func_221013_a(16.0).func_221008_a().func_221012_a(livingEntity -> ((SheepEntity)livingEntity).func_175509_cj() == DyeColor.BLUE);
        }

        @Override
        public boolean func_75250_a() {
            if (EvokerEntity.this.func_70638_az() != null) {
                return false;
            }
            if (EvokerEntity.this.func_193082_dl()) {
                return false;
            }
            if (EvokerEntity.this.field_70173_aa < this.field_193322_d) {
                return false;
            }
            if (!EvokerEntity.this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223599_b)) {
                return false;
            }
            List<SheepEntity> list = EvokerEntity.this.field_70170_p.func_217374_a(SheepEntity.class, this.field_220845_e, EvokerEntity.this, EvokerEntity.this.func_174813_aQ().func_72314_b(16.0, 4.0, 16.0));
            if (list.isEmpty()) {
                return false;
            }
            EvokerEntity.this.func_190748_a(list.get(EvokerEntity.this.field_70146_Z.nextInt(list.size())));
            return true;
        }

        @Override
        public boolean func_75253_b() {
            return EvokerEntity.this.func_190751_dj() != null && this.field_193321_c > 0;
        }

        @Override
        public void func_75251_c() {
            super.func_75251_c();
            EvokerEntity.this.func_190748_a(null);
        }

        @Override
        protected void func_190868_j() {
            SheepEntity sheepEntity = EvokerEntity.this.func_190751_dj();
            if (sheepEntity != null && sheepEntity.func_70089_S()) {
                sheepEntity.func_175512_b(DyeColor.RED);
            }
        }

        @Override
        protected int func_190867_m() {
            return 40;
        }

        @Override
        protected int func_190869_f() {
            return 60;
        }

        @Override
        protected int func_190872_i() {
            return 140;
        }

        @Override
        protected SoundEvent func_190871_k() {
            return SoundEvents.field_191249_bs;
        }

        @Override
        protected SpellcastingIllagerEntity.SpellType func_193320_l() {
            return SpellcastingIllagerEntity.SpellType.WOLOLO;
        }
    }

    class SummonSpellGoal
    extends SpellcastingIllagerEntity.UseSpellGoal {
        private final EntityPredicate field_220843_e;

        private SummonSpellGoal() {
            super(EvokerEntity.this);
            this.field_220843_e = new EntityPredicate().func_221013_a(16.0).func_221014_c().func_221010_e().func_221008_a().func_221011_b();
        }

        @Override
        public boolean func_75250_a() {
            if (!super.func_75250_a()) {
                return false;
            }
            int n = EvokerEntity.this.field_70170_p.func_217374_a(VexEntity.class, this.field_220843_e, EvokerEntity.this, EvokerEntity.this.func_174813_aQ().func_186662_g(16.0)).size();
            return EvokerEntity.this.field_70146_Z.nextInt(8) + 1 > n;
        }

        @Override
        protected int func_190869_f() {
            return 100;
        }

        @Override
        protected int func_190872_i() {
            return 340;
        }

        @Override
        protected void func_190868_j() {
            for (int i = 0; i < 3; ++i) {
                BlockPos blockPos = new BlockPos(EvokerEntity.this).func_177982_a(-2 + EvokerEntity.this.field_70146_Z.nextInt(5), 1, -2 + EvokerEntity.this.field_70146_Z.nextInt(5));
                VexEntity \u26032 = EntityType.field_200755_au.func_200721_a(EvokerEntity.this.field_70170_p);
                \u26032.func_174828_a(blockPos, 0.0f, 0.0f);
                \u26032.func_213386_a(EvokerEntity.this.field_70170_p, EvokerEntity.this.field_70170_p.func_175649_E(blockPos), SpawnReason.MOB_SUMMONED, null, null);
                \u26032.func_190658_a(EvokerEntity.this);
                \u26032.func_190651_g(blockPos);
                \u26032.func_190653_a(20 * (30 + EvokerEntity.this.field_70146_Z.nextInt(90)));
                EvokerEntity.this.field_70170_p.func_217376_c(\u26032);
            }
        }

        @Override
        protected SoundEvent func_190871_k() {
            return SoundEvents.field_191248_br;
        }

        @Override
        protected SpellcastingIllagerEntity.SpellType func_193320_l() {
            return SpellcastingIllagerEntity.SpellType.SUMMON_VEX;
        }
    }

    class AttackSpellGoal
    extends SpellcastingIllagerEntity.UseSpellGoal {
        private AttackSpellGoal() {
            super(EvokerEntity.this);
        }

        @Override
        protected int func_190869_f() {
            return 40;
        }

        @Override
        protected int func_190872_i() {
            return 100;
        }

        @Override
        protected void func_190868_j() {
            LivingEntity livingEntity = EvokerEntity.this.func_70638_az();
            double \u26032 = Math.min(livingEntity.func_226278_cu_(), EvokerEntity.this.func_226278_cu_());
            double \u26033 = Math.max(livingEntity.func_226278_cu_(), EvokerEntity.this.func_226278_cu_()) + 1.0;
            float \u26034 = (float)MathHelper.func_181159_b(livingEntity.func_226281_cx_() - EvokerEntity.this.func_226281_cx_(), livingEntity.func_226277_ct_() - EvokerEntity.this.func_226277_ct_());
            if (EvokerEntity.this.func_70068_e(livingEntity) < 9.0) {
                float f;
                int n;
                for (n = 0; n < 5; ++n) {
                    f = \u26034 + (float)n * (float)Math.PI * 0.4f;
                    this.func_190876_a(EvokerEntity.this.func_226277_ct_() + (double)MathHelper.func_76134_b(f) * 1.5, EvokerEntity.this.func_226281_cx_() + (double)MathHelper.func_76126_a(f) * 1.5, \u26032, \u26033, f, 0);
                }
                for (n = 0; n < 8; ++n) {
                    f = \u26034 + (float)n * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                    this.func_190876_a(EvokerEntity.this.func_226277_ct_() + (double)MathHelper.func_76134_b(f) * 2.5, EvokerEntity.this.func_226281_cx_() + (double)MathHelper.func_76126_a(f) * 2.5, \u26032, \u26033, f, 3);
                }
            } else {
                for (int i = 0; i < 16; ++i) {
                    double d = 1.25 * (double)(i + 1);
                    int \u26035 = 1 * i;
                    this.func_190876_a(EvokerEntity.this.func_226277_ct_() + (double)MathHelper.func_76134_b(\u26034) * d, EvokerEntity.this.func_226281_cx_() + (double)MathHelper.func_76126_a(\u26034) * d, \u26032, \u26033, \u26034, \u26035);
                }
            }
        }

        private void func_190876_a(double d, double d2, double d3, double d4, float f, int n) {
            BlockPos blockPos = new BlockPos(d, d4, d2);
            boolean \u26032 = false;
            double \u26033 = 0.0;
            do {
                if (!(\u2603 = EvokerEntity.this.field_70170_p.func_180495_p(\u2603 = blockPos.func_177977_b())).func_224755_d(EvokerEntity.this.field_70170_p, \u2603, Direction.UP)) continue;
                if (!EvokerEntity.this.field_70170_p.func_175623_d(blockPos) && !(\u2603 = (\u2603 = EvokerEntity.this.field_70170_p.func_180495_p(blockPos)).func_196952_d(EvokerEntity.this.field_70170_p, blockPos)).func_197766_b()) {
                    \u26033 = \u2603.func_197758_c(Direction.Axis.Y);
                }
                \u26032 = true;
                break;
            } while ((blockPos = blockPos.func_177977_b()).func_177956_o() >= MathHelper.func_76128_c(d3) - 1);
            if (\u26032) {
                EvokerEntity.this.field_70170_p.func_217376_c(new EvokerFangsEntity(EvokerEntity.this.field_70170_p, d, (double)blockPos.func_177956_o() + \u26033, d2, f, n, EvokerEntity.this));
            }
        }

        @Override
        protected SoundEvent func_190871_k() {
            return SoundEvents.field_191247_bq;
        }

        @Override
        protected SpellcastingIllagerEntity.SpellType func_193320_l() {
            return SpellcastingIllagerEntity.SpellType.FANGS;
        }
    }

    class CastingSpellGoal
    extends SpellcastingIllagerEntity.CastingASpellGoal {
        private CastingSpellGoal() {
            super(EvokerEntity.this);
        }

        @Override
        public void func_75246_d() {
            if (EvokerEntity.this.func_70638_az() != null) {
                EvokerEntity.this.func_70671_ap().func_75651_a(EvokerEntity.this.func_70638_az(), EvokerEntity.this.func_184649_cE(), EvokerEntity.this.func_70646_bf());
            } else if (EvokerEntity.this.func_190751_dj() != null) {
                EvokerEntity.this.func_70671_ap().func_75651_a(EvokerEntity.this.func_190751_dj(), EvokerEntity.this.func_184649_cE(), EvokerEntity.this.func_70646_bf());
            }
        }
    }
}

