/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DispenserBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.fluid.IFluidState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.DispenserTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;

public abstract class StructurePiece {
    protected static final BlockState field_202556_l = Blocks.field_201941_jj.func_176223_P();
    protected MutableBoundingBox field_74887_e;
    @Nullable
    private Direction field_74885_f;
    private Mirror field_186168_b;
    private Rotation field_186169_c;
    protected int field_74886_g;
    private final IStructurePieceType field_214811_d;
    private static final Set<Block> field_211413_d = ImmutableSet.builder().add((Object)Blocks.field_150386_bk).add((Object)Blocks.field_150478_aa).add((Object)Blocks.field_196591_bQ).add((Object)Blocks.field_180407_aO).add((Object)Blocks.field_180408_aP).add((Object)Blocks.field_180406_aS).add((Object)Blocks.field_180405_aT).add((Object)Blocks.field_180404_aQ).add((Object)Blocks.field_180403_aR).add((Object)Blocks.field_150468_ap).add((Object)Blocks.field_150411_aY).build();

    protected StructurePiece(IStructurePieceType iStructurePieceType, int n) {
        this.field_214811_d = iStructurePieceType;
        this.field_74886_g = n;
    }

    public StructurePiece(IStructurePieceType iStructurePieceType, CompoundNBT compoundNBT) {
        this(iStructurePieceType, compoundNBT.func_74762_e("GD"));
        if (compoundNBT.func_74764_b("BB")) {
            this.field_74887_e = new MutableBoundingBox(compoundNBT.func_74759_k("BB"));
        }
        this.func_186164_a((\u2603 = compoundNBT.func_74762_e("O")) == -1 ? null : Direction.func_176731_b(\u2603));
    }

    public final CompoundNBT func_143010_b() {
        CompoundNBT compoundNBT = new CompoundNBT();
        compoundNBT.func_74778_a("id", Registry.field_218362_C.func_177774_c(this.func_214807_k()).toString());
        compoundNBT.func_218657_a("BB", this.field_74887_e.func_151535_h());
        Direction \u26032 = this.func_186165_e();
        compoundNBT.func_74768_a("O", \u26032 == null ? -1 : \u26032.func_176736_b());
        compoundNBT.func_74768_a("GD", this.field_74886_g);
        this.func_143011_b(compoundNBT);
        return compoundNBT;
    }

    protected abstract void func_143011_b(CompoundNBT var1);

    public void func_74861_a(StructurePiece structurePiece, List<StructurePiece> list, Random random) {
    }

    public abstract boolean func_225577_a_(IWorld var1, ChunkGenerator<?> var2, Random var3, MutableBoundingBox var4, ChunkPos var5);

    public MutableBoundingBox func_74874_b() {
        return this.field_74887_e;
    }

    public int func_74877_c() {
        return this.field_74886_g;
    }

    public boolean func_214810_a(ChunkPos chunkPos, int n) {
        \u2603 = chunkPos.field_77276_a << 4;
        \u2603 = chunkPos.field_77275_b << 4;
        return this.field_74887_e.func_78885_a(\u2603 - n, \u2603 - n, \u2603 + 15 + n, \u2603 + 15 + n);
    }

    public static StructurePiece func_74883_a(List<StructurePiece> list, MutableBoundingBox mutableBoundingBox) {
        for (StructurePiece structurePiece : list) {
            if (structurePiece.func_74874_b() == null || !structurePiece.func_74874_b().func_78884_a(mutableBoundingBox)) continue;
            return structurePiece;
        }
        return null;
    }

    protected boolean func_74860_a(IBlockReader iBlockReader, MutableBoundingBox mutableBoundingBox) {
        int n = Math.max(this.field_74887_e.field_78897_a - 1, mutableBoundingBox.field_78897_a);
        \u2603 = Math.max(this.field_74887_e.field_78895_b - 1, mutableBoundingBox.field_78895_b);
        \u2603 = Math.max(this.field_74887_e.field_78896_c - 1, mutableBoundingBox.field_78896_c);
        \u2603 = Math.min(this.field_74887_e.field_78893_d + 1, mutableBoundingBox.field_78893_d);
        \u2603 = Math.min(this.field_74887_e.field_78894_e + 1, mutableBoundingBox.field_78894_e);
        \u2603 = Math.min(this.field_74887_e.field_78892_f + 1, mutableBoundingBox.field_78892_f);
        BlockPos.Mutable \u26032 = new BlockPos.Mutable();
        for (\u2603 = n; \u2603 <= \u2603; ++\u2603) {
            for (\u2603 = \u2603; \u2603 <= \u2603; ++\u2603) {
                if (iBlockReader.func_180495_p(\u26032.func_181079_c(\u2603, \u2603, \u2603)).func_185904_a().func_76224_d()) {
                    return true;
                }
                if (!iBlockReader.func_180495_p(\u26032.func_181079_c(\u2603, \u2603, \u2603)).func_185904_a().func_76224_d()) continue;
                return true;
            }
        }
        for (\u2603 = n; \u2603 <= \u2603; ++\u2603) {
            for (\u2603 = \u2603; \u2603 <= \u2603; ++\u2603) {
                if (iBlockReader.func_180495_p(\u26032.func_181079_c(\u2603, \u2603, \u2603)).func_185904_a().func_76224_d()) {
                    return true;
                }
                if (!iBlockReader.func_180495_p(\u26032.func_181079_c(\u2603, \u2603, \u2603)).func_185904_a().func_76224_d()) continue;
                return true;
            }
        }
        for (\u2603 = \u2603; \u2603 <= \u2603; ++\u2603) {
            for (\u2603 = \u2603; \u2603 <= \u2603; ++\u2603) {
                if (iBlockReader.func_180495_p(\u26032.func_181079_c(n, \u2603, \u2603)).func_185904_a().func_76224_d()) {
                    return true;
                }
                if (!iBlockReader.func_180495_p(\u26032.func_181079_c(\u2603, \u2603, \u2603)).func_185904_a().func_76224_d()) continue;
                return true;
            }
        }
        return false;
    }

    protected int func_74865_a(int n, int n2) {
        Direction direction = this.func_186165_e();
        if (direction == null) {
            return n;
        }
        switch (direction) {
            case NORTH: 
            case SOUTH: {
                return this.field_74887_e.field_78897_a + n;
            }
            case WEST: {
                return this.field_74887_e.field_78893_d - n2;
            }
            case EAST: {
                return this.field_74887_e.field_78897_a + n2;
            }
        }
        return n;
    }

    protected int func_74862_a(int n) {
        if (this.func_186165_e() == null) {
            return n;
        }
        return n + this.field_74887_e.field_78895_b;
    }

    protected int func_74873_b(int n, int n2) {
        Direction direction = this.func_186165_e();
        if (direction == null) {
            return n2;
        }
        switch (direction) {
            case NORTH: {
                return this.field_74887_e.field_78892_f - n2;
            }
            case SOUTH: {
                return this.field_74887_e.field_78896_c + n2;
            }
            case WEST: 
            case EAST: {
                return this.field_74887_e.field_78896_c + n;
            }
        }
        return n2;
    }

    protected void func_175811_a(IWorld iWorld2, BlockState blockState2, int n, int n2, int n3, MutableBoundingBox mutableBoundingBox) {
        IWorld iWorld2;
        BlockState blockState2;
        BlockPos blockPos = new BlockPos(this.func_74865_a(n, n3), this.func_74862_a(n2), this.func_74873_b(n, n3));
        if (!mutableBoundingBox.func_175898_b(blockPos)) {
            return;
        }
        if (this.field_186168_b != Mirror.NONE) {
            blockState2 = blockState2.func_185902_a(this.field_186168_b);
        }
        if (this.field_186169_c != Rotation.NONE) {
            blockState2 = blockState2.func_185907_a(this.field_186169_c);
        }
        iWorld2.func_180501_a(blockPos, blockState2, 2);
        IFluidState \u26032 = iWorld2.func_204610_c(blockPos);
        if (!\u26032.func_206888_e()) {
            iWorld2.func_205219_F_().func_205360_a(blockPos, \u26032.func_206886_c(), 0);
        }
        if (field_211413_d.contains(blockState2.func_177230_c())) {
            iWorld2.func_217349_x(blockPos).func_201594_d(blockPos);
        }
    }

    protected BlockState func_175807_a(IBlockReader iBlockReader, int n, int n2, int n3, MutableBoundingBox mutableBoundingBox) {
        int n4 = this.func_74865_a(n, n3);
        BlockPos \u26032 = new BlockPos(n4, \u2603 = this.func_74862_a(n2), \u2603 = this.func_74873_b(n, n3));
        if (!mutableBoundingBox.func_175898_b(\u26032)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return iBlockReader.func_180495_p(\u26032);
    }

    protected boolean func_189916_b(IWorldReader iWorldReader, int n, int n2, int n3, MutableBoundingBox mutableBoundingBox) {
        int n4 = this.func_74865_a(n, n3);
        BlockPos \u26032 = new BlockPos(n4, \u2603 = this.func_74862_a(n2 + 1), \u2603 = this.func_74873_b(n, n3));
        if (!mutableBoundingBox.func_175898_b(\u26032)) {
            return false;
        }
        return \u2603 < iWorldReader.func_201676_a(Heightmap.Type.OCEAN_FLOOR_WG, n4, \u2603);
    }

    protected void func_74878_a(IWorld iWorld, MutableBoundingBox mutableBoundingBox, int n, int n2, int n3, int n4, int n5, int n6) {
        for (\u2603 = n2; \u2603 <= n5; ++\u2603) {
            for (\u2603 = n; \u2603 <= n4; ++\u2603) {
                for (\u2603 = n3; \u2603 <= n6; ++\u2603) {
                    this.func_175811_a(iWorld, Blocks.field_150350_a.func_176223_P(), \u2603, \u2603, \u2603, mutableBoundingBox);
                }
            }
        }
    }

    protected void func_175804_a(IWorld iWorld, MutableBoundingBox mutableBoundingBox, int n, int n2, int n3, int n4, int n5, int n6, BlockState blockState, BlockState blockState2, boolean bl) {
        for (int i = n2; i <= n5; ++i) {
            for (\u2603 = n; \u2603 <= n4; ++\u2603) {
                for (\u2603 = n3; \u2603 <= n6; ++\u2603) {
                    if (bl && this.func_175807_a(iWorld, \u2603, i, \u2603, mutableBoundingBox).func_196958_f()) continue;
                    if (i == n2 || i == n5 || \u2603 == n || \u2603 == n4 || \u2603 == n3 || \u2603 == n6) {
                        this.func_175811_a(iWorld, blockState, \u2603, i, \u2603, mutableBoundingBox);
                        continue;
                    }
                    this.func_175811_a(iWorld, blockState2, \u2603, i, \u2603, mutableBoundingBox);
                }
            }
        }
    }

    protected void func_74882_a(IWorld iWorld, MutableBoundingBox mutableBoundingBox, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, Random random, BlockSelector blockSelector) {
        for (int i = n2; i <= n5; ++i) {
            for (\u2603 = n; \u2603 <= n4; ++\u2603) {
                for (\u2603 = n3; \u2603 <= n6; ++\u2603) {
                    if (bl && this.func_175807_a(iWorld, \u2603, i, \u2603, mutableBoundingBox).func_196958_f()) continue;
                    blockSelector.func_75062_a(random, \u2603, i, \u2603, i == n2 || i == n5 || \u2603 == n || \u2603 == n4 || \u2603 == n3 || \u2603 == n6);
                    this.func_175811_a(iWorld, blockSelector.func_180780_a(), \u2603, i, \u2603, mutableBoundingBox);
                }
            }
        }
    }

    protected void func_189914_a(IWorld iWorld, MutableBoundingBox mutableBoundingBox, Random random, float f, int n, int n2, int n3, int n4, int n5, int n6, BlockState blockState, BlockState blockState2, boolean bl, boolean bl2) {
        for (int i = n2; i <= n5; ++i) {
            for (\u2603 = n; \u2603 <= n4; ++\u2603) {
                for (\u2603 = n3; \u2603 <= n6; ++\u2603) {
                    if (random.nextFloat() > f || bl && this.func_175807_a(iWorld, \u2603, i, \u2603, mutableBoundingBox).func_196958_f() || bl2 && !this.func_189916_b(iWorld, \u2603, i, \u2603, mutableBoundingBox)) continue;
                    if (i == n2 || i == n5 || \u2603 == n || \u2603 == n4 || \u2603 == n3 || \u2603 == n6) {
                        this.func_175811_a(iWorld, blockState, \u2603, i, \u2603, mutableBoundingBox);
                        continue;
                    }
                    this.func_175811_a(iWorld, blockState2, \u2603, i, \u2603, mutableBoundingBox);
                }
            }
        }
    }

    protected void func_175809_a(IWorld iWorld, MutableBoundingBox mutableBoundingBox, Random random, float f, int n, int n2, int n3, BlockState blockState) {
        if (random.nextFloat() < f) {
            this.func_175811_a(iWorld, blockState, n, n2, n3, mutableBoundingBox);
        }
    }

    protected void func_180777_a(IWorld iWorld, MutableBoundingBox mutableBoundingBox, int n, int n2, int n3, int n4, int n5, int n6, BlockState blockState, boolean bl) {
        float f = n4 - n + 1;
        \u2603 = n5 - n2 + 1;
        \u2603 = n6 - n3 + 1;
        \u2603 = (float)n + f / 2.0f;
        \u2603 = (float)n3 + \u2603 / 2.0f;
        for (int i = n2; i <= n5; ++i) {
            float f2 = (float)(i - n2) / \u2603;
            for (int j = n; j <= n4; ++j) {
                float f3 = ((float)j - \u2603) / (f * 0.5f);
                for (int k = n3; k <= n6; ++k) {
                    float f4 = ((float)k - \u2603) / (\u2603 * 0.5f);
                    if (bl && this.func_175807_a(iWorld, j, i, k, mutableBoundingBox).func_196958_f() || !((\u2603 = f3 * f3 + f2 * f2 + f4 * f4) <= 1.05f)) continue;
                    this.func_175811_a(iWorld, blockState, j, i, k, mutableBoundingBox);
                }
            }
        }
    }

    protected void func_175808_b(IWorld iWorld, BlockState blockState, int n, int n2, int n3, MutableBoundingBox mutableBoundingBox) {
        int n4 = this.func_74865_a(n, n3);
        if (!mutableBoundingBox.func_175898_b(new BlockPos(n4, \u2603 = this.func_74862_a(n2), \u2603 = this.func_74873_b(n, n3)))) {
            return;
        }
        while ((iWorld.func_175623_d(new BlockPos(n4, \u2603, \u2603)) || iWorld.func_180495_p(new BlockPos(n4, \u2603, \u2603)).func_185904_a().func_76224_d()) && \u2603 > 1) {
            iWorld.func_180501_a(new BlockPos(n4, \u2603, \u2603), blockState, 2);
            --\u2603;
        }
    }

    protected boolean func_186167_a(IWorld iWorld, MutableBoundingBox mutableBoundingBox, Random random, int n, int n2, int n3, ResourceLocation resourceLocation) {
        BlockPos blockPos = new BlockPos(this.func_74865_a(n, n3), this.func_74862_a(n2), this.func_74873_b(n, n3));
        return this.func_191080_a(iWorld, mutableBoundingBox, random, blockPos, resourceLocation, null);
    }

    public static BlockState func_197528_a(IBlockReader iBlockReader, BlockPos blockPos, BlockState blockState) {
        Object object = null;
        for (Object object2 : Direction.Plane.HORIZONTAL) {
            BlockPos blockPos2 = blockPos.func_177972_a((Direction)object2);
            BlockState \u26032 = iBlockReader.func_180495_p(blockPos2);
            if (\u26032.func_177230_c() == Blocks.field_150486_ae) {
                return blockState;
            }
            if (!\u26032.func_200015_d(iBlockReader, blockPos2)) continue;
            if (object == null) {
                object = object2;
                continue;
            }
            object = null;
            break;
        }
        if (object != null) {
            return (BlockState)blockState.func_206870_a(HorizontalBlock.field_185512_D, ((Direction)object).func_176734_d());
        }
        Direction \u26033 = blockState.func_177229_b(HorizontalBlock.field_185512_D);
        object2 = blockPos.func_177972_a(\u26033);
        if (iBlockReader.func_180495_p((BlockPos)object2).func_200015_d(iBlockReader, (BlockPos)object2)) {
            \u26033 = \u26033.func_176734_d();
            object2 = blockPos.func_177972_a(\u26033);
        }
        if (iBlockReader.func_180495_p((BlockPos)object2).func_200015_d(iBlockReader, (BlockPos)object2)) {
            \u26033 = \u26033.func_176746_e();
            object2 = blockPos.func_177972_a(\u26033);
        }
        if (iBlockReader.func_180495_p((BlockPos)object2).func_200015_d(iBlockReader, (BlockPos)object2)) {
            \u26033 = \u26033.func_176734_d();
            object2 = blockPos.func_177972_a(\u26033);
        }
        return (BlockState)blockState.func_206870_a(HorizontalBlock.field_185512_D, \u26033);
    }

    protected boolean func_191080_a(IWorld iWorld, MutableBoundingBox mutableBoundingBox, Random random, BlockPos blockPos, ResourceLocation resourceLocation, @Nullable BlockState blockState) {
        if (!mutableBoundingBox.func_175898_b(blockPos) || iWorld.func_180495_p(blockPos).func_177230_c() == Blocks.field_150486_ae) {
            return false;
        }
        if (blockState == null) {
            blockState = StructurePiece.func_197528_a(iWorld, blockPos, Blocks.field_150486_ae.func_176223_P());
        }
        iWorld.func_180501_a(blockPos, blockState, 2);
        TileEntity tileEntity = iWorld.func_175625_s(blockPos);
        if (tileEntity instanceof ChestTileEntity) {
            ((ChestTileEntity)tileEntity).func_189404_a(resourceLocation, random.nextLong());
        }
        return true;
    }

    protected boolean func_189419_a(IWorld iWorld, MutableBoundingBox mutableBoundingBox, Random random, int n, int n2, int n3, Direction direction, ResourceLocation resourceLocation) {
        BlockPos blockPos = new BlockPos(this.func_74865_a(n, n3), this.func_74862_a(n2), this.func_74873_b(n, n3));
        if (mutableBoundingBox.func_175898_b(blockPos) && iWorld.func_180495_p(blockPos).func_177230_c() != Blocks.field_150367_z) {
            this.func_175811_a(iWorld, (BlockState)Blocks.field_150367_z.func_176223_P().func_206870_a(DispenserBlock.field_176441_a, direction), n, n2, n3, mutableBoundingBox);
            TileEntity tileEntity = iWorld.func_175625_s(blockPos);
            if (tileEntity instanceof DispenserTileEntity) {
                ((DispenserTileEntity)tileEntity).func_189404_a(resourceLocation, random.nextLong());
            }
            return true;
        }
        return false;
    }

    public void func_181138_a(int n, int n2, int n3) {
        this.field_74887_e.func_78886_a(n, n2, n3);
    }

    @Nullable
    public Direction func_186165_e() {
        return this.field_74885_f;
    }

    public void func_186164_a(@Nullable Direction direction) {
        this.field_74885_f = direction;
        if (direction == null) {
            this.field_186169_c = Rotation.NONE;
            this.field_186168_b = Mirror.NONE;
        } else {
            switch (direction) {
                case SOUTH: {
                    this.field_186168_b = Mirror.LEFT_RIGHT;
                    this.field_186169_c = Rotation.NONE;
                    break;
                }
                case WEST: {
                    this.field_186168_b = Mirror.LEFT_RIGHT;
                    this.field_186169_c = Rotation.CLOCKWISE_90;
                    break;
                }
                case EAST: {
                    this.field_186168_b = Mirror.NONE;
                    this.field_186169_c = Rotation.CLOCKWISE_90;
                    break;
                }
                default: {
                    this.field_186168_b = Mirror.NONE;
                    this.field_186169_c = Rotation.NONE;
                }
            }
        }
    }

    public Rotation func_214809_Y_() {
        return this.field_186169_c;
    }

    public IStructurePieceType func_214807_k() {
        return this.field_214811_d;
    }

    public static abstract class BlockSelector {
        protected BlockState field_151562_a = Blocks.field_150350_a.func_176223_P();

        protected BlockSelector() {
        }

        public abstract void func_75062_a(Random var1, int var2, int var3, int var4, boolean var5);

        public BlockState func_180780_a() {
            return this.field_151562_a;
        }
    }
}

