/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.command.arguments.BlockStateParser;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.properties.StructureMode;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class TemplateStructurePiece
extends StructurePiece {
    private static final Logger field_214825_d = LogManager.getLogger();
    protected Template field_186176_a;
    protected PlacementSettings field_186177_b;
    protected BlockPos field_186178_c;

    public TemplateStructurePiece(IStructurePieceType iStructurePieceType, int n) {
        super(iStructurePieceType, n);
    }

    public TemplateStructurePiece(IStructurePieceType iStructurePieceType, CompoundNBT compoundNBT) {
        super(iStructurePieceType, compoundNBT);
        this.field_186178_c = new BlockPos(compoundNBT.func_74762_e("TPX"), compoundNBT.func_74762_e("TPY"), compoundNBT.func_74762_e("TPZ"));
    }

    protected void func_186173_a(Template template, BlockPos blockPos, PlacementSettings placementSettings) {
        this.field_186176_a = template;
        this.func_186164_a(Direction.NORTH);
        this.field_186178_c = blockPos;
        this.field_186177_b = placementSettings;
        this.field_74887_e = template.func_215388_b(placementSettings, blockPos);
    }

    @Override
    protected void func_143011_b(CompoundNBT compoundNBT) {
        compoundNBT.func_74768_a("TPX", this.field_186178_c.func_177958_n());
        compoundNBT.func_74768_a("TPY", this.field_186178_c.func_177956_o());
        compoundNBT.func_74768_a("TPZ", this.field_186178_c.func_177952_p());
    }

    @Override
    public boolean func_225577_a_(IWorld iWorld, ChunkGenerator<?> chunkGenerator, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos) {
        this.field_186177_b.func_186223_a(mutableBoundingBox);
        this.field_74887_e = this.field_186176_a.func_215388_b(this.field_186177_b, this.field_186178_c);
        if (this.field_186176_a.func_189962_a(iWorld, this.field_186178_c, this.field_186177_b, 2)) {
            List<Template.BlockInfo> list = this.field_186176_a.func_215381_a(this.field_186178_c, this.field_186177_b, Blocks.field_185779_df);
            for (Template.BlockInfo blockInfo : list) {
                StructureMode structureMode;
                if (blockInfo.field_186244_c == null || (structureMode = StructureMode.valueOf(blockInfo.field_186244_c.func_74779_i("mode"))) != StructureMode.DATA) continue;
                this.func_186175_a(blockInfo.field_186244_c.func_74779_i("metadata"), blockInfo.field_186242_a, iWorld, random, mutableBoundingBox);
            }
            List<Template.BlockInfo> list2 = this.field_186176_a.func_215381_a(this.field_186178_c, this.field_186177_b, Blocks.field_226904_lY_);
            for (Template.BlockInfo blockInfo : list2) {
                if (blockInfo.field_186244_c == null) continue;
                String string = blockInfo.field_186244_c.func_74779_i("final_state");
                BlockStateParser \u26032 = new BlockStateParser(new StringReader(string), false);
                BlockState \u26033 = Blocks.field_150350_a.func_176223_P();
                try {
                    \u26032.func_197243_a(true);
                    BlockState blockState = \u26032.func_197249_b();
                    if (blockState != null) {
                        \u26033 = blockState;
                    } else {
                        field_214825_d.error("Error while parsing blockstate {} in jigsaw block @ {}", (Object)string, (Object)blockInfo.field_186242_a);
                    }
                }
                catch (CommandSyntaxException commandSyntaxException) {
                    field_214825_d.error("Error while parsing blockstate {} in jigsaw block @ {}", (Object)string, (Object)blockInfo.field_186242_a);
                }
                iWorld.func_180501_a(blockInfo.field_186242_a, \u26033, 3);
            }
        }
        return true;
    }

    protected abstract void func_186175_a(String var1, BlockPos var2, IWorld var3, Random var4, MutableBoundingBox var5);

    @Override
    public void func_181138_a(int n, int n2, int n3) {
        super.func_181138_a(n, n2, n3);
        this.field_186178_c = this.field_186178_c.func_177982_a(n, n2, n3);
    }

    @Override
    public Rotation func_214809_Y_() {
        return this.field_186177_b.func_186215_c();
    }
}

