/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.data;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.LootTableProvider;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootParameterSet;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.ParentedLootEntry;
import net.minecraft.world.storage.loot.ValidationTracker;
import net.minecraft.world.storage.loot.conditions.Alternative;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraft.world.storage.loot.conditions.Inverted;
import net.minecraft.world.storage.loot.conditions.MatchTool;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class ForgeLootTableProvider
extends LootTableProvider {
    public ForgeLootTableProvider(DataGenerator gen) {
        super(gen);
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationTracker validationtracker) {
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
        return super.getTables().stream().map(pair -> new Pair(() -> this.replaceAndFilterChangesOnly((Consumer)((Supplier)pair.getFirst()).get()), pair.getSecond())).collect(Collectors.toList());
    }

    private Consumer<BiConsumer<ResourceLocation, LootTable.Builder>> replaceAndFilterChangesOnly(Consumer<BiConsumer<ResourceLocation, LootTable.Builder>> consumer) {
        return newConsumer -> consumer.accept((resourceLocation, builder) -> {
            if (this.findAndReplaceInLootTableBuilder((LootTable.Builder)builder, Items.field_151097_aZ, Tags.Items.SHEARS)) {
                newConsumer.accept(resourceLocation, builder);
            }
        });
    }

    private boolean findAndReplaceInLootTableBuilder(LootTable.Builder builder, Item from, Tag<Item> to) {
        List lootPools = (List)ObfuscationReflectionHelper.getPrivateValue(LootTable.Builder.class, builder, "field_216041_a");
        boolean found = false;
        if (lootPools == null) {
            throw new IllegalStateException(LootTable.Builder.class.getName() + " is missing field field_216041_a");
        }
        for (LootPool lootPool : lootPools) {
            if (!this.findAndReplaceInLootPool(lootPool, from, to)) continue;
            found = true;
        }
        return found;
    }

    private boolean findAndReplaceInLootPool(LootPool lootPool, Item from, Tag<Item> to) {
        List lootEntries = (List)ObfuscationReflectionHelper.getPrivateValue(LootPool.class, lootPool, "field_186453_a");
        List lootConditions = (List)ObfuscationReflectionHelper.getPrivateValue(LootPool.class, lootPool, "field_186454_b");
        boolean found = false;
        if (lootEntries == null) {
            throw new IllegalStateException(LootPool.class.getName() + " is missing field field_186453_a");
        }
        for (LootEntry lootEntry : lootEntries) {
            if (!(lootEntry instanceof ParentedLootEntry) || !this.findAndReplaceInParentedLootEntry((ParentedLootEntry)lootEntry, from, to)) continue;
            found = true;
        }
        if (lootConditions == null) {
            throw new IllegalStateException(LootPool.class.getName() + " is missing field field_186454_b");
        }
        for (int i = 0; i < lootConditions.size(); ++i) {
            ILootCondition lootCondition = (ILootCondition)lootConditions.get(i);
            if (lootCondition instanceof MatchTool && this.checkMatchTool((MatchTool)lootCondition, from)) {
                lootConditions.set(i, MatchTool.func_216012_a((ItemPredicate.Builder)ItemPredicate.Builder.func_200309_a().func_200307_a(to)).build());
                found = true;
                continue;
            }
            if (!(lootCondition instanceof Inverted)) continue;
            ILootCondition invLootCondition = (ILootCondition)ObfuscationReflectionHelper.getPrivateValue(Inverted.class, (Inverted)lootCondition, "field_215981_a");
            if (invLootCondition instanceof MatchTool && this.checkMatchTool((MatchTool)invLootCondition, from)) {
                lootConditions.set(i, Inverted.func_215979_a((ILootCondition.IBuilder)MatchTool.func_216012_a((ItemPredicate.Builder)ItemPredicate.Builder.func_200309_a().func_200307_a(to))).build());
                found = true;
                continue;
            }
            if (!(invLootCondition instanceof Alternative) || !this.findAndReplaceInAlternative((Alternative)invLootCondition, from, to)) continue;
            found = true;
        }
        return found;
    }

    private boolean findAndReplaceInParentedLootEntry(ParentedLootEntry entry, Item from, Tag<Item> to) {
        LootEntry[] lootEntries = (LootEntry[])ObfuscationReflectionHelper.getPrivateValue(ParentedLootEntry.class, entry, "field_216147_c");
        boolean found = false;
        if (lootEntries == null) {
            throw new IllegalStateException(ParentedLootEntry.class.getName() + " is missing field field_216147_c");
        }
        for (LootEntry lootEntry : lootEntries) {
            if (!this.findAndReplaceInLootEntry(lootEntry, from, to)) continue;
            found = true;
        }
        return found;
    }

    private boolean findAndReplaceInLootEntry(LootEntry entry, Item from, Tag<Item> to) {
        ILootCondition[] lootConditions = (ILootCondition[])ObfuscationReflectionHelper.getPrivateValue(LootEntry.class, entry, "field_216144_d");
        boolean found = false;
        if (lootConditions == null) {
            throw new IllegalStateException(LootEntry.class.getName() + " is missing field field_216144_d");
        }
        for (int i = 0; i < lootConditions.length; ++i) {
            if (lootConditions[i] instanceof Alternative && this.findAndReplaceInAlternative((Alternative)lootConditions[i], from, to)) {
                found = true;
                continue;
            }
            if (!(lootConditions[i] instanceof MatchTool) || !this.checkMatchTool((MatchTool)lootConditions[i], from)) continue;
            lootConditions[i] = MatchTool.func_216012_a((ItemPredicate.Builder)ItemPredicate.Builder.func_200309_a().func_200307_a(to)).build();
            found = true;
        }
        return found;
    }

    private boolean findAndReplaceInAlternative(Alternative alternative, Item from, Tag<Item> to) {
        ILootCondition[] lootConditions = (ILootCondition[])ObfuscationReflectionHelper.getPrivateValue(Alternative.class, alternative, "field_215962_a");
        boolean found = false;
        if (lootConditions == null) {
            throw new IllegalStateException(Alternative.class.getName() + " is missing field field_215962_a");
        }
        for (int i = 0; i < lootConditions.length; ++i) {
            if (!(lootConditions[i] instanceof MatchTool) || !this.checkMatchTool((MatchTool)lootConditions[i], from)) continue;
            lootConditions[i] = MatchTool.func_216012_a((ItemPredicate.Builder)ItemPredicate.Builder.func_200309_a().func_200307_a(to)).build();
            found = true;
        }
        return found;
    }

    private boolean checkMatchTool(MatchTool lootCondition, Item expected) {
        ItemPredicate predicate = (ItemPredicate)ObfuscationReflectionHelper.getPrivateValue(MatchTool.class, lootCondition, "field_216014_a");
        Item item = (Item)ObfuscationReflectionHelper.getPrivateValue(ItemPredicate.class, predicate, "field_192496_b");
        return item != null && item.equals(expected);
    }
}

