/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.extensions;

import com.google.gson.JsonArray;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagCollection;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.data.IOptionalTagEntry;

public interface IForgeTagBuilder<T> {
    default public Tag.Builder<T> addOptional(TagCollection<T> collection, ResourceLocation ... locations) {
        return this.addOptional(collection, Arrays.asList(locations));
    }

    default public Tag.Builder<T> addOptional(TagCollection<T> collection, Collection<ResourceLocation> locations) {
        return this.addOptional(collection.getEntryLookup(), locations);
    }

    @Deprecated
    default public Tag.Builder<T> addOptional(final Function<ResourceLocation, Optional<T>> entryLookup, final Collection<ResourceLocation> locations) {
        return ((Tag.Builder)this).func_200575_a((Tag.ITagEntry)new IOptionalTagEntry<T>(){

            public void func_200162_a(Collection<T> itemsIn) {
                locations.stream().map(entryLookup).forEach(e -> e.ifPresent(itemsIn::add));
            }

            public void func_200576_a(JsonArray array, Function<T, ResourceLocation> getNameForObject) {
                locations.stream().map(ResourceLocation::toString).forEach(arg_0 -> ((JsonArray)array).add(arg_0));
            }
        });
    }

    default public Tag.Builder<T> addOptionalTag(TagCollection<T> collection, Tag<T> ... tags) {
        for (Tag<T> tag : tags) {
            this.addOptionalTag(tag.func_199886_b());
        }
        return (Tag.Builder)this;
    }

    default public Tag.Builder<T> addOptionalTag(ResourceLocation ... tags) {
        for (ResourceLocation rl : tags) {
            this.addOptionalTag(rl);
        }
        return (Tag.Builder)this;
    }

    default public Tag.Builder<T> addOptionalTag(ResourceLocation tag) {
        class TagTarget<U>
        extends Tag.TagEntry<U>
        implements IOptionalTagEntry<U> {
            private Tag<U> resolvedTag;

            protected TagTarget(ResourceLocation referent) {
                super(referent);
                this.resolvedTag = null;
            }

            public boolean func_200161_a(@Nonnull Function<ResourceLocation, Tag<U>> resolver) {
                if (this.resolvedTag == null) {
                    this.resolvedTag = resolver.apply(this.func_200577_a());
                }
                return true;
            }

            public void func_200162_a(@Nonnull Collection<U> items) {
                if (this.resolvedTag != null) {
                    items.addAll(this.resolvedTag.func_199885_a());
                }
            }
        }
        return ((Tag.Builder)this).func_200575_a(new TagTarget(tag));
    }
}

