/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.relauncher.libraries;

import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.relauncher.libraries.Artifact;
import net.minecraftforge.fml.relauncher.libraries.LinkRepository;
import net.minecraftforge.fml.relauncher.libraries.MemoryModList;
import net.minecraftforge.fml.relauncher.libraries.ModList;
import net.minecraftforge.fml.relauncher.libraries.Repository;
import net.minecraftforge.fml.relauncher.libraries.SnapshotJson;
import net.minecraftforge.versions.mcp.MCPVersion;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.artifact.versioning.ArtifactVersion;

public class LibraryManager {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final boolean DISABLE_EXTERNAL_MANIFEST = Boolean.parseBoolean(System.getProperty("forge.disable_external_manifest", "false"));
    public static final boolean ENABLE_AUTO_MOD_MOVEMENT = Boolean.parseBoolean(System.getProperty("forge.enable_auto_mod_movement", "false"));
    private static final String LIBRARY_DIRECTORY_OVERRIDE = System.getProperty("forge.lib_folder", null);
    private static final List<String> skipContainedDeps = Arrays.asList(System.getProperty("fml.skipContainedDeps", "").split(","));
    private static final FilenameFilter MOD_FILENAME_FILTER = (dir, name) -> name.endsWith(".jar") || name.endsWith(".zip");
    private static final Comparator<File> FILE_NAME_SORTER_INSENSITVE = (o1, o2) -> o1.getName().toLowerCase(Locale.ENGLISH).compareTo(o2.getName().toLowerCase(Locale.ENGLISH));
    public static final Attributes.Name MODSIDE = new Attributes.Name("ModSide");
    private static final Attributes.Name MODCONTAINSDEPS = new Attributes.Name("ContainedDeps");
    private static final Attributes.Name MAVEN_ARTIFACT = new Attributes.Name("Maven-Artifact");
    private static final Attributes.Name TIMESTAMP = new Attributes.Name("Timestamp");
    private static final Attributes.Name MD5 = new Attributes.Name("MD5");
    private static Repository libraries_dir = null;
    private static Set<File> processed = new HashSet<File>();

    public static void setup(File minecraftHome) {
        File libDir = LibraryManager.findLibraryFolder(minecraftHome);
        LOGGER.debug("Determined Minecraft Libraries Root: {}", (Object)libDir);
        Repository old = Repository.replace(libDir, "libraries");
        if (old != null) {
            LOGGER.debug("  Overwriting Previous: {}", (Object)old);
        }
        libraries_dir = Repository.get("libraries");
        File mods = new File(minecraftHome, "mods");
        File mods_ver = new File(mods, MCPVersion.getMCVersion());
        MemoryModList memory = null;
        if (!ENABLE_AUTO_MOD_MOVEMENT) {
            LinkRepository repo = new LinkRepository(new File(mods, "memory_repo"));
            memory = new MemoryModList(repo);
            ModList.cache.put("MEMORY", memory);
            Repository.cache.put("MEMORY", repo);
        }
        for (File dir : new File[]{mods, mods_ver}) {
            LibraryManager.cleanDirectory(dir, ENABLE_AUTO_MOD_MOVEMENT ? ModList.create(new File(dir, "mod_list.json"), minecraftHome) : memory, mods_ver, mods);
        }
        for (ModList list : ModList.getKnownLists(minecraftHome)) {
            Repository repo = list.getRepository() == null ? libraries_dir : list.getRepository();
            List<Artifact> artifacts = list.getArtifacts();
            for (int i = 0; i < artifacts.size(); ++i) {
                File target;
                Artifact artifact = artifacts.get(i);
                Artifact resolved = repo.resolve(artifact);
                if (resolved == null || !(target = repo.getFile(resolved.getPath())).exists()) continue;
                LibraryManager.extractPacked(target, list, mods_ver, mods);
            }
        }
    }

    private static File findLibraryFolder(File minecraftHome) {
        if (LIBRARY_DIRECTORY_OVERRIDE != null) {
            LOGGER.error("System variable set to override Library Directory: {}", (Object)LIBRARY_DIRECTORY_OVERRIDE);
            return new File(LIBRARY_DIRECTORY_OVERRIDE);
        }
        CodeSource source = ArtifactVersion.class.getProtectionDomain().getCodeSource();
        if (source == null) {
            LOGGER.error("Unable to determine codesource for {}. Using default libraries directory.", (Object)ArtifactVersion.class.getName());
            return new File(minecraftHome, "libraries");
        }
        try {
            String comp;
            File apache = new File(source.getLocation().toURI());
            if (apache.isFile()) {
                apache = apache.getParentFile();
            }
            if (!(comp = (apache = apache.getParentFile()).getAbsolutePath().toLowerCase(Locale.ENGLISH).replace('\\', '/')).endsWith("/")) {
                comp = comp + '/';
            }
            if (!comp.endsWith("/org/apache/maven/maven-artifact/")) {
                LOGGER.error("Apache Maven library folder was not in the format expected. Using default libraries directory.");
                LOGGER.error("Full: {}", (Object)new File(source.getLocation().toURI()));
                LOGGER.error("Trimmed: {}", (Object)comp);
                return new File(minecraftHome, "libraries");
            }
            return apache.getParentFile().getParentFile().getParentFile().getParentFile();
        }
        catch (URISyntaxException e) {
            LOGGER.error(LOGGER.getMessageFactory().newMessage("Unable to determine file for {}. Using default libraries directory.", new Object[]{ArtifactVersion.class.getName()}), (Throwable)e);
            return new File(minecraftHome, "libraries");
        }
    }

    private static void cleanDirectory(File dir, ModList modlist, File ... modDirs) {
        if (!dir.exists()) {
            return;
        }
        LOGGER.debug("Cleaning up mods folder: {}", (Object)dir);
        for (File file : dir.listFiles(f -> f.isFile() && f.getName().endsWith(".jar"))) {
            Pair<Artifact, byte[]> ret = LibraryManager.extractPacked(file, modlist, modDirs);
            if (ret == null) continue;
            Artifact artifact = (Artifact)ret.getLeft();
            Repository repo = modlist.getRepository() == null ? libraries_dir : modlist.getRepository();
            File moved = repo.archive(artifact, file, (byte[])ret.getRight());
            processed.add(moved);
        }
        try {
            if (modlist.changed()) {
                modlist.save();
            }
        }
        catch (IOException e) {
            LOGGER.error(LOGGER.getMessageFactory().newMessage("Error updating modlist file {}", new Object[]{modlist.getName()}), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Pair<Artifact, byte[]> extractPacked(File file, ModList modlist, File ... modDirs) {
        if (processed.contains(file)) {
            LOGGER.debug("File already proccessed {}, Skipping", (Object)file.getAbsolutePath());
            return null;
        }
        JarFile jar = null;
        try {
            jar = new JarFile(file);
            LOGGER.debug("Examining file: {}", (Object)file.getName());
            processed.add(file);
            Pair<Artifact, byte[]> pair = LibraryManager.extractPacked(jar, modlist, modDirs);
            return pair;
        }
        catch (IOException ioe) {
            LOGGER.error("Unable to read the jar file {} - ignoring", (Object)file.getName(), (Object)ioe);
        }
        finally {
            try {
                if (jar != null) {
                    jar.close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    private static Pair<Artifact, byte[]> extractPacked(JarFile jar, ModList modlist, File ... modDirs) throws IOException {
        Attributes attrs;
        String modSide;
        if (jar.getManifest() == null) {
            return null;
        }
        JarEntry manifest_entry = jar.getJarEntry("META-INF/MANIFEST.MF");
        if (manifest_entry == null) {
            manifest_entry = jar.stream().filter(e -> "META-INF/MANIFEST.MF".equals(e.getName().toUpperCase(Locale.ENGLISH))).findFirst().get();
        }
        if ((modSide = (attrs = jar.getManifest().getMainAttributes()).getValue(MODSIDE)) != null && !"BOTH".equals(modSide) && !FMLEnvironment.dist.name().equals(modSide)) {
            return null;
        }
        if (attrs.containsKey(MODCONTAINSDEPS)) {
            for (String dep : attrs.getValue(MODCONTAINSDEPS).split(" ")) {
                Throwable throwable;
                InputStream in;
                File target;
                JarEntry depEntry;
                if (!dep.endsWith(".jar")) {
                    LOGGER.error("Contained Dep is not a jar file: {}", (Object)dep);
                    throw new IllegalStateException("Invalid contained dep, Must be jar: " + dep);
                }
                if (jar.getJarEntry(dep) == null && jar.getJarEntry("META-INF/libraries/" + dep) != null) {
                    dep = "META-INF/libraries/" + dep;
                }
                if ((depEntry = jar.getJarEntry(dep)) == null) {
                    LOGGER.error("Contained Dep is not in the jar: {}", (Object)dep);
                    throw new IllegalStateException("Invalid contained dep, Missing from jar: " + dep);
                }
                String depEndName = new File(dep).getName();
                if (skipContainedDeps.contains(dep) || skipContainedDeps.contains(depEndName)) {
                    LOGGER.error("Skipping dep at request: {}", (Object)dep);
                    continue;
                }
                Attributes meta = null;
                byte[] data = null;
                byte[] manifest_data = null;
                JarEntry metaEntry = jar.getJarEntry(dep + ".meta");
                if (metaEntry != null) {
                    manifest_data = LibraryManager.readAll(jar.getInputStream(metaEntry));
                    meta = new Manifest(new ByteArrayInputStream(manifest_data)).getMainAttributes();
                } else {
                    data = LibraryManager.readAll(jar.getInputStream(depEntry));
                    ZipInputStream zi = new ZipInputStream(new ByteArrayInputStream(data));
                    Object object = null;
                    try {
                        ZipEntry ze = null;
                        while ((ze = zi.getNextEntry()) != null) {
                            if (!ze.getName().equalsIgnoreCase("META-INF/MANIFEST.MF")) continue;
                            manifest_data = LibraryManager.readAll(zi);
                            meta = new Manifest(new ByteArrayInputStream(manifest_data)).getMainAttributes();
                            break;
                        }
                    }
                    catch (Throwable ze) {
                        object = ze;
                        throw ze;
                    }
                    finally {
                        if (zi != null) {
                            if (object != null) {
                                try {
                                    zi.close();
                                }
                                catch (Throwable ze) {
                                    ((Throwable)object).addSuppressed(ze);
                                }
                            } else {
                                zi.close();
                            }
                        }
                    }
                }
                if (meta == null || !meta.containsKey(MAVEN_ARTIFACT)) {
                    boolean found = false;
                    for (File dir : modDirs) {
                        File target2 = new File(dir, depEndName);
                        if (!target2.exists()) continue;
                        LOGGER.debug("Found existing ContainDep extracted to {}, skipping extraction", (Object)target2.getCanonicalPath());
                        found = true;
                    }
                    if (found) continue;
                    target = new File(modDirs[0], depEndName);
                    LOGGER.debug("Extracting ContainedDep {} from {} to {}", (Object)dep, (Object)jar.getName(), (Object)target.getCanonicalPath());
                    try {
                        Files.createParentDirs((File)target);
                        try (FileOutputStream out = new FileOutputStream(target);){
                            in = data == null ? jar.getInputStream(depEntry) : new ByteArrayInputStream(data);
                            throwable = null;
                            try {
                                ByteStreams.copy((InputStream)in, (OutputStream)out);
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (in != null) {
                                    if (throwable != null) {
                                        try {
                                            in.close();
                                        }
                                        catch (Throwable throwable3) {
                                            throwable.addSuppressed(throwable3);
                                        }
                                    } else {
                                        in.close();
                                    }
                                }
                            }
                        }
                        LOGGER.debug("Extracted ContainedDep {} from {} to {}", (Object)dep, (Object)jar.getName(), (Object)target.getCanonicalPath());
                        LibraryManager.extractPacked(target, modlist, modDirs);
                    }
                    catch (IOException e2) {
                        LOGGER.error("An error occurred extracting dependency", (Throwable)e2);
                    }
                    continue;
                }
                try {
                    Pair<Artifact, byte[]> child;
                    Artifact artifact = LibraryManager.readArtifact(modlist.getRepository(), meta);
                    target = artifact.getFile();
                    if (target.exists()) {
                        LOGGER.debug("Found existing ContainedDep {}({}) from {} extracted to {}, skipping extraction", (Object)dep, (Object)artifact.toString(), (Object)target.getCanonicalPath(), (Object)jar.getName());
                        if (ENABLE_AUTO_MOD_MOVEMENT || (child = LibraryManager.extractPacked(target, modlist, modDirs)) != null || metaEntry == null) continue;
                        modlist.add(artifact);
                        continue;
                    }
                    LOGGER.debug("Extracting ContainedDep {}({}) from {} to {}", (Object)dep, (Object)artifact.toString(), (Object)jar.getName(), (Object)target.getCanonicalPath());
                    Files.createParentDirs((File)target);
                    try (FileOutputStream out = new FileOutputStream(target);){
                        in = data == null ? jar.getInputStream(depEntry) : new ByteArrayInputStream(data);
                        throwable = null;
                        try {
                            ByteStreams.copy((InputStream)in, (OutputStream)out);
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (in != null) {
                                if (throwable != null) {
                                    try {
                                        in.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                } else {
                                    in.close();
                                }
                            }
                        }
                    }
                    LOGGER.debug("Extracted ContainedDep {}({}) from {} to {}", (Object)dep, (Object)artifact.toString(), (Object)jar.getName(), (Object)target.getCanonicalPath());
                    if (artifact.isSnapshot()) {
                        SnapshotJson json = SnapshotJson.create(artifact.getSnapshotMeta());
                        json.add(new SnapshotJson.Entry(artifact.getTimestamp(), meta.getValue(MD5)));
                        json.write(artifact.getSnapshotMeta());
                    }
                    if (!DISABLE_EXTERNAL_MANIFEST) {
                        File meta_target = new File(target.getAbsolutePath() + ".meta");
                        Files.write((byte[])manifest_data, (File)meta_target);
                    }
                    if ((child = LibraryManager.extractPacked(target, modlist, modDirs)) != null || metaEntry == null) continue;
                    modlist.add(artifact);
                }
                catch (NumberFormatException nfe) {
                    LOGGER.error(LOGGER.getMessageFactory().newMessage("An error occurred extracting dependency. Invalid Timestamp: {}", new Object[]{meta.getValue(TIMESTAMP)}), (Throwable)nfe);
                }
                catch (IOException e3) {
                    LOGGER.error("An error occurred extracting dependency", (Throwable)e3);
                }
            }
        }
        if (attrs.containsKey(MAVEN_ARTIFACT)) {
            Artifact artifact = LibraryManager.readArtifact(modlist.getRepository(), attrs);
            modlist.add(artifact);
            return Pair.of((Object)artifact, (Object)LibraryManager.readAll(jar.getInputStream(manifest_entry)));
        }
        return null;
    }

    private static Artifact readArtifact(Repository repo, Attributes meta) {
        String timestamp = meta.getValue(TIMESTAMP);
        if (timestamp != null) {
            timestamp = SnapshotJson.TIMESTAMP.format(new Date(Long.parseLong(timestamp)));
        }
        return new Artifact(repo, meta.getValue(MAVEN_ARTIFACT), timestamp);
    }

    private static byte[] readAll(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int read = -1;
        byte[] data = new byte[16384];
        while ((read = in.read(data, 0, data.length)) != -1) {
            out.write(data, 0, read);
        }
        out.flush();
        return out.toByteArray();
    }

    public static List<Artifact> flattenLists(File mcDir) {
        ArrayList<Artifact> merged = new ArrayList<Artifact>();
        for (ModList list : ModList.getBasicLists(mcDir)) {
            for (Artifact art : list.flatten()) {
                Optional<Artifact> old = merged.stream().filter(art::matchesID).findFirst();
                if (!old.isPresent()) {
                    merged.add(art);
                    continue;
                }
                if (old.get().getVersion().compareTo(art.getVersion()) >= 0) continue;
                merged.add(merged.indexOf(old.get()), art);
                merged.remove(old.get());
            }
        }
        return merged;
    }

    public static List<File> gatherLegacyCanidates(File mcDir) {
        ArrayList<File> list = new ArrayList<File>();
        Map args = Collections.emptyMap();
        String extraMods = (String)args.get("--mods");
        if (extraMods != null) {
            LOGGER.info("Found mods from the command line:");
            for (String mod : extraMods.split(",")) {
                File file = new File(mcDir, mod);
                if (!file.exists()) {
                    LOGGER.info("  Failed to find mod file {} ({})", (Object)mod, (Object)file.getAbsolutePath());
                    continue;
                }
                if (!list.contains(file)) {
                    LOGGER.debug("  Adding {} ({}) to the mod list", (Object)mod, (Object)file.getAbsolutePath());
                    list.add(file);
                    continue;
                }
                if (list.contains(file)) continue;
                LOGGER.debug("  Duplicte command line mod detected {} ({})", (Object)mod, (Object)file.getAbsolutePath());
            }
        }
        for (String dir : new String[]{"mods", "mods" + File.separatorChar + MCPVersion.getMCVersion()}) {
            File base = new File(mcDir, dir);
            if (!base.isDirectory() || !base.exists()) continue;
            LOGGER.info("Searching {} for mods", (Object)base.getAbsolutePath());
            for (File f : base.listFiles(MOD_FILENAME_FILTER)) {
                if (list.contains(f)) continue;
                LOGGER.debug("  Adding {} to the mod list", (Object)f.getName());
                list.add(f);
            }
        }
        ModList memory = ModList.cache.get("MEMORY");
        if (!ENABLE_AUTO_MOD_MOVEMENT && memory != null && memory.getRepository() != null) {
            memory.getRepository().filterLegacy(list);
        }
        list.sort(FILE_NAME_SORTER_INSENSITVE);
        return list;
    }

    public static Repository getDefaultRepo() {
        return libraries_dir;
    }
}

