/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.fastcsv.writer;

import de.siegmar.fastcsv.writer.FastBufferedWriter;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.Writer;

public final class CsvAppender
implements Closeable,
Flushable {
    private static final char LF = '\n';
    private static final char CR = '\r';
    private final Writer writer;
    private final char fieldSeparator;
    private final char textDelimiter;
    private final boolean alwaysDelimitText;
    private final char[] lineDelimiter;
    private boolean newline = true;

    CsvAppender(Writer writer, char fieldSeparator, char textDelimiter, boolean alwaysDelimitText, char[] lineDelimiter) {
        this.writer = new FastBufferedWriter(writer);
        this.fieldSeparator = fieldSeparator;
        this.textDelimiter = textDelimiter;
        this.alwaysDelimitText = alwaysDelimitText;
        this.lineDelimiter = lineDelimiter;
    }

    public void appendField(String value) throws IOException {
        if (!this.newline) {
            this.writer.write(this.fieldSeparator);
        } else {
            this.newline = false;
        }
        if (value == null) {
            if (this.alwaysDelimitText) {
                this.writer.write(this.textDelimiter);
                this.writer.write(this.textDelimiter);
            }
            return;
        }
        char[] valueChars = value.toCharArray();
        boolean needsTextDelimiter = this.alwaysDelimitText;
        boolean containsTextDelimiter = false;
        for (char c : valueChars) {
            if (c == this.textDelimiter) {
                needsTextDelimiter = true;
                containsTextDelimiter = true;
                break;
            }
            if (c != this.fieldSeparator && c != '\n' && c != '\r') continue;
            needsTextDelimiter = true;
        }
        if (needsTextDelimiter) {
            this.writer.write(this.textDelimiter);
        }
        if (containsTextDelimiter) {
            for (char c : valueChars) {
                if (c == this.textDelimiter) {
                    this.writer.write(this.textDelimiter);
                }
                this.writer.write(c);
            }
        } else {
            this.writer.write(valueChars);
        }
        if (needsTextDelimiter) {
            this.writer.write(this.textDelimiter);
        }
    }

    public void appendLine(String ... values) throws IOException {
        for (String value : values) {
            this.appendField(value);
        }
        this.endLine();
    }

    public void endLine() throws IOException {
        this.writer.write(this.lineDelimiter);
        this.newline = true;
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }
}

