/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.ConditionArrayParser;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.crafting.ConditionalAdvancement;
import org.apache.commons.lang3.ArrayUtils;

public class Advancement {
    private final Advancement field_192076_a;
    private final DisplayInfo field_192077_b;
    private final AdvancementRewards field_192078_c;
    private final ResourceLocation field_192079_d;
    private final Map<String, Criterion> field_192080_e;
    private final String[][] field_192081_f;
    private final Set<Advancement> field_192082_g = Sets.newLinkedHashSet();
    private final ITextComponent field_193125_h;

    public Advancement(ResourceLocation id, @Nullable Advancement parentIn, @Nullable DisplayInfo displayIn, AdvancementRewards rewardsIn, Map<String, Criterion> criteriaIn, String[][] requirementsIn) {
        this.field_192079_d = id;
        this.field_192077_b = displayIn;
        this.field_192080_e = ImmutableMap.copyOf(criteriaIn);
        this.field_192076_a = parentIn;
        this.field_192078_c = rewardsIn;
        this.field_192081_f = requirementsIn;
        if (parentIn != null) {
            parentIn.func_192071_a(this);
        }
        if (displayIn == null) {
            this.field_193125_h = new StringTextComponent(id.toString());
        } else {
            ITextComponent itextcomponent = displayIn.func_192297_a();
            TextFormatting textformatting = displayIn.func_192291_d().func_193229_c();
            IFormattableTextComponent itextcomponent1 = TextComponentUtils.func_240648_a_((IFormattableTextComponent)itextcomponent.func_230532_e_(), (Style)Style.field_240709_b_.func_240712_a_(textformatting)).func_240702_b_("\n").func_230529_a_(displayIn.func_193222_b());
            IFormattableTextComponent itextcomponent2 = itextcomponent.func_230532_e_().func_240700_a_(arg_0 -> Advancement.lambda$new$0((ITextComponent)itextcomponent1, arg_0));
            this.field_193125_h = new StringTextComponent("[").func_230529_a_((ITextComponent)itextcomponent2).func_240702_b_("]").func_240699_a_(textformatting);
        }
    }

    public Builder func_192075_a() {
        return new Builder(this.field_192076_a == null ? null : this.field_192076_a.func_192067_g(), this.field_192077_b, this.field_192078_c, this.field_192080_e, this.field_192081_f);
    }

    @Nullable
    public Advancement func_192070_b() {
        return this.field_192076_a;
    }

    @Nullable
    public DisplayInfo func_192068_c() {
        return this.field_192077_b;
    }

    public AdvancementRewards func_192072_d() {
        return this.field_192078_c;
    }

    public String toString() {
        return "SimpleAdvancement{id=" + this.func_192067_g() + ", parent=" + (this.field_192076_a == null ? "null" : this.field_192076_a.func_192067_g()) + ", display=" + this.field_192077_b + ", rewards=" + this.field_192078_c + ", criteria=" + this.field_192080_e + ", requirements=" + Arrays.deepToString((Object[])this.field_192081_f) + '}';
    }

    public Iterable<Advancement> func_192069_e() {
        return this.field_192082_g;
    }

    public Map<String, Criterion> func_192073_f() {
        return this.field_192080_e;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_193124_g() {
        return this.field_192081_f.length;
    }

    public void func_192071_a(Advancement advancementIn) {
        this.field_192082_g.add(advancementIn);
    }

    public ResourceLocation func_192067_g() {
        return this.field_192079_d;
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (!(p_equals_1_ instanceof Advancement)) {
            return false;
        }
        Advancement advancement = (Advancement)p_equals_1_;
        return this.field_192079_d.equals((Object)advancement.field_192079_d);
    }

    public int hashCode() {
        return this.field_192079_d.hashCode();
    }

    public String[][] func_192074_h() {
        return this.field_192081_f;
    }

    public ITextComponent func_193123_j() {
        return this.field_193125_h;
    }

    private static /* synthetic */ Style lambda$new$0(ITextComponent itextcomponent1, Style p_211567_1_) {
        return p_211567_1_.func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)itextcomponent1));
    }

    public static class Builder {
        private ResourceLocation field_192061_a;
        private Advancement field_192062_b;
        private DisplayInfo field_192063_c;
        private AdvancementRewards field_192064_d = AdvancementRewards.field_192114_a;
        private Map<String, Criterion> field_192065_e = Maps.newLinkedHashMap();
        private String[][] field_192066_f;
        private IRequirementsStrategy field_199751_g = IRequirementsStrategy.field_223214_a_;

        private Builder(@Nullable ResourceLocation parentIdIn, @Nullable DisplayInfo displayIn, AdvancementRewards rewardsIn, Map<String, Criterion> criteriaIn, String[][] requirementsIn) {
            this.field_192061_a = parentIdIn;
            this.field_192063_c = displayIn;
            this.field_192064_d = rewardsIn;
            this.field_192065_e = criteriaIn;
            this.field_192066_f = requirementsIn;
        }

        private Builder() {
        }

        public static Builder func_200278_a() {
            return new Builder();
        }

        public Builder func_203905_a(Advancement parentIn) {
            this.field_192062_b = parentIn;
            return this;
        }

        public Builder func_200272_a(ResourceLocation parentIdIn) {
            this.field_192061_a = parentIdIn;
            return this;
        }

        public Builder func_215092_a(ItemStack stack, ITextComponent title, ITextComponent description, @Nullable ResourceLocation background, FrameType frame, boolean showToast, boolean announceToChat, boolean hidden) {
            return this.func_203903_a(new DisplayInfo(stack, title, description, background, frame, showToast, announceToChat, hidden));
        }

        public Builder func_203902_a(IItemProvider itemIn, ITextComponent title, ITextComponent description, @Nullable ResourceLocation background, FrameType frame, boolean showToast, boolean announceToChat, boolean hidden) {
            return this.func_203903_a(new DisplayInfo(new ItemStack(itemIn.func_199767_j()), title, description, background, frame, showToast, announceToChat, hidden));
        }

        public Builder func_203903_a(DisplayInfo displayIn) {
            this.field_192063_c = displayIn;
            return this;
        }

        public Builder func_200271_a(AdvancementRewards.Builder rewardsBuilder) {
            return this.func_200274_a(rewardsBuilder.func_200281_a());
        }

        public Builder func_200274_a(AdvancementRewards p_200274_1_) {
            this.field_192064_d = p_200274_1_;
            return this;
        }

        public Builder func_200275_a(String key, ICriterionInstance criterionIn) {
            return this.func_200276_a(key, new Criterion(criterionIn));
        }

        public Builder func_200276_a(String key, Criterion criterionIn) {
            if (this.field_192065_e.containsKey(key)) {
                throw new IllegalArgumentException("Duplicate criterion " + key);
            }
            this.field_192065_e.put(key, criterionIn);
            return this;
        }

        public Builder func_200270_a(IRequirementsStrategy strategy) {
            this.field_199751_g = strategy;
            return this;
        }

        public boolean func_192058_a(Function<ResourceLocation, Advancement> lookup) {
            if (this.field_192061_a == null) {
                return true;
            }
            if (this.field_192062_b == null) {
                this.field_192062_b = lookup.apply(this.field_192061_a);
            }
            return this.field_192062_b != null;
        }

        public Advancement func_192056_a(ResourceLocation id) {
            if (!this.func_192058_a(p_199750_0_ -> null)) {
                throw new IllegalStateException("Tried to build incomplete advancement!");
            }
            if (this.field_192066_f == null) {
                this.field_192066_f = this.field_199751_g.createRequirements(this.field_192065_e.keySet());
            }
            return new Advancement(id, this.field_192062_b, this.field_192063_c, this.field_192064_d, this.field_192065_e, this.field_192066_f);
        }

        public Advancement func_203904_a(Consumer<Advancement> consumer, String id) {
            Advancement advancement = this.func_192056_a(new ResourceLocation(id));
            consumer.accept(advancement);
            return advancement;
        }

        public JsonObject func_200273_b() {
            if (this.field_192066_f == null) {
                this.field_192066_f = this.field_199751_g.createRequirements(this.field_192065_e.keySet());
            }
            JsonObject jsonobject = new JsonObject();
            if (this.field_192062_b != null) {
                jsonobject.addProperty("parent", this.field_192062_b.func_192067_g().toString());
            } else if (this.field_192061_a != null) {
                jsonobject.addProperty("parent", this.field_192061_a.toString());
            }
            if (this.field_192063_c != null) {
                jsonobject.add("display", this.field_192063_c.func_200290_k());
            }
            jsonobject.add("rewards", this.field_192064_d.func_200286_b());
            JsonObject jsonobject1 = new JsonObject();
            for (Map.Entry<String, Criterion> entry : this.field_192065_e.entrySet()) {
                jsonobject1.add(entry.getKey(), entry.getValue().func_200287_b());
            }
            jsonobject.add("criteria", (JsonElement)jsonobject1);
            JsonArray jsonarray1 = new JsonArray();
            for (String[] astring : this.field_192066_f) {
                JsonArray jsonarray = new JsonArray();
                for (String s : astring) {
                    jsonarray.add(s);
                }
                jsonarray1.add((JsonElement)jsonarray);
            }
            jsonobject.add("requirements", (JsonElement)jsonarray1);
            return jsonobject;
        }

        public void func_192057_a(PacketBuffer buf) {
            if (this.field_192061_a == null) {
                buf.writeBoolean(false);
            } else {
                buf.writeBoolean(true);
                buf.func_192572_a(this.field_192061_a);
            }
            if (this.field_192063_c == null) {
                buf.writeBoolean(false);
            } else {
                buf.writeBoolean(true);
                this.field_192063_c.func_192290_a(buf);
            }
            Criterion.func_192141_a(this.field_192065_e, (PacketBuffer)buf);
            buf.func_150787_b(this.field_192066_f.length);
            for (String[] astring : this.field_192066_f) {
                buf.func_150787_b(astring.length);
                for (String s : astring) {
                    buf.func_180714_a(s);
                }
            }
        }

        public String toString() {
            return "Task Advancement{parentId=" + this.field_192061_a + ", display=" + this.field_192063_c + ", rewards=" + this.field_192064_d + ", criteria=" + this.field_192065_e + ", requirements=" + Arrays.deepToString((Object[])this.field_192066_f) + '}';
        }

        public static Builder func_241043_a_(JsonObject p_241043_0_, ConditionArrayParser p_241043_1_) {
            if (!ConditionalAdvancement.processConditions((JsonObject)p_241043_0_)) {
                return null;
            }
            ResourceLocation resourcelocation = p_241043_0_.has("parent") ? new ResourceLocation(JSONUtils.func_151200_h((JsonObject)p_241043_0_, (String)"parent")) : null;
            DisplayInfo displayinfo = p_241043_0_.has("display") ? DisplayInfo.func_192294_a((JsonObject)JSONUtils.func_152754_s((JsonObject)p_241043_0_, (String)"display")) : null;
            AdvancementRewards advancementrewards = p_241043_0_.has("rewards") ? AdvancementRewards.func_241096_a_(JSONUtils.func_152754_s((JsonObject)p_241043_0_, (String)"rewards")) : AdvancementRewards.field_192114_a;
            Map map = Criterion.func_232634_b_((JsonObject)JSONUtils.func_152754_s((JsonObject)p_241043_0_, (String)"criteria"), (ConditionArrayParser)p_241043_1_);
            if (map.isEmpty()) {
                throw new JsonSyntaxException("Advancement criteria cannot be empty");
            }
            JsonArray jsonarray = JSONUtils.func_151213_a((JsonObject)p_241043_0_, (String)"requirements", (JsonArray)new JsonArray());
            String[][] astring = new String[jsonarray.size()][];
            for (int i = 0; i < jsonarray.size(); ++i) {
                JsonArray jsonarray1 = JSONUtils.func_151207_m((JsonElement)jsonarray.get(i), (String)("requirements[" + i + "]"));
                astring[i] = new String[jsonarray1.size()];
                for (int j = 0; j < jsonarray1.size(); ++j) {
                    astring[i][j] = JSONUtils.func_151206_a((JsonElement)jsonarray1.get(j), (String)("requirements[" + i + "][" + j + "]"));
                }
            }
            if (astring.length == 0) {
                astring = new String[map.size()][];
                int k = 0;
                for (String s2 : map.keySet()) {
                    astring[k++] = new String[]{s2};
                }
            }
            for (String[] astring1 : astring) {
                if (astring1.length == 0 && map.isEmpty()) {
                    throw new JsonSyntaxException("Requirement entry cannot be empty");
                }
                String[] stringArray = astring1;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String s = stringArray[i];
                    if (map.containsKey(s)) continue;
                    throw new JsonSyntaxException("Unknown required criterion '" + s + "'");
                }
            }
            for (String s1 : map.keySet()) {
                boolean flag = false;
                for (Object[] objectArray : astring) {
                    if (!ArrayUtils.contains((Object[])objectArray, (Object)s1)) continue;
                    flag = true;
                    break;
                }
                if (flag) continue;
                throw new JsonSyntaxException("Criterion '" + s1 + "' isn't a requirement for completion. This isn't supported behaviour, all criteria must be required.");
            }
            return new Builder(resourcelocation, displayinfo, advancementrewards, map, astring);
        }

        public static Builder func_192060_b(PacketBuffer buf) {
            ResourceLocation resourcelocation = buf.readBoolean() ? buf.func_192575_l() : null;
            DisplayInfo displayinfo = buf.readBoolean() ? DisplayInfo.func_192295_b((PacketBuffer)buf) : null;
            Map map = Criterion.func_192142_c((PacketBuffer)buf);
            String[][] astring = new String[buf.func_150792_a()][];
            for (int i = 0; i < astring.length; ++i) {
                astring[i] = new String[buf.func_150792_a()];
                for (int j = 0; j < astring[i].length; ++j) {
                    astring[i][j] = buf.func_150789_c(Short.MAX_VALUE);
                }
            }
            return new Builder(resourcelocation, displayinfo, AdvancementRewards.field_192114_a, map, astring);
        }

        public Map<String, Criterion> func_200277_c() {
            return this.field_192065_e;
        }
    }
}

