/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.GlazedTerracottaBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.piglin.PiglinTasks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.state.StateContainer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.extensions.IForgeBlock;
import net.minecraftforge.common.util.ReverseTagWrapper;
import net.minecraftforge.registries.GameData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Block
extends AbstractBlock
implements IItemProvider,
IForgeBlock {
    protected static final Logger field_196273_d = LogManager.getLogger();
    @Deprecated
    public static final ObjectIntIdentityMap<BlockState> field_176229_d = GameData.getBlockStateIDMap();
    private static final LoadingCache<VoxelShape, Boolean> field_223006_b = CacheBuilder.newBuilder().maximumSize(512L).weakKeys().build((CacheLoader)new CacheLoader<VoxelShape, Boolean>(){

        public Boolean load(VoxelShape p_load_1_) {
            return !VoxelShapes.func_197879_c((VoxelShape)VoxelShapes.func_197868_b(), (VoxelShape)p_load_1_, (IBooleanFunction)IBooleanFunction.field_223236_g_);
        }
    });
    private static final VoxelShape field_220083_b = VoxelShapes.func_197878_a((VoxelShape)VoxelShapes.func_197868_b(), (VoxelShape)Block.func_208617_a(2.0, 0.0, 2.0, 14.0, 16.0, 14.0), (IBooleanFunction)IBooleanFunction.field_223234_e_);
    private static final VoxelShape field_220084_c = Block.func_208617_a(7.0, 0.0, 7.0, 9.0, 10.0, 9.0);
    protected final StateContainer<Block, BlockState> field_176227_L;
    private BlockState field_196275_y;
    @Nullable
    private String field_149770_b;
    @Nullable
    private Item field_220086_i;
    private static final ThreadLocal<Object2ByteLinkedOpenHashMap<RenderSideCacheKey>> field_210300_r = ThreadLocal.withInitial(() -> {
        Object2ByteLinkedOpenHashMap<RenderSideCacheKey> object2bytelinkedopenhashmap = new Object2ByteLinkedOpenHashMap<RenderSideCacheKey>(2048, 0.25f){

            protected void rehash(int p_rehash_1_) {
            }
        };
        object2bytelinkedopenhashmap.defaultReturnValue((byte)127);
        return object2bytelinkedopenhashmap;
    });
    protected Random RANDOM = new Random();
    private ToolType harvestTool;
    private int harvestLevel;
    private final ReverseTagWrapper<Block> reverseTags = new ReverseTagWrapper((Object)this, BlockTags::func_199896_a);

    public static int func_196246_j(@Nullable BlockState state) {
        if (state == null) {
            return 0;
        }
        int i = field_176229_d.func_148747_b((Object)state);
        return i == -1 ? 0 : i;
    }

    public static BlockState func_196257_b(int id) {
        BlockState blockstate = (BlockState)((Object)field_176229_d.func_148745_a(id));
        return blockstate == null ? Blocks.field_150350_a.func_176223_P() : blockstate;
    }

    public static Block func_149634_a(@Nullable Item itemIn) {
        return itemIn instanceof BlockItem ? ((BlockItem)itemIn).func_179223_d() : Blocks.field_150350_a;
    }

    public static BlockState func_199601_a(BlockState oldState, BlockState newState, World worldIn, BlockPos pos) {
        VoxelShape voxelshape = VoxelShapes.func_197882_b((VoxelShape)oldState.func_196952_d((IBlockReader)((Object)worldIn), pos), (VoxelShape)newState.func_196952_d((IBlockReader)((Object)worldIn), pos), (IBooleanFunction)IBooleanFunction.field_223232_c_).func_197751_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        for (Entity entity : worldIn.func_72839_b(null, voxelshape.func_197752_a())) {
            double d0 = VoxelShapes.func_212437_a((Direction.Axis)Direction.Axis.Y, (AxisAlignedBB)entity.func_174813_aQ().func_72317_d(0.0, 1.0, 0.0), Stream.of(voxelshape), (double)-1.0);
            entity.func_70634_a(entity.func_226277_ct_(), entity.func_226278_cu_() + 1.0 + d0, entity.func_226281_cx_());
        }
        return newState;
    }

    public static VoxelShape func_208617_a(double x1, double y1, double z1, double x2, double y2, double z2) {
        return VoxelShapes.func_197873_a((double)(x1 / 16.0), (double)(y1 / 16.0), (double)(z1 / 16.0), (double)(x2 / 16.0), (double)(y2 / 16.0), (double)(z2 / 16.0));
    }

    public boolean func_203417_a(ITag<Block> tagIn) {
        return tagIn.func_230235_a_(this);
    }

    public boolean func_235332_a_(Block p_235332_1_) {
        return this == p_235332_1_;
    }

    public static BlockState func_199770_b(BlockState currentState, IWorld worldIn, BlockPos pos) {
        BlockState blockstate = currentState;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (Direction direction : field_212556_a) {
            blockpos$mutable.func_239622_a_((Vector3i)pos, direction);
            blockstate = blockstate.func_196956_a(direction, worldIn.func_180495_p((BlockPos)blockpos$mutable), worldIn, pos, (BlockPos)blockpos$mutable);
        }
        return blockstate;
    }

    public static void func_196263_a(BlockState oldState, BlockState newState, IWorld worldIn, BlockPos pos, int flags) {
        Block.func_241468_a_(oldState, newState, worldIn, pos, flags, 512);
    }

    public static void func_241468_a_(BlockState p_241468_0_, BlockState p_241468_1_, IWorld p_241468_2_, BlockPos p_241468_3_, int p_241468_4_, int p_241468_5_) {
        if (p_241468_1_ != p_241468_0_) {
            if (p_241468_1_.func_196958_f()) {
                if (!p_241468_2_.func_201670_d()) {
                    p_241468_2_.func_241212_a_(p_241468_3_, (p_241468_4_ & 0x20) == 0, (Entity)null, p_241468_5_);
                }
            } else {
                p_241468_2_.func_241211_a_(p_241468_3_, p_241468_1_, p_241468_4_ & 0xFFFFFFDF, p_241468_5_);
            }
        }
    }

    public Block(AbstractBlock.Properties properties) {
        super(properties);
        StateContainer.Builder builder = new StateContainer.Builder((Object)this);
        this.func_206840_a((StateContainer.Builder<Block, BlockState>)builder);
        this.harvestLevel = properties.getHarvestLevel();
        this.harvestTool = properties.getHarvestTool();
        this.field_176227_L = builder.func_235882_a_(Block::func_176223_P, BlockState::new);
        this.func_180632_j((BlockState)this.field_176227_L.func_177621_b());
    }

    public static boolean func_220073_a(Block blockIn) {
        return blockIn instanceof LeavesBlock || blockIn == Blocks.field_180401_cv || blockIn == Blocks.field_196625_cS || blockIn == Blocks.field_196628_cT || blockIn == Blocks.field_150440_ba || blockIn == Blocks.field_150423_aK || blockIn.func_203417_a(BlockTags.field_226150_J_);
    }

    public boolean func_149653_t(BlockState state) {
        return this.field_149789_z;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean func_176225_a(BlockState adjacentState, IBlockReader blockState, BlockPos blockAccess, Direction pos) {
        BlockPos blockpos = blockAccess.func_177972_a(pos);
        BlockState blockstate = blockState.func_180495_p(blockpos);
        if (adjacentState.func_200017_a(blockstate, pos)) {
            return false;
        }
        if (blockstate.func_200132_m()) {
            RenderSideCacheKey block$rendersidecachekey = new RenderSideCacheKey(adjacentState, blockstate, pos);
            Object2ByteLinkedOpenHashMap<RenderSideCacheKey> object2bytelinkedopenhashmap = field_210300_r.get();
            byte b0 = object2bytelinkedopenhashmap.getAndMoveToFirst((Object)block$rendersidecachekey);
            if (b0 != 127) {
                return b0 != 0;
            }
            VoxelShape voxelshape = adjacentState.func_215702_a(blockState, blockAccess, pos);
            VoxelShape voxelshape1 = blockstate.func_215702_a(blockState, blockpos, pos.func_176734_d());
            boolean flag = VoxelShapes.func_197879_c((VoxelShape)voxelshape, (VoxelShape)voxelshape1, (IBooleanFunction)IBooleanFunction.field_223234_e_);
            if (object2bytelinkedopenhashmap.size() == 2048) {
                object2bytelinkedopenhashmap.removeLastByte();
            }
            object2bytelinkedopenhashmap.putAndMoveToFirst((Object)block$rendersidecachekey, (byte)(flag ? 1 : 0));
            return flag;
        }
        return true;
    }

    public static boolean func_220064_c(IBlockReader worldIn, BlockPos pos) {
        BlockState blockstate = worldIn.func_180495_p(pos);
        return blockstate.func_235785_r_(worldIn, pos) && blockstate.func_224755_d(worldIn, pos, Direction.UP) || !VoxelShapes.func_197879_c((VoxelShape)blockstate.func_196951_e(worldIn, pos).func_212434_a(Direction.UP), (VoxelShape)field_220083_b, (IBooleanFunction)IBooleanFunction.field_223232_c_);
    }

    public static boolean func_220055_a(IWorldReader worldIn, BlockPos pos, Direction directionIn) {
        BlockState blockstate = worldIn.func_180495_p(pos);
        if (directionIn == Direction.DOWN && blockstate.func_235714_a_(BlockTags.field_232869_aB_)) {
            return false;
        }
        return !VoxelShapes.func_197879_c((VoxelShape)blockstate.func_196951_e((IBlockReader)((Object)worldIn), pos).func_212434_a(directionIn), (VoxelShape)field_220084_c, (IBooleanFunction)IBooleanFunction.field_223232_c_);
    }

    public static boolean func_220056_d(BlockState state, IBlockReader worldIn, BlockPos pos, Direction side) {
        return Block.func_208061_a(state.func_196951_e(worldIn, pos), side);
    }

    public static boolean func_208061_a(VoxelShape shape, Direction side) {
        VoxelShape voxelshape = shape.func_212434_a(side);
        return Block.func_208062_a(voxelshape);
    }

    public static boolean func_208062_a(VoxelShape shape) {
        return (Boolean)field_223006_b.getUnchecked((Object)shape);
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return !Block.func_208062_a(state.func_196954_c(reader, pos)) && state.func_204520_s().func_206888_e();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
    }

    public void func_176206_d(IWorld worldIn, BlockPos pos, BlockState state) {
    }

    public static List<ItemStack> func_220070_a(BlockState state, ServerWorld worldIn, BlockPos pos, @Nullable TileEntity tileEntityIn) {
        LootContext.Builder lootcontext$builder = new LootContext.Builder(worldIn).func_216023_a(worldIn.field_73012_v).func_216015_a(LootParameters.field_216286_f, pos).func_216015_a(LootParameters.field_216289_i, ItemStack.field_190927_a).func_216021_b(LootParameters.field_216288_h, tileEntityIn);
        return state.func_215693_a(lootcontext$builder);
    }

    public static List<ItemStack> func_220077_a(BlockState state, ServerWorld worldIn, BlockPos pos, @Nullable TileEntity tileEntityIn, @Nullable Entity entityIn, ItemStack stack) {
        LootContext.Builder lootcontext$builder = new LootContext.Builder(worldIn).func_216023_a(worldIn.field_73012_v).func_216015_a(LootParameters.field_216286_f, pos).func_216015_a(LootParameters.field_216289_i, stack).func_216021_b(LootParameters.field_216281_a, entityIn).func_216021_b(LootParameters.field_216288_h, tileEntityIn);
        return state.func_215693_a(lootcontext$builder);
    }

    public static void func_220075_c(BlockState state, World worldIn, BlockPos pos) {
        if (worldIn instanceof ServerWorld) {
            Block.func_220070_a(state, (ServerWorld)worldIn, pos, null).forEach(p_220079_2_ -> Block.func_180635_a(worldIn, pos, p_220079_2_));
        }
        state.func_215706_a(worldIn, pos, ItemStack.field_190927_a);
    }

    public static void func_220059_a(BlockState state, World worldIn, BlockPos pos, @Nullable TileEntity tileEntityIn) {
        if (worldIn instanceof ServerWorld) {
            Block.func_220070_a(state, (ServerWorld)worldIn, pos, tileEntityIn).forEach(p_220061_2_ -> Block.func_180635_a(worldIn, pos, p_220061_2_));
        }
        state.func_215706_a(worldIn, pos, ItemStack.field_190927_a);
    }

    public static void func_220054_a(BlockState state, World worldIn, BlockPos pos, @Nullable TileEntity tileEntityIn, Entity entityIn, ItemStack stack) {
        if (worldIn instanceof ServerWorld) {
            Block.func_220077_a(state, (ServerWorld)worldIn, pos, tileEntityIn, entityIn, stack).forEach(p_220057_2_ -> Block.func_180635_a(worldIn, pos, p_220057_2_));
        }
        state.func_215706_a(worldIn, pos, stack);
    }

    public static void func_180635_a(World worldIn, BlockPos pos, ItemStack stack) {
        if (!worldIn.field_72995_K && !stack.func_190926_b() && worldIn.func_82736_K().func_223586_b(GameRules.field_223603_f) && !worldIn.restoringBlockSnapshots) {
            float f = 0.5f;
            double d0 = (double)(worldIn.field_73012_v.nextFloat() * 0.5f) + 0.25;
            double d1 = (double)(worldIn.field_73012_v.nextFloat() * 0.5f) + 0.25;
            double d2 = (double)(worldIn.field_73012_v.nextFloat() * 0.5f) + 0.25;
            ItemEntity itementity = new ItemEntity(worldIn, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, stack);
            itementity.func_174869_p();
            worldIn.func_217376_c(itementity);
        }
    }

    public void func_180637_b(World worldIn, BlockPos pos, int amount) {
        if (!worldIn.field_72995_K && worldIn.func_82736_K().func_223586_b(GameRules.field_223603_f) && !worldIn.restoringBlockSnapshots) {
            while (amount > 0) {
                int i = ExperienceOrbEntity.func_70527_a(amount);
                amount -= i;
                worldIn.func_217376_c(new ExperienceOrbEntity(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, i));
            }
        }
    }

    @Deprecated
    public float func_149638_a() {
        return this.field_235689_au_;
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.func_176223_P();
    }

    public void func_180657_a(World worldIn, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity te, ItemStack stack) {
        player.func_71029_a(Stats.field_188065_ae.func_199076_b(this));
        player.func_71020_j(0.005f);
        Block.func_220054_a(state, worldIn, pos, te, player, stack);
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
    }

    public boolean func_181623_g() {
        return !this.field_149764_J.func_76220_a() && !this.field_149764_J.func_76224_d();
    }

    @OnlyIn(value=Dist.CLIENT)
    public IFormattableTextComponent func_235333_g_() {
        return new TranslationTextComponent(this.func_149739_a());
    }

    public String func_149739_a() {
        if (this.field_149770_b == null) {
            this.field_149770_b = Util.func_200697_a((String)"block", (ResourceLocation)Registry.field_212618_g.func_177774_c((Object)this));
        }
        return this.field_149770_b;
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        entityIn.func_225503_b_(fallDistance, 1.0f);
    }

    public void func_176216_a(IBlockReader worldIn, Entity entityIn) {
        entityIn.func_213317_d(entityIn.func_213322_ci().func_216372_d(1.0, 0.0, 1.0));
    }

    @Deprecated
    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return new ItemStack(this);
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack(this));
    }

    public float func_208618_m() {
        return this.field_149765_K;
    }

    public float func_226891_m_() {
        return this.field_226886_f_;
    }

    public float func_226892_n_() {
        return this.field_226887_g_;
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        worldIn.func_217378_a(player, 2001, pos, Block.func_196246_j(state));
        if (this.func_203417_a(BlockTags.field_232883_ay_)) {
            PiglinTasks.func_234478_a_(player, false);
        }
    }

    public void func_176224_k(World worldIn, BlockPos pos) {
    }

    @Deprecated
    public boolean func_149659_a(Explosion explosionIn) {
        return true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
    }

    public StateContainer<Block, BlockState> func_176194_O() {
        return this.field_176227_L;
    }

    protected final void func_180632_j(BlockState state) {
        this.field_196275_y = state;
    }

    public final BlockState func_176223_P() {
        return this.field_196275_y;
    }

    @Deprecated
    public SoundType func_220072_p(BlockState state) {
        return this.field_149762_H;
    }

    @Override
    public Item func_199767_j() {
        if (this.field_220086_i == null) {
            this.field_220086_i = Item.func_150898_a(this);
        }
        return (Item)((Object)this.field_220086_i.delegate.get());
    }

    public boolean func_208619_r() {
        return this.field_208621_p;
    }

    public String toString() {
        return "Block{" + this.getRegistryName() + "}";
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
    }

    @Override
    protected Block func_230328_p_() {
        return this;
    }

    public float getSlipperiness(BlockState state, IWorldReader world, BlockPos pos, @Nullable Entity entity) {
        return this.field_149765_K;
    }

    @Nullable
    public ToolType getHarvestTool(BlockState state) {
        return this.harvestTool;
    }

    public int getHarvestLevel(BlockState state) {
        return this.harvestLevel;
    }

    public boolean canSustainPlant(BlockState state, IBlockReader world, BlockPos pos, Direction facing, IPlantable plantable) {
        BlockState plant = plantable.getPlant(world, pos.func_177972_a(facing));
        PlantType type = plantable.getPlantType(world, pos.func_177972_a(facing));
        if (plant.func_177230_c() == Blocks.field_150434_aF) {
            return state.func_203425_a(Blocks.field_150434_aF) || state.func_203425_a(Blocks.field_150354_m) || state.func_203425_a(Blocks.field_196611_F);
        }
        if (plant.func_177230_c() == Blocks.field_196608_cF && this == Blocks.field_196608_cF) {
            return true;
        }
        if (plantable instanceof BushBlock && ((BushBlock)plantable).func_200014_a_(state, world, pos)) {
            return true;
        }
        if (PlantType.DESERT.equals(type)) {
            return this.getBlock() == Blocks.field_150354_m || this.getBlock() == Blocks.field_150405_ch || this.getBlock() instanceof GlazedTerracottaBlock;
        }
        if (PlantType.NETHER.equals(type)) {
            return this.getBlock() == Blocks.field_150425_aM;
        }
        if (PlantType.CROP.equals(type)) {
            return state.func_203425_a(Blocks.field_150458_ak);
        }
        if (PlantType.CAVE.equals(type)) {
            return Block.func_220056_d(state, world, pos, Direction.UP);
        }
        if (PlantType.PLAINS.equals(type)) {
            return this.getBlock() == Blocks.field_196658_i || Tags.Blocks.DIRT.func_230235_a_(this) || this.getBlock() == Blocks.field_150458_ak;
        }
        if (PlantType.WATER.equals(type)) {
            return state.func_185904_a() == Material.field_151586_h;
        }
        if (PlantType.BEACH.equals(type)) {
            boolean isBeach = state.func_203425_a(Blocks.field_196658_i) || Tags.Blocks.DIRT.func_230235_a_(this) || state.func_203425_a(Blocks.field_150354_m) || state.func_203425_a(Blocks.field_196611_F);
            boolean hasWater = false;
            for (Direction face : Direction.Plane.HORIZONTAL) {
                BlockState blockState = world.func_180495_p(pos.func_177972_a(face));
                FluidState fluidState = world.func_204610_c(pos.func_177972_a(face));
                hasWater |= blockState.func_203425_a(Blocks.field_185778_de);
                if (!(hasWater |= fluidState.func_206884_a(FluidTags.field_206959_a))) continue;
                break;
            }
            return isBeach && hasWater;
        }
        return false;
    }

    public final Set<ResourceLocation> getTags() {
        return this.reverseTags.getTagNames();
    }

    static {
        ForgeHooks.setBlockToolSetter((block, tool, level) -> {
            block.harvestTool = tool;
            block.harvestLevel = level;
        });
    }

    public static final class RenderSideCacheKey {
        private final BlockState field_212164_a;
        private final BlockState field_212165_b;
        private final Direction field_212166_c;

        public RenderSideCacheKey(BlockState state, BlockState adjacentState, Direction side) {
            this.field_212164_a = state;
            this.field_212165_b = adjacentState;
            this.field_212166_c = side;
        }

        public boolean equals(Object p_equals_1_) {
            if (this == p_equals_1_) {
                return true;
            }
            if (!(p_equals_1_ instanceof RenderSideCacheKey)) {
                return false;
            }
            RenderSideCacheKey block$rendersidecachekey = (RenderSideCacheKey)p_equals_1_;
            return this.field_212164_a == block$rendersidecachekey.field_212164_a && this.field_212165_b == block$rendersidecachekey.field_212165_b && this.field_212166_c == block$rendersidecachekey.field_212166_c;
        }

        public int hashCode() {
            int i = ((Object)((Object)this.field_212164_a)).hashCode();
            i = 31 * i + ((Object)((Object)this.field_212165_b)).hashCode();
            return 31 * i + this.field_212166_c.hashCode();
        }
    }
}

