/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.advancements;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.client.gui.advancements.AdvancementEntryGui;
import net.minecraft.client.gui.advancements.AdvancementTabGui;
import net.minecraft.client.gui.advancements.AdvancementTabType;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.multiplayer.ClientAdvancementManager;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.resources.I18n;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.client.CSeenAdvancementsPacket;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AdvancementsScreen
extends Screen
implements ClientAdvancementManager.IListener {
    private static final ResourceLocation field_191943_f = new ResourceLocation("textures/gui/advancements/window.png");
    private static final ResourceLocation field_191945_g = new ResourceLocation("textures/gui/advancements/tabs.png");
    private final ClientAdvancementManager field_191946_h;
    private final Map<Advancement, AdvancementTabGui> field_191947_i = Maps.newLinkedHashMap();
    private AdvancementTabGui field_191940_s;
    private boolean field_191944_v;
    private static int tabPage;
    private static int maxPages;

    public AdvancementsScreen(ClientAdvancementManager p_i47383_1_) {
        super(NarratorChatListener.field_216868_a);
        this.field_191946_h = p_i47383_1_;
    }

    @Override
    protected void func_231160_c_() {
        this.field_191947_i.clear();
        this.field_191940_s = null;
        this.field_191946_h.func_192798_a((ClientAdvancementManager.IListener)this);
        if (this.field_191940_s == null && !this.field_191947_i.isEmpty()) {
            this.field_191946_h.func_194230_a(this.field_191947_i.values().iterator().next().func_193935_c(), true);
        } else {
            this.field_191946_h.func_194230_a(this.field_191940_s == null ? null : this.field_191940_s.func_193935_c(), true);
        }
        if (this.field_191947_i.size() > AdvancementTabType.MAX_TABS) {
            int guiLeft = (this.field_230708_k_ - 252) / 2;
            int guiTop = (this.field_230709_l_ - 140) / 2;
            this.func_230480_a_(new Button(guiLeft, guiTop - 50, 20, 20, (ITextComponent)new StringTextComponent("<"), b -> {
                tabPage = Math.max(tabPage - 1, 0);
            }));
            this.func_230480_a_(new Button(guiLeft + 252 - 20, guiTop - 50, 20, 20, (ITextComponent)new StringTextComponent(">"), b -> {
                tabPage = Math.min(tabPage + 1, maxPages);
            }));
            maxPages = this.field_191947_i.size() / AdvancementTabType.MAX_TABS;
        }
    }

    @Override
    public void func_231164_f_() {
        this.field_191946_h.func_192798_a((ClientAdvancementManager.IListener)null);
        ClientPlayNetHandler clientplaynethandler = this.field_230706_i_.func_147114_u();
        if (clientplaynethandler != null) {
            clientplaynethandler.func_147297_a((IPacket<?>)CSeenAdvancementsPacket.func_194164_a());
        }
    }

    public boolean func_231044_a_(double p_231044_1_, double p_231044_3_, int p_231044_5_) {
        if (p_231044_5_ == 0) {
            int i = (this.field_230708_k_ - 252) / 2;
            int j = (this.field_230709_l_ - 140) / 2;
            for (AdvancementTabGui advancementtabgui : this.field_191947_i.values()) {
                if (advancementtabgui.getPage() != tabPage || !advancementtabgui.func_195627_a(i, j, p_231044_1_, p_231044_3_)) continue;
                this.field_191946_h.func_194230_a(advancementtabgui.func_193935_c(), true);
                break;
            }
        }
        return super.func_231044_a_(p_231044_1_, p_231044_3_, p_231044_5_);
    }

    @Override
    public boolean func_231046_a_(int p_231046_1_, int p_231046_2_, int p_231046_3_) {
        if (this.field_230706_i_.field_71474_y.field_194146_ao.func_197976_a(p_231046_1_, p_231046_2_)) {
            this.field_230706_i_.func_147108_a(null);
            this.field_230706_i_.field_71417_B.func_198034_i();
            return true;
        }
        return super.func_231046_a_(p_231046_1_, p_231046_2_, p_231046_3_);
    }

    @Override
    public void func_230430_a_(MatrixStack p_230430_1_, int p_230430_2_, int p_230430_3_, float p_230430_4_) {
        int i = (this.field_230708_k_ - 252) / 2;
        int j = (this.field_230709_l_ - 140) / 2;
        this.func_230446_a_(p_230430_1_);
        if (maxPages != 0) {
            StringTextComponent page = new StringTextComponent(String.format("%d / %d", tabPage + 1, maxPages + 1));
            int width = this.field_230712_o_.func_238414_a_((ITextProperties)page);
            RenderSystem.disableLighting();
            this.field_230712_o_.func_238407_a_(p_230430_1_, (ITextProperties)page, (float)(i + 126 - width / 2), (float)(j - 44), -1);
        }
        this.func_238696_c_(p_230430_1_, p_230430_2_, p_230430_3_, i, j);
        this.func_238695_a_(p_230430_1_, i, j);
        this.func_238697_d_(p_230430_1_, p_230430_2_, p_230430_3_, i, j);
    }

    public boolean func_231045_a_(double p_231045_1_, double p_231045_3_, int p_231045_5_, double p_231045_6_, double p_231045_8_) {
        if (p_231045_5_ != 0) {
            this.field_191944_v = false;
            return false;
        }
        if (!this.field_191944_v) {
            this.field_191944_v = true;
        } else if (this.field_191940_s != null) {
            this.field_191940_s.func_195626_a(p_231045_6_, p_231045_8_);
        }
        return true;
    }

    private void func_238696_c_(MatrixStack p_238696_1_, int p_238696_2_, int p_238696_3_, int p_238696_4_, int p_238696_5_) {
        AdvancementTabGui advancementtabgui = this.field_191940_s;
        if (advancementtabgui == null) {
            AdvancementsScreen.func_238467_a_((MatrixStack)p_238696_1_, (int)(p_238696_4_ + 9), (int)(p_238696_5_ + 18), (int)(p_238696_4_ + 9 + 234), (int)(p_238696_5_ + 18 + 113), (int)-16777216);
            String s = I18n.func_135052_a("advancements.empty", new Object[0]);
            int i = this.field_230712_o_.func_78256_a(s);
            this.field_230712_o_.func_238421_b_(p_238696_1_, s, (float)(p_238696_4_ + 9 + 117 - i / 2), (float)(p_238696_5_ + 18 + 56 - 4), -1);
            this.field_230712_o_.func_238421_b_(p_238696_1_, ":(", (float)(p_238696_4_ + 9 + 117 - this.field_230712_o_.func_78256_a(":(") / 2), (float)(p_238696_5_ + 18 + 113 - 9), -1);
        } else {
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)(p_238696_4_ + 9), (float)(p_238696_5_ + 18), (float)0.0f);
            advancementtabgui.func_238682_a_(p_238696_1_);
            RenderSystem.popMatrix();
            RenderSystem.depthFunc((int)515);
            RenderSystem.disableDepthTest();
        }
    }

    public void func_238695_a_(MatrixStack p_238695_1_, int p_238695_2_, int p_238695_3_) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        this.field_230706_i_.func_110434_K().func_110577_a(field_191943_f);
        this.func_238474_b_(p_238695_1_, p_238695_2_, p_238695_3_, 0, 0, 252, 140);
        if (this.field_191947_i.size() > 1) {
            this.field_230706_i_.func_110434_K().func_110577_a(field_191945_g);
            for (AdvancementTabGui advancementtabgui : this.field_191947_i.values()) {
                if (advancementtabgui.getPage() != tabPage) continue;
                advancementtabgui.func_238683_a_(p_238695_1_, p_238695_2_, p_238695_3_, advancementtabgui == this.field_191940_s);
            }
            RenderSystem.enableRescaleNormal();
            RenderSystem.defaultBlendFunc();
            for (AdvancementTabGui advancementtabgui1 : this.field_191947_i.values()) {
                if (advancementtabgui1.getPage() != tabPage) continue;
                advancementtabgui1.func_191796_a(p_238695_2_, p_238695_3_, this.field_230707_j_);
            }
            RenderSystem.disableBlend();
        }
        this.field_230712_o_.func_238421_b_(p_238695_1_, I18n.func_135052_a("gui.advancements", new Object[0]), (float)(p_238695_2_ + 8), (float)(p_238695_3_ + 6), 0x404040);
    }

    private void func_238697_d_(MatrixStack p_238697_1_, int p_238697_2_, int p_238697_3_, int p_238697_4_, int p_238697_5_) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.field_191940_s != null) {
            RenderSystem.pushMatrix();
            RenderSystem.enableDepthTest();
            RenderSystem.translatef((float)(p_238697_4_ + 9), (float)(p_238697_5_ + 18), (float)400.0f);
            this.field_191940_s.func_238684_c_(p_238697_1_, p_238697_2_ - p_238697_4_ - 9, p_238697_3_ - p_238697_5_ - 18, p_238697_4_, p_238697_5_);
            RenderSystem.disableDepthTest();
            RenderSystem.popMatrix();
        }
        if (this.field_191947_i.size() > 1) {
            for (AdvancementTabGui advancementtabgui : this.field_191947_i.values()) {
                if (advancementtabgui.getPage() != tabPage || !advancementtabgui.func_195627_a(p_238697_4_, p_238697_5_, p_238697_2_, p_238697_3_)) continue;
                this.func_238652_a_(p_238697_1_, (ITextProperties)advancementtabgui.func_238685_d_(), p_238697_2_, p_238697_3_);
            }
        }
    }

    public void func_191931_a(Advancement advancementIn) {
        AdvancementTabGui advancementtabgui = AdvancementTabGui.func_193936_a(this.field_230706_i_, this, this.field_191947_i.size(), advancementIn);
        if (advancementtabgui != null) {
            this.field_191947_i.put(advancementIn, advancementtabgui);
        }
    }

    public void func_191928_b(Advancement advancementIn) {
    }

    public void func_191932_c(Advancement advancementIn) {
        AdvancementTabGui advancementtabgui = this.func_191935_f(advancementIn);
        if (advancementtabgui != null) {
            advancementtabgui.func_191800_a(advancementIn);
        }
    }

    public void func_191929_d(Advancement advancementIn) {
    }

    public void func_191933_a(Advancement advancementIn, AdvancementProgress progress) {
        AdvancementEntryGui advancemententrygui = this.func_191938_e(advancementIn);
        if (advancemententrygui != null) {
            advancemententrygui.func_191824_a(progress);
        }
    }

    public void func_193982_e(@Nullable Advancement advancementIn) {
        this.field_191940_s = this.field_191947_i.get(advancementIn);
    }

    public void func_191930_a() {
        this.field_191947_i.clear();
        this.field_191940_s = null;
    }

    @Nullable
    public AdvancementEntryGui func_191938_e(Advancement p_191938_1_) {
        AdvancementTabGui advancementtabgui = this.func_191935_f(p_191938_1_);
        return advancementtabgui == null ? null : advancementtabgui.func_191794_b(p_191938_1_);
    }

    @Nullable
    private AdvancementTabGui func_191935_f(Advancement p_191935_1_) {
        while (p_191935_1_.func_192070_b() != null) {
            p_191935_1_ = p_191935_1_.func_192070_b();
        }
        return this.field_191947_i.get(p_191935_1_);
    }
}

