/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.ArrowLayer;
import net.minecraft.client.renderer.entity.layers.BeeStingerLayer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.layers.CapeLayer;
import net.minecraft.client.renderer.entity.layers.Deadmau5HeadLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.HeadLayer;
import net.minecraft.client.renderer.entity.layers.HeldItemLayer;
import net.minecraft.client.renderer.entity.layers.ParrotVariantLayer;
import net.minecraft.client.renderer.entity.layers.SpinAttackEffectLayer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

@OnlyIn(value=Dist.CLIENT)
public class PlayerRenderer
extends LivingRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> {
    public PlayerRenderer(EntityRendererManager renderManager) {
        this(renderManager, false);
    }

    public PlayerRenderer(EntityRendererManager renderManager, boolean useSmallArms) {
        super(renderManager, new PlayerModel(0.0f, useSmallArms), 0.5f);
        this.func_177094_a(new BipedArmorLayer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>, BipedModel>(this, new BipedModel(0.5f), new BipedModel(1.0f)));
        this.func_177094_a(new HeldItemLayer((IEntityRenderer)this));
        this.func_177094_a(new ArrowLayer((LivingRenderer)this));
        this.func_177094_a(new Deadmau5HeadLayer((IEntityRenderer)this));
        this.func_177094_a(new CapeLayer((IEntityRenderer)this));
        this.func_177094_a(new HeadLayer((IEntityRenderer)this));
        this.func_177094_a(new ElytraLayer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>>(this));
        this.func_177094_a(new ParrotVariantLayer((IEntityRenderer)this));
        this.func_177094_a(new SpinAttackEffectLayer((IEntityRenderer)this));
        this.func_177094_a(new BeeStingerLayer((LivingRenderer)this));
    }

    @Override
    public void func_225623_a_(AbstractClientPlayerEntity entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        this.func_177137_d(entityIn);
        if (MinecraftForge.EVENT_BUS.post((Event)new RenderPlayerEvent.Pre((PlayerEntity)entityIn, this, partialTicks, matrixStackIn, bufferIn, packedLightIn))) {
            return;
        }
        super.func_225623_a_(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        MinecraftForge.EVENT_BUS.post((Event)new RenderPlayerEvent.Post((PlayerEntity)entityIn, this, partialTicks, matrixStackIn, bufferIn, packedLightIn));
    }

    @Override
    public Vector3d func_225627_b_(AbstractClientPlayerEntity entityIn, float partialTicks) {
        return entityIn.func_213453_ef() ? new Vector3d(0.0, -0.125, 0.0) : super.func_225627_b_(entityIn, partialTicks);
    }

    private void func_177137_d(AbstractClientPlayerEntity clientPlayer) {
        PlayerModel playermodel = (PlayerModel)this.func_217764_d();
        if (clientPlayer.func_175149_v()) {
            playermodel.func_178719_a(false);
            playermodel.field_78116_c.field_78806_j = true;
            playermodel.field_178720_f.field_78806_j = true;
        } else {
            playermodel.func_178719_a(true);
            playermodel.field_178720_f.field_78806_j = clientPlayer.func_175148_a(PlayerModelPart.HAT);
            playermodel.field_178730_v.field_78806_j = clientPlayer.func_175148_a(PlayerModelPart.JACKET);
            playermodel.field_178733_c.field_78806_j = clientPlayer.func_175148_a(PlayerModelPart.LEFT_PANTS_LEG);
            playermodel.field_178731_d.field_78806_j = clientPlayer.func_175148_a(PlayerModelPart.RIGHT_PANTS_LEG);
            playermodel.field_178734_a.field_78806_j = clientPlayer.func_175148_a(PlayerModelPart.LEFT_SLEEVE);
            playermodel.field_178732_b.field_78806_j = clientPlayer.func_175148_a(PlayerModelPart.RIGHT_SLEEVE);
            playermodel.field_228270_o_ = clientPlayer.func_213453_ef();
            BipedModel.ArmPose bipedmodel$armpose = PlayerRenderer.func_241741_a_(clientPlayer, Hand.MAIN_HAND);
            BipedModel.ArmPose bipedmodel$armpose1 = PlayerRenderer.func_241741_a_(clientPlayer, Hand.OFF_HAND);
            if (bipedmodel$armpose.func_241657_a_()) {
                BipedModel.ArmPose armPose = bipedmodel$armpose1 = clientPlayer.func_184592_cb().func_190926_b() ? BipedModel.ArmPose.EMPTY : BipedModel.ArmPose.ITEM;
            }
            if (clientPlayer.func_184591_cq() == HandSide.RIGHT) {
                playermodel.field_187076_m = bipedmodel$armpose;
                playermodel.field_187075_l = bipedmodel$armpose1;
            } else {
                playermodel.field_187076_m = bipedmodel$armpose1;
                playermodel.field_187075_l = bipedmodel$armpose;
            }
        }
    }

    private static BipedModel.ArmPose func_241741_a_(AbstractClientPlayerEntity p_241741_0_, Hand p_241741_1_) {
        ItemStack itemstack = p_241741_0_.func_184586_b(p_241741_1_);
        if (itemstack.func_190926_b()) {
            return BipedModel.ArmPose.EMPTY;
        }
        if (p_241741_0_.func_184600_cs() == p_241741_1_ && p_241741_0_.func_184605_cv() > 0) {
            UseAction useaction = itemstack.func_77975_n();
            if (useaction == UseAction.BLOCK) {
                return BipedModel.ArmPose.BLOCK;
            }
            if (useaction == UseAction.BOW) {
                return BipedModel.ArmPose.BOW_AND_ARROW;
            }
            if (useaction == UseAction.SPEAR) {
                return BipedModel.ArmPose.THROW_SPEAR;
            }
            if (useaction == UseAction.CROSSBOW && p_241741_1_ == p_241741_0_.func_184600_cs()) {
                return BipedModel.ArmPose.CROSSBOW_CHARGE;
            }
        } else if (!p_241741_0_.field_82175_bq && itemstack.func_77973_b() == Items.field_222114_py && CrossbowItem.func_220012_d((ItemStack)itemstack)) {
            return BipedModel.ArmPose.CROSSBOW_HOLD;
        }
        return BipedModel.ArmPose.ITEM;
    }

    @Override
    public ResourceLocation func_110775_a(AbstractClientPlayerEntity entity) {
        return entity.func_110306_p();
    }

    @Override
    protected void func_225620_a_(AbstractClientPlayerEntity entitylivingbaseIn, MatrixStack matrixStackIn, float partialTickTime) {
        float f = 0.9375f;
        matrixStackIn.func_227862_a_(0.9375f, 0.9375f, 0.9375f);
    }

    @Override
    protected void func_225629_a_(AbstractClientPlayerEntity entityIn, ITextComponent displayNameIn, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        Scoreboard scoreboard;
        ScoreObjective scoreobjective;
        double d0 = this.field_76990_c.func_229099_b_(entityIn);
        matrixStackIn.func_227860_a_();
        if (d0 < 100.0 && (scoreobjective = (scoreboard = entityIn.func_96123_co()).func_96539_a(2)) != null) {
            Score score = scoreboard.func_96529_a(entityIn.func_195047_I_(), scoreobjective);
            super.func_225629_a_(entityIn, (ITextComponent)new StringTextComponent(Integer.toString(score.func_96652_c())).func_240702_b_(" ").func_230529_a_(scoreobjective.func_96678_d()), matrixStackIn, bufferIn, packedLightIn);
            matrixStackIn.func_227861_a_(0.0, (double)0.25875f, 0.0);
        }
        super.func_225629_a_(entityIn, displayNameIn, matrixStackIn, bufferIn, packedLightIn);
        matrixStackIn.func_227865_b_();
    }

    public void func_229144_a_(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, AbstractClientPlayerEntity playerIn) {
        this.func_229145_a_(matrixStackIn, bufferIn, combinedLightIn, playerIn, ((PlayerModel)this.field_77045_g).field_178723_h, ((PlayerModel)this.field_77045_g).field_178732_b);
    }

    public void func_229146_b_(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, AbstractClientPlayerEntity playerIn) {
        this.func_229145_a_(matrixStackIn, bufferIn, combinedLightIn, playerIn, ((PlayerModel)this.field_77045_g).field_178724_i, ((PlayerModel)this.field_77045_g).field_178734_a);
    }

    private void func_229145_a_(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, AbstractClientPlayerEntity playerIn, ModelRenderer rendererArmIn, ModelRenderer rendererArmwearIn) {
        PlayerModel playermodel = (PlayerModel)this.func_217764_d();
        this.func_177137_d(playerIn);
        playermodel.field_217112_c = 0.0f;
        playermodel.field_228270_o_ = false;
        playermodel.field_205061_a = 0.0f;
        playermodel.func_225597_a_((LivingEntity)playerIn, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        rendererArmIn.field_78795_f = 0.0f;
        rendererArmIn.func_228308_a_(matrixStackIn, bufferIn.getBuffer(RenderType.func_228634_a_((ResourceLocation)playerIn.func_110306_p())), combinedLightIn, OverlayTexture.field_229196_a_);
        rendererArmwearIn.field_78795_f = 0.0f;
        rendererArmwearIn.func_228308_a_(matrixStackIn, bufferIn.getBuffer(RenderType.func_228644_e_((ResourceLocation)playerIn.func_110306_p())), combinedLightIn, OverlayTexture.field_229196_a_);
    }

    @Override
    protected void func_225621_a_(AbstractClientPlayerEntity entityLiving, MatrixStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks) {
        float f = entityLiving.func_205015_b(partialTicks);
        if (entityLiving.func_184613_cA()) {
            super.func_225621_a_(entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks);
            float f1 = (float)entityLiving.func_184599_cB() + partialTicks;
            float f2 = MathHelper.func_76131_a((float)(f1 * f1 / 100.0f), (float)0.0f, (float)1.0f);
            if (!entityLiving.func_204805_cN()) {
                matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(f2 * (-90.0f - entityLiving.field_70125_A)));
            }
            Vector3d vector3d = entityLiving.func_70676_i(partialTicks);
            Vector3d vector3d1 = entityLiving.func_213322_ci();
            double d0 = Entity.func_213296_b(vector3d1);
            double d1 = Entity.func_213296_b(vector3d);
            if (d0 > 0.0 && d1 > 0.0) {
                double d2 = (vector3d1.field_72450_a * vector3d.field_72450_a + vector3d1.field_72449_c * vector3d.field_72449_c) / (Math.sqrt(d0) * Math.sqrt(d1));
                double d3 = vector3d1.field_72450_a * vector3d.field_72449_c - vector3d1.field_72449_c * vector3d.field_72450_a;
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_((float)(Math.signum(d3) * Math.acos(d2))));
            }
        } else if (f > 0.0f) {
            super.func_225621_a_(entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks);
            float f3 = entityLiving.func_70090_H() ? -90.0f - entityLiving.field_70125_A : -90.0f;
            float f4 = MathHelper.func_219799_g((float)f, (float)0.0f, (float)f3);
            matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(f4));
            if (entityLiving.func_213314_bj()) {
                matrixStackIn.func_227861_a_(0.0, -1.0, (double)0.3f);
            }
        } else {
            super.func_225621_a_(entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks);
        }
    }
}

