/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.model;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import org.apache.commons.lang3.tuple.Pair;

@OnlyIn(value=Dist.CLIENT)
public class MultipartBakedModel
implements IDynamicBakedModel {
    private final List<Pair<Predicate<BlockState>, IBakedModel>> field_188626_f;
    protected final boolean field_188621_a;
    protected final boolean field_188622_b;
    protected final boolean field_230185_c_;
    protected final TextureAtlasSprite field_188623_c;
    protected final ItemCameraTransforms field_188624_d;
    protected final ItemOverrideList field_188625_e;
    private final Map<BlockState, BitSet> field_210277_g = new Object2ObjectOpenCustomHashMap(Util.func_212443_g());
    private final IBakedModel defaultModel;

    public MultipartBakedModel(List<Pair<Predicate<BlockState>, IBakedModel>> p_i48273_1_) {
        IBakedModel ibakedmodel;
        this.field_188626_f = p_i48273_1_;
        this.defaultModel = ibakedmodel = (IBakedModel)p_i48273_1_.iterator().next().getRight();
        this.field_188621_a = ibakedmodel.func_177555_b();
        this.field_188622_b = ibakedmodel.func_177556_c();
        this.field_230185_c_ = ibakedmodel.func_230044_c_();
        this.field_188623_c = ibakedmodel.func_177554_e();
        this.field_188624_d = ibakedmodel.func_177552_f();
        this.field_188625_e = ibakedmodel.func_188617_f();
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData modelData) {
        if (state == null) {
            return Collections.emptyList();
        }
        BitSet bitset = this.field_210277_g.get((Object)state);
        if (bitset == null) {
            bitset = new BitSet();
            for (int i = 0; i < this.field_188626_f.size(); ++i) {
                Pair<Predicate<BlockState>, IBakedModel> pair = this.field_188626_f.get(i);
                if (!((Predicate)pair.getLeft()).test(state)) continue;
                bitset.set(i);
            }
            this.field_210277_g.put(state, bitset);
        }
        ArrayList list = Lists.newArrayList();
        long k = rand.nextLong();
        for (int j = 0; j < bitset.length(); ++j) {
            if (!bitset.get(j)) continue;
            list.addAll(((IBakedModel)this.field_188626_f.get(j).getRight()).getQuads(state, side, new Random(k), modelData));
        }
        return list;
    }

    public boolean func_177555_b() {
        return this.field_188621_a;
    }

    public boolean isAmbientOcclusion(BlockState state) {
        return this.defaultModel.isAmbientOcclusion(state);
    }

    public boolean func_177556_c() {
        return this.field_188622_b;
    }

    public boolean func_230044_c_() {
        return this.field_230185_c_;
    }

    public boolean func_188618_c() {
        return false;
    }

    @Deprecated
    public TextureAtlasSprite func_177554_e() {
        return this.field_188623_c;
    }

    public TextureAtlasSprite getParticleTexture(IModelData modelData) {
        return this.defaultModel.getParticleTexture(modelData);
    }

    @Deprecated
    public ItemCameraTransforms func_177552_f() {
        return this.field_188624_d;
    }

    public IBakedModel handlePerspective(ItemCameraTransforms.TransformType transformType, MatrixStack matrixStack) {
        return this.defaultModel.handlePerspective(transformType, matrixStack);
    }

    public ItemOverrideList func_188617_f() {
        return this.field_188625_e;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Builder {
        private final List<Pair<Predicate<BlockState>, IBakedModel>> field_188649_a = Lists.newArrayList();

        public void func_188648_a(Predicate<BlockState> predicate, IBakedModel model) {
            this.field_188649_a.add((Pair<Predicate<BlockState>, IBakedModel>)Pair.of(predicate, (Object)model));
        }

        public IBakedModel func_188647_a() {
            return new MultipartBakedModel(this.field_188649_a);
        }
    }
}

