/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.model;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.WeightedRandom;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;

@OnlyIn(value=Dist.CLIENT)
public class WeightedBakedModel
implements IDynamicBakedModel {
    private final int field_177567_a;
    private final List<WeightedModel> field_177565_b;
    private final IBakedModel field_177566_c;

    public WeightedBakedModel(List<WeightedModel> modelsIn) {
        this.field_177565_b = modelsIn;
        this.field_177567_a = WeightedRandom.func_76272_a(modelsIn);
        this.field_177566_c = modelsIn.get((int)0).field_185281_b;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData modelData) {
        return ((WeightedModel)WeightedRandom.func_180166_a(this.field_177565_b, (int)(Math.abs((int)((int)rand.nextLong())) % this.field_177567_a))).field_185281_b.getQuads(state, side, rand, modelData);
    }

    public boolean func_177555_b() {
        return this.field_177566_c.func_177555_b();
    }

    public boolean isAmbientOcclusion(BlockState state) {
        return this.field_177566_c.isAmbientOcclusion(state);
    }

    public boolean func_177556_c() {
        return this.field_177566_c.func_177556_c();
    }

    public boolean func_230044_c_() {
        return this.field_177566_c.func_230044_c_();
    }

    public boolean func_188618_c() {
        return this.field_177566_c.func_188618_c();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.field_177566_c.func_177554_e();
    }

    public TextureAtlasSprite getParticleTexture(IModelData modelData) {
        return this.field_177566_c.getParticleTexture(modelData);
    }

    public ItemCameraTransforms func_177552_f() {
        return this.field_177566_c.func_177552_f();
    }

    public IBakedModel handlePerspective(ItemCameraTransforms.TransformType transformType, MatrixStack matrixStack) {
        return this.field_177566_c.handlePerspective(transformType, matrixStack);
    }

    public ItemOverrideList func_188617_f() {
        return this.field_177566_c.func_188617_f();
    }

    @OnlyIn(value=Dist.CLIENT)
    static class WeightedModel
    extends WeightedRandom.Item {
        protected final IBakedModel field_185281_b;

        public WeightedModel(IBakedModel modelIn, int itemWeightIn) {
            super(itemWeightIn);
            this.field_185281_b = modelIn;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Builder {
        private final List<WeightedModel> field_177678_a = Lists.newArrayList();

        public Builder func_177677_a(@Nullable IBakedModel model, int weight) {
            if (model != null) {
                this.field_177678_a.add(new WeightedModel(model, weight));
            }
            return this;
        }

        @Nullable
        public IBakedModel func_209614_a() {
            if (this.field_177678_a.isEmpty()) {
                return null;
            }
            return this.field_177678_a.size() == 1 ? this.field_177678_a.get((int)0).field_185281_b : new WeightedBakedModel(this.field_177678_a);
        }
    }
}

