/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.EnumSet;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.ResetAngerGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.EndermiteEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.TickRangeConverter;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.eventbus.api.Event;

public class EndermanEntity
extends MonsterEntity
implements IAngerable {
    private static final UUID field_110192_bp = UUID.fromString("020E0DFB-87AE-4653-9556-831010E291A0");
    private static final AttributeModifier field_110193_bq = new AttributeModifier(field_110192_bp, "Attacking speed boost", (double)0.15f, AttributeModifier.Operation.ADDITION);
    private static final DataParameter<Optional<BlockState>> field_184718_bv = EntityDataManager.func_187226_a(EndermanEntity.class, DataSerializers.field_187197_g);
    private static final DataParameter<Boolean> field_184719_bw = EntityDataManager.func_187226_a(EndermanEntity.class, DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> field_226535_bx_ = EntityDataManager.func_187226_a(EndermanEntity.class, DataSerializers.field_187198_h);
    private static final Predicate<LivingEntity> field_213627_bA = p_213626_0_ -> p_213626_0_ instanceof EndermiteEntity && ((EndermiteEntity)p_213626_0_).func_175495_n();
    private int field_226536_bz_ = Integer.MIN_VALUE;
    private int field_184721_by;
    private static final RangedInteger field_234286_bz_ = TickRangeConverter.func_233037_a_((int)20, (int)39);
    private int field_234284_bA_;
    private UUID field_234285_bB_;

    public EndermanEntity(EntityType<? extends EndermanEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70138_W = 1.0f;
        this.func_184644_a(PathNodeType.WATER, -1.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)((Object)this)));
        this.field_70714_bg.func_75776_a(1, (Goal)new StareGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0, 0.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)((Object)this), PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)((Object)this)));
        this.field_70714_bg.func_75776_a(10, (Goal)new PlaceBlockGoal(this));
        this.field_70714_bg.func_75776_a(11, (Goal)new TakeBlockGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)((Object)this), PlayerEntity.class, 10, true, false, arg_0 -> ((EndermanEntity)this).func_233680_b_(arg_0)));
        this.field_70715_bh.func_75776_a(2, (Goal)new FindPlayerGoal(this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)((Object)this), EndermiteEntity.class, 10, true, false, field_213627_bA));
        this.field_70715_bh.func_75776_a(5, (Goal)new ResetAngerGoal((MobEntity)((Object)this), false));
    }

    public static AttributeModifierMap.MutableAttribute func_234287_m_() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 40.0).func_233815_a_(Attributes.field_233821_d_, (double)0.3f).func_233815_a_(Attributes.field_233823_f_, 7.0).func_233815_a_(Attributes.field_233819_b_, 64.0);
    }

    public void func_70624_b(@Nullable LivingEntity entitylivingbaseIn) {
        ModifiableAttributeInstance modifiableattributeinstance = this.func_110148_a(Attributes.field_233821_d_);
        if (entitylivingbaseIn == null) {
            this.field_184721_by = 0;
            this.field_70180_af.func_187227_b(field_184719_bw, false);
            this.field_70180_af.func_187227_b(field_226535_bx_, false);
            modifiableattributeinstance.func_111124_b(field_110193_bq);
        } else {
            this.field_184721_by = this.field_70173_aa;
            this.field_70180_af.func_187227_b(field_184719_bw, true);
            if (!modifiableattributeinstance.func_180374_a(field_110193_bq)) {
                modifiableattributeinstance.func_233767_b_(field_110193_bq);
            }
        }
        super.func_70624_b(entitylivingbaseIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184718_bv, Optional.empty());
        this.field_70180_af.func_187214_a(field_184719_bw, false);
        this.field_70180_af.func_187214_a(field_226535_bx_, false);
    }

    public void func_230258_H__() {
        this.func_230260_a__(field_234286_bz_.func_233018_a_(this.field_70146_Z));
    }

    public void func_230260_a__(int p_230260_1_) {
        this.field_234284_bA_ = p_230260_1_;
    }

    public int func_230256_F__() {
        return this.field_234284_bA_;
    }

    public void func_230259_a_(@Nullable UUID p_230259_1_) {
        this.field_234285_bB_ = p_230259_1_;
    }

    public UUID func_230257_G__() {
        return this.field_234285_bB_;
    }

    public void func_226539_l_() {
        if (this.field_70173_aa >= this.field_226536_bz_ + 400) {
            this.field_226536_bz_ = this.field_70173_aa;
            if (!this.func_174814_R()) {
                this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_(), SoundEvents.field_187533_aW, this.func_184176_by(), 2.5f, 1.0f, false);
            }
        }
    }

    public void func_184206_a(DataParameter<?> key) {
        if (field_184719_bw.equals(key) && this.func_226537_et_() && this.field_70170_p.field_72995_K) {
            this.func_226539_l_();
        }
        super.func_184206_a(key);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        BlockState blockstate = this.func_195405_dq();
        if (blockstate != null) {
            compound.func_218657_a("carriedBlockState", NBTUtil.func_190009_a((BlockState)blockstate));
        }
        this.func_233682_c_(compound);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        BlockState blockstate = null;
        if (compound.func_150297_b("carriedBlockState", 10) && (blockstate = NBTUtil.func_190008_d((CompoundNBT)compound.func_74775_l("carriedBlockState"))).func_196958_f()) {
            blockstate = null;
        }
        this.func_195406_b(blockstate);
        this.func_241358_a_((ServerWorld)this.field_70170_p, compound);
    }

    private boolean func_70821_d(PlayerEntity player) {
        ItemStack itemstack = (ItemStack)((Object)player.field_71071_by.field_70460_b.get(3));
        if (itemstack.isEnderMask(player, this)) {
            return false;
        }
        Vector3d vector3d = player.func_70676_i(1.0f).func_72432_b();
        Vector3d vector3d1 = new Vector3d(this.func_226277_ct_() - player.func_226277_ct_(), this.func_226280_cw_() - player.func_226280_cw_(), this.func_226281_cx_() - player.func_226281_cx_());
        double d0 = vector3d1.func_72433_c();
        double d1 = vector3d.func_72430_b(vector3d1 = vector3d1.func_72432_b());
        return d1 > 1.0 - 0.025 / d0 ? player.func_70685_l((Entity)((Object)this)) : false;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 2.55f;
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197599_J, this.func_226282_d_(0.5), this.func_226279_cv_() - 0.25, this.func_226287_g_(0.5), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
            }
        }
        this.field_70703_bu = false;
        if (!this.field_70170_p.field_72995_K) {
            this.func_241359_a_((ServerWorld)this.field_70170_p, true);
        }
        super.func_70636_d();
    }

    public boolean func_230270_dK_() {
        return true;
    }

    protected void func_70619_bc() {
        float f;
        if (this.field_70170_p.func_72935_r() && this.field_70173_aa >= this.field_184721_by + 600 && (f = this.func_70013_c()) > 0.5f && this.field_70170_p.func_226660_f_(this.func_233580_cy_()) && this.field_70146_Z.nextFloat() * 30.0f < (f - 0.4f) * 2.0f) {
            this.func_70624_b(null);
            this.func_70820_n();
        }
        super.func_70619_bc();
    }

    protected boolean func_70820_n() {
        if (!this.field_70170_p.func_201670_d() && this.func_70089_S()) {
            double d0 = this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
            double d1 = this.func_226278_cu_() + (double)(this.field_70146_Z.nextInt(64) - 32);
            double d2 = this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
            return this.func_70825_j(d0, d1, d2);
        }
        return false;
    }

    private boolean func_70816_c(Entity p_70816_1_) {
        Vector3d vector3d = new Vector3d(this.func_226277_ct_() - p_70816_1_.func_226277_ct_(), this.func_226283_e_(0.5) - p_70816_1_.func_226280_cw_(), this.func_226281_cx_() - p_70816_1_.func_226281_cx_());
        vector3d = vector3d.func_72432_b();
        double d0 = 16.0;
        double d1 = this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vector3d.field_72450_a * 16.0;
        double d2 = this.func_226278_cu_() + (double)(this.field_70146_Z.nextInt(16) - 8) - vector3d.field_72448_b * 16.0;
        double d3 = this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vector3d.field_72449_c * 16.0;
        return this.func_70825_j(d1, d2, d3);
    }

    private boolean func_70825_j(double x, double y, double z) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable(x, y, z);
        while (blockpos$mutable.func_177956_o() > 0 && !this.field_70170_p.func_180495_p((BlockPos)blockpos$mutable).func_185904_a().func_76230_c()) {
            blockpos$mutable.func_189536_c(Direction.DOWN);
        }
        BlockState blockstate = this.field_70170_p.func_180495_p((BlockPos)blockpos$mutable);
        boolean flag = blockstate.func_185904_a().func_76230_c();
        boolean flag1 = blockstate.func_204520_s().func_206884_a(FluidTags.field_206959_a);
        if (flag && !flag1) {
            EnderTeleportEvent event = new EnderTeleportEvent((LivingEntity)((Object)this), x, y, z, 0.0f);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return false;
            }
            boolean flag2 = this.func_213373_a(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (flag2 && !this.func_174814_R()) {
                this.field_70170_p.func_184148_a(null, this.field_70169_q, this.field_70167_r, this.field_70166_s, SoundEvents.field_187534_aX, this.func_184176_by(), 1.0f, 1.0f);
                this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
            }
            return flag2;
        }
        return false;
    }

    protected SoundEvent func_184639_G() {
        return this.func_70823_r() ? SoundEvents.field_187532_aV : SoundEvents.field_187529_aS;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187531_aU;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187530_aT;
    }

    protected void func_213333_a(DamageSource source, int looting, boolean recentlyHitIn) {
        super.func_213333_a(source, looting, recentlyHitIn);
        BlockState blockstate = this.func_195405_dq();
        if (blockstate != null) {
            this.func_199703_a(blockstate.func_177230_c());
        }
    }

    public void func_195406_b(@Nullable BlockState state) {
        this.field_70180_af.func_187227_b(field_184718_bv, Optional.ofNullable(state));
    }

    @Nullable
    public BlockState func_195405_dq() {
        return this.field_70180_af.func_187225_a(field_184718_bv).orElse(null);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (source instanceof IndirectEntityDamageSource) {
            for (int i = 0; i < 64; ++i) {
                if (!this.func_70820_n()) continue;
                return true;
            }
            return false;
        }
        boolean flag = super.func_70097_a(source, amount);
        if (!this.field_70170_p.func_201670_d() && this.field_70146_Z.nextInt(10) != 0) {
            this.func_70820_n();
        }
        return flag;
    }

    public boolean func_70823_r() {
        return this.field_70180_af.func_187225_a(field_184719_bw);
    }

    public boolean func_226537_et_() {
        return this.field_70180_af.func_187225_a(field_226535_bx_);
    }

    public void func_226538_eu_() {
        this.field_70180_af.func_187227_b(field_226535_bx_, true);
    }

    public boolean func_213392_I() {
        return super.func_213392_I() || this.func_195405_dq() != null;
    }

    static class TakeBlockGoal
    extends Goal {
        private final EndermanEntity field_179473_a;

        public TakeBlockGoal(EndermanEntity endermanIn) {
            this.field_179473_a = endermanIn;
        }

        public boolean func_75250_a() {
            if (this.field_179473_a.func_195405_dq() != null) {
                return false;
            }
            if (!ForgeEventFactory.getMobGriefingEvent((World)this.field_179473_a.field_70170_p, (Entity)((Object)this.field_179473_a))) {
                return false;
            }
            return this.field_179473_a.func_70681_au().nextInt(20) == 0;
        }

        public void func_75246_d() {
            Random random = this.field_179473_a.func_70681_au();
            World world = this.field_179473_a.field_70170_p;
            int i = MathHelper.func_76128_c((double)(this.field_179473_a.func_226277_ct_() - 2.0 + random.nextDouble() * 4.0));
            int j = MathHelper.func_76128_c((double)(this.field_179473_a.func_226278_cu_() + random.nextDouble() * 3.0));
            int k = MathHelper.func_76128_c((double)(this.field_179473_a.func_226281_cx_() - 2.0 + random.nextDouble() * 4.0));
            BlockPos blockpos = new BlockPos(i, j, k);
            BlockState blockstate = world.func_180495_p(blockpos);
            Block block = blockstate.func_177230_c();
            Vector3d vector3d = new Vector3d((double)MathHelper.func_76128_c((double)this.field_179473_a.func_226277_ct_()) + 0.5, (double)j + 0.5, (double)MathHelper.func_76128_c((double)this.field_179473_a.func_226281_cx_()) + 0.5);
            Vector3d vector3d1 = new Vector3d((double)i + 0.5, (double)j + 0.5, (double)k + 0.5);
            BlockRayTraceResult blockraytraceresult = world.func_217299_a(new RayTraceContext(vector3d, vector3d1, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)((Object)this.field_179473_a)));
            boolean flag = blockraytraceresult.func_216350_a().equals((Object)blockpos);
            if (block.func_203417_a(BlockTags.field_201151_l) && flag) {
                this.field_179473_a.func_195406_b(blockstate);
                world.func_217377_a(blockpos, false);
            }
        }
    }

    static class StareGoal
    extends Goal {
        private final EndermanEntity field_220835_a;
        private LivingEntity field_226540_b_;

        public StareGoal(EndermanEntity endermanIn) {
            this.field_220835_a = endermanIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            this.field_226540_b_ = this.field_220835_a.func_70638_az();
            if (!(this.field_226540_b_ instanceof PlayerEntity)) {
                return false;
            }
            double d0 = this.field_226540_b_.func_70068_e((Entity)((Object)this.field_220835_a));
            return d0 > 256.0 ? false : this.field_220835_a.func_70821_d((PlayerEntity)this.field_226540_b_);
        }

        public void func_75249_e() {
            this.field_220835_a.func_70661_as().func_75499_g();
        }

        public void func_75246_d() {
            this.field_220835_a.func_70671_ap().func_220679_a(this.field_226540_b_.func_226277_ct_(), this.field_226540_b_.func_226280_cw_(), this.field_226540_b_.func_226281_cx_());
        }
    }

    static class PlaceBlockGoal
    extends Goal {
        private final EndermanEntity field_179475_a;

        public PlaceBlockGoal(EndermanEntity p_i45843_1_) {
            this.field_179475_a = p_i45843_1_;
        }

        public boolean func_75250_a() {
            if (this.field_179475_a.func_195405_dq() == null) {
                return false;
            }
            if (!ForgeEventFactory.getMobGriefingEvent((World)this.field_179475_a.field_70170_p, (Entity)((Object)this.field_179475_a))) {
                return false;
            }
            return this.field_179475_a.func_70681_au().nextInt(2000) == 0;
        }

        public void func_75246_d() {
            Random random = this.field_179475_a.func_70681_au();
            World iworld = this.field_179475_a.field_70170_p;
            int i = MathHelper.func_76128_c((double)(this.field_179475_a.func_226277_ct_() - 1.0 + random.nextDouble() * 2.0));
            int j = MathHelper.func_76128_c((double)(this.field_179475_a.func_226278_cu_() + random.nextDouble() * 2.0));
            int k = MathHelper.func_76128_c((double)(this.field_179475_a.func_226281_cx_() - 1.0 + random.nextDouble() * 2.0));
            BlockPos blockpos = new BlockPos(i, j, k);
            BlockState blockstate = iworld.func_180495_p(blockpos);
            BlockPos blockpos1 = blockpos.func_177977_b();
            BlockState blockstate1 = iworld.func_180495_p(blockpos1);
            BlockState blockstate2 = this.field_179475_a.func_195405_dq();
            if (blockstate2 != null && this.func_220836_a((IWorldReader)((Object)iworld), blockpos, blockstate2, blockstate, blockstate1, blockpos1) && !ForgeEventFactory.onBlockPlace((Entity)((Object)this.field_179475_a), (BlockSnapshot)BlockSnapshot.create((IWorld)iworld, (BlockPos)blockpos1), (Direction)Direction.UP)) {
                iworld.func_180501_a(blockpos, blockstate2, 3);
                this.field_179475_a.func_195406_b(null);
            }
        }

        private boolean func_220836_a(IWorldReader p_220836_1_, BlockPos p_220836_2_, BlockState p_220836_3_, BlockState p_220836_4_, BlockState p_220836_5_, BlockPos p_220836_6_) {
            return p_220836_4_.isAir((IBlockReader)((Object)p_220836_1_), p_220836_2_) && !p_220836_5_.isAir((IBlockReader)((Object)p_220836_1_), p_220836_6_) && p_220836_5_.func_235785_r_((IBlockReader)((Object)p_220836_1_), p_220836_6_) && p_220836_3_.func_196955_c(p_220836_1_, p_220836_2_);
        }
    }

    static class FindPlayerGoal
    extends NearestAttackableTargetGoal<PlayerEntity> {
        private final EndermanEntity field_179449_j;
        private PlayerEntity field_179448_g;
        private int field_179450_h;
        private int field_179451_i;
        private final EntityPredicate field_220791_m;
        private final EntityPredicate field_220792_n = new EntityPredicate().func_221014_c();

        public FindPlayerGoal(EndermanEntity endermanIn) {
            super((MobEntity)((Object)endermanIn), PlayerEntity.class, false);
            this.field_179449_j = endermanIn;
            this.field_220791_m = new EntityPredicate().func_221013_a(this.func_111175_f()).func_221012_a(p_220790_1_ -> endermanIn.func_70821_d((PlayerEntity)((Object)p_220790_1_)));
        }

        public boolean func_75250_a() {
            this.field_179448_g = this.field_179449_j.field_70170_p.func_217370_a(this.field_220791_m, (LivingEntity)((Object)this.field_179449_j));
            return this.field_179448_g != null;
        }

        public void func_75249_e() {
            this.field_179450_h = 5;
            this.field_179451_i = 0;
            this.field_179449_j.func_226538_eu_();
        }

        public void func_75251_c() {
            this.field_179448_g = null;
            super.func_75251_c();
        }

        public boolean func_75253_b() {
            if (this.field_179448_g != null) {
                if (!this.field_179449_j.func_70821_d(this.field_179448_g)) {
                    return false;
                }
                this.field_179449_j.func_70625_a(this.field_179448_g, 10.0f, 10.0f);
                return true;
            }
            return this.field_75309_a != null && this.field_220792_n.func_221015_a((LivingEntity)((Object)this.field_179449_j), this.field_75309_a) ? true : super.func_75253_b();
        }

        public void func_75246_d() {
            if (this.field_179449_j.func_70638_az() == null) {
                super.func_234054_a_((LivingEntity)null);
            }
            if (this.field_179448_g != null) {
                if (--this.field_179450_h <= 0) {
                    this.field_75309_a = this.field_179448_g;
                    this.field_179448_g = null;
                    super.func_75249_e();
                }
            } else {
                if (this.field_75309_a != null && !this.field_179449_j.func_184218_aH()) {
                    if (this.field_179449_j.func_70821_d((PlayerEntity)this.field_75309_a)) {
                        if (this.field_75309_a.func_70068_e((Entity)((Object)this.field_179449_j)) < 16.0) {
                            this.field_179449_j.func_70820_n();
                        }
                        this.field_179451_i = 0;
                    } else if (this.field_75309_a.func_70068_e((Entity)((Object)this.field_179449_j)) > 256.0 && this.field_179451_i++ >= 30 && this.field_179449_j.func_70816_c(this.field_75309_a)) {
                        this.field_179451_i = 0;
                    }
                }
                super.func_75246_d();
            }
        }
    }
}

