/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.EndNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTypes;

public class CompressedStreamTools {
    public static CompoundNBT func_74796_a(InputStream is) throws IOException {
        CompoundNBT compoundnbt;
        try (DataInputStream datainputstream = new DataInputStream(new BufferedInputStream(new GZIPInputStream(is)));){
            compoundnbt = CompressedStreamTools.func_152456_a(datainputstream, NBTSizeTracker.field_152451_a);
        }
        return compoundnbt;
    }

    public static void func_74799_a(CompoundNBT compound, OutputStream outputStream) throws IOException {
        try (DataOutputStream dataoutputstream = new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream(outputStream)));){
            CompressedStreamTools.func_74800_a(compound, dataoutputstream);
        }
    }

    public static void func_74795_b(CompoundNBT compound, File fileIn) throws IOException {
        try (DataOutputStream dataoutputstream = new DataOutputStream(new FileOutputStream(fileIn));){
            CompressedStreamTools.func_74800_a(compound, dataoutputstream);
        }
    }

    @Nullable
    public static CompoundNBT func_74797_a(File fileIn) throws IOException {
        CompoundNBT compoundnbt;
        if (!fileIn.exists()) {
            return null;
        }
        try (DataInputStream datainputstream = new DataInputStream(new FileInputStream(fileIn));){
            compoundnbt = CompressedStreamTools.func_152456_a(datainputstream, NBTSizeTracker.field_152451_a);
        }
        return compoundnbt;
    }

    public static CompoundNBT func_74794_a(DataInputStream inputStream) throws IOException {
        return CompressedStreamTools.func_152456_a(inputStream, NBTSizeTracker.field_152451_a);
    }

    public static CompoundNBT func_152456_a(DataInput input, NBTSizeTracker accounter) throws IOException {
        INBT inbt = CompressedStreamTools.func_152455_a(input, 0, accounter);
        if (inbt instanceof CompoundNBT) {
            return (CompoundNBT)inbt;
        }
        throw new IOException("Root tag must be a named compound tag");
    }

    public static void func_74800_a(CompoundNBT compound, DataOutput output) throws IOException {
        CompressedStreamTools.func_150663_a(compound, output);
    }

    private static void func_150663_a(INBT tag, DataOutput output) throws IOException {
        output.writeByte(tag.func_74732_a());
        if (tag.func_74732_a() != 0) {
            output.writeUTF("");
            tag.func_74734_a(output);
        }
    }

    private static INBT func_152455_a(DataInput input, int depth, NBTSizeTracker accounter) throws IOException {
        byte b0 = input.readByte();
        accounter.func_152450_a(8L);
        if (b0 == 0) {
            return EndNBT.field_229686_b_;
        }
        accounter.readUTF(input.readUTF());
        accounter.func_152450_a(32L);
        try {
            return NBTTypes.func_229710_a_((int)b0).func_225649_b_(input, depth, accounter);
        }
        catch (IOException ioexception) {
            CrashReport crashreport = CrashReport.func_85055_a(ioexception, "Loading NBT data");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("NBT Tag");
            crashreportcategory.func_71507_a("Tag type", b0);
            throw new ReportedException(crashreport);
        }
    }
}

