/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.datafixers.DataFixer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.invoke.LambdaMetafactory;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.net.Proxy;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyPair;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.advancements.AdvancementManager;
import net.minecraft.advancements.FunctionManager;
import net.minecraft.block.Block;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ICommandSource;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.player.SpawnLocationHelper;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.loot.LootPredicateManager;
import net.minecraft.loot.LootTableManager;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkSystem;
import net.minecraft.network.ServerStatusResponse;
import net.minecraft.network.play.server.SServerDifficultyPacket;
import net.minecraft.network.play.server.SUpdateTimePacket;
import net.minecraft.profiler.EmptyProfiler;
import net.minecraft.profiler.IProfileResult;
import net.minecraft.profiler.IProfiler;
import net.minecraft.profiler.ISnooperInfo;
import net.minecraft.profiler.LongTickDetector;
import net.minecraft.profiler.Snooper;
import net.minecraft.profiler.TimeTracker;
import net.minecraft.resources.DataPackRegistries;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.scoreboard.ScoreboardSaveData;
import net.minecraft.scoreboard.ServerScoreboard;
import net.minecraft.server.CustomServerBossInfoManager;
import net.minecraft.server.IDynamicRegistries;
import net.minecraft.server.management.OpEntry;
import net.minecraft.server.management.PlayerList;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.server.management.WhiteList;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.NetworkTagManager;
import net.minecraft.test.TestCollection;
import net.minecraft.util.FrameTimer;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Unit;
import net.minecraft.util.Util;
import net.minecraft.util.concurrent.RecursiveEventLoop;
import net.minecraft.util.concurrent.TickDelayedTask;
import net.minecraft.util.datafix.codec.DatapackCodec;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.SimpleRegistry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.village.VillageSiege;
import net.minecraft.world.Difficulty;
import net.minecraft.world.Dimension;
import net.minecraft.world.DimensionType;
import net.minecraft.world.ForcedChunksSaveData;
import net.minecraft.world.GameRules;
import net.minecraft.world.GameType;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.border.IBorderListener;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.listener.IChunkStatusListener;
import net.minecraft.world.chunk.listener.IChunkStatusListenerFactory;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;
import net.minecraft.world.spawner.CatSpawner;
import net.minecraft.world.spawner.ISpecialSpawner;
import net.minecraft.world.spawner.PatrolSpawner;
import net.minecraft.world.spawner.PhantomSpawner;
import net.minecraft.world.spawner.WanderingTraderSpawner;
import net.minecraft.world.storage.CommandStorage;
import net.minecraft.world.storage.DerivedWorldInfo;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.FolderName;
import net.minecraft.world.storage.IServerConfiguration;
import net.minecraft.world.storage.IServerWorldInfo;
import net.minecraft.world.storage.IWorldInfo;
import net.minecraft.world.storage.PlayerData;
import net.minecraft.world.storage.SaveFormat;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraft.world.storage.WorldSavedDataCallableSave;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.BrandingControl;
import net.minecraftforge.fml.common.thread.SidedThreadGroups;
import net.minecraftforge.fml.hooks.BasicEventHooks;
import net.minecraftforge.fml.packs.ResourcePackLoader;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MinecraftServer
extends RecursiveEventLoop<TickDelayedTask>
implements ISnooperInfo,
ICommandSource,
AutoCloseable {
    private static final Logger field_147145_h = LogManager.getLogger();
    public static final File field_152367_a = new File("usercache.json");
    public static final WorldSettings field_213219_c = new WorldSettings("Demo World", GameType.SURVIVAL, false, Difficulty.NORMAL, false, new GameRules(), DatapackCodec.field_234880_a_);
    protected final SaveFormat.LevelSave field_71310_m;
    protected final PlayerData field_240766_e_;
    private final Snooper field_71307_n = new Snooper("server", (ISnooperInfo)this, Util.func_211177_b());
    private final List<Runnable> field_71322_p = Lists.newArrayList();
    private TimeTracker field_240769_m_ = new TimeTracker(Util.field_211180_a, this::func_71259_af);
    private IProfiler field_71304_b = EmptyProfiler.field_219906_a;
    private final NetworkSystem field_147144_o;
    private final IChunkStatusListenerFactory field_213220_d;
    private final ServerStatusResponse field_147147_p = new ServerStatusResponse();
    private final Random field_147146_q = new Random();
    private final DataFixer field_184112_s;
    private String field_71320_r;
    private int field_71319_s = -1;
    protected final IDynamicRegistries.Impl field_240767_f_;
    private final Map<RegistryKey<World>, ServerWorld> field_71305_c = Maps.newLinkedHashMap();
    private PlayerList field_71318_t;
    private volatile boolean field_71317_u = true;
    private boolean field_71316_v;
    private int field_71315_w;
    protected final Proxy field_110456_c;
    private boolean field_71325_x;
    private boolean field_190519_A;
    private boolean field_71284_A;
    private boolean field_71285_B;
    @Nullable
    private String field_71286_C;
    private int field_71280_D;
    private int field_143008_E;
    public final long[] field_71311_j = new long[100];
    @Nullable
    private KeyPair field_71292_I;
    @Nullable
    private String field_71293_J;
    private boolean field_71288_M;
    private String field_147141_M = "";
    private String field_175588_P = "";
    private volatile boolean field_71296_Q;
    private long field_71299_R;
    private boolean field_71295_T;
    private boolean field_104057_T;
    private final MinecraftSessionService field_147143_S;
    private final GameProfileRepository field_152365_W;
    private final PlayerProfileCache field_152366_X;
    private long field_147142_T;
    private final Thread field_175590_aa;
    protected long field_211151_aa = Util.func_211177_b();
    private long field_213213_ab;
    private boolean field_213214_ac;
    @OnlyIn(value=Dist.CLIENT)
    private boolean field_184111_ab;
    private final ResourcePackList<ResourcePackInfo> field_195577_ad;
    private final ServerScoreboard field_200255_ai = new ServerScoreboard(this);
    @Nullable
    private CommandStorage field_229733_al_;
    private final CustomServerBossInfoManager field_201301_aj = new CustomServerBossInfoManager();
    private final FunctionManager field_200258_al;
    private final FrameTimer field_213215_ap = new FrameTimer();
    private boolean field_205745_an;
    private float field_211152_ao;
    private final Executor field_213217_au;
    @Nullable
    private String field_213218_av;
    private DataPackRegistries field_195576_ac;
    private final TemplateManager field_240765_ak_;
    protected final IServerConfiguration field_240768_i_;
    private Map<RegistryKey<World>, long[]> perWorldTickTimes = Maps.newIdentityHashMap();
    private int worldArrayMarker = 0;
    private int worldArrayLast = -1;
    private ServerWorld[] worldArray;

    public static <S extends MinecraftServer> S func_240784_a_(Function<Thread, S> p_240784_0_) {
        AtomicReference<MinecraftServer> atomicreference = new AtomicReference<MinecraftServer>();
        Thread thread = new Thread((ThreadGroup)SidedThreadGroups.SERVER, () -> ((MinecraftServer)atomicreference.get()).func_240802_v_(), "Server thread");
        thread.setUncaughtExceptionHandler((p_240779_0_, p_240779_1_) -> field_147145_h.error((Object)p_240779_1_));
        MinecraftServer s = (MinecraftServer)p_240784_0_.apply(thread);
        atomicreference.set(s);
        thread.start();
        return (S)s;
    }

    public MinecraftServer(Thread p_i232576_1_, IDynamicRegistries.Impl p_i232576_2_, SaveFormat.LevelSave p_i232576_3_, IServerConfiguration p_i232576_4_, ResourcePackList<ResourcePackInfo> p_i232576_5_, Proxy p_i232576_6_, DataFixer p_i232576_7_, DataPackRegistries p_i232576_8_, MinecraftSessionService p_i232576_9_, GameProfileRepository p_i232576_10_, PlayerProfileCache p_i232576_11_, IChunkStatusListenerFactory p_i232576_12_) {
        super("Server");
        this.field_240767_f_ = p_i232576_2_;
        this.field_240768_i_ = p_i232576_4_;
        this.field_110456_c = p_i232576_6_;
        this.field_195577_ad = p_i232576_5_;
        this.field_195576_ac = p_i232576_8_;
        this.field_147143_S = p_i232576_9_;
        this.field_152365_W = p_i232576_10_;
        this.field_152366_X = p_i232576_11_;
        this.field_147144_o = new NetworkSystem(this);
        this.field_213220_d = p_i232576_12_;
        this.field_71310_m = p_i232576_3_;
        this.field_240766_e_ = p_i232576_3_.func_237292_b_();
        this.field_184112_s = p_i232576_7_;
        this.field_200258_al = new FunctionManager(this, p_i232576_8_.func_240960_a_());
        this.field_240765_ak_ = new TemplateManager(p_i232576_8_.func_240970_h_(), p_i232576_3_, p_i232576_7_);
        this.field_175590_aa = p_i232576_1_;
        this.field_213217_au = Util.func_215072_e();
    }

    private void func_213204_a(DimensionSavedDataManager p_213204_1_) {
        ScoreboardSaveData scoreboardsavedata = p_213204_1_.func_215752_a(ScoreboardSaveData::new, "scoreboard");
        scoreboardsavedata.func_96499_a((Scoreboard)this.func_200251_aP());
        this.func_200251_aP().func_186684_a((Runnable)new WorldSavedDataCallableSave((WorldSavedData)scoreboardsavedata));
    }

    protected abstract boolean func_71197_b() throws IOException;

    public static void func_240777_a_(SaveFormat.LevelSave p_240777_0_) {
        if (p_240777_0_.func_237295_c_()) {
            field_147145_h.info("Converting map!");
            p_240777_0_.func_237283_a_(new IProgressUpdate(){
                private long field_96245_b = Util.func_211177_b();

                public void func_200210_a(ITextComponent component) {
                }

                @OnlyIn(value=Dist.CLIENT)
                public void func_200211_b(ITextComponent component) {
                }

                public void func_73718_a(int progress) {
                    if (Util.func_211177_b() - this.field_96245_b >= 1000L) {
                        this.field_96245_b = Util.func_211177_b();
                        field_147145_h.info("Converting... {}%", (Object)progress);
                    }
                }

                @OnlyIn(value=Dist.CLIENT)
                public void func_146586_a() {
                }

                public void func_200209_c(ITextComponent component) {
                }
            });
        }
    }

    protected void func_240800_l__() {
        this.func_175584_a();
        this.field_240768_i_.func_230412_a_(this.getServerModName(), this.func_230045_q_().isPresent());
        IChunkStatusListener ichunkstatuslistener = this.field_213220_d.create(11);
        this.func_240787_a_(ichunkstatuslistener);
        this.func_230543_p_();
        this.func_213186_a(ichunkstatuslistener);
    }

    protected void func_230543_p_() {
    }

    protected void func_240787_a_(IChunkStatusListener p_240787_1_) {
        ChunkGenerator chunkgenerator;
        DimensionType dimensiontype;
        IServerWorldInfo iserverworldinfo = this.field_240768_i_.func_230407_G_();
        DimensionGeneratorSettings dimensiongeneratorsettings = this.field_240768_i_.func_230418_z_();
        boolean flag = dimensiongeneratorsettings.func_236227_h_();
        long i = dimensiongeneratorsettings.func_236221_b_();
        long j = BiomeManager.func_235200_a_((long)i);
        ImmutableList list = ImmutableList.of((Object)new PhantomSpawner(), (Object)new PatrolSpawner(), (Object)new CatSpawner(), (Object)new VillageSiege(), (Object)new WanderingTraderSpawner(iserverworldinfo));
        SimpleRegistry simpleregistry = dimensiongeneratorsettings.func_236224_e_();
        Dimension dimension = (Dimension)simpleregistry.func_230516_a_(Dimension.field_236053_b_);
        if (dimension == null) {
            dimensiontype = DimensionType.func_236019_a_();
            chunkgenerator = DimensionGeneratorSettings.func_236211_a_((long)new Random().nextLong());
        } else {
            dimensiontype = dimension.func_236063_b_();
            chunkgenerator = dimension.func_236064_c_();
        }
        RegistryKey<DimensionType> registrykey = this.field_240767_f_.func_230520_a_().func_230519_c_(dimensiontype).orElseThrow(() -> new IllegalStateException("Unregistered dimension type: " + dimensiontype));
        ServerWorld serverworld = new ServerWorld(this, this.field_213217_au, this.field_71310_m, iserverworldinfo, World.field_234918_g_, registrykey, dimensiontype, p_240787_1_, chunkgenerator, flag, j, (List<ISpecialSpawner>)list, true);
        this.field_71305_c.put(World.field_234918_g_, serverworld);
        DimensionSavedDataManager dimensionsaveddatamanager = serverworld.func_217481_x();
        this.func_213204_a(dimensionsaveddatamanager);
        this.field_229733_al_ = new CommandStorage(dimensionsaveddatamanager);
        WorldBorder worldborder = serverworld.func_175723_af();
        worldborder.func_235926_a_(iserverworldinfo.func_230398_q_());
        if (!iserverworldinfo.func_76070_v()) {
            try {
                MinecraftServer.func_240786_a_(serverworld, iserverworldinfo, dimensiongeneratorsettings.func_236223_d_(), flag, true);
                iserverworldinfo.func_76091_d(true);
                if (flag) {
                    this.func_240778_a_(this.field_240768_i_);
                }
            }
            catch (Throwable throwable1) {
                CrashReport crashreport = CrashReport.func_85055_a(throwable1, "Exception initializing level");
                try {
                    serverworld.func_72914_a(crashreport);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw new ReportedException(crashreport);
            }
            iserverworldinfo.func_76091_d(true);
        }
        this.func_184103_al().func_212504_a(serverworld);
        if (this.field_240768_i_.func_230404_D_() != null) {
            this.func_201300_aS().func_201381_a(this.field_240768_i_.func_230404_D_());
        }
        for (Map.Entry entry : simpleregistry.func_239659_c_()) {
            RegistryKey registrykey1 = (RegistryKey)entry.getKey();
            if (registrykey1 != Dimension.field_236053_b_) {
                RegistryKey<World> registrykey2 = RegistryKey.func_240903_a_(Registry.field_239699_ae_, registrykey1.func_240901_a_());
                DimensionType dimensiontype1 = ((Dimension)entry.getValue()).func_236063_b_();
                RegistryKey<DimensionType> registrykey3 = this.field_240767_f_.func_230520_a_().func_230519_c_(dimensiontype1).orElseThrow(() -> new IllegalStateException("Unregistered dimension type: " + dimensiontype1));
                ChunkGenerator chunkgenerator1 = ((Dimension)entry.getValue()).func_236064_c_();
                DerivedWorldInfo derivedworldinfo = new DerivedWorldInfo(this.field_240768_i_, iserverworldinfo);
                ServerWorld serverworld1 = new ServerWorld(this, this.field_213217_au, this.field_71310_m, (IServerWorldInfo)derivedworldinfo, registrykey2, registrykey3, dimensiontype1, p_240787_1_, chunkgenerator1, flag, j, (List<ISpecialSpawner>)ImmutableList.of(), false);
                worldborder.func_177737_a((IBorderListener)new IBorderListener.Impl(serverworld1.func_175723_af()));
                this.field_71305_c.put(registrykey2, serverworld1);
            }
            MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Load((IWorld)this.field_71305_c.get(registrykey1)));
        }
    }

    private static void func_240786_a_(ServerWorld p_240786_0_, IServerWorldInfo p_240786_1_, boolean p_240786_2_, boolean p_240786_3_, boolean p_240786_4_) {
        ChunkGenerator chunkgenerator = p_240786_0_.func_72863_F().func_201711_g();
        if (!p_240786_4_) {
            p_240786_1_.func_176143_a(BlockPos.field_177992_a.func_177981_b(chunkgenerator.func_205470_d()));
        } else if (p_240786_3_) {
            p_240786_1_.func_176143_a(BlockPos.field_177992_a.func_177984_a());
        } else {
            ChunkPos chunkpos;
            if (ForgeEventFactory.onCreateWorldSpawn((World)p_240786_0_, (IServerWorldInfo)p_240786_1_)) {
                return;
            }
            BiomeProvider biomeprovider = chunkgenerator.func_202090_b();
            List list = biomeprovider.func_76932_a();
            Random random = new Random(p_240786_0_.func_72905_C());
            BlockPos blockpos = biomeprovider.func_225531_a_(0, p_240786_0_.func_181545_F(), 0, 256, list, random);
            ChunkPos chunkPos = chunkpos = blockpos == null ? new ChunkPos(0, 0) : new ChunkPos(blockpos);
            if (blockpos == null) {
                field_147145_h.warn("Unable to find spawn biome");
            }
            boolean flag = false;
            for (Block block : BlockTags.field_205599_H.func_230236_b_()) {
                if (!biomeprovider.func_205706_b().contains((Object)block.func_176223_P())) continue;
                flag = true;
                break;
            }
            p_240786_1_.func_176143_a(chunkpos.func_206849_h().func_177982_a(8, chunkgenerator.func_205470_d(), 8));
            int i1 = 0;
            int j1 = 0;
            int i = 0;
            int j = -1;
            int k = 32;
            for (int l = 0; l < 1024; ++l) {
                BlockPos blockpos1;
                if (i1 > -16 && i1 <= 16 && j1 > -16 && j1 <= 16 && (blockpos1 = SpawnLocationHelper.func_241094_a_((ServerWorld)p_240786_0_, (ChunkPos)new ChunkPos(chunkpos.field_77276_a + i1, chunkpos.field_77275_b + j1), (boolean)flag)) != null) {
                    p_240786_1_.func_176143_a(blockpos1);
                    break;
                }
                if (i1 == j1 || i1 < 0 && i1 == -j1 || i1 > 0 && i1 == 1 - j1) {
                    int k1 = i;
                    i = -j;
                    j = k1;
                }
                i1 += i;
                j1 += j;
            }
            if (p_240786_2_) {
                ConfiguredFeature configuredfeature = Feature.field_214487_aO.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e);
                configuredfeature.func_236265_a_((ISeedReader)p_240786_0_, p_240786_0_.func_241112_a_(), chunkgenerator, p_240786_0_.field_73012_v, new BlockPos(p_240786_1_.func_76079_c(), p_240786_1_.func_76075_d(), p_240786_1_.func_76074_e()));
            }
        }
    }

    private void func_240778_a_(IServerConfiguration p_240778_1_) {
        p_240778_1_.func_230409_a_(Difficulty.PEACEFUL);
        p_240778_1_.func_230415_d_(true);
        IServerWorldInfo iserverworldinfo = p_240778_1_.func_230407_G_();
        iserverworldinfo.func_76084_b(false);
        iserverworldinfo.func_76069_a(false);
        iserverworldinfo.func_230391_a_(1000000000);
        iserverworldinfo.func_76068_b(6000L);
        iserverworldinfo.func_230392_a_(GameType.SPECTATOR);
    }

    private void func_213186_a(IChunkStatusListener p_213186_1_) {
        ServerWorld serverworld = this.func_241755_D_();
        field_147145_h.info("Preparing start region for dimension {}", (Object)serverworld.func_234923_W_().func_240901_a_());
        BlockPos blockpos = serverworld.func_241135_u_();
        p_213186_1_.func_219509_a(new ChunkPos(blockpos));
        ServerChunkProvider serverchunkprovider = serverworld.func_72863_F();
        serverchunkprovider.func_212863_j_().func_215598_a(500);
        this.field_211151_aa = Util.func_211177_b();
        serverchunkprovider.func_217228_a(TicketType.field_219488_a, new ChunkPos(blockpos), 11, (Object)Unit.INSTANCE);
        while (serverchunkprovider.func_217229_b() != 441) {
            this.field_211151_aa = Util.func_211177_b() + 10L;
            this.func_213202_o();
        }
        this.field_211151_aa = Util.func_211177_b() + 10L;
        this.func_213202_o();
        for (ServerWorld serverworld1 : this.field_71305_c.values()) {
            ForcedChunksSaveData forcedchunkssavedata = serverworld1.func_217481_x().func_215753_b(ForcedChunksSaveData::new, "chunks");
            if (forcedchunkssavedata == null) continue;
            LongIterator longiterator = forcedchunkssavedata.func_212438_a().iterator();
            while (longiterator.hasNext()) {
                long i = longiterator.nextLong();
                ChunkPos chunkpos = new ChunkPos(i);
                serverworld1.func_72863_F().func_217206_a(chunkpos, true);
            }
        }
        this.field_211151_aa = Util.func_211177_b() + 10L;
        this.func_213202_o();
        p_213186_1_.func_219510_b();
        serverchunkprovider.func_212863_j_().func_215598_a(5);
        this.func_240794_aZ_();
    }

    protected void func_175584_a() {
        File file1 = this.field_71310_m.func_237285_a_(FolderName.field_237252_h_).toFile();
        if (file1.isFile()) {
            String s = this.field_71310_m.func_237282_a_();
            try {
                this.func_180507_a_("level://" + URLEncoder.encode(s, StandardCharsets.UTF_8.toString()) + "/resources.zip", "");
            }
            catch (UnsupportedEncodingException unsupportedencodingexception) {
                field_147145_h.warn("Something went wrong url encoding {}", (Object)s);
            }
        }
    }

    public GameType func_71265_f() {
        return this.field_240768_i_.func_76077_q();
    }

    public boolean func_71199_h() {
        return this.field_240768_i_.func_76093_s();
    }

    public abstract int func_110455_j();

    public abstract int func_223707_k();

    public abstract boolean func_195569_l();

    public boolean func_213211_a(boolean suppressLog, boolean flush, boolean forced) {
        boolean flag = false;
        for (ServerWorld serverworld : this.func_212370_w()) {
            if (!suppressLog) {
                field_147145_h.info("Saving chunks for level '{}'/{}", (Object)serverworld, (Object)serverworld.func_234923_W_().func_240901_a_());
            }
            serverworld.func_217445_a(null, flush, serverworld.field_73058_d && !forced);
            flag = true;
        }
        ServerWorld serverworld1 = this.func_241755_D_();
        IServerWorldInfo iserverworldinfo = this.field_240768_i_.func_230407_G_();
        iserverworldinfo.func_230393_a_(serverworld1.func_175723_af().func_235927_t_());
        this.field_240768_i_.func_230414_b_(this.func_201300_aS().func_201380_c());
        this.field_71310_m.func_237288_a_((IDynamicRegistries)this.field_240767_f_, this.field_240768_i_, this.func_184103_al().func_72378_q());
        return flag;
    }

    @Override
    public void close() {
        this.func_71260_j();
    }

    protected void func_71260_j() {
        field_147145_h.info("Stopping server");
        if (this.func_147137_ag() != null) {
            this.func_147137_ag().func_151268_b();
        }
        if (this.field_71318_t != null) {
            field_147145_h.info("Saving players");
            this.field_71318_t.func_72389_g();
            this.field_71318_t.func_72392_r();
        }
        field_147145_h.info("Saving worlds");
        for (ServerWorld serverworld : this.func_212370_w()) {
            if (serverworld == null) continue;
            serverworld.field_73058_d = false;
        }
        this.func_213211_a(false, true, false);
        for (ServerWorld serverworld1 : this.func_212370_w()) {
            if (serverworld1 == null) continue;
            try {
                MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Unload((IWorld)serverworld1));
                serverworld1.close();
            }
            catch (IOException ioexception1) {
                field_147145_h.error("Exception closing the level", (Throwable)ioexception1);
            }
        }
        if (this.field_71307_n.func_76468_d()) {
            this.field_71307_n.func_76470_e();
        }
        this.field_195576_ac.close();
        try {
            this.field_71310_m.close();
        }
        catch (IOException ioexception) {
            field_147145_h.error("Failed to unlock level {}", (Object)this.field_71310_m.func_237282_a_(), (Object)ioexception);
        }
    }

    public String func_71211_k() {
        return this.field_71320_r;
    }

    public void func_71189_e(String host) {
        this.field_71320_r = host;
    }

    public boolean func_71278_l() {
        return this.field_71317_u;
    }

    public void func_71263_m(boolean waitForServer) {
        this.field_71317_u = false;
        if (waitForServer) {
            try {
                this.field_175590_aa.join();
            }
            catch (InterruptedException interruptedexception) {
                field_147145_h.error("Error while shutting down", (Throwable)interruptedexception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void func_240802_v_() {
        try {
            if (this.func_71197_b()) {
                ServerLifecycleHooks.handleServerStarted((MinecraftServer)this);
                this.field_211151_aa = Util.func_211177_b();
                this.field_147147_p.func_151315_a((ITextComponent)new StringTextComponent(this.field_71286_C));
                this.field_147147_p.func_151321_a(new ServerStatusResponse.Version(SharedConstants.func_215069_a().getName(), SharedConstants.func_215069_a().getProtocolVersion()));
                this.func_184107_a(this.field_147147_p);
                while (this.field_71317_u) {
                    long i = Util.func_211177_b() - this.field_211151_aa;
                    if (i > 2000L && this.field_211151_aa - this.field_71299_R >= 15000L) {
                        long j = i / 50L;
                        field_147145_h.warn("Can't keep up! Is the server overloaded? Running {}ms or {} ticks behind", (Object)i, (Object)j);
                        this.field_211151_aa += j * 50L;
                        this.field_71299_R = this.field_211151_aa;
                    }
                    this.field_211151_aa += 50L;
                    LongTickDetector longtickdetector = LongTickDetector.func_233524_a_((String)"Server");
                    this.func_240773_a_(longtickdetector);
                    this.field_71304_b.func_219894_a();
                    this.field_71304_b.func_76320_a("tick");
                    this.func_71217_p(this::func_212379_aT);
                    this.field_71304_b.func_219895_b("nextTickWait");
                    this.field_213214_ac = true;
                    this.field_213213_ab = Math.max(Util.func_211177_b() + 50L, this.field_211151_aa);
                    this.func_213202_o();
                    this.field_71304_b.func_76319_b();
                    this.field_71304_b.func_219897_b();
                    this.func_240795_b_(longtickdetector);
                    this.field_71296_Q = true;
                }
                ServerLifecycleHooks.handleServerStopping((MinecraftServer)this);
                ServerLifecycleHooks.expectServerStopped();
            } else {
                ServerLifecycleHooks.expectServerStopped();
                this.func_71228_a(null);
            }
        }
        catch (Throwable throwable1) {
            field_147145_h.error("Encountered an unexpected exception", throwable1);
            CrashReport crashreport = throwable1 instanceof ReportedException ? this.func_71230_b(((ReportedException)throwable1).func_71575_a()) : this.func_71230_b(new CrashReport("Exception in server tick loop", throwable1));
            File file1 = new File(new File(this.func_71238_n(), "crash-reports"), "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
            if (crashreport.func_147149_a(file1)) {
                field_147145_h.error("This crash report has been saved to: {}", (Object)file1.getAbsolutePath());
            } else {
                field_147145_h.error("We were unable to save this crash report to disk.");
            }
            ServerLifecycleHooks.expectServerStopped();
            this.func_71228_a(crashreport);
        }
        finally {
            try {
                this.field_71316_v = true;
                this.func_71260_j();
            }
            catch (Throwable throwable) {
                field_147145_h.error("Exception stopping the server", throwable);
            }
            finally {
                ServerLifecycleHooks.handleServerStopped((MinecraftServer)this);
                this.func_71240_o();
            }
        }
    }

    private boolean func_212379_aT() {
        return this.func_213182_bg() || Util.func_211177_b() < (this.field_213214_ac ? this.field_213213_ab : this.field_211151_aa);
    }

    protected void func_213202_o() {
        this.func_213160_bf();
        this.func_213161_c(() -> !this.func_212379_aT());
    }

    protected TickDelayedTask func_212875_d_(Runnable runnable) {
        return new TickDelayedTask(this.field_71315_w, runnable);
    }

    protected boolean func_212874_c_(TickDelayedTask runnable) {
        return runnable.func_218823_a() + 3 < this.field_71315_w || this.func_212379_aT();
    }

    public boolean func_213168_p() {
        boolean flag;
        this.field_213214_ac = flag = this.func_213205_aW();
        return flag;
    }

    private boolean func_213205_aW() {
        if (super.func_213168_p()) {
            return true;
        }
        if (this.func_212379_aT()) {
            for (ServerWorld serverworld : this.func_212370_w()) {
                if (!serverworld.func_72863_F().func_217234_d()) continue;
                return true;
            }
        }
        return false;
    }

    protected void func_213166_h(TickDelayedTask taskIn) {
        this.func_213185_aS().func_230035_c_("runTask");
        super.func_213166_h((Runnable)taskIn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void func_184107_a(ServerStatusResponse response) {
        File file1 = this.func_71209_f("server-icon.png");
        if (!file1.exists()) {
            file1 = this.field_71310_m.func_237298_f_();
        }
        if (file1.isFile()) {
            ByteBuf bytebuf = Unpooled.buffer();
            try {
                BufferedImage bufferedimage = ImageIO.read(file1);
                Validate.validState((bufferedimage.getWidth() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                Validate.validState((bufferedimage.getHeight() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                ImageIO.write((RenderedImage)bufferedimage, "PNG", (OutputStream)new ByteBufOutputStream(bytebuf));
                ByteBuffer bytebuffer = Base64.getEncoder().encode(bytebuf.nioBuffer());
                response.func_151320_a("data:image/png;base64," + StandardCharsets.UTF_8.decode(bytebuffer));
            }
            catch (Exception exception) {
                field_147145_h.error("Couldn't load server icon", (Throwable)exception);
            }
            finally {
                bytebuf.release();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_184106_y() {
        this.field_184111_ab = this.field_184111_ab || this.func_184109_z().isFile();
        return this.field_184111_ab;
    }

    @OnlyIn(value=Dist.CLIENT)
    public File func_184109_z() {
        return this.field_71310_m.func_237298_f_();
    }

    public File func_71238_n() {
        return new File(".");
    }

    protected void func_71228_a(CrashReport report) {
    }

    protected void func_71240_o() {
    }

    protected void func_71217_p(BooleanSupplier hasTimeLeft) {
        long i = Util.func_211178_c();
        BasicEventHooks.onPreServerTick();
        ++this.field_71315_w;
        this.func_71190_q(hasTimeLeft);
        if (i - this.field_147142_T >= 5000000000L) {
            this.field_147142_T = i;
            this.field_147147_p.func_151319_a(new ServerStatusResponse.Players(this.func_71275_y(), this.func_71233_x()));
            GameProfile[] agameprofile = new GameProfile[Math.min(this.func_71233_x(), 12)];
            int j = MathHelper.func_76136_a((Random)this.field_147146_q, (int)0, (int)(this.func_71233_x() - agameprofile.length));
            for (int k = 0; k < agameprofile.length; ++k) {
                agameprofile[k] = this.field_71318_t.func_181057_v().get(j + k).func_146103_bH();
            }
            Collections.shuffle(Arrays.asList(agameprofile));
            this.field_147147_p.func_151318_b().func_151330_a(agameprofile);
            this.field_147147_p.invalidateJson();
        }
        if (this.field_71315_w % 6000 == 0) {
            field_147145_h.debug("Autosave started");
            this.field_71304_b.func_76320_a("save");
            this.field_71318_t.func_72389_g();
            this.func_213211_a(true, false, false);
            this.field_71304_b.func_76319_b();
            field_147145_h.debug("Autosave finished");
        }
        this.field_71304_b.func_76320_a("snooper");
        if (!this.field_71307_n.func_76468_d() && this.field_71315_w > 100) {
            this.field_71307_n.func_76463_a();
        }
        if (this.field_71315_w % 6000 == 0) {
            this.field_71307_n.func_76471_b();
        }
        this.field_71304_b.func_76319_b();
        this.field_71304_b.func_76320_a("tallying");
        long l = Util.func_211178_c() - i;
        this.field_71311_j[this.field_71315_w % 100] = l;
        long l2 = l;
        this.field_211152_ao = this.field_211152_ao * 0.8f + (float)l2 / 1000000.0f * 0.19999999f;
        long i1 = Util.func_211178_c();
        this.field_213215_ap.func_181747_a(i1 - i);
        this.field_71304_b.func_76319_b();
        BasicEventHooks.onPostServerTick();
    }

    protected void func_71190_q(BooleanSupplier hasTimeLeft) {
        this.field_71304_b.func_76320_a("commandFunctions");
        this.func_193030_aL().func_73660_a();
        this.field_71304_b.func_219895_b("levels");
        for (ServerWorld serverworld : this.getWorldArray()) {
            long tickStart = Util.func_211178_c();
            this.field_71304_b.func_194340_a(() -> serverworld + " " + serverworld.func_234923_W_().func_240901_a_());
            if (this.field_71315_w % 20 == 0) {
                this.field_71304_b.func_76320_a("timeSync");
                this.field_71318_t.func_232642_a_((IPacket<?>)new SUpdateTimePacket(serverworld.func_82737_E(), serverworld.func_72820_D(), serverworld.func_82736_K().func_223586_b(GameRules.field_223607_j)), serverworld.func_234923_W_());
                this.field_71304_b.func_76319_b();
            }
            this.field_71304_b.func_76320_a("tick");
            BasicEventHooks.onPreWorldTick((World)serverworld);
            try {
                serverworld.func_72835_b(hasTimeLeft);
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a(throwable, "Exception ticking world");
                serverworld.func_72914_a(crashreport);
                throw new ReportedException(crashreport);
            }
            BasicEventHooks.onPostWorldTick((World)serverworld);
            this.field_71304_b.func_76319_b();
            this.field_71304_b.func_76319_b();
            this.perWorldTickTimes.computeIfAbsent(serverworld.func_234923_W_(), (Function<RegistryKey, long[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$updateTimeLightAndEntities$6(net.minecraft.util.RegistryKey ), (Lnet/minecraft/util/RegistryKey;)[J)())[this.field_71315_w % 100] = Util.func_211178_c() - tickStart;
        }
        this.field_71304_b.func_219895_b("connection");
        this.func_147137_ag().func_151269_c();
        this.field_71304_b.func_219895_b("players");
        this.field_71318_t.func_72374_b();
        if (SharedConstants.field_206244_b) {
            TestCollection.field_229570_a_.func_229574_b_();
        }
        this.field_71304_b.func_219895_b("server gui refresh");
        for (int i = 0; i < this.field_71322_p.size(); ++i) {
            this.field_71322_p.get(i).run();
        }
        this.field_71304_b.func_76319_b();
    }

    public boolean func_71255_r() {
        return true;
    }

    public void func_82010_a(Runnable tickable) {
        this.field_71322_p.add(tickable);
    }

    protected void func_213208_c(String serverIdIn) {
        this.field_213218_av = serverIdIn;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_213201_w() {
        return !this.field_175590_aa.isAlive();
    }

    public File func_71209_f(String fileName) {
        return new File(this.func_71238_n(), fileName);
    }

    public final ServerWorld func_241755_D_() {
        return this.field_71305_c.get(World.field_234918_g_);
    }

    @Nullable
    public ServerWorld func_71218_a(RegistryKey<World> dimension) {
        return this.field_71305_c.get(dimension);
    }

    public Set<RegistryKey<World>> func_240770_D_() {
        return this.field_71305_c.keySet();
    }

    public Iterable<ServerWorld> func_212370_w() {
        return this.field_71305_c.values();
    }

    public String func_71249_w() {
        return SharedConstants.func_215069_a().getName();
    }

    public int func_71233_x() {
        return this.field_71318_t.func_72394_k();
    }

    public int func_71275_y() {
        return this.field_71318_t.func_72352_l();
    }

    public String[] func_71213_z() {
        return this.field_71318_t.func_72369_d();
    }

    public String getServerModName() {
        return BrandingControl.getServerBranding();
    }

    public CrashReport func_71230_b(CrashReport report) {
        if (this.field_71318_t != null) {
            report.func_85056_g().func_189529_a("Player Count", (ICrashReportDetail<String>)((ICrashReportDetail)() -> this.field_71318_t.func_72394_k() + " / " + this.field_71318_t.func_72352_l() + "; " + this.field_71318_t.func_181057_v()));
        }
        report.func_85056_g().func_189529_a("Data Packs", (ICrashReportDetail<String>)((ICrashReportDetail)() -> {
            StringBuilder stringbuilder = new StringBuilder();
            LogManager.shutdown();
            for (ResourcePackInfo resourcepackinfo : this.field_195577_ad.func_198980_d()) {
                if (stringbuilder.length() > 0) {
                    stringbuilder.append(", ");
                }
                stringbuilder.append(resourcepackinfo.func_195790_f());
                if (resourcepackinfo.func_195791_d().func_198968_a()) continue;
                stringbuilder.append(" (incompatible)");
            }
            return stringbuilder.toString();
        }));
        if (this.field_213218_av != null) {
            report.func_85056_g().func_189529_a("Server Id", (ICrashReportDetail<String>)((ICrashReportDetail)() -> this.field_213218_av));
        }
        return report;
    }

    public abstract Optional<String> func_230045_q_();

    public void func_145747_a(ITextComponent component, UUID p_145747_2_) {
        field_147145_h.info(component.getString());
    }

    public KeyPair func_71250_E() {
        return this.field_71292_I;
    }

    public int func_71215_F() {
        return this.field_71319_s;
    }

    public void func_71208_b(int port) {
        this.field_71319_s = port;
    }

    public String func_71214_G() {
        return this.field_71293_J;
    }

    public void func_71224_l(String owner) {
        this.field_71293_J = owner;
    }

    public boolean func_71264_H() {
        return this.field_71293_J != null;
    }

    public void func_71253_a(KeyPair keyPair) {
        this.field_71292_I = keyPair;
    }

    public void func_147139_a(Difficulty difficulty, boolean p_147139_2_) {
        if (p_147139_2_ || !this.field_240768_i_.func_176123_z()) {
            this.field_240768_i_.func_230409_a_(this.field_240768_i_.func_76093_s() ? Difficulty.HARD : difficulty);
            this.func_240794_aZ_();
            this.func_184103_al().func_181057_v().forEach(this::func_213189_a);
        }
    }

    public int func_230512_b_(int p_230512_1_) {
        return p_230512_1_;
    }

    private void func_240794_aZ_() {
        for (ServerWorld serverworld : this.func_212370_w()) {
            serverworld.func_72891_a(this.func_230536_N_(), this.func_230537_U_());
        }
    }

    public void func_213209_d(boolean locked) {
        this.field_240768_i_.func_230415_d_(locked);
        this.func_184103_al().func_181057_v().forEach(this::func_213189_a);
    }

    private void func_213189_a(ServerPlayerEntity playerIn) {
        IWorldInfo iworldinfo = playerIn.func_71121_q().func_72912_H();
        playerIn.field_71135_a.func_147359_a((IPacket<?>)new SServerDifficultyPacket(iworldinfo.func_176130_y(), iworldinfo.func_176123_z()));
    }

    protected boolean func_230536_N_() {
        return this.field_240768_i_.func_176130_y() != Difficulty.PEACEFUL;
    }

    public boolean func_71242_L() {
        return this.field_71288_M;
    }

    public void func_71204_b(boolean demo) {
        this.field_71288_M = demo;
    }

    public String func_147133_T() {
        return this.field_147141_M;
    }

    public String func_175581_ab() {
        return this.field_175588_P;
    }

    public void func_180507_a_(String url, String hash) {
        this.field_147141_M = url;
        this.field_175588_P = hash;
    }

    public void func_70000_a(Snooper snooper) {
        snooper.func_152768_a("whitelist_enabled", (Object)false);
        snooper.func_152768_a("whitelist_count", (Object)0);
        if (this.field_71318_t != null) {
            snooper.func_152768_a("players_current", (Object)this.func_71233_x());
            snooper.func_152768_a("players_max", (Object)this.func_71275_y());
            snooper.func_152768_a("players_seen", (Object)this.field_240766_e_.func_237334_a_().length);
        }
        snooper.func_152768_a("uses_auth", (Object)this.field_71325_x);
        snooper.func_152768_a("gui_state", (Object)(this.func_71279_ae() ? "enabled" : "disabled"));
        snooper.func_152768_a("run_time", (Object)((Util.func_211177_b() - snooper.func_130105_g()) / 60L * 1000L));
        snooper.func_152768_a("avg_tick_ms", (Object)((int)(MathHelper.func_76127_a((long[])this.field_71311_j) * 1.0E-6)));
        int i = 0;
        for (ServerWorld serverworld : this.func_212370_w()) {
            if (serverworld == null) continue;
            snooper.func_152768_a("world[" + i + "][dimension]", (Object)serverworld.func_234923_W_().func_240901_a_());
            snooper.func_152768_a("world[" + i + "][mode]", (Object)this.field_240768_i_.func_76077_q());
            snooper.func_152768_a("world[" + i + "][difficulty]", (Object)serverworld.func_175659_aa());
            snooper.func_152768_a("world[" + i + "][hardcore]", (Object)this.field_240768_i_.func_76093_s());
            snooper.func_152768_a("world[" + i + "][height]", (Object)this.field_71280_D);
            snooper.func_152768_a("world[" + i + "][chunks_loaded]", (Object)serverworld.func_72863_F().func_73152_e());
            ++i;
        }
        snooper.func_152768_a("worlds", (Object)i);
    }

    public abstract boolean func_71262_S();

    public boolean func_71266_T() {
        return this.field_71325_x;
    }

    public void func_71229_d(boolean online) {
        this.field_71325_x = online;
    }

    public boolean func_190518_ac() {
        return this.field_190519_A;
    }

    public void func_190517_e(boolean p_190517_1_) {
        this.field_190519_A = p_190517_1_;
    }

    public boolean func_230537_U_() {
        return true;
    }

    public boolean func_230538_V_() {
        return true;
    }

    public abstract boolean func_181035_ah();

    public boolean func_71219_W() {
        return this.field_71284_A;
    }

    public void func_71188_g(boolean allowPvp) {
        this.field_71284_A = allowPvp;
    }

    public boolean func_71231_X() {
        return this.field_71285_B;
    }

    public void func_71245_h(boolean allow) {
        this.field_71285_B = allow;
    }

    public abstract boolean func_82356_Z();

    public String func_71273_Y() {
        return this.field_71286_C;
    }

    public void func_71205_p(String motdIn) {
        this.field_71286_C = motdIn;
    }

    public int func_71207_Z() {
        return this.field_71280_D;
    }

    public void func_71191_d(int maxBuildHeight) {
        this.field_71280_D = maxBuildHeight;
    }

    public boolean func_71241_aa() {
        return this.field_71316_v;
    }

    public PlayerList func_184103_al() {
        return this.field_71318_t;
    }

    public void func_184105_a(PlayerList list) {
        this.field_71318_t = list;
    }

    public abstract boolean func_71344_c();

    public void func_71235_a(GameType gameMode) {
        this.field_240768_i_.func_230392_a_(gameMode);
    }

    @Nullable
    public NetworkSystem func_147137_ag() {
        return this.field_147144_o;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_71200_ad() {
        return this.field_71296_Q;
    }

    public boolean func_71279_ae() {
        return false;
    }

    public abstract boolean func_195565_a(GameType var1, boolean var2, int var3);

    public int func_71259_af() {
        return this.field_71315_w;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Snooper func_80003_ah() {
        return this.field_71307_n;
    }

    public int func_82357_ak() {
        return 16;
    }

    public boolean func_175579_a(ServerWorld worldIn, BlockPos pos, PlayerEntity playerIn) {
        return false;
    }

    public void func_104055_i(boolean force) {
        this.field_104057_T = force;
    }

    public boolean func_104056_am() {
        return this.field_104057_T;
    }

    public boolean func_230541_aj_() {
        return true;
    }

    public int func_143007_ar() {
        return this.field_143008_E;
    }

    public void func_143006_e(int idleTimeout) {
        this.field_143008_E = idleTimeout;
    }

    public MinecraftSessionService func_147130_as() {
        return this.field_147143_S;
    }

    public GameProfileRepository func_152359_aw() {
        return this.field_152365_W;
    }

    public PlayerProfileCache func_152358_ax() {
        return this.field_152366_X;
    }

    public ServerStatusResponse func_147134_at() {
        return this.field_147147_p;
    }

    public void func_147132_au() {
        this.field_147142_T = 0L;
    }

    public int func_175580_aG() {
        return 29999984;
    }

    public boolean func_213164_aw() {
        return super.func_213164_aw() && !this.func_71241_aa();
    }

    public Thread func_213170_ax() {
        return this.field_175590_aa;
    }

    public int func_175577_aI() {
        return 256;
    }

    public long func_211150_az() {
        return this.field_211151_aa;
    }

    public DataFixer func_195563_aC() {
        return this.field_184112_s;
    }

    public int func_184108_a(@Nullable ServerWorld worldIn) {
        return worldIn != null ? worldIn.func_82736_K().func_223592_c(GameRules.field_223614_q) : 10;
    }

    public AdvancementManager func_191949_aK() {
        return this.field_195576_ac.func_240969_g_();
    }

    public FunctionManager func_193030_aL() {
        return this.field_200258_al;
    }

    public CompletableFuture<Void> func_240780_a_(Collection<String> p_240780_1_) {
        CompletionStage completablefuture = ((CompletableFuture)CompletableFuture.supplyAsync(() -> (ImmutableList)p_240780_1_.stream().map(this.field_195577_ad::func_198981_a).filter(Objects::nonNull).map(ResourcePackInfo::func_195796_e).collect(ImmutableList.toImmutableList()), (Executor)((Object)this)).thenCompose(p_240775_1_ -> DataPackRegistries.func_240961_a_((List<IResourcePack>)p_240775_1_, this.func_71262_S() ? Commands.EnvironmentType.DEDICATED : Commands.EnvironmentType.INTEGRATED, this.func_223707_k(), this.field_213217_au, (Executor)((Object)this)))).thenAcceptAsync(p_240782_2_ -> {
            this.field_195576_ac.close();
            this.field_195576_ac = p_240782_2_;
            this.field_195577_ad.func_198985_a(p_240780_1_);
            this.field_240768_i_.func_230410_a_(MinecraftServer.func_240771_a_(this.field_195577_ad));
            p_240782_2_.func_240971_i_();
            this.func_184103_al().func_72389_g();
            this.func_184103_al().func_193244_w();
            this.field_200258_al.func_240946_a_(this.field_195576_ac.func_240960_a_());
            this.field_240765_ak_.func_195410_a(this.field_195576_ac.func_240970_h_());
            this.func_184103_al().func_181057_v().forEach(this.func_184103_al()::func_187243_f);
        }, (Executor)((Object)this));
        if (this.func_213162_bc()) {
            this.func_213161_c(((CompletableFuture)completablefuture)::isDone);
        }
        return completablefuture;
    }

    public static DatapackCodec func_240772_a_(ResourcePackList<ResourcePackInfo> p_240772_0_, DatapackCodec p_240772_1_, boolean p_240772_2_) {
        ResourcePackLoader.loadResourcePacks(p_240772_0_, ServerLifecycleHooks::buildPackFinder);
        p_240772_0_.func_198983_a();
        DatapackCodec.field_234880_a_.addModPacks(ForgeHooks.getModPacks());
        p_240772_1_.addModPacks(ForgeHooks.getModPacks());
        if (p_240772_2_) {
            p_240772_0_.func_198985_a(ForgeHooks.getModPacksWithVanilla());
            return new DatapackCodec(ForgeHooks.getModPacksWithVanilla(), (List<String>)ImmutableList.of());
        }
        LinkedHashSet set = Sets.newLinkedHashSet();
        for (String s : p_240772_1_.func_234884_a_()) {
            if (p_240772_0_.func_232617_b_(s)) {
                set.add(s);
                continue;
            }
            field_147145_h.warn("Missing data pack {}", (Object)s);
        }
        for (ResourcePackInfo resourcepackinfo : p_240772_0_.func_198978_b()) {
            String s1 = resourcepackinfo.func_195790_f();
            if (p_240772_1_.func_234887_b_().contains(s1) || set.contains(s1)) continue;
            field_147145_h.info("Found new data pack {}, loading it automatically", (Object)s1);
            set.add(s1);
        }
        if (set.isEmpty()) {
            field_147145_h.info("No datapacks selected, forcing vanilla");
            set.add("vanilla");
        }
        p_240772_0_.func_198985_a(set);
        return MinecraftServer.func_240771_a_(p_240772_0_);
    }

    private static DatapackCodec func_240771_a_(ResourcePackList<?> p_240771_0_) {
        Collection<String> collection = p_240771_0_.func_232621_d_();
        ImmutableList list = ImmutableList.copyOf(collection);
        List list1 = (List)p_240771_0_.func_232616_b_().stream().filter(p_240781_1_ -> !collection.contains(p_240781_1_)).collect(ImmutableList.toImmutableList());
        return new DatapackCodec((List<String>)list, list1);
    }

    public void func_205743_a(CommandSource commandSourceIn) {
        if (this.func_205744_aT()) {
            PlayerList playerlist = commandSourceIn.func_197028_i().func_184103_al();
            WhiteList whitelist = playerlist.func_152599_k();
            for (ServerPlayerEntity serverplayerentity : Lists.newArrayList(playerlist.func_181057_v())) {
                if (whitelist.func_152705_a(serverplayerentity.func_146103_bH())) continue;
                serverplayerentity.field_71135_a.func_194028_b((ITextComponent)new TranslationTextComponent("multiplayer.disconnect.not_whitelisted"));
            }
        }
    }

    public ResourcePackList<ResourcePackInfo> func_195561_aH() {
        return this.field_195577_ad;
    }

    public Commands func_195571_aL() {
        return this.field_195576_ac.func_240968_f_();
    }

    public CommandSource func_195573_aM() {
        ServerWorld serverworld = this.func_241755_D_();
        return new CommandSource((ICommandSource)this, serverworld == null ? Vector3d.field_186680_a : Vector3d.func_237491_b_((Vector3i)serverworld.func_241135_u_()), Vector2f.field_189974_a, serverworld, 4, "Server", (ITextComponent)new StringTextComponent("Server"), this, (Entity)null);
    }

    public boolean func_195039_a() {
        return true;
    }

    public boolean func_195040_b() {
        return true;
    }

    public RecipeManager func_199529_aN() {
        return this.field_195576_ac.func_240967_e_();
    }

    public NetworkTagManager func_199731_aO() {
        return this.field_195576_ac.func_240966_d_();
    }

    public ServerScoreboard func_200251_aP() {
        return this.field_200255_ai;
    }

    public CommandStorage func_229735_aN_() {
        if (this.field_229733_al_ == null) {
            throw new NullPointerException("Called before server init");
        }
        return this.field_229733_al_;
    }

    public LootTableManager func_200249_aQ() {
        return this.field_195576_ac.func_240965_c_();
    }

    public LootPredicateManager func_229736_aP_() {
        return this.field_195576_ac.func_240964_b_();
    }

    public GameRules func_200252_aR() {
        return this.func_241755_D_().func_82736_K();
    }

    public CustomServerBossInfoManager func_201300_aS() {
        return this.field_201301_aj;
    }

    public boolean func_205744_aT() {
        return this.field_205745_an;
    }

    public void func_205741_k(boolean whitelistEnabledIn) {
        this.field_205745_an = whitelistEnabledIn;
    }

    public float func_211149_aT() {
        return this.field_211152_ao;
    }

    public int func_211833_a(GameProfile profile) {
        if (this.func_184103_al().func_152596_g(profile)) {
            OpEntry opentry = (OpEntry)this.func_184103_al().func_152603_m().func_152683_b((Object)profile);
            if (opentry != null) {
                return opentry.func_152644_a();
            }
            if (this.func_213199_b(profile)) {
                return 4;
            }
            if (this.func_71264_H()) {
                return this.func_184103_al().func_206257_x() ? 4 : 0;
            }
            return this.func_110455_j();
        }
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public FrameTimer func_213210_aR() {
        return this.field_213215_ap;
    }

    public IProfiler func_213185_aS() {
        return this.field_71304_b;
    }

    public abstract boolean func_213199_b(GameProfile var1);

    @Nullable
    public long[] getTickTime(RegistryKey<World> dim) {
        return this.perWorldTickTimes.get(dim);
    }

    @Deprecated
    public synchronized Map<RegistryKey<World>, ServerWorld> forgeGetWorldMap() {
        return this.field_71305_c;
    }

    @Deprecated
    public synchronized void markWorldsDirty() {
        ++this.worldArrayMarker;
    }

    private ServerWorld[] getWorldArray() {
        if (this.worldArrayMarker == this.worldArrayLast && this.worldArray != null) {
            return this.worldArray;
        }
        this.worldArray = (ServerWorld[])this.field_71305_c.values().stream().toArray(ServerWorld[]::new);
        this.worldArrayLast = this.worldArrayMarker;
        return this.worldArray;
    }

    public void func_223711_a(Path p_223711_1_) throws IOException {
        Path path = p_223711_1_.resolve("levels");
        for (Map.Entry<RegistryKey<World>, ServerWorld> entry : this.field_71305_c.entrySet()) {
            ResourceLocation resourcelocation = entry.getKey().func_240901_a_();
            Path path1 = path.resolve(resourcelocation.func_110624_b()).resolve(resourcelocation.func_110623_a());
            Files.createDirectories(path1, new FileAttribute[0]);
            entry.getValue().func_225322_a(path1);
        }
        this.func_223708_d(p_223711_1_.resolve("gamerules.txt"));
        this.func_223706_e(p_223711_1_.resolve("classpath.txt"));
        this.func_223709_c(p_223711_1_.resolve("example_crash.txt"));
        this.func_223710_b(p_223711_1_.resolve("stats.txt"));
        this.func_223712_f(p_223711_1_.resolve("threads.txt"));
    }

    private void func_223710_b(Path p_223710_1_) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(p_223710_1_, new OpenOption[0]);){
            writer.write(String.format("pending_tasks: %d\n", this.func_223704_be()));
            writer.write(String.format("average_tick_time: %f\n", Float.valueOf(this.func_211149_aT())));
            writer.write(String.format("tick_times: %s\n", Arrays.toString(this.field_71311_j)));
            writer.write(String.format("queue: %s\n", Util.func_215072_e()));
        }
    }

    private void func_223709_c(Path p_223709_1_) throws IOException {
        CrashReport crashreport = new CrashReport("Server dump", new Exception("dummy"));
        this.func_71230_b(crashreport);
        try (BufferedWriter writer = Files.newBufferedWriter(p_223709_1_, new OpenOption[0]);){
            writer.write(crashreport.func_71502_e());
        }
    }

    private void func_223708_d(Path p_223708_1_) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(p_223708_1_, new OpenOption[0]);){
            final ArrayList list = Lists.newArrayList();
            final GameRules gamerules = this.func_200252_aR();
            GameRules.func_223590_a((GameRules.IRuleEntryVisitor)new GameRules.IRuleEntryVisitor(){

                public <T extends GameRules.RuleValue<T>> void func_223481_a(GameRules.RuleKey<T> key, GameRules.RuleType<T> type) {
                    list.add(String.format("%s=%s\n", key.func_223576_a(), gamerules.func_223585_a(key).toString()));
                }
            });
            for (String s : list) {
                writer.write(s);
            }
        }
    }

    private void func_223706_e(Path p_223706_1_) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(p_223706_1_, new OpenOption[0]);){
            String s = System.getProperty("java.class.path");
            String s1 = System.getProperty("path.separator");
            for (String s2 : Splitter.on((String)s1).split((CharSequence)s)) {
                writer.write(s2);
                writer.write("\n");
            }
        }
    }

    private void func_223712_f(Path p_223712_1_) throws IOException {
        ThreadMXBean threadmxbean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] athreadinfo = threadmxbean.dumpAllThreads(true, true);
        Arrays.sort(athreadinfo, Comparator.comparing(ThreadInfo::getThreadName));
        try (BufferedWriter writer = Files.newBufferedWriter(p_223712_1_, new OpenOption[0]);){
            for (ThreadInfo threadinfo : athreadinfo) {
                writer.write(threadinfo.toString());
                ((Writer)writer).write(10);
            }
        }
    }

    private void func_240773_a_(@Nullable LongTickDetector p_240773_1_) {
        if (this.field_71295_T) {
            this.field_71295_T = false;
            this.field_240769_m_.func_233507_c_();
        }
        this.field_71304_b = LongTickDetector.func_233523_a_((IProfiler)this.field_240769_m_.func_233508_d_(), (LongTickDetector)p_240773_1_);
    }

    private void func_240795_b_(@Nullable LongTickDetector p_240795_1_) {
        if (p_240795_1_ != null) {
            p_240795_1_.func_233525_b_();
        }
        this.field_71304_b = this.field_240769_m_.func_233508_d_();
    }

    public boolean func_240789_aP_() {
        return this.field_240769_m_.func_233505_a_();
    }

    public void func_240790_aQ_() {
        this.field_71295_T = true;
    }

    public IProfileResult func_240791_aR_() {
        IProfileResult iprofileresult = this.field_240769_m_.func_233509_e_();
        this.field_240769_m_.func_233506_b_();
        return iprofileresult;
    }

    public Path func_240776_a_(FolderName p_240776_1_) {
        return this.field_71310_m.func_237285_a_(p_240776_1_);
    }

    public boolean func_230540_aS_() {
        return true;
    }

    public TemplateManager func_240792_aT_() {
        return this.field_240765_ak_;
    }

    public IServerConfiguration func_240793_aU_() {
        return this.field_240768_i_;
    }

    public DataPackRegistries getDataPackRegistries() {
        return this.field_195576_ac;
    }

    private static /* synthetic */ long[] lambda$updateTimeLightAndEntities$6(RegistryKey k) {
        return new long[100];
    }
}

