/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.google.common.collect.HashMultimap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.network.PacketBuffer;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.NetworkTagCollection;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeNetworkTagManager;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.eventbus.api.Event;

public class NetworkTagManager
implements IFutureReloadListener {
    protected NetworkTagCollection<Block> field_199719_a = new NetworkTagCollection(Registry.field_212618_g, "tags/blocks", "block");
    protected NetworkTagCollection<Item> field_199720_b = new NetworkTagCollection(Registry.field_212630_s, "tags/items", "item");
    protected NetworkTagCollection<Fluid> field_205705_c = new NetworkTagCollection(Registry.field_212619_h, "tags/fluids", "fluid");
    protected NetworkTagCollection<EntityType<?>> field_215299_d = new NetworkTagCollection(Registry.field_212629_r, "tags/entity_types", "entity_type");

    public NetworkTagCollection<Block> func_199717_a() {
        return this.field_199719_a;
    }

    public NetworkTagCollection<Item> func_199715_b() {
        return this.field_199720_b;
    }

    public NetworkTagCollection<Fluid> func_205704_c() {
        return this.field_205705_c;
    }

    public NetworkTagCollection<EntityType<?>> func_215297_d() {
        return this.field_215299_d;
    }

    public void func_199716_a(PacketBuffer buffer) {
        this.field_199719_a.func_200042_a(buffer);
        this.field_199720_b.func_200042_a(buffer);
        this.field_205705_c.func_200042_a(buffer);
        this.field_215299_d.func_200042_a(buffer);
    }

    public static NetworkTagManager readSafe(PacketBuffer buffer) {
        return NetworkTagManager.read(buffer, ForgeNetworkTagManager.create());
    }

    public static NetworkTagManager func_199714_b(PacketBuffer buffer) {
        return NetworkTagManager.read(buffer, new NetworkTagManager());
    }

    private static NetworkTagManager read(PacketBuffer buffer, NetworkTagManager networktagmanager) {
        networktagmanager.func_199717_a().func_200043_b(buffer);
        networktagmanager.func_199715_b().func_200043_b(buffer);
        networktagmanager.func_205704_c().func_200043_b(buffer);
        networktagmanager.func_215297_d().func_200043_b(buffer);
        return networktagmanager;
    }

    public CompletableFuture<Void> func_215226_a(IFutureReloadListener.IStage stage, IResourceManager resourceManager, IProfiler preparationsProfiler, IProfiler reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        CompletableFuture completablefuture = this.field_199719_a.func_219781_a(resourceManager, backgroundExecutor);
        CompletableFuture completablefuture1 = this.field_199720_b.func_219781_a(resourceManager, backgroundExecutor);
        CompletableFuture completablefuture2 = this.field_205705_c.func_219781_a(resourceManager, backgroundExecutor);
        CompletableFuture completablefuture3 = this.field_215299_d.func_219781_a(resourceManager, backgroundExecutor);
        return ((CompletableFuture)CompletableFuture.allOf(completablefuture, completablefuture1, completablefuture2, completablefuture3).thenCompose(arg_0 -> ((IFutureReloadListener.IStage)stage).func_216872_a(arg_0))).thenAcceptAsync(p_232979_5_ -> {
            this.field_199719_a.func_219779_a((Map)completablefuture.join());
            this.field_199720_b.func_219779_a((Map)completablefuture1.join());
            this.field_205705_c.func_219779_a((Map)completablefuture2.join());
            this.field_215299_d.func_219779_a((Map)completablefuture3.join());
            TagCollectionManager.func_232924_a_(this.field_199719_a, this.field_199720_b, this.field_205705_c, this.field_215299_d);
            HashMultimap multimap = HashMultimap.create();
            multimap.putAll((Object)"blocks", (Iterable)BlockTags.func_232892_b_(this.field_199719_a));
            multimap.putAll((Object)"items", (Iterable)ItemTags.func_232917_b_(this.field_199720_b));
            multimap.putAll((Object)"fluids", (Iterable)FluidTags.func_232901_b_(this.field_205705_c));
            multimap.putAll((Object)"entity_types", (Iterable)EntityTypeTags.func_232897_b_(this.field_215299_d));
            if (!multimap.isEmpty()) {
                throw new IllegalStateException("Missing required tags: " + multimap.entries().stream().map(p_232978_0_ -> (String)p_232978_0_.getKey() + ":" + p_232978_0_.getValue()).sorted().collect(Collectors.joining(",")));
            }
        }, gameExecutor);
    }

    public void func_232980_f_() {
        BlockTags.func_199895_a(this.field_199719_a);
        ItemTags.func_199902_a(this.field_199720_b);
        FluidTags.func_206953_a(this.field_205705_c);
        EntityTypeTags.func_219759_a(this.field_215299_d);
        Blocks.func_235419_a_();
        MinecraftForge.EVENT_BUS.post((Event)new TagsUpdatedEvent(this));
    }
}

