/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DispenserBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.fluid.FluidState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.DispenserTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructureManager;

public abstract class StructurePiece {
    protected static final BlockState field_202556_l = Blocks.field_201941_jj.func_176223_P();
    protected MutableBoundingBox field_74887_e;
    @Nullable
    private Direction field_74885_f;
    private Mirror field_186168_b;
    private Rotation field_186169_c;
    protected int field_74886_g;
    private final IStructurePieceType field_214811_d;
    private static final Set<Block> field_211413_d = ImmutableSet.builder().add((Object)Blocks.field_150386_bk).add((Object)Blocks.field_150478_aa).add((Object)Blocks.field_196591_bQ).add((Object)Blocks.field_180407_aO).add((Object)Blocks.field_180408_aP).add((Object)Blocks.field_180406_aS).add((Object)Blocks.field_180405_aT).add((Object)Blocks.field_180404_aQ).add((Object)Blocks.field_180403_aR).add((Object)Blocks.field_150468_ap).add((Object)Blocks.field_150411_aY).build();

    protected StructurePiece(IStructurePieceType structurePieceTypeIn, int componentTypeIn) {
        this.field_214811_d = structurePieceTypeIn;
        this.field_74886_g = componentTypeIn;
    }

    public StructurePiece(IStructurePieceType structurePierceTypeIn, CompoundNBT nbt) {
        this(structurePierceTypeIn, nbt.func_74762_e("GD"));
        int i;
        if (nbt.func_74764_b("BB")) {
            this.field_74887_e = new MutableBoundingBox(nbt.func_74759_k("BB"));
        }
        this.func_186164_a((i = nbt.func_74762_e("O")) == -1 ? null : Direction.func_176731_b(i));
    }

    public final CompoundNBT func_143010_b() {
        if (Registry.field_218362_C.func_177774_c(this.func_214807_k()) == null) {
            throw new RuntimeException("StructurePiece \"" + this.getClass().getName() + "\": \"" + this.func_214807_k() + "\" missing ID Mapping, Modder see MapGenStructureIO");
        }
        CompoundNBT compoundnbt = new CompoundNBT();
        compoundnbt.func_74778_a("id", Registry.field_218362_C.func_177774_c(this.func_214807_k()).toString());
        compoundnbt.func_218657_a("BB", (INBT)this.field_74887_e.func_151535_h());
        Direction direction = this.func_186165_e();
        compoundnbt.func_74768_a("O", direction == null ? -1 : direction.func_176736_b());
        compoundnbt.func_74768_a("GD", this.field_74886_g);
        this.func_143011_b(compoundnbt);
        return compoundnbt;
    }

    protected abstract void func_143011_b(CompoundNBT var1);

    public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
    }

    public abstract boolean func_230383_a_(ISeedReader var1, StructureManager var2, ChunkGenerator var3, Random var4, MutableBoundingBox var5, ChunkPos var6, BlockPos var7);

    public MutableBoundingBox func_74874_b() {
        return this.field_74887_e;
    }

    public int func_74877_c() {
        return this.field_74886_g;
    }

    public boolean func_214810_a(ChunkPos p_214810_1_, int p_214810_2_) {
        int i = p_214810_1_.field_77276_a << 4;
        int j = p_214810_1_.field_77275_b << 4;
        return this.field_74887_e.func_78885_a(i - p_214810_2_, j - p_214810_2_, i + 15 + p_214810_2_, j + 15 + p_214810_2_);
    }

    public static StructurePiece func_74883_a(List<StructurePiece> listIn, MutableBoundingBox boundingboxIn) {
        for (StructurePiece structurepiece : listIn) {
            if (structurepiece.func_74874_b() == null || !structurepiece.func_74874_b().func_78884_a(boundingboxIn)) continue;
            return structurepiece;
        }
        return null;
    }

    protected boolean func_74860_a(IBlockReader worldIn, MutableBoundingBox boundingboxIn) {
        int i = Math.max(this.field_74887_e.field_78897_a - 1, boundingboxIn.field_78897_a);
        int j = Math.max(this.field_74887_e.field_78895_b - 1, boundingboxIn.field_78895_b);
        int k = Math.max(this.field_74887_e.field_78896_c - 1, boundingboxIn.field_78896_c);
        int l = Math.min(this.field_74887_e.field_78893_d + 1, boundingboxIn.field_78893_d);
        int i1 = Math.min(this.field_74887_e.field_78894_e + 1, boundingboxIn.field_78894_e);
        int j1 = Math.min(this.field_74887_e.field_78892_f + 1, boundingboxIn.field_78892_f);
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int k1 = i; k1 <= l; ++k1) {
            for (int l1 = k; l1 <= j1; ++l1) {
                if (worldIn.func_180495_p((BlockPos)blockpos$mutable.func_181079_c(k1, j, l1)).func_185904_a().func_76224_d()) {
                    return true;
                }
                if (!worldIn.func_180495_p((BlockPos)blockpos$mutable.func_181079_c(k1, i1, l1)).func_185904_a().func_76224_d()) continue;
                return true;
            }
        }
        for (int i2 = i; i2 <= l; ++i2) {
            for (int k2 = j; k2 <= i1; ++k2) {
                if (worldIn.func_180495_p((BlockPos)blockpos$mutable.func_181079_c(i2, k2, k)).func_185904_a().func_76224_d()) {
                    return true;
                }
                if (!worldIn.func_180495_p((BlockPos)blockpos$mutable.func_181079_c(i2, k2, j1)).func_185904_a().func_76224_d()) continue;
                return true;
            }
        }
        for (int j2 = k; j2 <= j1; ++j2) {
            for (int l2 = j; l2 <= i1; ++l2) {
                if (worldIn.func_180495_p((BlockPos)blockpos$mutable.func_181079_c(i, l2, j2)).func_185904_a().func_76224_d()) {
                    return true;
                }
                if (!worldIn.func_180495_p((BlockPos)blockpos$mutable.func_181079_c(l, l2, j2)).func_185904_a().func_76224_d()) continue;
                return true;
            }
        }
        return false;
    }

    protected int func_74865_a(int x, int z) {
        Direction direction = this.func_186165_e();
        if (direction == null) {
            return x;
        }
        switch (direction) {
            case NORTH: 
            case SOUTH: {
                return this.field_74887_e.field_78897_a + x;
            }
            case WEST: {
                return this.field_74887_e.field_78893_d - z;
            }
            case EAST: {
                return this.field_74887_e.field_78897_a + z;
            }
        }
        return x;
    }

    protected int func_74862_a(int y) {
        return this.func_186165_e() == null ? y : y + this.field_74887_e.field_78895_b;
    }

    protected int func_74873_b(int x, int z) {
        Direction direction = this.func_186165_e();
        if (direction == null) {
            return z;
        }
        switch (direction) {
            case NORTH: {
                return this.field_74887_e.field_78892_f - z;
            }
            case SOUTH: {
                return this.field_74887_e.field_78896_c + z;
            }
            case WEST: 
            case EAST: {
                return this.field_74887_e.field_78896_c + x;
            }
        }
        return z;
    }

    protected void func_175811_a(IWorld worldIn, BlockState blockstateIn, int x, int y, int z, MutableBoundingBox boundingboxIn) {
        BlockPos blockpos = new BlockPos(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z));
        if (boundingboxIn.func_175898_b((Vector3i)blockpos)) {
            if (this.field_186168_b != Mirror.NONE) {
                blockstateIn = blockstateIn.func_185902_a(this.field_186168_b);
            }
            if (this.field_186169_c != Rotation.NONE) {
                blockstateIn = blockstateIn.func_185907_a(this.field_186169_c);
            }
            worldIn.func_180501_a(blockpos, blockstateIn, 2);
            FluidState fluidstate = worldIn.func_204610_c(blockpos);
            if (!fluidstate.func_206888_e()) {
                worldIn.func_205219_F_().func_205360_a(blockpos, (Object)fluidstate.func_206886_c(), 0);
            }
            if (field_211413_d.contains((Object)blockstateIn.func_177230_c())) {
                worldIn.func_217349_x(blockpos).func_201594_d(blockpos);
            }
        }
    }

    protected BlockState func_175807_a(IBlockReader worldIn, int x, int y, int z, MutableBoundingBox boundingboxIn) {
        int k;
        int j;
        int i = this.func_74865_a(x, z);
        BlockPos blockpos = new BlockPos(i, j = this.func_74862_a(y), k = this.func_74873_b(x, z));
        return !boundingboxIn.func_175898_b((Vector3i)blockpos) ? Blocks.field_150350_a.func_176223_P() : worldIn.func_180495_p(blockpos);
    }

    protected boolean func_189916_b(IWorldReader worldIn, int x, int y, int z, MutableBoundingBox boundingboxIn) {
        int k;
        int j;
        int i = this.func_74865_a(x, z);
        BlockPos blockpos = new BlockPos(i, j = this.func_74862_a(y + 1), k = this.func_74873_b(x, z));
        if (!boundingboxIn.func_175898_b((Vector3i)blockpos)) {
            return false;
        }
        return j < worldIn.func_201676_a(Heightmap.Type.OCEAN_FLOOR_WG, i, k);
    }

    protected void func_74878_a(IWorld worldIn, MutableBoundingBox structurebb, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        for (int i = minY; i <= maxY; ++i) {
            for (int j = minX; j <= maxX; ++j) {
                for (int k = minZ; k <= maxZ; ++k) {
                    this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), j, i, k, structurebb);
                }
            }
        }
    }

    protected void func_175804_a(IWorld worldIn, MutableBoundingBox boundingboxIn, int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, BlockState boundaryBlockState, BlockState insideBlockState, boolean existingOnly) {
        for (int i = yMin; i <= yMax; ++i) {
            for (int j = xMin; j <= xMax; ++j) {
                for (int k = zMin; k <= zMax; ++k) {
                    if (existingOnly && this.func_175807_a((IBlockReader)worldIn, j, i, k, boundingboxIn).func_196958_f()) continue;
                    if (i != yMin && i != yMax && j != xMin && j != xMax && k != zMin && k != zMax) {
                        this.func_175811_a(worldIn, insideBlockState, j, i, k, boundingboxIn);
                        continue;
                    }
                    this.func_175811_a(worldIn, boundaryBlockState, j, i, k, boundingboxIn);
                }
            }
        }
    }

    protected void func_74882_a(IWorld worldIn, MutableBoundingBox boundingboxIn, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, boolean alwaysReplace, Random rand, BlockSelector blockselector) {
        for (int i = minY; i <= maxY; ++i) {
            for (int j = minX; j <= maxX; ++j) {
                for (int k = minZ; k <= maxZ; ++k) {
                    if (alwaysReplace && this.func_175807_a((IBlockReader)worldIn, j, i, k, boundingboxIn).func_196958_f()) continue;
                    blockselector.func_75062_a(rand, j, i, k, i == minY || i == maxY || j == minX || j == maxX || k == minZ || k == maxZ);
                    this.func_175811_a(worldIn, blockselector.func_180780_a(), j, i, k, boundingboxIn);
                }
            }
        }
    }

    protected void func_189914_a(IWorld worldIn, MutableBoundingBox sbb, Random rand, float chance, int x1, int y1, int z1, int x2, int y2, int z2, BlockState edgeState, BlockState state, boolean requireNonAir, boolean requiredSkylight) {
        for (int i = y1; i <= y2; ++i) {
            for (int j = x1; j <= x2; ++j) {
                for (int k = z1; k <= z2; ++k) {
                    if (rand.nextFloat() > chance || requireNonAir && this.func_175807_a((IBlockReader)worldIn, j, i, k, sbb).func_196958_f() || requiredSkylight && !this.func_189916_b((IWorldReader)worldIn, j, i, k, sbb)) continue;
                    if (i != y1 && i != y2 && j != x1 && j != x2 && k != z1 && k != z2) {
                        this.func_175811_a(worldIn, state, j, i, k, sbb);
                        continue;
                    }
                    this.func_175811_a(worldIn, edgeState, j, i, k, sbb);
                }
            }
        }
    }

    protected void func_175809_a(IWorld worldIn, MutableBoundingBox boundingboxIn, Random rand, float chance, int x, int y, int z, BlockState blockstateIn) {
        if (rand.nextFloat() < chance) {
            this.func_175811_a(worldIn, blockstateIn, x, y, z, boundingboxIn);
        }
    }

    protected void func_180777_a(IWorld worldIn, MutableBoundingBox boundingboxIn, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockState blockstateIn, boolean excludeAir) {
        float f = maxX - minX + 1;
        float f1 = maxY - minY + 1;
        float f2 = maxZ - minZ + 1;
        float f3 = (float)minX + f / 2.0f;
        float f4 = (float)minZ + f2 / 2.0f;
        for (int i = minY; i <= maxY; ++i) {
            float f5 = (float)(i - minY) / f1;
            for (int j = minX; j <= maxX; ++j) {
                float f6 = ((float)j - f3) / (f * 0.5f);
                for (int k = minZ; k <= maxZ; ++k) {
                    float f8;
                    float f7 = ((float)k - f4) / (f2 * 0.5f);
                    if (excludeAir && this.func_175807_a((IBlockReader)worldIn, j, i, k, boundingboxIn).func_196958_f() || !((f8 = f6 * f6 + f5 * f5 + f7 * f7) <= 1.05f)) continue;
                    this.func_175811_a(worldIn, blockstateIn, j, i, k, boundingboxIn);
                }
            }
        }
    }

    protected void func_175808_b(IWorld worldIn, BlockState blockstateIn, int x, int y, int z, MutableBoundingBox boundingboxIn) {
        int k;
        int j;
        int i = this.func_74865_a(x, z);
        if (boundingboxIn.func_175898_b((Vector3i)new BlockPos(i, j = this.func_74862_a(y), k = this.func_74873_b(x, z)))) {
            while ((worldIn.func_175623_d(new BlockPos(i, j, k)) || worldIn.func_180495_p(new BlockPos(i, j, k)).func_185904_a().func_76224_d()) && j > 1) {
                worldIn.func_180501_a(new BlockPos(i, j, k), blockstateIn, 2);
                --j;
            }
        }
    }

    protected boolean func_186167_a(IWorld worldIn, MutableBoundingBox structurebb, Random randomIn, int x, int y, int z, ResourceLocation loot) {
        BlockPos blockpos = new BlockPos(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z));
        return this.func_191080_a(worldIn, structurebb, randomIn, blockpos, loot, null);
    }

    public static BlockState func_197528_a(IBlockReader worldIn, BlockPos posIn, BlockState blockStateIn) {
        Direction direction = null;
        for (Direction direction1 : Direction.Plane.HORIZONTAL) {
            BlockPos blockpos = posIn.func_177972_a(direction1);
            BlockState blockstate = worldIn.func_180495_p(blockpos);
            if (blockstate.func_203425_a(Blocks.field_150486_ae)) {
                return blockStateIn;
            }
            if (!blockstate.func_200015_d(worldIn, blockpos)) continue;
            if (direction != null) {
                direction = null;
                break;
            }
            direction = direction1;
        }
        if (direction != null) {
            return (BlockState)((Object)blockStateIn.func_206870_a((Property)HorizontalBlock.field_185512_D, (Comparable)((Object)direction.func_176734_d())));
        }
        Direction direction2 = (Direction)((Object)blockStateIn.func_177229_b((Property)HorizontalBlock.field_185512_D));
        BlockPos blockpos1 = posIn.func_177972_a(direction2);
        if (worldIn.func_180495_p(blockpos1).func_200015_d(worldIn, blockpos1)) {
            direction2 = direction2.func_176734_d();
            blockpos1 = posIn.func_177972_a(direction2);
        }
        if (worldIn.func_180495_p(blockpos1).func_200015_d(worldIn, blockpos1)) {
            direction2 = direction2.func_176746_e();
            blockpos1 = posIn.func_177972_a(direction2);
        }
        if (worldIn.func_180495_p(blockpos1).func_200015_d(worldIn, blockpos1)) {
            direction2 = direction2.func_176734_d();
            posIn.func_177972_a(direction2);
        }
        return (BlockState)((Object)blockStateIn.func_206870_a((Property)HorizontalBlock.field_185512_D, (Comparable)((Object)direction2)));
    }

    protected boolean func_191080_a(IWorld worldIn, MutableBoundingBox boundsIn, Random rand, BlockPos posIn, ResourceLocation resourceLocationIn, @Nullable BlockState p_191080_6_) {
        if (boundsIn.func_175898_b((Vector3i)posIn) && !worldIn.func_180495_p(posIn).func_203425_a(Blocks.field_150486_ae)) {
            if (p_191080_6_ == null) {
                p_191080_6_ = StructurePiece.func_197528_a((IBlockReader)worldIn, posIn, Blocks.field_150486_ae.func_176223_P());
            }
            worldIn.func_180501_a(posIn, p_191080_6_, 2);
            TileEntity tileentity = worldIn.func_175625_s(posIn);
            if (tileentity instanceof ChestTileEntity) {
                ((ChestTileEntity)((Object)tileentity)).func_189404_a(resourceLocationIn, rand.nextLong());
            }
            return true;
        }
        return false;
    }

    protected boolean func_189419_a(IWorld worldIn, MutableBoundingBox sbb, Random rand, int x, int y, int z, Direction facing, ResourceLocation lootTableIn) {
        BlockPos blockpos = new BlockPos(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z));
        if (sbb.func_175898_b((Vector3i)blockpos) && !worldIn.func_180495_p(blockpos).func_203425_a(Blocks.field_150367_z)) {
            this.func_175811_a(worldIn, (BlockState)((Object)Blocks.field_150367_z.func_176223_P().func_206870_a((Property)DispenserBlock.field_176441_a, (Comparable)((Object)facing))), x, y, z, sbb);
            TileEntity tileentity = worldIn.func_175625_s(blockpos);
            if (tileentity instanceof DispenserTileEntity) {
                ((DispenserTileEntity)tileentity).func_189404_a(lootTableIn, rand.nextLong());
            }
            return true;
        }
        return false;
    }

    public void func_181138_a(int x, int y, int z) {
        this.field_74887_e.func_78886_a(x, y, z);
    }

    @Nullable
    public Direction func_186165_e() {
        return this.field_74885_f;
    }

    public void func_186164_a(@Nullable Direction facing) {
        this.field_74885_f = facing;
        if (facing == null) {
            this.field_186169_c = Rotation.NONE;
            this.field_186168_b = Mirror.NONE;
        } else {
            switch (facing) {
                case SOUTH: {
                    this.field_186168_b = Mirror.LEFT_RIGHT;
                    this.field_186169_c = Rotation.NONE;
                    break;
                }
                case WEST: {
                    this.field_186168_b = Mirror.LEFT_RIGHT;
                    this.field_186169_c = Rotation.CLOCKWISE_90;
                    break;
                }
                case EAST: {
                    this.field_186168_b = Mirror.NONE;
                    this.field_186169_c = Rotation.CLOCKWISE_90;
                    break;
                }
                default: {
                    this.field_186168_b = Mirror.NONE;
                    this.field_186169_c = Rotation.NONE;
                }
            }
        }
    }

    public Rotation func_214809_Y_() {
        return this.field_186169_c;
    }

    public IStructurePieceType func_214807_k() {
        return this.field_214811_d;
    }

    public static abstract class BlockSelector {
        protected BlockState field_151562_a = Blocks.field_150350_a.func_176223_P();

        protected BlockSelector() {
        }

        public abstract void func_75062_a(Random var1, int var2, int var3, int var4, boolean var5);

        public BlockState func_180780_a() {
            return this.field_151562_a;
        }
    }
}

