/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.layer;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.INoiseRandom;
import net.minecraft.world.gen.layer.LayerUtil;
import net.minecraft.world.gen.layer.traits.IC0Transformer;
import net.minecraftforge.common.BiomeManager;

public class BiomeLayer
implements IC0Transformer {
    private static final int field_202727_a = Registry.field_212624_m.func_148757_b(Biomes.field_150583_P);
    private static final int field_202728_b = Registry.field_212624_m.func_148757_b(Biomes.field_76769_d);
    private static final int field_202729_c = Registry.field_212624_m.func_148757_b(Biomes.field_76770_e);
    private static final int field_202730_d = Registry.field_212624_m.func_148757_b(Biomes.field_76767_f);
    private static final int field_202731_e = Registry.field_212624_m.func_148757_b(Biomes.field_76774_n);
    private static final int field_202732_f = Registry.field_212624_m.func_148757_b(Biomes.field_76782_w);
    private static final int field_202733_g = Registry.field_212624_m.func_148757_b(Biomes.field_150608_ab);
    private static final int field_202734_h = Registry.field_212624_m.func_148757_b(Biomes.field_150607_aa);
    private static final int field_202735_i = Registry.field_212624_m.func_148757_b(Biomes.field_76789_p);
    private static final int field_202736_j = Registry.field_212624_m.func_148757_b(Biomes.field_76772_c);
    private static final int field_202737_k = Registry.field_212624_m.func_148757_b(Biomes.field_150578_U);
    private static final int field_202738_l = Registry.field_212624_m.func_148757_b(Biomes.field_150585_R);
    private static final int field_202739_m = Registry.field_212624_m.func_148757_b(Biomes.field_150588_X);
    private static final int field_202740_n = Registry.field_212624_m.func_148757_b(Biomes.field_76780_h);
    private static final int field_202741_o = Registry.field_212624_m.func_148757_b(Biomes.field_76768_g);
    private static final int field_202742_p = Registry.field_212624_m.func_148757_b(Biomes.field_150584_S);
    private static final int[] field_202743_q = new int[]{field_202728_b, field_202730_d, field_202729_c, field_202740_n, field_202736_j, field_202741_o};
    private static final int[] field_202744_r = new int[]{field_202728_b, field_202728_b, field_202728_b, field_202739_m, field_202739_m, field_202736_j};
    private static final int[] field_202745_s = new int[]{field_202730_d, field_202738_l, field_202729_c, field_202736_j, field_202727_a, field_202740_n};
    private static final int[] field_202746_t = new int[]{field_202730_d, field_202729_c, field_202741_o, field_202736_j};
    private static final int[] field_202747_u = new int[]{field_202731_e, field_202731_e, field_202731_e, field_202742_p};
    private int[] field_151623_c = field_202744_r;
    private List<BiomeManager.BiomeEntry>[] biomes = new ArrayList[BiomeManager.BiomeType.values().length];

    public BiomeLayer(boolean p_i232147_1_) {
        for (BiomeManager.BiomeType type : BiomeManager.BiomeType.values()) {
            ImmutableList biomesToAdd = BiomeManager.getBiomes((BiomeManager.BiomeType)type);
            if (this.biomes[type.ordinal()] == null) {
                this.biomes[type.ordinal()] = new ArrayList<BiomeManager.BiomeEntry>();
            }
            if (biomesToAdd == null) continue;
            this.biomes[type.ordinal()].addAll((Collection<BiomeManager.BiomeEntry>)biomesToAdd);
        }
        int desertIdx = BiomeManager.BiomeType.DESERT.ordinal();
        this.biomes[desertIdx].add(new BiomeManager.BiomeEntry(Biomes.field_76769_d, 30));
        this.biomes[desertIdx].add(new BiomeManager.BiomeEntry(Biomes.field_150588_X, 20));
        this.biomes[desertIdx].add(new BiomeManager.BiomeEntry(Biomes.field_76772_c, 10));
        if (p_i232147_1_) {
            this.biomes[desertIdx].clear();
            this.biomes[desertIdx].add(new BiomeManager.BiomeEntry(Biomes.field_76769_d, 10));
            this.biomes[desertIdx].add(new BiomeManager.BiomeEntry(Biomes.field_76767_f, 10));
            this.biomes[desertIdx].add(new BiomeManager.BiomeEntry(Biomes.field_76770_e, 10));
            this.biomes[desertIdx].add(new BiomeManager.BiomeEntry(Biomes.field_76780_h, 10));
            this.biomes[desertIdx].add(new BiomeManager.BiomeEntry(Biomes.field_76772_c, 10));
            this.biomes[desertIdx].add(new BiomeManager.BiomeEntry(Biomes.field_76768_g, 10));
        }
    }

    public int func_202726_a(INoiseRandom context, int value) {
        int i = (value & 0xF00) >> 8;
        if (!LayerUtil.func_202827_a((int)(value &= 0xFFFFF0FF)) && value != field_202735_i) {
            switch (value) {
                case 1: {
                    if (i > 0) {
                        return context.func_202696_a(3) == 0 ? field_202733_g : field_202734_h;
                    }
                    return Registry.field_212624_m.func_148757_b(this.getWeightedBiomeEntry(BiomeManager.BiomeType.DESERT, context));
                }
                case 2: {
                    if (i > 0) {
                        return field_202732_f;
                    }
                    return Registry.field_212624_m.func_148757_b(this.getWeightedBiomeEntry(BiomeManager.BiomeType.WARM, context));
                }
                case 3: {
                    if (i > 0) {
                        return field_202737_k;
                    }
                    return Registry.field_212624_m.func_148757_b(this.getWeightedBiomeEntry(BiomeManager.BiomeType.COOL, context));
                }
                case 4: {
                    return Registry.field_212624_m.func_148757_b(this.getWeightedBiomeEntry(BiomeManager.BiomeType.ICY, context));
                }
            }
            return field_202735_i;
        }
        return value;
    }

    private Biome getWeightedBiomeEntry(BiomeManager.BiomeType type, INoiseRandom context) {
        List<BiomeManager.BiomeEntry> biomeList = this.biomes[type.ordinal()];
        int totalWeight = WeightedRandom.func_76272_a(biomeList);
        int weight = BiomeManager.isTypeListModded((BiomeManager.BiomeType)type) ? context.func_202696_a(totalWeight) : context.func_202696_a(totalWeight / 10) * 10;
        return ((BiomeManager.BiomeEntry)WeightedRandom.func_180166_a(biomeList, (int)weight)).biome;
    }
}

