/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.server;

import com.mojang.datafixers.util.Either;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChangeBlockPacket;
import net.minecraft.network.play.server.SChunkDataPacket;
import net.minecraft.network.play.server.SMultiBlockChangePacket;
import net.minecraft.network.play.server.SUpdateLightPacket;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.ChunkPrimerWrapper;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.lighting.WorldLightManager;
import net.minecraft.world.server.ChunkManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfig;

public class ChunkHolder {
    public static final Either<IChunk, IChunkLoadingError> field_219306_a = Either.right((Object)IChunkLoadingError.field_219055_b);
    public static final CompletableFuture<Either<IChunk, IChunkLoadingError>> field_219307_b = CompletableFuture.completedFuture(field_219306_a);
    public static final Either<Chunk, IChunkLoadingError> field_219308_c = Either.right((Object)IChunkLoadingError.field_219055_b);
    private static final CompletableFuture<Either<Chunk, IChunkLoadingError>> field_219309_d = CompletableFuture.completedFuture(field_219308_c);
    private static final List<ChunkStatus> field_219310_e = ChunkStatus.func_222582_a();
    private static final LocationType[] field_219311_f = LocationType.values();
    private final AtomicReferenceArray<CompletableFuture<Either<IChunk, IChunkLoadingError>>> field_219312_g = new AtomicReferenceArray(field_219310_e.size());
    private volatile CompletableFuture<Either<Chunk, IChunkLoadingError>> field_222983_h = field_219309_d;
    private volatile CompletableFuture<Either<Chunk, IChunkLoadingError>> field_219313_h = field_219309_d;
    private volatile CompletableFuture<Either<Chunk, IChunkLoadingError>> field_219314_i = field_219309_d;
    private CompletableFuture<IChunk> field_219315_j = CompletableFuture.completedFuture(null);
    private int field_219316_k;
    private int field_219317_l;
    private int field_219318_m;
    private final ChunkPos field_219319_n;
    private short[] field_219320_o = new short[64];
    private int field_219321_p;
    private int field_219322_q;
    private int field_219324_s;
    private int field_219325_t;
    private final WorldLightManager field_219326_u;
    private final IListener field_219327_v;
    private final IPlayerProvider field_219328_w;
    private boolean field_219329_x;

    public ChunkHolder(ChunkPos p_i50716_1_, int p_i50716_2_, WorldLightManager p_i50716_3_, IListener p_i50716_4_, IPlayerProvider p_i50716_5_) {
        this.field_219319_n = p_i50716_1_;
        this.field_219326_u = p_i50716_3_;
        this.field_219327_v = p_i50716_4_;
        this.field_219328_w = p_i50716_5_;
        this.field_219317_l = this.field_219316_k = ChunkManager.field_219249_a + 1;
        this.field_219318_m = this.field_219316_k;
        this.func_219292_a(p_i50716_2_);
    }

    public CompletableFuture<Either<IChunk, IChunkLoadingError>> func_219301_a(ChunkStatus p_219301_1_) {
        CompletableFuture<Either<IChunk, IChunkLoadingError>> completablefuture = this.field_219312_g.get(p_219301_1_.func_222584_c());
        return completablefuture == null ? field_219307_b : completablefuture;
    }

    public CompletableFuture<Either<IChunk, IChunkLoadingError>> func_225410_b(ChunkStatus p_225410_1_) {
        return ChunkHolder.func_219278_b(this.field_219317_l).func_209003_a(p_225410_1_) ? this.func_219301_a(p_225410_1_) : field_219307_b;
    }

    public CompletableFuture<Either<Chunk, IChunkLoadingError>> func_219296_a() {
        return this.field_219313_h;
    }

    public CompletableFuture<Either<Chunk, IChunkLoadingError>> func_219297_b() {
        return this.field_219314_i;
    }

    public CompletableFuture<Either<Chunk, IChunkLoadingError>> func_223492_c() {
        return this.field_222983_h;
    }

    @Nullable
    public Chunk func_219298_c() {
        CompletableFuture<Either<Chunk, IChunkLoadingError>> completablefuture = this.func_219296_a();
        Either<Chunk, IChunkLoadingError> either = completablefuture.getNow((Either<Chunk, IChunkLoadingError>)((Either)null));
        return either == null ? null : either.left().orElse(null);
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public ChunkStatus func_219285_d() {
        for (int i = field_219310_e.size() - 1; i >= 0; --i) {
            ChunkStatus chunkstatus = field_219310_e.get(i);
            CompletableFuture<Either<IChunk, IChunkLoadingError>> completablefuture = this.func_219301_a(chunkstatus);
            if (!completablefuture.getNow(field_219306_a).left().isPresent()) continue;
            return chunkstatus;
        }
        return null;
    }

    @Nullable
    public IChunk func_219287_e() {
        for (int i = field_219310_e.size() - 1; i >= 0; --i) {
            Optional optional;
            ChunkStatus chunkstatus = field_219310_e.get(i);
            CompletableFuture<Either<IChunk, IChunkLoadingError>> completablefuture = this.func_219301_a(chunkstatus);
            if (completablefuture.isCompletedExceptionally() || !(optional = completablefuture.getNow(field_219306_a).left()).isPresent()) continue;
            return (IChunk)optional.get();
        }
        return null;
    }

    public CompletableFuture<IChunk> func_219302_f() {
        return this.field_219315_j;
    }

    public void func_241819_a(int p_241819_1_, int p_241819_2_, int p_241819_3_) {
        Chunk chunk = this.func_219298_c();
        if (chunk != null) {
            this.field_219322_q |= 1 << (p_241819_2_ >> 4);
            short short1 = (short)(p_241819_1_ << 12 | p_241819_3_ << 8 | p_241819_2_);
            for (int i = 0; i < this.field_219321_p; ++i) {
                if (this.field_219320_o[i] != short1) continue;
                return;
            }
            if (this.field_219321_p == this.field_219320_o.length) {
                this.field_219320_o = Arrays.copyOf(this.field_219320_o, this.field_219320_o.length << 1);
            }
            this.field_219320_o[this.field_219321_p++] = short1;
        }
    }

    public void func_219280_a(LightType type, int sectionY) {
        Chunk chunk = this.func_219298_c();
        if (chunk != null) {
            chunk.func_177427_f(true);
            if (type == LightType.SKY) {
                this.field_219325_t |= 1 << sectionY - -1;
            } else {
                this.field_219324_s |= 1 << sectionY - -1;
            }
        }
    }

    public void func_219274_a(Chunk chunkIn) {
        if (this.field_219321_p != 0 || this.field_219325_t != 0 || this.field_219324_s != 0) {
            World world = chunkIn.func_177412_p();
            if (this.field_219321_p < (Integer)ForgeConfig.SERVER.clumpingThreshold.get() && (this.field_219325_t != 0 || this.field_219324_s != 0)) {
                this.func_219293_a((IPacket<?>)new SUpdateLightPacket(chunkIn.func_76632_l(), this.field_219326_u, this.field_219325_t, this.field_219324_s, false), true);
                this.field_219325_t = 0;
                this.field_219324_s = 0;
            }
            if (this.field_219321_p == 1) {
                int i = (this.field_219320_o[0] >> 12 & 0xF) + this.field_219319_n.field_77276_a * 16;
                int j = this.field_219320_o[0] & 0xFF;
                int k = (this.field_219320_o[0] >> 8 & 0xF) + this.field_219319_n.field_77275_b * 16;
                BlockPos blockpos = new BlockPos(i, j, k);
                this.func_219293_a((IPacket<?>)new SChangeBlockPacket((IBlockReader)((Object)world), blockpos), false);
                if (world.func_180495_p(blockpos).hasTileEntity()) {
                    this.func_219305_a(world, blockpos);
                }
            } else if (this.field_219321_p >= (Integer)ForgeConfig.SERVER.clumpingThreshold.get()) {
                this.func_219293_a((IPacket<?>)new SChunkDataPacket(chunkIn, this.field_219322_q, false), false);
            } else if (this.field_219321_p != 0) {
                this.func_219293_a((IPacket<?>)new SMultiBlockChangePacket(this.field_219321_p, this.field_219320_o, chunkIn), false);
                for (int l = 0; l < this.field_219321_p; ++l) {
                    int i1 = (this.field_219320_o[l] >> 12 & 0xF) + this.field_219319_n.field_77276_a * 16;
                    int j1 = this.field_219320_o[l] & 0xFF;
                    int k1 = (this.field_219320_o[l] >> 8 & 0xF) + this.field_219319_n.field_77275_b * 16;
                    BlockPos blockpos1 = new BlockPos(i1, j1, k1);
                    if (!world.func_180495_p(blockpos1).hasTileEntity()) continue;
                    this.func_219305_a(world, blockpos1);
                }
            }
            this.field_219321_p = 0;
            this.field_219322_q = 0;
        }
    }

    private void func_219305_a(World worldIn, BlockPos posIn) {
        SUpdateTileEntityPacket supdatetileentitypacket;
        TileEntity tileentity = worldIn.func_175625_s(posIn);
        if (tileentity != null && (supdatetileentitypacket = tileentity.func_189518_D_()) != null) {
            this.func_219293_a((IPacket<?>)supdatetileentitypacket, false);
        }
    }

    private void func_219293_a(IPacket<?> packetIn, boolean boundaryOnly) {
        this.field_219328_w.func_219097_a(this.field_219319_n, boundaryOnly).forEach(p_219304_1_ -> p_219304_1_.field_71135_a.func_147359_a(packetIn));
    }

    public CompletableFuture<Either<IChunk, IChunkLoadingError>> func_219276_a(ChunkStatus p_219276_1_, ChunkManager p_219276_2_) {
        Either<IChunk, IChunkLoadingError> either;
        int i = p_219276_1_.func_222584_c();
        CompletableFuture<Either<IChunk, IChunkLoadingError>> completablefuture = this.field_219312_g.get(i);
        if (completablefuture != null && ((either = completablefuture.getNow((Either<IChunk, IChunkLoadingError>)((Either)null))) == null || either.left().isPresent())) {
            return completablefuture;
        }
        if (ChunkHolder.func_219278_b(this.field_219317_l).func_209003_a(p_219276_1_)) {
            CompletableFuture<Either<IChunk, IChunkLoadingError>> completablefuture1 = p_219276_2_.func_219244_a(this, p_219276_1_);
            this.func_219284_a(completablefuture1);
            this.field_219312_g.set(i, completablefuture1);
            return completablefuture1;
        }
        return completablefuture == null ? field_219307_b : completablefuture;
    }

    private void func_219284_a(CompletableFuture<? extends Either<? extends IChunk, IChunkLoadingError>> eitherChunk) {
        this.field_219315_j = this.field_219315_j.thenCombine(eitherChunk, (p_219295_0_, p_219295_1_) -> (IChunk)p_219295_1_.map(p_219283_0_ -> p_219283_0_, p_219288_1_ -> p_219295_0_));
    }

    @OnlyIn(value=Dist.CLIENT)
    public LocationType func_219300_g() {
        return ChunkHolder.func_219286_c(this.field_219317_l);
    }

    public ChunkPos func_219277_h() {
        return this.field_219319_n;
    }

    public int func_219299_i() {
        return this.field_219317_l;
    }

    public int func_219281_j() {
        return this.field_219318_m;
    }

    private void func_219275_d(int p_219275_1_) {
        this.field_219318_m = p_219275_1_;
    }

    public void func_219292_a(int level) {
        this.field_219317_l = level;
    }

    protected void func_219291_a(ChunkManager chunkManagerIn) {
        ChunkStatus chunkstatus = ChunkHolder.func_219278_b(this.field_219316_k);
        ChunkStatus chunkstatus1 = ChunkHolder.func_219278_b(this.field_219317_l);
        boolean flag = this.field_219316_k <= ChunkManager.field_219249_a;
        boolean flag1 = this.field_219317_l <= ChunkManager.field_219249_a;
        LocationType chunkholder$locationtype = ChunkHolder.func_219286_c(this.field_219316_k);
        LocationType chunkholder$locationtype1 = ChunkHolder.func_219286_c(this.field_219317_l);
        if (flag) {
            int i;
            Either either = Either.right((Object)new IChunkLoadingError(){

                public String toString() {
                    return "Unloaded ticket level " + ChunkHolder.this.field_219319_n.toString();
                }
            });
            int n = i = flag1 ? chunkstatus1.func_222584_c() + 1 : 0;
            while (i <= chunkstatus.func_222584_c()) {
                CompletableFuture<Either<IChunk, IChunkLoadingError>> completablefuture = this.field_219312_g.get(i);
                if (completablefuture != null) {
                    completablefuture.complete((Either<IChunk, IChunkLoadingError>)either);
                } else {
                    this.field_219312_g.set(i, CompletableFuture.completedFuture(either));
                }
                ++i;
            }
        }
        boolean flag5 = chunkholder$locationtype.func_219065_a(LocationType.BORDER);
        boolean flag6 = chunkholder$locationtype1.func_219065_a(LocationType.BORDER);
        this.field_219329_x |= flag6;
        if (!flag5 && flag6) {
            this.field_222983_h = chunkManagerIn.func_222961_b(this);
            this.func_219284_a(this.field_222983_h);
        }
        if (flag5 && !flag6) {
            CompletableFuture<Either<Chunk, IChunkLoadingError>> completablefuture1 = this.field_222983_h;
            this.field_222983_h = field_219309_d;
            this.func_219284_a((CompletableFuture<? extends Either<? extends IChunk, IChunkLoadingError>>)completablefuture1.thenApply(p_222982_1_ -> p_222982_1_.ifLeft(chunkManagerIn::func_222973_a)));
        }
        boolean flag7 = chunkholder$locationtype.func_219065_a(LocationType.TICKING);
        boolean flag2 = chunkholder$locationtype1.func_219065_a(LocationType.TICKING);
        if (!flag7 && flag2) {
            this.field_219313_h = chunkManagerIn.func_219179_a(this);
            this.func_219284_a(this.field_219313_h);
        }
        if (flag7 && !flag2) {
            this.field_219313_h.complete(field_219308_c);
            this.field_219313_h = field_219309_d;
        }
        boolean flag3 = chunkholder$locationtype.func_219065_a(LocationType.ENTITY_TICKING);
        boolean flag4 = chunkholder$locationtype1.func_219065_a(LocationType.ENTITY_TICKING);
        if (!flag3 && flag4) {
            if (this.field_219314_i != field_219309_d) {
                throw (IllegalStateException)Util.func_229757_c_((Throwable)new IllegalStateException());
            }
            this.field_219314_i = chunkManagerIn.func_219188_b(this.field_219319_n);
            this.func_219284_a(this.field_219314_i);
        }
        if (flag3 && !flag4) {
            this.field_219314_i.complete(field_219308_c);
            this.field_219314_i = field_219309_d;
        }
        this.field_219327_v.func_219066_a(this.field_219319_n, this::func_219281_j, this.field_219317_l, this::func_219275_d);
        this.field_219316_k = this.field_219317_l;
    }

    public static ChunkStatus func_219278_b(int level) {
        return level < 33 ? ChunkStatus.field_222617_m : ChunkStatus.func_222581_a(level - 33);
    }

    public static LocationType func_219286_c(int level) {
        return field_219311_f[MathHelper.func_76125_a((int)(33 - level + 1), (int)0, (int)(field_219311_f.length - 1))];
    }

    public boolean func_219289_k() {
        return this.field_219329_x;
    }

    public void func_219303_l() {
        this.field_219329_x = ChunkHolder.func_219286_c(this.field_219317_l).func_219065_a(LocationType.BORDER);
    }

    public void func_219294_a(ChunkPrimerWrapper p_219294_1_) {
        for (int i = 0; i < this.field_219312_g.length(); ++i) {
            Optional optional;
            CompletableFuture<Either<IChunk, IChunkLoadingError>> completablefuture = this.field_219312_g.get(i);
            if (completablefuture == null || !(optional = completablefuture.getNow(field_219306_a).left()).isPresent() || !(optional.get() instanceof ChunkPrimer)) continue;
            this.field_219312_g.set(i, CompletableFuture.completedFuture(Either.left((Object)p_219294_1_)));
        }
        this.func_219284_a(CompletableFuture.completedFuture(Either.left((Object)p_219294_1_.func_217336_u())));
    }

    public static enum LocationType {
        INACCESSIBLE,
        BORDER,
        TICKING,
        ENTITY_TICKING;


        public boolean func_219065_a(LocationType type) {
            return this.ordinal() >= type.ordinal();
        }
    }

    public static interface IPlayerProvider {
        public Stream<ServerPlayerEntity> func_219097_a(ChunkPos var1, boolean var2);
    }

    public static interface IListener {
        public void func_219066_a(ChunkPos var1, IntSupplier var2, int var3, IntConsumer var4);
    }

    public static interface IChunkLoadingError {
        public static final IChunkLoadingError field_219055_b = new IChunkLoadingError(){

            public String toString() {
                return "UNLOADED";
            }
        };
    }
}

