/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.criterion;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import javax.annotation.Nullable;
import net.minecraft.advancements.criterion.BlockPredicate;
import net.minecraft.advancements.criterion.FluidPredicate;
import net.minecraft.advancements.criterion.LightPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.block.CampfireBlock;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LocationPredicate {
    private static final Logger field_235305_b_ = LogManager.getLogger();
    public static final LocationPredicate field_193455_a = new LocationPredicate(MinMaxBounds.FloatBound.field_211359_e, MinMaxBounds.FloatBound.field_211359_e, MinMaxBounds.FloatBound.field_211359_e, null, null, null, null, LightPredicate.field_226854_a_, BlockPredicate.field_226231_a_, FluidPredicate.field_226643_a_);
    private final MinMaxBounds.FloatBound field_193457_c;
    private final MinMaxBounds.FloatBound field_193458_d;
    private final MinMaxBounds.FloatBound field_193459_e;
    @Nullable
    private final Biome field_193456_b;
    @Nullable
    private final Structure<?> field_193460_f;
    @Nullable
    private final RegistryKey<World> field_193461_g;
    @Nullable
    private final Boolean field_235306_i_;
    private final LightPredicate field_226864_h_;
    private final BlockPredicate field_226865_i_;
    private final FluidPredicate field_226866_j_;

    public LocationPredicate(MinMaxBounds.FloatBound floatBound, MinMaxBounds.FloatBound floatBound2, MinMaxBounds.FloatBound floatBound3, @Nullable Biome biome, @Nullable Structure<?> structure, @Nullable RegistryKey<World> registryKey, @Nullable Boolean bl, LightPredicate lightPredicate, BlockPredicate blockPredicate, FluidPredicate fluidPredicate) {
        this.field_193457_c = floatBound;
        this.field_193458_d = floatBound2;
        this.field_193459_e = floatBound3;
        this.field_193456_b = biome;
        this.field_193460_f = structure;
        this.field_193461_g = registryKey;
        this.field_235306_i_ = bl;
        this.field_226864_h_ = lightPredicate;
        this.field_226865_i_ = blockPredicate;
        this.field_226866_j_ = fluidPredicate;
    }

    public static LocationPredicate func_204010_a(Biome biome) {
        return new LocationPredicate(MinMaxBounds.FloatBound.field_211359_e, MinMaxBounds.FloatBound.field_211359_e, MinMaxBounds.FloatBound.field_211359_e, biome, null, null, null, LightPredicate.field_226854_a_, BlockPredicate.field_226231_a_, FluidPredicate.field_226643_a_);
    }

    public static LocationPredicate func_235308_a_(RegistryKey<World> registryKey) {
        return new LocationPredicate(MinMaxBounds.FloatBound.field_211359_e, MinMaxBounds.FloatBound.field_211359_e, MinMaxBounds.FloatBound.field_211359_e, null, null, registryKey, null, LightPredicate.field_226854_a_, BlockPredicate.field_226231_a_, FluidPredicate.field_226643_a_);
    }

    public static LocationPredicate func_218020_a(Structure<?> structure) {
        return new LocationPredicate(MinMaxBounds.FloatBound.field_211359_e, MinMaxBounds.FloatBound.field_211359_e, MinMaxBounds.FloatBound.field_211359_e, null, structure, null, null, LightPredicate.field_226854_a_, BlockPredicate.field_226231_a_, FluidPredicate.field_226643_a_);
    }

    public boolean func_193452_a(ServerWorld serverWorld, double d, double d2, double d3) {
        return this.func_193453_a(serverWorld, (float)d, (float)d2, (float)d3);
    }

    public boolean func_193453_a(ServerWorld serverWorld, float f, float f2, float f3) {
        if (!this.field_193457_c.func_211354_d(f)) {
            return false;
        }
        if (!this.field_193458_d.func_211354_d(f2)) {
            return false;
        }
        if (!this.field_193459_e.func_211354_d(f3)) {
            return false;
        }
        if (this.field_193461_g != null && this.field_193461_g != serverWorld.func_234923_W_()) {
            return false;
        }
        BlockPos blockPos = new BlockPos(f, f2, f3);
        boolean \u26032 = serverWorld.func_195588_v(blockPos);
        if (!(this.field_193456_b == null || \u26032 && this.field_193456_b == serverWorld.func_226691_t_(blockPos))) {
            return false;
        }
        if (!(this.field_193460_f == null || \u26032 && serverWorld.func_241112_a_().func_235010_a_(blockPos, true, this.field_193460_f).func_75069_d())) {
            return false;
        }
        if (!(this.field_235306_i_ == null || \u26032 && this.field_235306_i_ == CampfireBlock.func_235474_a_(serverWorld, blockPos))) {
            return false;
        }
        if (!this.field_226864_h_.func_226858_a_(serverWorld, blockPos)) {
            return false;
        }
        if (!this.field_226865_i_.func_226238_a_(serverWorld, blockPos)) {
            return false;
        }
        return this.field_226866_j_.func_226649_a_(serverWorld, blockPos);
    }

    public JsonElement func_204009_a() {
        if (this == field_193455_a) {
            return JsonNull.INSTANCE;
        }
        JsonObject jsonObject = new JsonObject();
        if (!(this.field_193457_c.func_211335_c() && this.field_193458_d.func_211335_c() && this.field_193459_e.func_211335_c())) {
            \u2603 = new JsonObject();
            \u2603.add("x", this.field_193457_c.func_200321_c());
            \u2603.add("y", this.field_193458_d.func_200321_c());
            \u2603.add("z", this.field_193459_e.func_200321_c());
            jsonObject.add("position", (JsonElement)\u2603);
        }
        if (this.field_193461_g != null) {
            World.field_234917_f_.encodeStart((DynamicOps)JsonOps.INSTANCE, this.field_193461_g).resultOrPartial(arg_0 -> ((Logger)field_235305_b_).error(arg_0)).ifPresent(jsonElement -> jsonObject.add("dimension", jsonElement));
        }
        if (this.field_193460_f != null) {
            jsonObject.addProperty("feature", this.field_193460_f.func_143025_a());
        }
        if (this.field_193456_b != null) {
            jsonObject.addProperty("biome", Registry.field_212624_m.func_177774_c(this.field_193456_b).toString());
        }
        if (this.field_235306_i_ != null) {
            jsonObject.addProperty("smokey", this.field_235306_i_);
        }
        jsonObject.add("light", this.field_226864_h_.func_226856_a_());
        jsonObject.add("block", this.field_226865_i_.func_226236_a_());
        jsonObject.add("fluid", this.field_226866_j_.func_226647_a_());
        return jsonObject;
    }

    public static LocationPredicate func_193454_a(@Nullable JsonElement jsonElement) {
        ResourceLocation \u26038;
        if (jsonElement == null || jsonElement.isJsonNull()) {
            return field_193455_a;
        }
        JsonObject jsonObject = JSONUtils.func_151210_l(jsonElement, "location");
        \u2603 = JSONUtils.func_151218_a(jsonObject, "position", new JsonObject());
        MinMaxBounds.FloatBound \u26032 = MinMaxBounds.FloatBound.func_211356_a(\u2603.get("x"));
        MinMaxBounds.FloatBound \u26033 = MinMaxBounds.FloatBound.func_211356_a(\u2603.get("y"));
        MinMaxBounds.FloatBound \u26034 = MinMaxBounds.FloatBound.func_211356_a(\u2603.get("z"));
        RegistryKey \u26035 = jsonObject.has("dimension") ? (RegistryKey)ResourceLocation.field_240908_a_.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject.get("dimension")).resultOrPartial(arg_0 -> ((Logger)field_235305_b_).error(arg_0)).map(resourceLocation -> RegistryKey.func_240903_a_(Registry.field_239699_ae_, resourceLocation)).orElse(null) : null;
        Structure \u26036 = jsonObject.has("feature") ? (Structure)Structure.field_236365_a_.get((Object)JSONUtils.func_151200_h(jsonObject, "feature")) : null;
        Biome \u26037 = null;
        if (jsonObject.has("biome")) {
            \u26038 = new ResourceLocation(JSONUtils.func_151200_h(jsonObject, "biome"));
            \u26037 = Registry.field_212624_m.func_218349_b(\u26038).orElseThrow(() -> new JsonSyntaxException("Unknown biome '" + \u26038 + "'"));
        }
        \u26038 = jsonObject.has("smokey") ? Boolean.valueOf(jsonObject.get("smokey").getAsBoolean()) : null;
        LightPredicate \u26039 = LightPredicate.func_226857_a_(jsonObject.get("light"));
        BlockPredicate \u260310 = BlockPredicate.func_226237_a_(jsonObject.get("block"));
        FluidPredicate \u260311 = FluidPredicate.func_226648_a_(jsonObject.get("fluid"));
        return new LocationPredicate(\u26032, \u26033, \u26034, \u26037, \u26036, \u26035, (Boolean)((Object)\u26038), \u26039, \u260310, \u260311);
    }

    public static class Builder {
        private MinMaxBounds.FloatBound field_218014_a = MinMaxBounds.FloatBound.field_211359_e;
        private MinMaxBounds.FloatBound field_218015_b = MinMaxBounds.FloatBound.field_211359_e;
        private MinMaxBounds.FloatBound field_218016_c = MinMaxBounds.FloatBound.field_211359_e;
        @Nullable
        private Biome field_218017_d;
        @Nullable
        private Structure<?> field_218018_e;
        @Nullable
        private RegistryKey<World> field_218019_f;
        @Nullable
        private Boolean field_235311_g_;
        private LightPredicate field_226867_g_ = LightPredicate.field_226854_a_;
        private BlockPredicate field_226868_h_ = BlockPredicate.field_226231_a_;
        private FluidPredicate field_226869_i_ = FluidPredicate.field_226643_a_;

        public static Builder func_226870_a_() {
            return new Builder();
        }

        public Builder func_218012_a(@Nullable Biome biome) {
            this.field_218017_d = biome;
            return this;
        }

        public Builder func_235312_a_(BlockPredicate blockPredicate) {
            this.field_226868_h_ = blockPredicate;
            return this;
        }

        public Builder func_235313_a_(Boolean bl) {
            this.field_235311_g_ = bl;
            return this;
        }

        public LocationPredicate func_218013_a() {
            return new LocationPredicate(this.field_218014_a, this.field_218015_b, this.field_218016_c, this.field_218017_d, this.field_218018_e, this.field_218019_f, this.field_235311_g_, this.field_226867_g_, this.field_226868_h_, this.field_226869_i_);
        }
    }
}

