/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block.pattern;

import com.google.common.base.MoreObjects;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.LoadingCache;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorldReader;

public class BlockPattern {
    private final Predicate<CachedBlockInfo>[][][] field_177689_a;
    private final int field_177687_b;
    private final int field_177688_c;
    private final int field_177686_d;

    public BlockPattern(Predicate<CachedBlockInfo>[][][] predicateArray) {
        this.field_177689_a = predicateArray;
        this.field_177687_b = predicateArray.length;
        if (this.field_177687_b > 0) {
            this.field_177688_c = predicateArray[0].length;
            this.field_177686_d = this.field_177688_c > 0 ? predicateArray[0][0].length : 0;
        } else {
            this.field_177688_c = 0;
            this.field_177686_d = 0;
        }
    }

    public int func_185922_a() {
        return this.field_177687_b;
    }

    public int func_177685_b() {
        return this.field_177688_c;
    }

    public int func_177684_c() {
        return this.field_177686_d;
    }

    @Nullable
    private PatternHelper func_177682_a(BlockPos blockPos2, Direction direction, Direction direction2, LoadingCache<BlockPos, CachedBlockInfo> loadingCache) {
        BlockPos blockPos2;
        for (int i = 0; i < this.field_177686_d; ++i) {
            for (\u2603 = 0; \u2603 < this.field_177688_c; ++\u2603) {
                for (\u2603 = 0; \u2603 < this.field_177687_b; ++\u2603) {
                    if (this.field_177689_a[\u2603][\u2603][i].test((CachedBlockInfo)loadingCache.getUnchecked((Object)BlockPattern.func_177683_a(blockPos2, direction, direction2, i, \u2603, \u2603)))) continue;
                    return null;
                }
            }
        }
        return new PatternHelper(blockPos2, direction, direction2, loadingCache, this.field_177686_d, this.field_177688_c, this.field_177687_b);
    }

    @Nullable
    public PatternHelper func_177681_a(IWorldReader iWorldReader, BlockPos blockPos) {
        LoadingCache<BlockPos, CachedBlockInfo> loadingCache = BlockPattern.func_181627_a(iWorldReader, false);
        int \u26032 = Math.max(Math.max(this.field_177686_d, this.field_177688_c), this.field_177687_b);
        for (BlockPos blockPos2 : BlockPos.func_218278_a(blockPos, blockPos.func_177982_a(\u26032 - 1, \u26032 - 1, \u26032 - 1))) {
            for (Direction direction : Direction.values()) {
                for (Direction direction2 : Direction.values()) {
                    if (direction2 == direction || direction2 == direction.func_176734_d() || (\u2603 = this.func_177682_a(blockPos2, direction, direction2, loadingCache)) == null) continue;
                    return \u2603;
                }
            }
        }
        return null;
    }

    public static LoadingCache<BlockPos, CachedBlockInfo> func_181627_a(IWorldReader iWorldReader, boolean bl) {
        return CacheBuilder.newBuilder().build((com.google.common.cache.CacheLoader)new CacheLoader(iWorldReader, bl));
    }

    protected static BlockPos func_177683_a(BlockPos blockPos, Direction direction, Direction direction2, int n, int n2, int n3) {
        if (direction == direction2 || direction == direction2.func_176734_d()) {
            throw new IllegalArgumentException("Invalid forwards & up combination");
        }
        Vector3i vector3i = new Vector3i(direction.func_82601_c(), direction.func_96559_d(), direction.func_82599_e());
        \u2603 = new Vector3i(direction2.func_82601_c(), direction2.func_96559_d(), direction2.func_82599_e());
        \u2603 = vector3i.func_177955_d(\u2603);
        return blockPos.func_177982_a(\u2603.func_177958_n() * -n2 + \u2603.func_177958_n() * n + vector3i.func_177958_n() * n3, \u2603.func_177956_o() * -n2 + \u2603.func_177956_o() * n + vector3i.func_177956_o() * n3, \u2603.func_177952_p() * -n2 + \u2603.func_177952_p() * n + vector3i.func_177952_p() * n3);
    }

    public static class PortalInfo {
        public final Vector3d field_222505_a;
        public final Vector3d field_222506_b;
        public final int field_222507_c;

        public PortalInfo(Vector3d vector3d, Vector3d vector3d2, int n) {
            this.field_222505_a = vector3d;
            this.field_222506_b = vector3d2;
            this.field_222507_c = n;
        }
    }

    public static class PatternHelper {
        private final BlockPos field_177674_a;
        private final Direction field_177672_b;
        private final Direction field_177673_c;
        private final LoadingCache<BlockPos, CachedBlockInfo> field_177671_d;
        private final int field_181120_e;
        private final int field_181121_f;
        private final int field_181122_g;

        public PatternHelper(BlockPos blockPos, Direction direction, Direction direction2, LoadingCache<BlockPos, CachedBlockInfo> loadingCache, int n, int n2, int n3) {
            this.field_177674_a = blockPos;
            this.field_177672_b = direction;
            this.field_177673_c = direction2;
            this.field_177671_d = loadingCache;
            this.field_181120_e = n;
            this.field_181121_f = n2;
            this.field_181122_g = n3;
        }

        public BlockPos func_181117_a() {
            return this.field_177674_a;
        }

        public Direction func_177669_b() {
            return this.field_177672_b;
        }

        public Direction func_177668_c() {
            return this.field_177673_c;
        }

        public int func_181118_d() {
            return this.field_181120_e;
        }

        public int func_181119_e() {
            return this.field_181121_f;
        }

        public CachedBlockInfo func_177670_a(int n, int n2, int n3) {
            return (CachedBlockInfo)this.field_177671_d.getUnchecked((Object)BlockPattern.func_177683_a(this.field_177674_a, this.func_177669_b(), this.func_177668_c(), n, n2, n3));
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("up", (Object)this.field_177673_c).add("forwards", (Object)this.field_177672_b).add("frontTopLeft", (Object)this.field_177674_a).toString();
        }

        public PortalInfo func_222504_a(Direction direction, BlockPos blockPos, double d, Vector3d vector3d2, double d22) {
            double \u26034;
            double \u26033;
            Direction direction2;
            double d3;
            Direction direction3 = this.func_177669_b();
            direction2 = direction3.func_176746_e();
            double \u26032 = (double)(this.func_181117_a().func_177956_o() + 1) - d * (double)this.func_181119_e();
            if (direction2 == Direction.NORTH) {
                d3 = (double)blockPos.func_177958_n() + 0.5;
                \u2603 = (double)(this.func_181117_a().func_177952_p() + 1) - (1.0 - d22) * (double)this.func_181118_d();
            } else if (direction2 == Direction.SOUTH) {
                d3 = (double)blockPos.func_177958_n() + 0.5;
                \u2603 = (double)this.func_181117_a().func_177952_p() + (1.0 - d22) * (double)this.func_181118_d();
            } else if (direction2 == Direction.WEST) {
                d3 = (double)(this.func_181117_a().func_177958_n() + 1) - (1.0 - d22) * (double)this.func_181118_d();
                \u2603 = (double)blockPos.func_177952_p() + 0.5;
            } else {
                double d22;
                d3 = (double)this.func_181117_a().func_177958_n() + (1.0 - d22) * (double)this.func_181118_d();
                \u2603 = (double)blockPos.func_177952_p() + 0.5;
            }
            if (direction3.func_176734_d() == direction) {
                \u26033 = vector3d2.field_72450_a;
                \u26034 = vector3d2.field_72449_c;
            } else if (direction3.func_176734_d() == direction.func_176734_d()) {
                \u26033 = -vector3d2.field_72450_a;
                \u26034 = -vector3d2.field_72449_c;
            } else if (direction3.func_176734_d() == direction.func_176746_e()) {
                \u26033 = -vector3d2.field_72449_c;
                \u26034 = vector3d2.field_72450_a;
            } else {
                Vector3d vector3d2;
                \u26033 = vector3d2.field_72449_c;
                \u26034 = -vector3d2.field_72450_a;
            }
            int n = (direction3.func_176736_b() - direction.func_176734_d().func_176736_b()) * 90;
            return new PortalInfo(new Vector3d(d3, \u26032, \u2603), new Vector3d(\u26033, vector3d2.field_72448_b, \u26034), n);
        }
    }

    static class CacheLoader
    extends com.google.common.cache.CacheLoader<BlockPos, CachedBlockInfo> {
        private final IWorldReader field_177680_a;
        private final boolean field_181626_b;

        public CacheLoader(IWorldReader iWorldReader, boolean bl) {
            this.field_177680_a = iWorldReader;
            this.field_181626_b = bl;
        }

        public CachedBlockInfo load(BlockPos blockPos) throws Exception {
            return new CachedBlockInfo(this.field_177680_a, blockPos, this.field_181626_b);
        }

        public /* synthetic */ Object load(Object object) throws Exception {
            return this.load((BlockPos)object);
        }
    }
}

