/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.arguments;

import com.google.common.collect.Maps;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.TagCollection;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.TranslationTextComponent;

public class BlockStateParser {
    public static final SimpleCommandExceptionType field_199831_a = new SimpleCommandExceptionType((Message)new TranslationTextComponent("argument.block.tag.disallowed"));
    public static final DynamicCommandExceptionType field_197259_a = new DynamicCommandExceptionType(object -> new TranslationTextComponent("argument.block.id.invalid", object));
    public static final Dynamic2CommandExceptionType field_197260_b = new Dynamic2CommandExceptionType((object, object2) -> new TranslationTextComponent("argument.block.property.unknown", object, object2));
    public static final Dynamic2CommandExceptionType field_197261_c = new Dynamic2CommandExceptionType((object, object2) -> new TranslationTextComponent("argument.block.property.duplicate", object2, object));
    public static final Dynamic3CommandExceptionType field_197262_d = new Dynamic3CommandExceptionType((object, object2, object3) -> new TranslationTextComponent("argument.block.property.invalid", object, object3, object2));
    public static final Dynamic2CommandExceptionType field_197263_e = new Dynamic2CommandExceptionType((object, object2) -> new TranslationTextComponent("argument.block.property.novalue", object, object2));
    public static final SimpleCommandExceptionType field_197264_f = new SimpleCommandExceptionType((Message)new TranslationTextComponent("argument.block.property.unclosed"));
    private static final BiFunction<SuggestionsBuilder, TagCollection<Block>, CompletableFuture<Suggestions>> field_197265_g = (suggestionsBuilder, tagCollection) -> suggestionsBuilder.buildFuture();
    private final StringReader field_197266_h;
    private final boolean field_199832_j;
    private final Map<Property<?>, Comparable<?>> field_197267_i = Maps.newHashMap();
    private final Map<String, String> field_200141_l = Maps.newHashMap();
    private ResourceLocation field_197268_j = new ResourceLocation("");
    private StateContainer<Block, BlockState> field_197269_k;
    private BlockState field_197270_l;
    @Nullable
    private CompoundNBT field_197271_m;
    private ResourceLocation field_199833_p = new ResourceLocation("");
    private int field_201954_r;
    private BiFunction<SuggestionsBuilder, TagCollection<Block>, CompletableFuture<Suggestions>> field_197272_n = field_197265_g;

    public BlockStateParser(StringReader stringReader, boolean bl) {
        this.field_197266_h = stringReader;
        this.field_199832_j = bl;
    }

    public Map<Property<?>, Comparable<?>> func_197254_a() {
        return this.field_197267_i;
    }

    @Nullable
    public BlockState func_197249_b() {
        return this.field_197270_l;
    }

    @Nullable
    public CompoundNBT func_197241_c() {
        return this.field_197271_m;
    }

    @Nullable
    public ResourceLocation func_199829_d() {
        return this.field_199833_p;
    }

    public BlockStateParser func_197243_a(boolean bl) throws CommandSyntaxException {
        this.field_197272_n = this::func_197250_h;
        if (this.field_197266_h.canRead() && this.field_197266_h.peek() == '#') {
            this.func_199827_f();
            this.field_197272_n = this::func_212599_i;
            if (this.field_197266_h.canRead() && this.field_197266_h.peek() == '[') {
                this.func_200137_h();
                this.field_197272_n = this::func_197244_d;
            }
        } else {
            this.func_197258_d();
            this.field_197272_n = this::func_197255_g;
            if (this.field_197266_h.canRead() && this.field_197266_h.peek() == '[') {
                this.func_197257_e();
                this.field_197272_n = this::func_197244_d;
            }
        }
        if (bl && this.field_197266_h.canRead() && this.field_197266_h.peek() == '{') {
            this.field_197272_n = field_197265_g;
            this.func_197240_f();
        }
        return this;
    }

    private CompletableFuture<Suggestions> func_197252_b(SuggestionsBuilder suggestionsBuilder, TagCollection<Block> tagCollection) {
        if (suggestionsBuilder.getRemaining().isEmpty()) {
            suggestionsBuilder.suggest(String.valueOf(']'));
        }
        return this.func_197256_c(suggestionsBuilder, tagCollection);
    }

    private CompletableFuture<Suggestions> func_200136_c(SuggestionsBuilder suggestionsBuilder, TagCollection<Block> tagCollection) {
        if (suggestionsBuilder.getRemaining().isEmpty()) {
            suggestionsBuilder.suggest(String.valueOf(']'));
        }
        return this.func_200134_e(suggestionsBuilder, tagCollection);
    }

    private CompletableFuture<Suggestions> func_197256_c(SuggestionsBuilder suggestionsBuilder2, TagCollection<Block> tagCollection) {
        SuggestionsBuilder suggestionsBuilder2;
        String string = suggestionsBuilder2.getRemaining().toLowerCase(Locale.ROOT);
        for (Property<?> property : this.field_197270_l.func_235904_r_()) {
            if (this.field_197267_i.containsKey(property) || !property.func_177701_a().startsWith(string)) continue;
            suggestionsBuilder2.suggest(property.func_177701_a() + '=');
        }
        return suggestionsBuilder2.buildFuture();
    }

    private CompletableFuture<Suggestions> func_200134_e(SuggestionsBuilder suggestionsBuilder2, TagCollection<Block> tagCollection) {
        SuggestionsBuilder suggestionsBuilder2;
        String string = suggestionsBuilder2.getRemaining().toLowerCase(Locale.ROOT);
        if (this.field_199833_p != null && !this.field_199833_p.func_110623_a().isEmpty() && (\u2603 = tagCollection.func_199910_a(this.field_199833_p)) != null) {
            for (Block block : \u2603.func_230236_b_()) {
                for (Property<?> property : block.func_176194_O().func_177623_d()) {
                    if (this.field_200141_l.containsKey(property.func_177701_a()) || !property.func_177701_a().startsWith(string)) continue;
                    suggestionsBuilder2.suggest(property.func_177701_a() + '=');
                }
            }
        }
        return suggestionsBuilder2.buildFuture();
    }

    private CompletableFuture<Suggestions> func_197244_d(SuggestionsBuilder suggestionsBuilder, TagCollection<Block> tagCollection) {
        if (suggestionsBuilder.getRemaining().isEmpty() && this.func_212598_k(tagCollection)) {
            suggestionsBuilder.suggest(String.valueOf('{'));
        }
        return suggestionsBuilder.buildFuture();
    }

    private boolean func_212598_k(TagCollection<Block> tagCollection) {
        if (this.field_197270_l != null) {
            return this.field_197270_l.func_177230_c().func_235695_q_();
        }
        if (this.field_199833_p != null && (\u2603 = tagCollection.func_199910_a(this.field_199833_p)) != null) {
            for (Block block : \u2603.func_230236_b_()) {
                if (!block.func_235695_q_()) continue;
                return true;
            }
        }
        return false;
    }

    private CompletableFuture<Suggestions> func_197246_e(SuggestionsBuilder suggestionsBuilder, TagCollection<Block> tagCollection) {
        if (suggestionsBuilder.getRemaining().isEmpty()) {
            suggestionsBuilder.suggest(String.valueOf('='));
        }
        return suggestionsBuilder.buildFuture();
    }

    private CompletableFuture<Suggestions> func_197248_f(SuggestionsBuilder suggestionsBuilder, TagCollection<Block> tagCollection) {
        if (suggestionsBuilder.getRemaining().isEmpty()) {
            suggestionsBuilder.suggest(String.valueOf(']'));
        }
        if (suggestionsBuilder.getRemaining().isEmpty() && this.field_197267_i.size() < this.field_197270_l.func_235904_r_().size()) {
            suggestionsBuilder.suggest(String.valueOf(','));
        }
        return suggestionsBuilder.buildFuture();
    }

    private static <T extends Comparable<T>> SuggestionsBuilder func_201037_a(SuggestionsBuilder suggestionsBuilder2, Property<T> property) {
        SuggestionsBuilder suggestionsBuilder2;
        for (Comparable comparable : property.func_177700_c()) {
            if (comparable instanceof Integer) {
                suggestionsBuilder2.suggest(((Integer)comparable).intValue());
                continue;
            }
            suggestionsBuilder2.suggest(property.func_177702_a(comparable));
        }
        return suggestionsBuilder2;
    }

    private CompletableFuture<Suggestions> func_239295_a_(SuggestionsBuilder suggestionsBuilder, TagCollection<Block> tagCollection, String string) {
        boolean bl = false;
        if (this.field_199833_p != null && !this.field_199833_p.func_110623_a().isEmpty() && (\u2603 = tagCollection.func_199910_a(this.field_199833_p)) != null) {
            block0: for (Block block : \u2603.func_230236_b_()) {
                Property<?> property = block.func_176194_O().func_185920_a(string);
                if (property != null) {
                    BlockStateParser.func_201037_a(suggestionsBuilder, property);
                }
                if (bl) continue;
                for (Property<?> property2 : block.func_176194_O().func_177623_d()) {
                    if (this.field_200141_l.containsKey(property2.func_177701_a())) continue;
                    bl = true;
                    continue block0;
                }
            }
        }
        if (bl) {
            suggestionsBuilder.suggest(String.valueOf(','));
        }
        suggestionsBuilder.suggest(String.valueOf(']'));
        return suggestionsBuilder.buildFuture();
    }

    private CompletableFuture<Suggestions> func_212599_i(SuggestionsBuilder suggestionsBuilder2, TagCollection<Block> tagCollection) {
        SuggestionsBuilder suggestionsBuilder2;
        if (suggestionsBuilder2.getRemaining().isEmpty() && (\u2603 = tagCollection.func_199910_a(this.field_199833_p)) != null) {
            boolean bl = false;
            \u2603 = false;
            Iterator<Block> iterator = \u2603.func_230236_b_().iterator();
            while (!(!iterator.hasNext() || (bl |= !(\u2603 = iterator.next()).func_176194_O().func_177623_d().isEmpty()) && (\u2603 |= \u2603.func_235695_q_()))) {
            }
            if (bl) {
                suggestionsBuilder2.suggest(String.valueOf('['));
            }
            if (\u2603) {
                suggestionsBuilder2.suggest(String.valueOf('{'));
            }
        }
        return this.func_201953_j(suggestionsBuilder2, tagCollection);
    }

    private CompletableFuture<Suggestions> func_197255_g(SuggestionsBuilder suggestionsBuilder, TagCollection<Block> tagCollection) {
        if (suggestionsBuilder.getRemaining().isEmpty()) {
            if (!this.field_197270_l.func_177230_c().func_176194_O().func_177623_d().isEmpty()) {
                suggestionsBuilder.suggest(String.valueOf('['));
            }
            if (this.field_197270_l.func_177230_c().func_235695_q_()) {
                suggestionsBuilder.suggest(String.valueOf('{'));
            }
        }
        return suggestionsBuilder.buildFuture();
    }

    private CompletableFuture<Suggestions> func_201953_j(SuggestionsBuilder suggestionsBuilder, TagCollection<Block> tagCollection) {
        return ISuggestionProvider.func_197014_a(tagCollection.func_199908_a(), suggestionsBuilder.createOffset(this.field_201954_r).add(suggestionsBuilder));
    }

    private CompletableFuture<Suggestions> func_197250_h(SuggestionsBuilder suggestionsBuilder, TagCollection<Block> tagCollection) {
        if (this.field_199832_j) {
            ISuggestionProvider.func_197006_a(tagCollection.func_199908_a(), suggestionsBuilder, String.valueOf('#'));
        }
        ISuggestionProvider.func_197014_a(Registry.field_212618_g.func_148742_b(), suggestionsBuilder);
        return suggestionsBuilder.buildFuture();
    }

    public void func_197258_d() throws CommandSyntaxException {
        int n = this.field_197266_h.getCursor();
        this.field_197268_j = ResourceLocation.func_195826_a(this.field_197266_h);
        Block \u26032 = (Block)Registry.field_212618_g.func_218349_b(this.field_197268_j).orElseThrow(() -> {
            this.field_197266_h.setCursor(n);
            return field_197259_a.createWithContext((ImmutableStringReader)this.field_197266_h, (Object)this.field_197268_j.toString());
        });
        this.field_197269_k = \u26032.func_176194_O();
        this.field_197270_l = \u26032.func_176223_P();
    }

    public void func_199827_f() throws CommandSyntaxException {
        if (!this.field_199832_j) {
            throw field_199831_a.create();
        }
        this.field_197272_n = this::func_201953_j;
        this.field_197266_h.expect('#');
        this.field_201954_r = this.field_197266_h.getCursor();
        this.field_199833_p = ResourceLocation.func_195826_a(this.field_197266_h);
    }

    public void func_197257_e() throws CommandSyntaxException {
        this.field_197266_h.skip();
        this.field_197272_n = this::func_197252_b;
        this.field_197266_h.skipWhitespace();
        while (this.field_197266_h.canRead() && this.field_197266_h.peek() != ']') {
            this.field_197266_h.skipWhitespace();
            int n = this.field_197266_h.getCursor();
            String \u26032 = this.field_197266_h.readString();
            Property<?> \u26033 = this.field_197269_k.func_185920_a(\u26032);
            if (\u26033 == null) {
                this.field_197266_h.setCursor(n);
                throw field_197260_b.createWithContext((ImmutableStringReader)this.field_197266_h, (Object)this.field_197268_j.toString(), (Object)\u26032);
            }
            if (this.field_197267_i.containsKey(\u26033)) {
                this.field_197266_h.setCursor(n);
                throw field_197261_c.createWithContext((ImmutableStringReader)this.field_197266_h, (Object)this.field_197268_j.toString(), (Object)\u26032);
            }
            this.field_197266_h.skipWhitespace();
            this.field_197272_n = this::func_197246_e;
            if (!this.field_197266_h.canRead() || this.field_197266_h.peek() != '=') {
                throw field_197263_e.createWithContext((ImmutableStringReader)this.field_197266_h, (Object)this.field_197268_j.toString(), (Object)\u26032);
            }
            this.field_197266_h.skip();
            this.field_197266_h.skipWhitespace();
            this.field_197272_n = (suggestionsBuilder, tagCollection) -> BlockStateParser.func_201037_a(suggestionsBuilder, \u26033).buildFuture();
            \u2603 = this.field_197266_h.getCursor();
            this.func_197253_a(\u26033, this.field_197266_h.readString(), \u2603);
            this.field_197272_n = this::func_197248_f;
            this.field_197266_h.skipWhitespace();
            if (!this.field_197266_h.canRead()) continue;
            if (this.field_197266_h.peek() == ',') {
                this.field_197266_h.skip();
                this.field_197272_n = this::func_197256_c;
                continue;
            }
            if (this.field_197266_h.peek() == ']') break;
            throw field_197264_f.createWithContext((ImmutableStringReader)this.field_197266_h);
        }
        if (!this.field_197266_h.canRead()) {
            throw field_197264_f.createWithContext((ImmutableStringReader)this.field_197266_h);
        }
        this.field_197266_h.skip();
    }

    public void func_200137_h() throws CommandSyntaxException {
        this.field_197266_h.skip();
        this.field_197272_n = this::func_200136_c;
        int \u26032 = -1;
        this.field_197266_h.skipWhitespace();
        while (this.field_197266_h.canRead() && this.field_197266_h.peek() != ']') {
            this.field_197266_h.skipWhitespace();
            \u2603 = this.field_197266_h.getCursor();
            String string = this.field_197266_h.readString();
            if (this.field_200141_l.containsKey(string)) {
                this.field_197266_h.setCursor(\u2603);
                throw field_197261_c.createWithContext((ImmutableStringReader)this.field_197266_h, (Object)this.field_197268_j.toString(), (Object)string);
            }
            this.field_197266_h.skipWhitespace();
            if (!this.field_197266_h.canRead() || this.field_197266_h.peek() != '=') {
                this.field_197266_h.setCursor(\u2603);
                throw field_197263_e.createWithContext((ImmutableStringReader)this.field_197266_h, (Object)this.field_197268_j.toString(), (Object)string);
            }
            this.field_197266_h.skip();
            this.field_197266_h.skipWhitespace();
            this.field_197272_n = (suggestionsBuilder, tagCollection) -> this.func_239295_a_((SuggestionsBuilder)suggestionsBuilder, (TagCollection<Block>)tagCollection, string);
            \u26032 = this.field_197266_h.getCursor();
            String string2 = this.field_197266_h.readString();
            this.field_200141_l.put(string, string2);
            this.field_197266_h.skipWhitespace();
            if (!this.field_197266_h.canRead()) continue;
            \u26032 = -1;
            if (this.field_197266_h.peek() == ',') {
                this.field_197266_h.skip();
                this.field_197272_n = this::func_200134_e;
                continue;
            }
            if (this.field_197266_h.peek() == ']') break;
            throw field_197264_f.createWithContext((ImmutableStringReader)this.field_197266_h);
        }
        if (!this.field_197266_h.canRead()) {
            if (\u26032 >= 0) {
                this.field_197266_h.setCursor(\u26032);
            }
            throw field_197264_f.createWithContext((ImmutableStringReader)this.field_197266_h);
        }
        this.field_197266_h.skip();
    }

    public void func_197240_f() throws CommandSyntaxException {
        this.field_197271_m = new JsonToNBT(this.field_197266_h).func_193593_f();
    }

    private <T extends Comparable<T>> void func_197253_a(Property<T> property, String string, int n) throws CommandSyntaxException {
        Optional<T> optional = property.func_185929_b(string);
        if (!optional.isPresent()) {
            this.field_197266_h.setCursor(n);
            throw field_197262_d.createWithContext((ImmutableStringReader)this.field_197266_h, (Object)this.field_197268_j.toString(), (Object)property.func_177701_a(), (Object)string);
        }
        this.field_197270_l = (BlockState)this.field_197270_l.func_206870_a(property, (Comparable)optional.get());
        this.field_197267_i.put(property, (Comparable<?>)optional.get());
    }

    public static String func_197247_a(BlockState blockState) {
        StringBuilder stringBuilder = new StringBuilder(Registry.field_212618_g.func_177774_c(blockState.func_177230_c()).toString());
        if (!blockState.func_235904_r_().isEmpty()) {
            stringBuilder.append('[');
            boolean bl = false;
            for (Map.Entry entry : blockState.func_206871_b().entrySet()) {
                if (bl) {
                    stringBuilder.append(',');
                }
                BlockStateParser.func_211375_a(stringBuilder, (Property)entry.getKey(), (Comparable)entry.getValue());
                bl = true;
            }
            stringBuilder.append(']');
        }
        return stringBuilder.toString();
    }

    private static <T extends Comparable<T>> void func_211375_a(StringBuilder stringBuilder, Property<T> property, Comparable<?> comparable) {
        stringBuilder.append(property.func_177701_a());
        stringBuilder.append('=');
        stringBuilder.append(property.func_177702_a(comparable));
    }

    public CompletableFuture<Suggestions> func_197245_a(SuggestionsBuilder suggestionsBuilder, TagCollection<Block> tagCollection) {
        return this.field_197272_n.apply(suggestionsBuilder.createOffset(this.field_197266_h.getCursor()), tagCollection);
    }

    public Map<String, String> func_200139_j() {
        return this.field_200141_l;
    }
}

