/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.impl;

import com.google.common.collect.Lists;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.ResultConsumer;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.OptionalInt;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.IntFunction;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.command.arguments.BlockPredicateArgument;
import net.minecraft.command.arguments.DimensionArgument;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.IRangeArgument;
import net.minecraft.command.arguments.NBTPathArgument;
import net.minecraft.command.arguments.ObjectiveArgument;
import net.minecraft.command.arguments.ResourceLocationArgument;
import net.minecraft.command.arguments.RotationArgument;
import net.minecraft.command.arguments.ScoreHolderArgument;
import net.minecraft.command.arguments.SwizzleArgument;
import net.minecraft.command.arguments.Vec3Argument;
import net.minecraft.command.impl.BossBarCommand;
import net.minecraft.command.impl.data.DataCommand;
import net.minecraft.command.impl.data.IDataAccessor;
import net.minecraft.entity.Entity;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootPredicateManager;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.nbt.ShortNBT;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ServerScoreboard;
import net.minecraft.server.CustomServerBossInfo;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;

public class ExecuteCommand {
    private static final Dynamic2CommandExceptionType field_198421_a = new Dynamic2CommandExceptionType((object, object2) -> new TranslationTextComponent("commands.execute.blocks.toobig", object, object2));
    private static final SimpleCommandExceptionType field_210456_b = new SimpleCommandExceptionType((Message)new TranslationTextComponent("commands.execute.conditional.fail"));
    private static final DynamicCommandExceptionType field_210457_c = new DynamicCommandExceptionType(object -> new TranslationTextComponent("commands.execute.conditional.fail_count", object));
    private static final BinaryOperator<ResultConsumer<CommandSource>> field_209957_b = (resultConsumer, resultConsumer2) -> (commandContext, bl, n) -> {
        resultConsumer.onCommandComplete(commandContext, bl, n);
        resultConsumer2.onCommandComplete(commandContext, bl, n);
    };
    private static final SuggestionProvider<CommandSource> field_229760_e_ = (commandContext, suggestionsBuilder) -> {
        LootPredicateManager lootPredicateManager = ((CommandSource)commandContext.getSource()).func_197028_i().func_229736_aP_();
        return ISuggestionProvider.func_197014_a(lootPredicateManager.func_227513_a_(), suggestionsBuilder);
    };

    public static void func_198378_a(CommandDispatcher<CommandSource> commandDispatcher) {
        LiteralCommandNode literalCommandNode = commandDispatcher.register((LiteralArgumentBuilder)Commands.func_197057_a("execute").requires(commandSource -> commandSource.func_197034_c(2)));
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a("execute").requires(commandSource -> commandSource.func_197034_c(2))).then(Commands.func_197057_a("run").redirect((CommandNode)commandDispatcher.getRoot()))).then(ExecuteCommand.func_198394_a((CommandNode<CommandSource>)literalCommandNode, Commands.func_197057_a("if"), true))).then(ExecuteCommand.func_198394_a((CommandNode<CommandSource>)literalCommandNode, Commands.func_197057_a("unless"), false))).then(Commands.func_197057_a("as").then(Commands.func_197056_a("targets", EntityArgument.func_197093_b()).fork((CommandNode)literalCommandNode, commandContext -> {
            ArrayList arrayList = Lists.newArrayList();
            for (Entity entity : EntityArgument.func_197087_c((CommandContext<CommandSource>)commandContext, "targets")) {
                arrayList.add(((CommandSource)commandContext.getSource()).func_197024_a(entity));
            }
            return arrayList;
        })))).then(Commands.func_197057_a("at").then(Commands.func_197056_a("targets", EntityArgument.func_197093_b()).fork((CommandNode)literalCommandNode, commandContext -> {
            ArrayList arrayList = Lists.newArrayList();
            for (Entity entity : EntityArgument.func_197087_c((CommandContext<CommandSource>)commandContext, "targets")) {
                arrayList.add(((CommandSource)commandContext.getSource()).func_201003_a((ServerWorld)entity.field_70170_p).func_201009_a(entity.func_213303_ch()).func_201007_a(entity.func_189653_aC()));
            }
            return arrayList;
        })))).then(((LiteralArgumentBuilder)Commands.func_197057_a("store").then(ExecuteCommand.func_198392_a((LiteralCommandNode<CommandSource>)literalCommandNode, Commands.func_197057_a("result"), true))).then(ExecuteCommand.func_198392_a((LiteralCommandNode<CommandSource>)literalCommandNode, Commands.func_197057_a("success"), false)))).then(((LiteralArgumentBuilder)Commands.func_197057_a("positioned").then(Commands.func_197056_a("pos", Vec3Argument.func_197301_a()).redirect((CommandNode)literalCommandNode, commandContext -> ((CommandSource)commandContext.getSource()).func_201009_a(Vec3Argument.func_197300_a((CommandContext<CommandSource>)commandContext, "pos")).func_201010_a(EntityAnchorArgument.Type.FEET)))).then(Commands.func_197057_a("as").then(Commands.func_197056_a("targets", EntityArgument.func_197093_b()).fork((CommandNode)literalCommandNode, commandContext -> {
            ArrayList arrayList = Lists.newArrayList();
            for (Entity entity : EntityArgument.func_197087_c((CommandContext<CommandSource>)commandContext, "targets")) {
                arrayList.add(((CommandSource)commandContext.getSource()).func_201009_a(entity.func_213303_ch()));
            }
            return arrayList;
        }))))).then(((LiteralArgumentBuilder)Commands.func_197057_a("rotated").then(Commands.func_197056_a("rot", RotationArgument.func_197288_a()).redirect((CommandNode)literalCommandNode, commandContext -> ((CommandSource)commandContext.getSource()).func_201007_a(RotationArgument.func_200384_a((CommandContext<CommandSource>)commandContext, "rot").func_197282_b((CommandSource)commandContext.getSource()))))).then(Commands.func_197057_a("as").then(Commands.func_197056_a("targets", EntityArgument.func_197093_b()).fork((CommandNode)literalCommandNode, commandContext -> {
            ArrayList arrayList = Lists.newArrayList();
            for (Entity entity : EntityArgument.func_197087_c((CommandContext<CommandSource>)commandContext, "targets")) {
                arrayList.add(((CommandSource)commandContext.getSource()).func_201007_a(entity.func_189653_aC()));
            }
            return arrayList;
        }))))).then(((LiteralArgumentBuilder)Commands.func_197057_a("facing").then(Commands.func_197057_a("entity").then(Commands.func_197056_a("targets", EntityArgument.func_197093_b()).then(Commands.func_197056_a("anchor", EntityAnchorArgument.func_201024_a()).fork((CommandNode)literalCommandNode, commandContext -> {
            ArrayList arrayList = Lists.newArrayList();
            EntityAnchorArgument.Type \u26032 = EntityAnchorArgument.func_201023_a((CommandContext<CommandSource>)commandContext, "anchor");
            for (Entity entity : EntityArgument.func_197087_c((CommandContext<CommandSource>)commandContext, "targets")) {
                arrayList.add(((CommandSource)commandContext.getSource()).func_201006_a(entity, \u26032));
            }
            return arrayList;
        }))))).then(Commands.func_197056_a("pos", Vec3Argument.func_197301_a()).redirect((CommandNode)literalCommandNode, commandContext -> ((CommandSource)commandContext.getSource()).func_201005_b(Vec3Argument.func_197300_a((CommandContext<CommandSource>)commandContext, "pos")))))).then(Commands.func_197057_a("align").then(Commands.func_197056_a("axes", SwizzleArgument.func_197293_a()).redirect((CommandNode)literalCommandNode, commandContext -> ((CommandSource)commandContext.getSource()).func_201009_a(((CommandSource)commandContext.getSource()).func_197036_d().func_197746_a(SwizzleArgument.func_197291_a((CommandContext<CommandSource>)commandContext, "axes"))))))).then(Commands.func_197057_a("anchored").then(Commands.func_197056_a("anchor", EntityAnchorArgument.func_201024_a()).redirect((CommandNode)literalCommandNode, commandContext -> ((CommandSource)commandContext.getSource()).func_201010_a(EntityAnchorArgument.func_201023_a((CommandContext<CommandSource>)commandContext, "anchor")))))).then(Commands.func_197057_a("in").then(Commands.func_197056_a("dimension", DimensionArgument.func_212595_a()).redirect((CommandNode)literalCommandNode, commandContext -> ((CommandSource)commandContext.getSource()).func_201003_a(DimensionArgument.func_212592_a((CommandContext<CommandSource>)commandContext, "dimension"))))));
    }

    private static ArgumentBuilder<CommandSource, ?> func_198392_a(LiteralCommandNode<CommandSource> literalCommandNode, LiteralArgumentBuilder<CommandSource> literalArgumentBuilder2, boolean bl) {
        LiteralArgumentBuilder<CommandSource> literalArgumentBuilder2;
        literalArgumentBuilder2.then(Commands.func_197057_a("score").then(Commands.func_197056_a("targets", ScoreHolderArgument.func_197214_b()).suggests(ScoreHolderArgument.field_201326_a).then(Commands.func_197056_a("objective", ObjectiveArgument.func_197157_a()).redirect(literalCommandNode, commandContext -> ExecuteCommand.func_209930_a((CommandSource)commandContext.getSource(), ScoreHolderArgument.func_211707_c((CommandContext<CommandSource>)commandContext, "targets"), ObjectiveArgument.func_197158_a((CommandContext<CommandSource>)commandContext, "objective"), bl)))));
        literalArgumentBuilder2.then(Commands.func_197057_a("bossbar").then(((RequiredArgumentBuilder)Commands.func_197056_a("id", ResourceLocationArgument.func_197197_a()).suggests(BossBarCommand.field_201431_a).then(Commands.func_197057_a("value").redirect(literalCommandNode, commandContext -> ExecuteCommand.func_209952_a((CommandSource)commandContext.getSource(), BossBarCommand.func_201416_a((CommandContext<CommandSource>)commandContext), true, bl)))).then(Commands.func_197057_a("max").redirect(literalCommandNode, commandContext -> ExecuteCommand.func_209952_a((CommandSource)commandContext.getSource(), BossBarCommand.func_201416_a((CommandContext<CommandSource>)commandContext), false, bl)))));
        for (DataCommand.IDataProvider iDataProvider : DataCommand.field_218955_b) {
            iDataProvider.func_198920_a((ArgumentBuilder<CommandSource, ?>)literalArgumentBuilder2, argumentBuilder -> argumentBuilder.then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a("path", NBTPathArgument.func_197149_a()).then(Commands.func_197057_a("int").then(Commands.func_197056_a("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)literalCommandNode, commandContext -> ExecuteCommand.func_198397_a((CommandSource)commandContext.getSource(), iDataProvider.func_198919_a((CommandContext<CommandSource>)commandContext), NBTPathArgument.func_197148_a((CommandContext<CommandSource>)commandContext, "path"), n -> IntNBT.func_229692_a_((int)((double)n * DoubleArgumentType.getDouble((CommandContext)commandContext, (String)"scale"))), bl))))).then(Commands.func_197057_a("float").then(Commands.func_197056_a("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)literalCommandNode, commandContext -> ExecuteCommand.func_198397_a((CommandSource)commandContext.getSource(), iDataProvider.func_198919_a((CommandContext<CommandSource>)commandContext), NBTPathArgument.func_197148_a((CommandContext<CommandSource>)commandContext, "path"), n -> FloatNBT.func_229689_a_((float)((double)n * DoubleArgumentType.getDouble((CommandContext)commandContext, (String)"scale"))), bl))))).then(Commands.func_197057_a("short").then(Commands.func_197056_a("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)literalCommandNode, commandContext -> ExecuteCommand.func_198397_a((CommandSource)commandContext.getSource(), iDataProvider.func_198919_a((CommandContext<CommandSource>)commandContext), NBTPathArgument.func_197148_a((CommandContext<CommandSource>)commandContext, "path"), n -> ShortNBT.func_229701_a_((short)((double)n * DoubleArgumentType.getDouble((CommandContext)commandContext, (String)"scale"))), bl))))).then(Commands.func_197057_a("long").then(Commands.func_197056_a("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)literalCommandNode, commandContext -> ExecuteCommand.func_198397_a((CommandSource)commandContext.getSource(), iDataProvider.func_198919_a((CommandContext<CommandSource>)commandContext), NBTPathArgument.func_197148_a((CommandContext<CommandSource>)commandContext, "path"), n -> LongNBT.func_229698_a_((long)((double)n * DoubleArgumentType.getDouble((CommandContext)commandContext, (String)"scale"))), bl))))).then(Commands.func_197057_a("double").then(Commands.func_197056_a("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)literalCommandNode, commandContext -> ExecuteCommand.func_198397_a((CommandSource)commandContext.getSource(), iDataProvider.func_198919_a((CommandContext<CommandSource>)commandContext), NBTPathArgument.func_197148_a((CommandContext<CommandSource>)commandContext, "path"), n -> DoubleNBT.func_229684_a_((double)n * DoubleArgumentType.getDouble((CommandContext)commandContext, (String)"scale")), bl))))).then(Commands.func_197057_a("byte").then(Commands.func_197056_a("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)literalCommandNode, commandContext -> ExecuteCommand.func_198397_a((CommandSource)commandContext.getSource(), iDataProvider.func_198919_a((CommandContext<CommandSource>)commandContext), NBTPathArgument.func_197148_a((CommandContext<CommandSource>)commandContext, "path"), n -> ByteNBT.func_229671_a_((byte)((double)n * DoubleArgumentType.getDouble((CommandContext)commandContext, (String)"scale"))), bl))))));
        }
        return literalArgumentBuilder2;
    }

    private static CommandSource func_209930_a(CommandSource commandSource, Collection<String> collection, ScoreObjective scoreObjective, boolean bl) {
        ServerScoreboard serverScoreboard = commandSource.func_197028_i().func_200251_aP();
        return commandSource.func_209550_a((ResultConsumer<CommandSource>)((ResultConsumer)(commandContext, bl2, n) -> {
            for (String string : collection) {
                Score score = serverScoreboard.func_96529_a(string, scoreObjective);
                int \u26032 = bl ? n : (bl2 ? 1 : 0);
                score.func_96647_c(\u26032);
            }
        }), field_209957_b);
    }

    private static CommandSource func_209952_a(CommandSource commandSource, CustomServerBossInfo customServerBossInfo, boolean bl, boolean bl2) {
        return commandSource.func_209550_a((ResultConsumer<CommandSource>)((ResultConsumer)(commandContext, bl3, n) -> {
            int n2 = bl2 ? n : (\u2603 = bl3 ? 1 : 0);
            if (bl) {
                customServerBossInfo.func_201362_a(\u2603);
            } else {
                customServerBossInfo.func_201366_b(\u2603);
            }
        }), field_209957_b);
    }

    private static CommandSource func_198397_a(CommandSource commandSource, IDataAccessor iDataAccessor, NBTPathArgument.NBTPath nBTPath, IntFunction<INBT> intFunction, boolean bl) {
        return commandSource.func_209550_a((ResultConsumer<CommandSource>)((ResultConsumer)(commandContext, bl2, n) -> {
            try {
                CompoundNBT compoundNBT = iDataAccessor.func_198923_a();
                int \u26032 = bl ? n : (bl2 ? 1 : 0);
                nBTPath.func_218076_b(compoundNBT, () -> (INBT)intFunction.apply(\u26032));
                iDataAccessor.func_198925_a(compoundNBT);
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }), field_209957_b);
    }

    private static ArgumentBuilder<CommandSource, ?> func_198394_a(CommandNode<CommandSource> commandNode, LiteralArgumentBuilder<CommandSource> literalArgumentBuilder2, boolean bl) {
        LiteralArgumentBuilder<CommandSource> literalArgumentBuilder2;
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)literalArgumentBuilder2.then(Commands.func_197057_a("block").then(Commands.func_197056_a("pos", BlockPosArgument.func_197276_a()).then(ExecuteCommand.func_210415_a(commandNode, Commands.func_197056_a("block", BlockPredicateArgument.func_199824_a()), bl, commandContext -> BlockPredicateArgument.func_199825_a((CommandContext<CommandSource>)commandContext, "block").test(new CachedBlockInfo(((CommandSource)commandContext.getSource()).func_197023_e(), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "pos"), true))))))).then(Commands.func_197057_a("score").then(Commands.func_197056_a("target", ScoreHolderArgument.func_197209_a()).suggests(ScoreHolderArgument.field_201326_a).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a("targetObjective", ObjectiveArgument.func_197157_a()).then(Commands.func_197057_a("=").then(Commands.func_197056_a("source", ScoreHolderArgument.func_197209_a()).suggests(ScoreHolderArgument.field_201326_a).then(ExecuteCommand.func_210415_a(commandNode, Commands.func_197056_a("sourceObjective", ObjectiveArgument.func_197157_a()), bl, commandContext -> ExecuteCommand.func_198371_a((CommandContext<CommandSource>)commandContext, Integer::equals)))))).then(Commands.func_197057_a("<").then(Commands.func_197056_a("source", ScoreHolderArgument.func_197209_a()).suggests(ScoreHolderArgument.field_201326_a).then(ExecuteCommand.func_210415_a(commandNode, Commands.func_197056_a("sourceObjective", ObjectiveArgument.func_197157_a()), bl, commandContext -> ExecuteCommand.func_198371_a((CommandContext<CommandSource>)commandContext, (n, n2) -> n < n2)))))).then(Commands.func_197057_a("<=").then(Commands.func_197056_a("source", ScoreHolderArgument.func_197209_a()).suggests(ScoreHolderArgument.field_201326_a).then(ExecuteCommand.func_210415_a(commandNode, Commands.func_197056_a("sourceObjective", ObjectiveArgument.func_197157_a()), bl, commandContext -> ExecuteCommand.func_198371_a((CommandContext<CommandSource>)commandContext, (n, n2) -> n <= n2)))))).then(Commands.func_197057_a(">").then(Commands.func_197056_a("source", ScoreHolderArgument.func_197209_a()).suggests(ScoreHolderArgument.field_201326_a).then(ExecuteCommand.func_210415_a(commandNode, Commands.func_197056_a("sourceObjective", ObjectiveArgument.func_197157_a()), bl, commandContext -> ExecuteCommand.func_198371_a((CommandContext<CommandSource>)commandContext, (n, n2) -> n > n2)))))).then(Commands.func_197057_a(">=").then(Commands.func_197056_a("source", ScoreHolderArgument.func_197209_a()).suggests(ScoreHolderArgument.field_201326_a).then(ExecuteCommand.func_210415_a(commandNode, Commands.func_197056_a("sourceObjective", ObjectiveArgument.func_197157_a()), bl, commandContext -> ExecuteCommand.func_198371_a((CommandContext<CommandSource>)commandContext, (n, n2) -> n >= n2)))))).then(Commands.func_197057_a("matches").then(ExecuteCommand.func_210415_a(commandNode, Commands.func_197056_a("range", IRangeArgument.func_211371_a()), bl, commandContext -> ExecuteCommand.func_201115_a((CommandContext<CommandSource>)commandContext, IRangeArgument.IntRange.func_211372_a((CommandContext<CommandSource>)commandContext, "range"))))))))).then(Commands.func_197057_a("blocks").then(Commands.func_197056_a("start", BlockPosArgument.func_197276_a()).then(Commands.func_197056_a("end", BlockPosArgument.func_197276_a()).then(((RequiredArgumentBuilder)Commands.func_197056_a("destination", BlockPosArgument.func_197276_a()).then(ExecuteCommand.func_212178_a(commandNode, Commands.func_197057_a("all"), bl, false))).then(ExecuteCommand.func_212178_a(commandNode, Commands.func_197057_a("masked"), bl, true))))))).then(Commands.func_197057_a("entity").then(((RequiredArgumentBuilder)Commands.func_197056_a("entities", EntityArgument.func_197093_b()).fork(commandNode, commandContext -> ExecuteCommand.func_198411_a((CommandContext<CommandSource>)commandContext, bl, !EntityArgument.func_197087_c((CommandContext<CommandSource>)commandContext, "entities").isEmpty()))).executes(ExecuteCommand.func_218834_a(bl, commandContext -> EntityArgument.func_197087_c((CommandContext<CommandSource>)commandContext, "entities").size()))))).then(Commands.func_197057_a("predicate").then(ExecuteCommand.func_210415_a(commandNode, Commands.func_197056_a("predicate", ResourceLocationArgument.func_197197_a()).suggests(field_229760_e_), bl, commandContext -> ExecuteCommand.func_229767_a_((CommandSource)commandContext.getSource(), ResourceLocationArgument.func_228259_c_((CommandContext<CommandSource>)commandContext, "predicate")))));
        for (DataCommand.IDataProvider iDataProvider : DataCommand.field_218956_c) {
            literalArgumentBuilder2.then(iDataProvider.func_198920_a((ArgumentBuilder<CommandSource, ?>)Commands.func_197057_a("data"), argumentBuilder -> argumentBuilder.then(((RequiredArgumentBuilder)Commands.func_197056_a("path", NBTPathArgument.func_197149_a()).fork(commandNode, commandContext -> ExecuteCommand.func_198411_a((CommandContext<CommandSource>)commandContext, bl, ExecuteCommand.func_218831_a(iDataProvider.func_198919_a((CommandContext<CommandSource>)commandContext), NBTPathArgument.func_197148_a((CommandContext<CommandSource>)commandContext, "path")) > 0))).executes(ExecuteCommand.func_218834_a(bl, commandContext -> ExecuteCommand.func_218831_a(iDataProvider.func_198919_a((CommandContext<CommandSource>)commandContext), NBTPathArgument.func_197148_a((CommandContext<CommandSource>)commandContext, "path")))))));
        }
        return literalArgumentBuilder2;
    }

    private static Command<CommandSource> func_218834_a(boolean bl, INumericTest iNumericTest) {
        if (bl) {
            return commandContext -> {
                int n = iNumericTest.test((CommandContext<CommandSource>)commandContext);
                if (n > 0) {
                    ((CommandSource)commandContext.getSource()).func_197030_a(new TranslationTextComponent("commands.execute.conditional.pass_count", n), false);
                    return n;
                }
                throw field_210456_b.create();
            };
        }
        return commandContext -> {
            int n = iNumericTest.test((CommandContext<CommandSource>)commandContext);
            if (n == 0) {
                ((CommandSource)commandContext.getSource()).func_197030_a(new TranslationTextComponent("commands.execute.conditional.pass"), false);
                return 1;
            }
            throw field_210457_c.create((Object)n);
        };
    }

    private static int func_218831_a(IDataAccessor iDataAccessor, NBTPathArgument.NBTPath nBTPath) throws CommandSyntaxException {
        return nBTPath.func_218069_b(iDataAccessor.func_198923_a());
    }

    private static boolean func_198371_a(CommandContext<CommandSource> commandContext, BiPredicate<Integer, Integer> biPredicate) throws CommandSyntaxException {
        String string = ScoreHolderArgument.func_197211_a(commandContext, "target");
        ScoreObjective \u26032 = ObjectiveArgument.func_197158_a(commandContext, "targetObjective");
        \u2603 = ScoreHolderArgument.func_197211_a(commandContext, "source");
        ScoreObjective \u26033 = ObjectiveArgument.func_197158_a(commandContext, "sourceObjective");
        ServerScoreboard \u26034 = ((CommandSource)commandContext.getSource()).func_197028_i().func_200251_aP();
        if (!\u26034.func_178819_b(string, \u26032) || !\u26034.func_178819_b(\u2603, \u26033)) {
            return false;
        }
        Score \u26035 = \u26034.func_96529_a(string, \u26032);
        Score \u26036 = \u26034.func_96529_a(\u2603, \u26033);
        return biPredicate.test(\u26035.func_96652_c(), \u26036.func_96652_c());
    }

    private static boolean func_201115_a(CommandContext<CommandSource> commandContext, MinMaxBounds.IntBound intBound) throws CommandSyntaxException {
        String string = ScoreHolderArgument.func_197211_a(commandContext, "target");
        ScoreObjective \u26032 = ObjectiveArgument.func_197158_a(commandContext, "targetObjective");
        ServerScoreboard \u26033 = ((CommandSource)commandContext.getSource()).func_197028_i().func_200251_aP();
        if (!\u26033.func_178819_b(string, \u26032)) {
            return false;
        }
        return intBound.func_211339_d(\u26033.func_96529_a(string, \u26032).func_96652_c());
    }

    private static boolean func_229767_a_(CommandSource commandSource, ILootCondition iLootCondition) {
        ServerWorld serverWorld = commandSource.func_197023_e();
        LootContext.Builder \u26032 = new LootContext.Builder(serverWorld).func_216015_a(LootParameters.field_216286_f, new BlockPos(commandSource.func_197036_d())).func_216021_b(LootParameters.field_216281_a, commandSource.func_197022_f());
        return iLootCondition.test(\u26032.func_216022_a(LootParameterSets.field_227557_c_));
    }

    private static Collection<CommandSource> func_198411_a(CommandContext<CommandSource> commandContext, boolean bl, boolean bl2) {
        if (bl2 == bl) {
            return Collections.singleton(commandContext.getSource());
        }
        return Collections.emptyList();
    }

    private static ArgumentBuilder<CommandSource, ?> func_210415_a(CommandNode<CommandSource> commandNode, ArgumentBuilder<CommandSource, ?> argumentBuilder, boolean bl, IBooleanTest iBooleanTest) {
        return argumentBuilder.fork(commandNode, commandContext -> ExecuteCommand.func_198411_a((CommandContext<CommandSource>)commandContext, bl, iBooleanTest.test((CommandContext<CommandSource>)commandContext))).executes(commandContext -> {
            if (bl == iBooleanTest.test((CommandContext<CommandSource>)commandContext)) {
                ((CommandSource)commandContext.getSource()).func_197030_a(new TranslationTextComponent("commands.execute.conditional.pass"), false);
                return 1;
            }
            throw field_210456_b.create();
        });
    }

    private static ArgumentBuilder<CommandSource, ?> func_212178_a(CommandNode<CommandSource> commandNode, ArgumentBuilder<CommandSource, ?> argumentBuilder, boolean bl, boolean bl2) {
        return argumentBuilder.fork(commandNode, commandContext -> ExecuteCommand.func_198411_a((CommandContext<CommandSource>)commandContext, bl, ExecuteCommand.func_212169_c((CommandContext<CommandSource>)commandContext, bl2).isPresent())).executes(bl ? commandContext -> ExecuteCommand.func_212175_a((CommandContext<CommandSource>)commandContext, bl2) : commandContext -> ExecuteCommand.func_212173_b((CommandContext<CommandSource>)commandContext, bl2));
    }

    private static int func_212175_a(CommandContext<CommandSource> commandContext, boolean bl) throws CommandSyntaxException {
        OptionalInt optionalInt = ExecuteCommand.func_212169_c(commandContext, bl);
        if (optionalInt.isPresent()) {
            ((CommandSource)commandContext.getSource()).func_197030_a(new TranslationTextComponent("commands.execute.conditional.pass_count", optionalInt.getAsInt()), false);
            return optionalInt.getAsInt();
        }
        throw field_210456_b.create();
    }

    private static int func_212173_b(CommandContext<CommandSource> commandContext, boolean bl) throws CommandSyntaxException {
        OptionalInt optionalInt = ExecuteCommand.func_212169_c(commandContext, bl);
        if (optionalInt.isPresent()) {
            throw field_210457_c.create((Object)optionalInt.getAsInt());
        }
        ((CommandSource)commandContext.getSource()).func_197030_a(new TranslationTextComponent("commands.execute.conditional.pass"), false);
        return 1;
    }

    private static OptionalInt func_212169_c(CommandContext<CommandSource> commandContext, boolean bl) throws CommandSyntaxException {
        return ExecuteCommand.func_198395_a(((CommandSource)commandContext.getSource()).func_197023_e(), BlockPosArgument.func_197273_a(commandContext, "start"), BlockPosArgument.func_197273_a(commandContext, "end"), BlockPosArgument.func_197273_a(commandContext, "destination"), bl);
    }

    private static OptionalInt func_198395_a(ServerWorld serverWorld, BlockPos blockPos, BlockPos blockPos2, BlockPos blockPos3, boolean bl) throws CommandSyntaxException {
        MutableBoundingBox mutableBoundingBox = new MutableBoundingBox(blockPos, blockPos2);
        \u2603 = new MutableBoundingBox(blockPos3, blockPos3.func_177971_a(mutableBoundingBox.func_175896_b()));
        BlockPos \u26032 = new BlockPos(\u2603.field_78897_a - mutableBoundingBox.field_78897_a, \u2603.field_78895_b - mutableBoundingBox.field_78895_b, \u2603.field_78896_c - mutableBoundingBox.field_78896_c);
        int \u26033 = mutableBoundingBox.func_78883_b() * mutableBoundingBox.func_78882_c() * mutableBoundingBox.func_78880_d();
        if (\u26033 > 32768) {
            throw field_198421_a.create((Object)32768, (Object)\u26033);
        }
        int \u26034 = 0;
        for (int i = mutableBoundingBox.field_78896_c; i <= mutableBoundingBox.field_78892_f; ++i) {
            for (\u2603 = mutableBoundingBox.field_78895_b; \u2603 <= mutableBoundingBox.field_78894_e; ++\u2603) {
                for (\u2603 = mutableBoundingBox.field_78897_a; \u2603 <= mutableBoundingBox.field_78893_d; ++\u2603) {
                    BlockPos blockPos4 = new BlockPos(\u2603, \u2603, i);
                    \u2603 = blockPos4.func_177971_a(\u26032);
                    BlockState \u26035 = serverWorld.func_180495_p(blockPos4);
                    if (bl && \u26035.func_203425_a(Blocks.field_150350_a)) continue;
                    if (\u26035 != serverWorld.func_180495_p(\u2603)) {
                        return OptionalInt.empty();
                    }
                    TileEntity \u26036 = serverWorld.func_175625_s(blockPos4);
                    TileEntity \u26037 = serverWorld.func_175625_s(\u2603);
                    if (\u26036 != null) {
                        if (\u26037 == null) {
                            return OptionalInt.empty();
                        }
                        CompoundNBT compoundNBT = \u26036.func_189515_b(new CompoundNBT());
                        compoundNBT.func_82580_o("x");
                        compoundNBT.func_82580_o("y");
                        compoundNBT.func_82580_o("z");
                        \u2603 = \u26037.func_189515_b(new CompoundNBT());
                        \u2603.func_82580_o("x");
                        \u2603.func_82580_o("y");
                        \u2603.func_82580_o("z");
                        if (!compoundNBT.equals(\u2603)) {
                            return OptionalInt.empty();
                        }
                    }
                    ++\u26034;
                }
            }
        }
        return OptionalInt.of(\u26034);
    }

    @FunctionalInterface
    static interface INumericTest {
        public int test(CommandContext<CommandSource> var1) throws CommandSyntaxException;
    }

    @FunctionalInterface
    static interface IBooleanTest {
        public boolean test(CommandContext<CommandSource> var1) throws CommandSyntaxException;
    }
}

